/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin.core.align;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.plugin.core.align.JaccardSimilarity;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignment;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignmentBuildData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NodeGroupMap {
    private final PerfectNGMode mode_;
    private Set<NetLink> links_;
    private Set<NetNode> loners_;
    private Map<NetNode, Boolean> mergedToCorrectNC_;
    private NetworkAlignment.NodeColorMap nodeColorMap_;
    private Map<NetNode, Set<NetLink>> nodeToLinks_;
    private Map<NetNode, Set<NetNode>> nodeToNeighbors_;
    private Map<GroupID, Integer> groupIDtoIndex_;
    private Map<Integer, GroupID> indexToGroupID_;
    private Map<GroupID, String> groupIDtoColor_;
    private final int numGroups_;
    private Map<String, Double> nodeGroupRatios_;
    private Map<String, Double> linkGroupRatios_;
    private JaccardSimilarity funcJS_;
    private BTProgressMonitor monitor_;
    public static final String[] nodeGroupOrder;
    public static final String[][] nodeGroupAnnots;
    public static final String[] nodeGroupOrderPerfectNG;
    public static final String[][] nodeGroupAnnotsPerfectNG;

    public NodeGroupMap(BuildData bd, String[] nodeGroupOrder, String[][] colorMap, BTProgressMonitor monitor) throws AsynchExitRequestException {
        this(bd.getLinks(), bd.getSingletonNodes(), ((NetworkAlignmentBuildData)bd.getPluginBuildData()).colorMapMain, ((NetworkAlignmentBuildData)bd.getPluginBuildData()).allLinksPerfect, ((NetworkAlignmentBuildData)bd.getPluginBuildData()).loneNodeIDsPerfect, ((NetworkAlignmentBuildData)bd.getPluginBuildData()).colorMapPerfect, ((NetworkAlignmentBuildData)bd.getPluginBuildData()).mergedToCorrectNC, ((NetworkAlignmentBuildData)bd.getPluginBuildData()).mode, ((NetworkAlignmentBuildData)bd.getPluginBuildData()).jaccSimThreshold, ((NetworkAlignmentBuildData)bd.getPluginBuildData()).linksSmall, ((NetworkAlignmentBuildData)bd.getPluginBuildData()).lonersSmall, ((NetworkAlignmentBuildData)bd.getPluginBuildData()).linksLarge, ((NetworkAlignmentBuildData)bd.getPluginBuildData()).lonersLarge, ((NetworkAlignmentBuildData)bd.getPluginBuildData()).mapG1toG2, ((NetworkAlignmentBuildData)bd.getPluginBuildData()).perfectG1toG2, nodeGroupOrder, colorMap, monitor);
    }

    public NodeGroupMap(Set<NetLink> allLinksMain, Set<NetNode> loneNodeIDsMain, NetworkAlignment.NodeColorMap colorMapMain, Set<NetLink> allLinksPerfect, Set<NetNode> loneNodeIDsPerfect, NetworkAlignment.NodeColorMap colorMapPerfect, Map<NetNode, Boolean> mergedToCorrectNC, PerfectNGMode mode, Double jaccSimThreshold, ArrayList<NetLink> linksSmall, HashSet<NetNode> lonersSmall, ArrayList<NetLink> linksLarge, HashSet<NetNode> lonersLarge, Map<NetNode, NetNode> mapG1toG2, Map<NetNode, NetNode> perfectG1toG2, String[] nodeGroupOrder, String[][] colorMap, BTProgressMonitor monitor) throws AsynchExitRequestException {
        this.links_ = allLinksMain;
        this.loners_ = loneNodeIDsMain;
        this.mergedToCorrectNC_ = mergedToCorrectNC;
        this.nodeColorMap_ = colorMapMain;
        this.numGroups_ = nodeGroupOrder.length;
        this.mode_ = mode;
        this.monitor_ = monitor;
        this.nodeToNeighbors_ = new HashMap<NetNode, Set<NetNode>>();
        this.nodeToLinks_ = new HashMap<NetNode, Set<NetLink>>();
        PluginSupportFactory.getBuildExtractor().createNeighborLinkMap(this.links_, this.loners_, this.nodeToNeighbors_, this.nodeToLinks_, this.monitor_);
        if (mode == PerfectNGMode.JACCARD_SIMILARITY) {
            HashMap<NetNode, Set<NetNode>> nodeToNeighborsPerfect = new HashMap<NetNode, Set<NetNode>>();
            HashMap<NetNode, Set<NetLink>> nodeToLinksPerfect = new HashMap<NetNode, Set<NetLink>>();
            PluginSupportFactory.getBuildExtractor().createNeighborLinkMap(allLinksPerfect, loneNodeIDsPerfect, nodeToNeighborsPerfect, nodeToLinksPerfect, this.monitor_);
            this.funcJS_ = new JaccardSimilarity(allLinksMain, loneNodeIDsMain, colorMapMain, allLinksPerfect, loneNodeIDsPerfect, colorMapPerfect, this.nodeToNeighbors_, this.nodeToLinks_, nodeToNeighborsPerfect, nodeToLinksPerfect, linksSmall, lonersSmall, linksLarge, lonersLarge, mapG1toG2, perfectG1toG2, jaccSimThreshold, monitor);
        }
        this.generateOrderMap(nodeGroupOrder);
        this.generateColorMap(colorMap);
        this.calcNGRatios();
        this.calcLGRatios();
    }

    private void generateOrderMap(String[] nodeGroupOrder) {
        this.groupIDtoIndex_ = new HashMap<GroupID, Integer>();
        this.indexToGroupID_ = new HashMap<Integer, GroupID>();
        for (int index = 0; index < nodeGroupOrder.length; ++index) {
            GroupID gID = new GroupID(nodeGroupOrder[index]);
            this.groupIDtoIndex_.put(gID, index);
            this.indexToGroupID_.put(index, gID);
        }
    }

    private void generateColorMap(String[][] colorMap) {
        this.groupIDtoColor_ = new HashMap<GroupID, String>();
        for (String[] ngCol : colorMap) {
            GroupID groupID = new GroupID(ngCol[0]);
            String color = ngCol[1];
            this.groupIDtoColor_.put(groupID, color);
        }
    }

    private GroupID generateID(NetNode node) {
        boolean[] inLG = new boolean[NetworkAlignment.LINK_GROUPS.length];
        for (NetLink netLink : this.nodeToLinks_.get(node)) {
            for (int rel = 0; rel < inLG.length; ++rel) {
                if (!netLink.getRelation().equals(NetworkAlignment.LINK_GROUPS[rel].tag)) continue;
                inLG[rel] = true;
            }
        }
        ArrayList<String> tags = new ArrayList<String>();
        for (NetworkAlignment.EdgeType type : NetworkAlignment.LINK_GROUPS) {
            if (!inLG[type.index]) continue;
            tags.add(type.tag);
        }
        if (tags.isEmpty()) {
            tags.add("0");
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("(");
        stringBuilder.append(this.nodeColorMap_.getColor((NetNode)node).tag);
        stringBuilder.append(":");
        for (int i = 0; i < tags.size(); ++i) {
            stringBuilder.append((String)tags.get(i));
            if (i == tags.size() - 1) continue;
            stringBuilder.append("/");
        }
        if (this.mode_ != PerfectNGMode.NONE) {
            stringBuilder.append("/");
            if (this.mergedToCorrectNC_.get(node) == null) {
                stringBuilder.append(0);
            } else {
                boolean isCorrect;
                if (this.mode_ == PerfectNGMode.NODE_CORRECTNESS) {
                    isCorrect = this.mergedToCorrectNC_.get(node);
                } else if (this.mode_ == PerfectNGMode.JACCARD_SIMILARITY) {
                    isCorrect = this.funcJS_.isCorrectJS(node);
                } else {
                    throw new IllegalStateException("Incorrect mode for Perfect NGs Group Map");
                }
                stringBuilder.append(isCorrect ? 1 : 0);
            }
        }
        stringBuilder.append(")");
        return new GroupID(stringBuilder.toString());
    }

    private void calcNGRatios() {
        Set<NetNode> nodes = this.nodeToLinks_.keySet();
        double size = nodes.size();
        Set<GroupID> tags = this.groupIDtoIndex_.keySet();
        HashMap<GroupID, Integer> counts = new HashMap<GroupID, Integer>();
        for (GroupID groupID : tags) {
            counts.put(groupID, 0);
        }
        for (NetNode netNode : nodes) {
            GroupID gID = this.generateID(netNode);
            counts.put(gID, (Integer)counts.get(gID) + 1);
        }
        this.nodeGroupRatios_ = new HashMap<String, Double>();
        for (Map.Entry entry : counts.entrySet()) {
            String tag = ((GroupID)entry.getKey()).getKey();
            double ratio = (double)((Integer)entry.getValue()).intValue() / size;
            this.nodeGroupRatios_.put(tag, ratio);
        }
    }

    /*
     * WARNING - void declaration
     */
    private void calcLGRatios() throws AsynchExitRequestException {
        void var6_7;
        double size = this.links_.size();
        HashMap<String, Integer> counts = new HashMap<String, Integer>();
        NetworkAlignment.EdgeType[] edgeTypeArray = NetworkAlignment.LINK_GROUPS;
        int n = edgeTypeArray.length;
        boolean bl = false;
        while (var6_7 < n) {
            NetworkAlignment.EdgeType type = edgeTypeArray[var6_7];
            counts.put(type.tag, 0);
            ++var6_7;
        }
        LoopReporter lr = new LoopReporter((long)this.links_.size(), 20, this.monitor_, 0.0, 1.0, "progress.calculatingLinkRatios");
        for (NetLink netLink : this.links_) {
            lr.report();
            String rel = netLink.getRelation();
            counts.put(rel, (Integer)counts.get(rel) + 1);
        }
        this.linkGroupRatios_ = new HashMap<String, Double>();
        for (Map.Entry entry : counts.entrySet()) {
            String tag = (String)entry.getKey();
            double ratio = (double)((Integer)entry.getValue()).intValue() / size;
            this.linkGroupRatios_.put(tag, ratio);
        }
    }

    public int getIndex(NetNode node) {
        GroupID groupID = this.generateID(node);
        Integer index = this.groupIDtoIndex_.get(groupID);
        if (index == null) {
            throw new IllegalArgumentException("GroupID " + groupID + " not found in given order list; given node " + node.getName());
        }
        return index;
    }

    public int getIndex(String key) {
        Integer index = this.groupIDtoIndex_.get(new GroupID(key));
        if (index == null) {
            throw new IllegalArgumentException("GroupID " + key + " not found in given order list; given key " + key);
        }
        return index;
    }

    public String getKey(Integer index) {
        if (this.indexToGroupID_.get(index) == null) {
            throw new IllegalArgumentException("Index not found in given order list; given index " + index);
        }
        return this.indexToGroupID_.get(index).getKey();
    }

    public String getColor(Integer index) {
        GroupID groupID = this.indexToGroupID_.get(index);
        return this.groupIDtoColor_.get(groupID);
    }

    public int numGroups() {
        return this.numGroups_;
    }

    public Map<String, Double> getNodeGroupRatios() {
        return this.nodeGroupRatios_;
    }

    public Map<String, Double> getLinkGroupRatios() {
        return this.linkGroupRatios_;
    }

    public Comparator<NetNode> sortDecrDegree() {
        return new Comparator<NetNode>(){

            @Override
            public int compare(NetNode node1, NetNode node2) {
                int diffSize = ((Set)NodeGroupMap.this.nodeToNeighbors_.get(node2)).size() - ((Set)NodeGroupMap.this.nodeToNeighbors_.get(node1)).size();
                return diffSize != 0 ? diffSize : node1.getName().compareTo(node2.getName());
            }
        };
    }

    static {
        int i;
        nodeGroupAnnots = new String[][]{{"(P:0)", "GrayBlue"}, {"(P:P)", "Orange"}, {"(P:pBp)", "Yellow"}, {"(P:pBb)", "DarkPeach"}, {"(P:pBp/pBb)", "DarkPowderBlue"}, {"(P:pRp)", "Green"}, {"(P:P/pBp)", "Purple"}, {"(P:P/pBb)", "DarkOrange"}, {"(P:P/pBp/pBb)", "DarkYellow"}, {"(P:P/pRp)", "Pink"}, {"(P:pBp/pRp)", "PowderBlue"}, {"(P:pBb/pRp)", "DarkGreen"}, {"(P:pBp/pBb/pRp)", "DarkPurple"}, {"(P:P/pBp/pRp)", "Peach"}, {"(P:P/pBb/pRp)", "DarkGrayBlue"}, {"(P:P/pBp/pBb/pRp)", "DarkPink"}, {"(P:pRr)", "GrayBlue"}, {"(P:P/pRr)", "Orange"}, {"(P:pBp/pRr)", "Yellow"}, {"(P:pBb/pRr)", "DarkPowderBlue"}, {"(P:pBp/pBb/pRr)", "DarkPeach"}, {"(P:pRp/pRr)", "Green"}, {"(P:P/pBp/pRr)", "Purple"}, {"(P:P/pBb/pRr)", "DarkGrayBlue"}, {"(P:P/pBp/pBb/pRr)", "DarkOrange"}, {"(P:P/pRp/pRr)", "Pink"}, {"(P:pBp/pRp/pRr)", "PowderBlue"}, {"(P:pBb/pRp/pRr)", "DarkYellow"}, {"(P:pBp/pBb/pRp/pRr)", "DarkPurple"}, {"(P:P/pBp/pRp/pRr)", "Peach"}, {"(P:P/pBb/pRp/pRr)", "DarkPink"}, {"(P:P/pBp/pBb/pRp/pRr)", "DarkGreen"}, {"(B:pBb)", "PowderBlue"}, {"(B:bBb)", "Purple"}, {"(B:pBb/bBb)", "Pink"}, {"(B:0)", "Peach"}, {"(R:pRr)", "GrayBlue"}, {"(R:rRr)", "Orange"}, {"(R:pRr/rRr)", "Yellow"}, {"(R:0)", "Green"}};
        nodeGroupAnnotsPerfectNG = new String[][]{{"(P:0/1)", "GrayBlue"}, {"(P:0/0)", "DarkGrayBlue"}, {"(P:P/1)", "Orange"}, {"(P:P/0)", "DarkOrange"}, {"(P:pBp/1)", "Yellow"}, {"(P:pBp/0)", "DarkYellow"}, {"(P:pBb/1)", "DarkPeach"}, {"(P:pBb/0)", "Peach"}, {"(P:pBp/pBb/1)", "DarkPowderBlue"}, {"(P:pBp/pBb/0)", "PowderBlue"}, {"(P:pRp/1)", "Green"}, {"(P:pRp/0)", "DarkGreen"}, {"(P:P/pBp/1)", "Purple"}, {"(P:P/pBp/0)", "DarkPurple"}, {"(P:P/pBb/1)", "DarkOrange"}, {"(P:P/pBb/0)", "Orange"}, {"(P:P/pBp/pBb/1)", "DarkYellow"}, {"(P:P/pBp/pBb/0)", "Yellow"}, {"(P:P/pRp/1)", "Pink"}, {"(P:P/pRp/0)", "DarkPink"}, {"(P:pBp/pRp/1)", "PowderBlue"}, {"(P:pBp/pRp/0)", "DarkPowderBlue"}, {"(P:pBb/pRp/1)", "DarkGreen"}, {"(P:pBb/pRp/0)", "Green"}, {"(P:pBp/pBb/pRp/1)", "DarkPurple"}, {"(P:pBp/pBb/pRp/0)", "Purple"}, {"(P:P/pBp/pRp/1)", "Peach"}, {"(P:P/pBp/pRp/0)", "DarkPeach"}, {"(P:P/pBb/pRp/1)", "DarkGrayBlue"}, {"(P:P/pBb/pRp/0)", "GrayBlue"}, {"(P:P/pBp/pBb/pRp/1)", "DarkPink"}, {"(P:P/pBp/pBb/pRp/0)", "Pink"}, {"(P:pRr/1)", "GrayBlue"}, {"(P:pRr/0)", "DarkGrayBlue"}, {"(P:P/pRr/1)", "Orange"}, {"(P:P/pRr/0)", "DarkOrange"}, {"(P:pBp/pRr/1)", "Yellow"}, {"(P:pBp/pRr/0)", "DarkYellow"}, {"(P:pBb/pRr/1)", "DarkPowderBlue"}, {"(P:pBb/pRr/0)", "PowderBlue"}, {"(P:pBp/pBb/pRr/1)", "DarkPeach"}, {"(P:pBp/pBb/pRr/0)", "Peach"}, {"(P:pRp/pRr/1)", "Green"}, {"(P:pRp/pRr/0)", "DarkGreen"}, {"(P:P/pBp/pRr/1)", "Purple"}, {"(P:P/pBp/pRr/0)", "DarkPurple"}, {"(P:P/pBb/pRr/1)", "DarkGrayBlue"}, {"(P:P/pBb/pRr/0)", "GrayBlue"}, {"(P:P/pBp/pBb/pRr/1)", "DarkOrange"}, {"(P:P/pBp/pBb/pRr/0)", "Orange"}, {"(P:P/pRp/pRr/1)", "Pink"}, {"(P:P/pRp/pRr/0)", "DarkPink"}, {"(P:pBp/pRp/pRr/1)", "PowderBlue"}, {"(P:pBp/pRp/pRr/0)", "DarkPowderBlue"}, {"(P:pBb/pRp/pRr/1)", "DarkYellow"}, {"(P:pBb/pRp/pRr/0)", "Yellow"}, {"(P:pBp/pBb/pRp/pRr/1)", "DarkPurple"}, {"(P:pBp/pBb/pRp/pRr/0)", "Purple"}, {"(P:P/pBp/pRp/pRr/1)", "Peach"}, {"(P:P/pBp/pRp/pRr/0)", "DarkPeach"}, {"(P:P/pBb/pRp/pRr/1)", "DarkPink"}, {"(P:P/pBb/pRp/pRr/0)", "Pink"}, {"(P:P/pBp/pBb/pRp/pRr/1)", "DarkGreen"}, {"(P:P/pBp/pBb/pRp/pRr/0)", "Green"}, {"(B:pBb/1)", "PowderBlue"}, {"(B:pBb/0)", "DarkPowderBlue"}, {"(B:bBb/1)", "Purple"}, {"(B:bBb/0)", "DarkPurple"}, {"(B:pBb/bBb/1)", "Pink"}, {"(B:pBb/bBb/0)", "DarkPink"}, {"(B:0/1)", "Peach"}, {"(B:0/0)", "DarkPeach"}, {"(R:pRr/0)", "GrayBlue"}, {"(R:rRr/0)", "Orange"}, {"(R:pRr/rRr/0)", "Yellow"}, {"(R:0/0)", "Green"}};
        nodeGroupOrder = new String[nodeGroupAnnots.length];
        for (i = 0; i < nodeGroupOrder.length; ++i) {
            NodeGroupMap.nodeGroupOrder[i] = nodeGroupAnnots[i][0];
        }
        nodeGroupOrderPerfectNG = new String[nodeGroupAnnotsPerfectNG.length];
        for (i = 0; i < nodeGroupOrderPerfectNG.length; ++i) {
            NodeGroupMap.nodeGroupOrderPerfectNG[i] = nodeGroupAnnotsPerfectNG[i][0];
        }
    }

    private static class GroupID {
        private final String key_;

        public GroupID(String key) {
            this.key_ = key;
        }

        public String getKey() {
            return this.key_;
        }

        public String toString() {
            return this.key_;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GroupID)) {
                return false;
            }
            GroupID groupID = (GroupID)o;
            return !(this.key_ != null ? !this.key_.equals(groupID.key_) : groupID.key_ != null);
        }

        public int hashCode() {
            return this.key_ != null ? this.key_.hashCode() : 0;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum PerfectNGMode {
        NONE,
        NODE_CORRECTNESS,
        JACCARD_SIMILARITY;

    }
}

