/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin.core.align;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.PluginResourceManager;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.plugin.core.align.JaccardSimilarity;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignment;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignmentPlugIn;
import org.systemsbiology.biofabric.plugin.core.align.NodeGroupMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkAlignmentScorer {
    private Set<NetLink> linksMain_;
    private Set<NetLink> linksPerfect_;
    private Set<NetNode> loneNodeIDsMain_;
    private Set<NetNode> loneNodeIDsPerfect_;
    private NetworkAlignment.NodeColorMap nodeColorMapMain_;
    private NetworkAlignment.NodeColorMap nodeColorMapPerfect_;
    private Map<NetNode, Boolean> mergedToCorrectNC_;
    private Map<NetNode, Set<NetLink>> nodeToLinksMain_;
    private Map<NetNode, Set<NetLink>> nodeToLinksPerfect_;
    private Map<NetNode, Set<NetNode>> nodeToNeighborsMain_;
    private Map<NetNode, Set<NetNode>> nodeToNeighborsPerfect_;
    private NodeGroupMap groupMapMain_;
    private NodeGroupMap groupMapPerfect_;
    private ArrayList<NetLink> linksSmall_;
    private ArrayList<NetLink> linksLarge_;
    private HashSet<NetNode> lonersSmall_;
    private HashSet<NetNode> lonersLarge_;
    private Map<NetNode, NetNode> mapG1toG2_;
    private Map<NetNode, NetNode> perfectG1toG2_;
    private BTProgressMonitor monitor_;
    private PluginResourceManager rMan_;
    private Double EC;
    private Double S3;
    private Double ICS;
    private Double NC;
    private Double NGS;
    private Double LGS;
    private Double JaccSim;
    private NetworkAlignmentPlugIn.NetAlignStats netAlignStats_;

    public NetworkAlignmentScorer(Set<NetLink> reducedLinks, Set<NetNode> loneNodeIDs, Map<NetNode, Boolean> mergedToCorrectNC, NetworkAlignment.NodeColorMap nodeColorMap, NetworkAlignment.NodeColorMap nodeColorMapPerfect, Set<NetLink> linksPerfect, Set<NetNode> loneNodeIDsPerfect, ArrayList<NetLink> linksSmall, HashSet<NetNode> lonersSmall, ArrayList<NetLink> linksLarge, HashSet<NetNode> lonersLarge, Map<NetNode, NetNode> mapG1toG2, Map<NetNode, NetNode> perfectG1toG2, BTProgressMonitor monitor, PluginResourceManager rMan) throws AsynchExitRequestException {
        this.rMan_ = rMan;
        this.linksMain_ = new HashSet<NetLink>(reducedLinks);
        this.loneNodeIDsMain_ = new HashSet<NetNode>(loneNodeIDs);
        this.nodeColorMapMain_ = nodeColorMap;
        this.nodeColorMapPerfect_ = nodeColorMapPerfect;
        this.mergedToCorrectNC_ = mergedToCorrectNC;
        this.linksPerfect_ = linksPerfect;
        this.loneNodeIDsPerfect_ = loneNodeIDsPerfect;
        this.monitor_ = monitor;
        this.nodeToLinksMain_ = new HashMap<NetNode, Set<NetLink>>();
        this.nodeToNeighborsMain_ = new HashMap<NetNode, Set<NetNode>>();
        this.nodeToLinksPerfect_ = new HashMap<NetNode, Set<NetLink>>();
        this.nodeToNeighborsPerfect_ = new HashMap<NetNode, Set<NetNode>>();
        this.linksSmall_ = linksSmall;
        this.lonersSmall_ = lonersSmall;
        this.linksLarge_ = linksLarge;
        this.lonersLarge_ = lonersLarge;
        this.mapG1toG2_ = mapG1toG2;
        this.perfectG1toG2_ = perfectG1toG2;
        this.groupMapMain_ = new NodeGroupMap(this.linksMain_, this.loneNodeIDsMain_, this.nodeColorMapMain_, this.linksPerfect_, this.loneNodeIDsPerfect_, this.nodeColorMapPerfect_, this.mergedToCorrectNC_, NodeGroupMap.PerfectNGMode.NONE, null, linksSmall, lonersSmall, linksLarge, lonersLarge, mapG1toG2, perfectG1toG2, NodeGroupMap.nodeGroupOrder, NodeGroupMap.nodeGroupAnnots, this.monitor_);
        if (mergedToCorrectNC != null) {
            this.groupMapPerfect_ = new NodeGroupMap(this.linksPerfect_, this.loneNodeIDsPerfect_, this.nodeColorMapPerfect_, null, null, null, null, NodeGroupMap.PerfectNGMode.NONE, null, linksSmall, lonersSmall, linksLarge, lonersLarge, mapG1toG2, perfectG1toG2, NodeGroupMap.nodeGroupOrder, NodeGroupMap.nodeGroupAnnots, this.monitor_);
        }
        this.removeDuplicateAndShadow();
        PluginSupportFactory.getBuildExtractor().createNeighborLinkMap(this.linksMain_, this.loneNodeIDsMain_, this.nodeToNeighborsMain_, this.nodeToLinksMain_, this.monitor_);
        if (mergedToCorrectNC != null) {
            PluginSupportFactory.getBuildExtractor().createNeighborLinkMap(this.linksPerfect_, this.loneNodeIDsPerfect_, this.nodeToNeighborsPerfect_, this.nodeToLinksPerfect_, this.monitor_);
        }
        this.calcScores();
        this.finalizeMeasures();
    }

    private void removeDuplicateAndShadow() throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter((long)this.linksMain_.size(), 20, this.monitor_, 0.0, 1.0, "progress.filteringLinksA");
        HashSet<NetLink> nonShdwLinks = new HashSet<NetLink>();
        for (NetLink link : this.linksMain_) {
            lr.report();
            if (link.isShadow()) continue;
            nonShdwLinks.add(link);
        }
        lr = new LoopReporter((long)nonShdwLinks.size(), 20, this.monitor_, 0.0, 1.0, "progress.filteringLinksB");
        HashMap<String, NetLink> map = new HashMap<String, NetLink>();
        for (NetLink netLink : nonShdwLinks) {
            lr.report();
            Object[] arr1 = new String[]{netLink.getSrcNode().getName(), netLink.getTrgNode().getName()};
            Arrays.sort(arr1);
            String concat = String.format("%s___%s", arr1[0], arr1[1]);
            if (map.get(concat) != null) continue;
            map.put(concat, netLink);
        }
        this.linksMain_.clear();
        for (Map.Entry entry : map.entrySet()) {
            this.linksMain_.add((NetLink)entry.getValue());
        }
    }

    private void calcScores() throws AsynchExitRequestException {
        this.calcTopologicalMeasures();
        if (this.mergedToCorrectNC_ != null) {
            this.calcNodeCorrectness();
            this.calcGroupSimilarity();
            this.calcJaccardSimilarity();
        }
    }

    private void finalizeMeasures() {
        String ECn = this.rMan_.getPluginString("networkAlignment.edgeCoverage");
        String S3n = this.rMan_.getPluginString("networkAlignment.symmetricSubstructureScore");
        String ICSn = this.rMan_.getPluginString("networkAlignment.inducedConservedStructure");
        String NCn = this.rMan_.getPluginString("networkAlignment.nodeCorrectness");
        String NGSn = this.rMan_.getPluginString("networkAlignment.nodeGroupSimilarity");
        String LGSn = this.rMan_.getPluginString("networkAlignment.linkGroupSimilarity");
        String JSn = this.rMan_.getPluginString("networkAlignment.jaccardSimilarity");
        NetworkAlignmentPlugIn.NetAlignMeasure[] possibleMeasures = new NetworkAlignmentPlugIn.NetAlignMeasure[]{new NetworkAlignmentPlugIn.NetAlignMeasure(ECn, this.EC), new NetworkAlignmentPlugIn.NetAlignMeasure(S3n, this.S3), new NetworkAlignmentPlugIn.NetAlignMeasure(ICSn, this.ICS), new NetworkAlignmentPlugIn.NetAlignMeasure(NCn, this.NC), new NetworkAlignmentPlugIn.NetAlignMeasure(NGSn, this.NGS), new NetworkAlignmentPlugIn.NetAlignMeasure(LGSn, this.LGS), new NetworkAlignmentPlugIn.NetAlignMeasure(JSn, this.JaccSim)};
        ArrayList<NetworkAlignmentPlugIn.NetAlignMeasure> measures = new ArrayList<NetworkAlignmentPlugIn.NetAlignMeasure>();
        for (NetworkAlignmentPlugIn.NetAlignMeasure msr : possibleMeasures) {
            if (msr.val == null) continue;
            measures.add(msr);
        }
        this.netAlignStats_ = new NetworkAlignmentPlugIn.NetAlignStats(measures);
    }

    private void calcTopologicalMeasures() throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter((long)this.linksMain_.size(), 20, this.monitor_, 0.0, 1.0, "progress.topologicalMeasures");
        int numCoveredEdge = 0;
        int numInducedGraph1 = 0;
        int numInducedGraph2 = 0;
        for (NetLink link : this.linksMain_) {
            lr.report();
            if (link.getRelation().equals(NetworkAlignment.EdgeType.COVERED.tag)) {
                ++numCoveredEdge;
                continue;
            }
            if (link.getRelation().equals(NetworkAlignment.EdgeType.INDUCED_GRAPH1.tag)) {
                ++numInducedGraph1;
                continue;
            }
            if (!link.getRelation().equals(NetworkAlignment.EdgeType.INDUCED_GRAPH2.tag)) continue;
            ++numInducedGraph2;
        }
        this.EC = (double)numCoveredEdge / (double)(numCoveredEdge + numInducedGraph1);
        this.S3 = (double)numCoveredEdge / (double)(numCoveredEdge + numInducedGraph1 + numInducedGraph2);
        this.ICS = (double)numCoveredEdge / (double)(numCoveredEdge + numInducedGraph2);
        if (this.EC.isNaN()) {
            this.EC = null;
        }
        if (this.S3.isNaN()) {
            this.S3 = null;
        }
        if (this.ICS.isNaN()) {
            this.ICS = null;
        }
    }

    private void calcNodeCorrectness() {
        if (this.mergedToCorrectNC_ == null) {
            this.NC = null;
            return;
        }
        int numCorrect = 0;
        for (Map.Entry<NetNode, Boolean> node : this.mergedToCorrectNC_.entrySet()) {
            if (!node.getValue().booleanValue()) continue;
            ++numCorrect;
        }
        this.NC = (double)numCorrect / (double)this.mergedToCorrectNC_.size();
    }

    private void calcGroupSimilarity() {
        GroupSimilarityMeasure gd = new GroupSimilarityMeasure();
        this.NGS = gd.calcNGS(this.groupMapMain_, this.groupMapPerfect_);
        this.LGS = gd.calcLGS(this.groupMapMain_, this.groupMapPerfect_);
    }

    private void calcJaccardSimilarity() throws AsynchExitRequestException {
        this.JaccSim = new JaccardSimilarity(this.linksMain_, this.loneNodeIDsMain_, this.nodeColorMapMain_, this.linksPerfect_, this.loneNodeIDsPerfect_, this.nodeColorMapPerfect_, this.nodeToNeighborsMain_, this.nodeToLinksMain_, this.nodeToNeighborsPerfect_, this.nodeToLinksPerfect_, this.linksSmall_, this.lonersSmall_, this.linksLarge_, this.lonersLarge_, this.mapG1toG2_, this.perfectG1toG2_, null, this.monitor_).calcScore();
    }

    public NetworkAlignmentPlugIn.NetAlignStats getNetAlignStats() {
        return this.netAlignStats_;
    }

    private static class GroupSimilarityMeasure {
        private GroupSimilarityMeasure() {
        }

        double calcNGS(NodeGroupMap groupMapMain, NodeGroupMap groupMapPerfect) {
            VectorND main = this.getNGVector(groupMapMain);
            VectorND perfect = this.getNGVector(groupMapPerfect);
            double score = main.angSim(perfect);
            return score;
        }

        private VectorND getNGVector(NodeGroupMap groupMap) {
            VectorND vector = new VectorND(groupMap.numGroups());
            Map<String, Double> ngRatios = groupMap.getNodeGroupRatios();
            for (Map.Entry<String, Double> entry : ngRatios.entrySet()) {
                int index = groupMap.getIndex(entry.getKey());
                vector.set(index, entry.getValue());
            }
            vector.normalize();
            return vector;
        }

        double calcLGS(NodeGroupMap groupMapMain, NodeGroupMap groupMapPerfect) {
            VectorND main = this.getLGVector(groupMapMain);
            VectorND perfect = this.getLGVector(groupMapPerfect);
            double score = main.angSim(perfect);
            return score;
        }

        private VectorND getLGVector(NodeGroupMap groupMap) {
            HashMap<String, Integer> relToIndex = new HashMap<String, Integer>();
            for (NetworkAlignment.EdgeType type : NetworkAlignment.LINK_GROUPS) {
                relToIndex.put(type.tag, type.index);
            }
            VectorND vector = new VectorND(NetworkAlignment.LINK_GROUPS.length);
            Map<String, Double> lgRatios = groupMap.getLinkGroupRatios();
            for (Map.Entry<String, Double> entry : lgRatios.entrySet()) {
                int index = (Integer)relToIndex.get(entry.getKey());
                vector.set(index, entry.getValue());
            }
            vector.normalize();
            return vector;
        }
    }

    private static class VectorND {
        private double[] values_;

        public VectorND(int size) {
            this.values_ = new double[size];
        }

        public double get(int index) {
            return this.values_[index];
        }

        public void set(int index, double val) {
            this.values_[index] = val;
        }

        public double distance(VectorND vector) {
            if (this.values_.length != vector.values_.length) {
                throw new IllegalArgumentException("score vector length not equal");
            }
            double ret = 0.0;
            for (int i = 0; i < this.values_.length; ++i) {
                ret += (this.values_[i] - vector.values_[i]) * (this.values_[i] - vector.values_[i]);
            }
            ret = Math.pow(ret, 0.5);
            return ret;
        }

        public double magnitude() {
            double ret = this.dot(this);
            ret = Math.sqrt(ret);
            return ret;
        }

        public void normalize() {
            double mag = this.magnitude();
            if (mag == 0.0) {
                return;
            }
            int i = 0;
            while (i < this.values_.length) {
                int n = i++;
                this.values_[n] = this.values_[n] / mag;
            }
        }

        public double dot(VectorND vector) {
            if (this.values_.length != vector.values_.length) {
                throw new IllegalArgumentException("score vector length not equal");
            }
            double ret = 0.0;
            for (int i = 0; i < this.values_.length; ++i) {
                ret += this.values_[i] * vector.values_[i];
            }
            return ret;
        }

        public double cosSim(VectorND vector) {
            double cosTheta = this.dot(vector) / (this.magnitude() * vector.magnitude());
            return cosTheta;
        }

        public double angSim(VectorND vector) {
            Double cosT = this.cosSim(vector);
            if (Double.compare(cosT, 1.0) > 0) {
                cosT = 1.0;
            } else if (Double.compare(cosT, 0.0) < 0) {
                cosT = 0.0;
            }
            Double sim = 1.0 - 2.0 * Math.acos(cosT) / Math.PI;
            if (sim.isNaN()) {
                // empty if block
            }
            return sim;
        }

        public String toString() {
            return "VectorND{values_=" + Arrays.toString(this.values_) + '}';
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof VectorND)) {
                return false;
            }
            VectorND vectorND = (VectorND)o;
            return Arrays.equals(this.values_, vectorND.values_);
        }

        public int hashCode() {
            return Arrays.hashCode(this.values_);
        }
    }
}

