/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin.core.align;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.systemsbiology.biofabric.api.io.AttributeExtractor;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.io.BuildExtractor;
import org.systemsbiology.biofabric.api.io.CharacterEntityMapper;
import org.systemsbiology.biofabric.api.io.FileLoadFlows;
import org.systemsbiology.biofabric.api.io.Indenter;
import org.systemsbiology.biofabric.api.io.PluginWhiteboard;
import org.systemsbiology.biofabric.api.model.AugRelation;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.model.Network;
import org.systemsbiology.biofabric.api.parser.AbstractFactoryClient;
import org.systemsbiology.biofabric.api.parser.GlueStick;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.PluginResourceManager;
import org.systemsbiology.biofabric.api.util.UniqueLabeller;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BFWorker;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.BackgroundCore;
import org.systemsbiology.biofabric.api.worker.BackgroundWorkerControlManager;
import org.systemsbiology.biofabric.api.worker.BackgroundWorkerOwner;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugIn;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugInCmd;
import org.systemsbiology.biofabric.plugin.BioFabricToolPlugInData;
import org.systemsbiology.biofabric.plugin.PlugInManager;
import org.systemsbiology.biofabric.plugin.PlugInNetworkModelAPI;
import org.systemsbiology.biofabric.plugin.PluginBuildData;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.plugin.core.align.AlignmentLoader;
import org.systemsbiology.biofabric.plugin.core.align.NetAlignMeasureDialog;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignment;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignmentBuildData;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignmentDialog;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignmentScorer;
import org.systemsbiology.biofabric.plugin.core.align.ShadowsAndGroupsDialog;
import org.systemsbiology.biotapestry.biofabric.FabricCommands;
import org.xml.sax.Attributes;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkAlignmentPlugIn
implements BioFabricToolPlugIn {
    private ArrayList<BioFabricToolPlugInCmd> myCmds_ = new ArrayList();
    private String myTag_;
    private NetAlignStats publishedNetAlignStats_;
    private NetAlignStats pendingNetAlignStats_;
    private FileLoadFlows flf_;
    private JFrame topWindow_;
    private BackgroundWorkerControlManager bwcm_;
    private String className_;
    private PluginResourceManager rMan_;
    private PlugInNetworkModelAPI api_;

    public NetworkAlignmentPlugIn() {
        this.myCmds_.add(new LoadNetAlignGroupsCmd());
        this.myCmds_.add(new LoadNetAlignOrphanCmd());
        this.myCmds_.add(new LoadNetAlignCaseIICmd());
        this.myCmds_.add(new NetAlignMeasuresCmd());
        this.publishedNetAlignStats_ = new NetAlignStats();
        this.pendingNetAlignStats_ = new NetAlignStats();
        this.className_ = this.getClass().getName();
    }

    public void setUniquePlugInTag(String tag) {
        this.myTag_ = tag;
    }

    public String getUniquePlugInTag() {
        return this.myTag_;
    }

    public void newNetworkInstalled(Network bfn) {
        if (this.pendingNetAlignStats_.hasStats()) {
            this.publishedNetAlignStats_ = this.pendingNetAlignStats_;
            this.pendingNetAlignStats_ = new NetAlignStats();
        } else {
            this.publishedNetAlignStats_ = new NetAlignStats();
        }
        for (BioFabricToolPlugInCmd cmd : this.myCmds_) {
            ((Enabler)cmd).setEnabled(true);
        }
    }

    public void installManager(PlugInManager pMan) {
        this.rMan_ = PluginSupportFactory.getResourceManager((String)this.className_, (PlugInManager)pMan);
        this.rMan_.setPluginBundle("org.systemsbiology.biofabric.plugin.core.align.NetworkAlignment");
    }

    public void installAPI(PlugInNetworkModelAPI api) {
        this.flf_ = api.getFileUtilities();
        this.topWindow_ = api.getTopWindow();
        this.bwcm_ = api.getBWCtrlMgr();
        this.api_ = api;
        for (BioFabricToolPlugInCmd cmd : this.myCmds_) {
            ((Enabler)cmd).setEnabled(true);
        }
    }

    public String getToolMenu() {
        return this.rMan_.getPluginString("command.alignmentCommands");
    }

    public int getCommandCount() {
        return this.myCmds_.size();
    }

    public BioFabricToolPlugInCmd getCommand(int index) {
        return this.myCmds_.get(index);
    }

    public void writeXML(PrintWriter out, Indenter ind) {
        if (!this.publishedNetAlignStats_.hasStats()) {
            return;
        }
        ind.up();
        ind.indent();
        String name = this.getClass().getName();
        out.print("<");
        out.print(name);
        out.println(">");
        ind.up();
        this.publishedNetAlignStats_.writeXML(out, ind);
        ind.down();
        ind.indent();
        out.print("</");
        out.print(name);
        out.println(">");
        ind.down();
    }

    public AbstractFactoryClient getXMLWorker(PluginWhiteboard board) {
        return new PlugInWorker(board, this);
    }

    public void attachXMLData(BioFabricToolPlugInData data) {
        this.pendingNetAlignStats_ = (NetAlignStats)data;
    }

    private boolean networkAlignmentFromSources(NetworkAlignmentDialog.NetworkAlignmentDialogInfo nadi, NetworkAlignmentBuildData.ViewType outType) {
        UniqueLabeller idGen = new UniqueLabeller();
        ArrayList<NetLink> linksSmall = new ArrayList<NetLink>();
        HashSet<NetNode> lonersSmall = new HashSet<NetNode>();
        FileLoadFlows.FileLoadType type1 = this.flf_.getFileLoadType(nadi.graph1);
        FileLoadFlows.FileLoadResult flr = this.flf_.loadFromASource(nadi.graph1, linksSmall, lonersSmall, null, idGen, true, type1, false);
        File cacheFile = flr.getCacheFile();
        ArrayList<NetLink> linksLarge = new ArrayList<NetLink>();
        HashSet<NetNode> lonersLarge = new HashSet<NetNode>();
        FileLoadFlows.FileLoadType type2 = this.flf_.getFileLoadType(nadi.graph2);
        this.flf_.loadFromASource(nadi.graph2, linksLarge, lonersLarge, null, idGen, true, type2, false);
        return this.networkAlignmentStepTwo(nadi, linksSmall, lonersSmall, linksLarge, lonersLarge, nadi.jaccSimThreshold, idGen, outType, cacheFile);
    }

    private Map<NetNode, NetNode> loadTheAlignmentFile(File file, ArrayList<NetLink> linksGraph1, HashSet<NetNode> loneNodesGraph1, ArrayList<NetLink> linksGraph2, HashSet<NetNode> loneNodesGraph2) {
        HashMap<NetNode, NetNode> mapG1toG2 = new HashMap<NetNode, NetNode>();
        try {
            AlignmentLoader.NetAlignFileStats stats = new AlignmentLoader.NetAlignFileStats();
            AlignmentLoader alod = new AlignmentLoader(this.className_, this.rMan_);
            alod.readAlignment(file, mapG1toG2, stats, linksGraph1, loneNodesGraph1, linksGraph2, loneNodesGraph2);
            if (!stats.badLines.isEmpty()) {
                String badLineFormat = this.rMan_.getPluginString("netAlignRead.badLineFormat");
                String badLineMsg = MessageFormat.format(badLineFormat, stats.badLines.size());
                JOptionPane.showMessageDialog(this.topWindow_, badLineMsg, this.rMan_.getPluginString("netAlignRead.badLineTitle"), 2);
            }
            if (!stats.dupLines.isEmpty()) {
                String dupLineFormat = this.rMan_.getPluginString("netAlignRead.dupLineFormat");
                String dupLineMsg = MessageFormat.format(dupLineFormat, stats.dupLines.size());
                JOptionPane.showMessageDialog(this.topWindow_, dupLineMsg, this.rMan_.getPluginString("netAlignRead.dupLineTitle"), 2);
            }
        }
        catch (IOException ioe) {
            this.flf_.displayFileInputError(ioe);
            return null;
        }
        FabricCommands.setPreference((String)"AttribDirectory", (String)file.getAbsoluteFile().getParent());
        return mapG1toG2;
    }

    private boolean networkAlignmentStepTwo(NetworkAlignmentDialog.NetworkAlignmentDialogInfo nadi, ArrayList<NetLink> linksSmall, HashSet<NetNode> lonersSmall, ArrayList<NetLink> linksLarge, HashSet<NetNode> lonersLarge, Double jaccSimThreshold, UniqueLabeller idGen, NetworkAlignmentBuildData.ViewType outType, File cacheFile) {
        boolean isSubset;
        Map<NetNode, NetNode> perfectG1toG2;
        Map<NetNode, NetNode> mapG1toG2 = this.loadTheAlignmentFile(nadi.align, linksSmall, lonersSmall, linksLarge, lonersLarge);
        if (mapG1toG2 == null) {
            return true;
        }
        if (nadi.perfect != null) {
            perfectG1toG2 = this.loadTheAlignmentFile(nadi.perfect, linksSmall, lonersSmall, linksLarge, lonersLarge);
            if (perfectG1toG2 == null) {
                return true;
            }
        } else {
            perfectG1toG2 = null;
        }
        if (outType == NetworkAlignmentBuildData.ViewType.CYCLE && perfectG1toG2 == null && !(isSubset = this.isG1subsetG2(linksSmall, lonersSmall, linksLarge, lonersLarge))) {
            JOptionPane.showMessageDialog(this.topWindow_, this.rMan_.getPluginString("networkAlignment.cycleSubsetErrorMessage"), this.rMan_.getPluginString("networkAlignment.cycleSubsetErrorMessageTitle"), 0);
            return true;
        }
        boolean doingPerfectGroup = outType == NetworkAlignmentBuildData.ViewType.GROUP && perfectG1toG2 != null;
        NetworkAlignmentBuilder nab = new NetworkAlignmentBuilder();
        ArrayList<NetLink> mergedLinks = new ArrayList<NetLink>();
        HashSet<NetNode> mergedLoneNodeIDs = new HashSet<NetNode>();
        TreeMap<AugRelation, Boolean> relMap = new TreeMap<AugRelation, Boolean>();
        HashSet<NetLink> reducedLinks = new HashSet<NetLink>();
        HashMap<NetNode, Boolean> mergedToCorrectNC = null;
        NetworkAlignment.NodeColorMap nodeColorMap = new NetworkAlignment.NodeColorMap();
        if (doingPerfectGroup) {
            mergedToCorrectNC = new HashMap<NetNode, Boolean>();
        }
        boolean finished = nab.processNetAlign(mergedLinks, mergedLoneNodeIDs, mapG1toG2, perfectG1toG2, mergedToCorrectNC, nodeColorMap, linksSmall, lonersSmall, linksLarge, lonersLarge, relMap, outType, idGen, cacheFile);
        nab = null;
        ArrayList<NetLink> mergedLinksPerfect = null;
        HashSet<NetNode> mergedLoneNodeIDsPerfect = null;
        TreeMap<AugRelation, Boolean> relMapPerfect = null;
        HashSet<NetLink> reducedLinksPerfect = null;
        NetworkAlignment.NodeColorMap nodeColorMapPerfect = null;
        if (finished && doingPerfectGroup) {
            nab = new NetworkAlignmentBuilder();
            mergedLinksPerfect = new ArrayList<NetLink>();
            mergedLoneNodeIDsPerfect = new HashSet<NetNode>();
            relMapPerfect = new TreeMap<AugRelation, Boolean>();
            reducedLinksPerfect = new HashSet<NetLink>();
            nodeColorMapPerfect = new NetworkAlignment.NodeColorMap();
            finished = nab.processNetAlign(mergedLinksPerfect, mergedLoneNodeIDsPerfect, perfectG1toG2, null, null, nodeColorMapPerfect, linksSmall, lonersSmall, linksLarge, lonersLarge, relMapPerfect, NetworkAlignmentBuildData.ViewType.GROUP, idGen, cacheFile);
        }
        if (finished && mergedLinks.isEmpty()) {
            JOptionPane.showMessageDialog(this.topWindow_, this.rMan_.getPluginString("networkAlignment.emptyNetwork"), this.rMan_.getPluginString("networkAlignment.emptyNetworkTitle"), 2);
        }
        if (finished) {
            boolean skip_shadows = mergedLinks.isEmpty() || nadi.turnOnShadows;
            finished = this.flf_.handleDirectionsDupsAndShadows(mergedLinks, mergedLoneNodeIDs, false, relMap, reducedLinks, cacheFile, true, skip_shadows);
        }
        if (finished && doingPerfectGroup) {
            finished = this.flf_.handleDirectionsDupsAndShadows(mergedLinksPerfect, mergedLoneNodeIDsPerfect, false, relMapPerfect, reducedLinksPerfect, cacheFile, true, true);
        }
        if (finished) {
            finished = this.networkAlignmentStepFour(reducedLinks, mergedLoneNodeIDs, nodeColorMap, mergedToCorrectNC, reducedLinksPerfect, mergedLoneNodeIDsPerfect, nodeColorMapPerfect, this.pendingNetAlignStats_, linksSmall, lonersSmall, linksLarge, lonersLarge, mapG1toG2, perfectG1toG2);
        }
        if (finished) {
            Set allSmallerNodes;
            Set allLargerNodes;
            BuildExtractor bex = PluginSupportFactory.getBuildExtractor();
            try {
                allLargerNodes = bex.extractNodes(linksLarge, lonersLarge, null);
                allSmallerNodes = bex.extractNodes(linksSmall, lonersSmall, null);
            }
            catch (AsynchExitRequestException aere) {
                throw new IllegalStateException("Error met while extracting nodes");
            }
            NetworkAlignmentBuildData nabd = new NetworkAlignmentBuildData(nodeColorMap, reducedLinksPerfect, mergedLoneNodeIDsPerfect, nodeColorMapPerfect, mergedToCorrectNC, allSmallerNodes, linksSmall, lonersSmall, allLargerNodes, linksLarge, lonersLarge, mapG1toG2, perfectG1toG2, this.pendingNetAlignStats_, outType, nadi.mode, jaccSimThreshold, nadi.useNodeGroups, nadi.turnOnShadows);
            this.networkAlignmentStepFive(reducedLinks, mergedLoneNodeIDs, nabd, idGen, nadi.align, cacheFile);
        }
        this.pendingNetAlignStats_ = new NetAlignStats();
        return true;
    }

    private boolean networkAlignmentStepFour(Set<NetLink> reducedLinks, Set<NetNode> loneNodeIDs, NetworkAlignment.NodeColorMap nodeColorMap, Map<NetNode, Boolean> mergedToCorrectNC, Set<NetLink> reducedLinksPerfect, Set<NetNode> loneNodeIDsPerfect, NetworkAlignment.NodeColorMap nodeColorMapPerfect, NetAlignStats report, ArrayList<NetLink> linksSmall, HashSet<NetNode> lonersSmall, ArrayList<NetLink> linksLarge, HashSet<NetNode> lonersLarge, Map<NetNode, NetNode> mapG1toG2, Map<NetNode, NetNode> perfectG1toG2) {
        File holdIt;
        try {
            holdIt = File.createTempFile("BioFabricHold", ".zip");
            holdIt.deleteOnExit();
        }
        catch (IOException ioex) {
            holdIt = null;
        }
        NetAlignMeasureBuilder namb = new NetAlignMeasureBuilder();
        boolean finished = namb.processNetAlignMeasures(reducedLinks, loneNodeIDs, nodeColorMap, mergedToCorrectNC, reducedLinksPerfect, loneNodeIDsPerfect, nodeColorMapPerfect, report, linksSmall, lonersSmall, linksLarge, lonersLarge, mapG1toG2, perfectG1toG2, holdIt);
        return finished;
    }

    private boolean networkAlignmentStepFive(Set<NetLink> reducedLinks, Set<NetNode> loneNodeIDs, NetworkAlignmentBuildData nabd, UniqueLabeller idGen, File align, File holdIt) {
        HashMap emptyClustMap = new HashMap();
        BuildData bd = PluginSupportFactory.getBuildDataForPlugin((UniqueLabeller)idGen, reducedLinks, loneNodeIDs, emptyClustMap, null);
        bd.setLayoutMode(Network.LayoutMode.PER_NETWORK_MODE);
        bd.setPluginBuildData((PluginBuildData)nabd);
        try {
            this.flf_.buildNetworkForPlugIn(bd, holdIt, this.rMan_);
        }
        catch (OutOfMemoryError oom) {
            ExceptionHandler.getHandler().displayOutOfMemory(oom);
            return false;
        }
        this.flf_.setCurrentXMLFile(null);
        FabricCommands.setPreference((String)"LoadDirectory", (String)align.getAbsoluteFile().getParent());
        this.flf_.manageWindowTitle(align.getName());
        return true;
    }

    private boolean isG1subsetG2(ArrayList<NetLink> linksSmall, HashSet<NetNode> lonersSmall, ArrayList<NetLink> linksLarge, HashSet<NetNode> lonersLarge) {
        Set nodesG1 = null;
        Set nodesG2 = null;
        try {
            BuildExtractor bex = PluginSupportFactory.getBuildExtractor();
            nodesG1 = bex.extractNodes(linksSmall, lonersSmall, null);
            nodesG2 = bex.extractNodes(linksLarge, lonersLarge, null);
        }
        catch (AsynchExitRequestException bex) {
            // empty catch block
        }
        if (nodesG1 == null || nodesG2 == null) {
            throw new IllegalStateException("Node Set null in subset test");
        }
        HashSet<String> namesG1 = new HashSet<String>();
        HashSet<String> namesG2 = new HashSet<String>();
        for (NetNode node : nodesG1) {
            namesG1.add(node.getName());
        }
        for (NetNode node : nodesG2) {
            namesG2.add(node.getName());
        }
        return namesG2.containsAll(namesG1);
    }

    public static class NetAlignMeasureWorker
    extends AbstractFactoryClient {
        public NetAlignMeasureWorker(PluginWhiteboard board) {
            super((Object)board);
            this.myKeys_.add("NetAlignMeasure");
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            Object retval = null;
            PluginWhiteboard board = (PluginWhiteboard)this.sharedWhiteboard_;
            ((NetAlignStats)board.getCurrentPlugInData()).addAMeasure(this.buildFromXML(elemName, attrs));
            return retval;
        }

        private NetAlignMeasure buildFromXML(String elemName, Attributes attrs) throws IOException {
            NetAlignMeasure retval;
            String name = AttributeExtractor.extractAttribute((String)elemName, (Attributes)attrs, (String)"NetAlignMeasure", (String)"name", (boolean)true);
            name = CharacterEntityMapper.unmapEntities((String)name, (boolean)false);
            String valStr = AttributeExtractor.extractAttribute((String)elemName, (Attributes)attrs, (String)"NetAlignMeasure", (String)"val", (boolean)true);
            try {
                Double value = Double.valueOf(valStr);
                retval = new NetAlignMeasure(name, value);
            }
            catch (NumberFormatException nfex) {
                throw new IOException();
            }
            return retval;
        }
    }

    public static class NetAlignStatsGlue
    implements GlueStick {
        public Object glueKidToParent(Object kidObj, AbstractFactoryClient parentWorker, Object optionalArgs) throws IOException {
            PluginWhiteboard board = (PluginWhiteboard)optionalArgs;
            board.getCurrentPlugIn().attachXMLData(board.getCurrentPlugInData());
            return null;
        }
    }

    public static class NetAlignStatsWorker
    extends AbstractFactoryClient {
        public NetAlignStatsWorker(PluginWhiteboard board) {
            super((Object)board);
            this.myKeys_.add("NetAlignStats");
            this.installWorker(new NetAlignMeasureWorker(board), null);
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            BioFabricToolPlugInData retval = null;
            PluginWhiteboard board = (PluginWhiteboard)this.sharedWhiteboard_;
            board.setCurrentPlugInData((BioFabricToolPlugInData)new NetAlignStats());
            retval = board.getCurrentPlugInData();
            return retval;
        }
    }

    public static class PlugInWorker
    extends AbstractFactoryClient {
        private NetworkAlignmentPlugIn plugin_;

        public PlugInWorker(PluginWhiteboard board, NetworkAlignmentPlugIn plugin) {
            super((Object)board);
            this.plugin_ = plugin;
            String name = plugin.getClass().getName();
            this.myKeys_.add(name);
            this.installWorker(new NetAlignStatsWorker(board), new NetAlignStatsGlue());
        }

        protected Object localProcessElement(String elemName, Attributes attrs) throws IOException {
            BioFabricToolPlugIn retval = null;
            PluginWhiteboard board = (PluginWhiteboard)this.sharedWhiteboard_;
            if (this.myKeys_.contains(elemName)) {
                board.setCurrentPlugIn((BioFabricToolPlugIn)this.plugin_);
                retval = board.getCurrentPlugIn();
            }
            return retval;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NetAlignMeasureRunner
    implements BackgroundCore {
        private Map<NetNode, NetNode> mapG1toG2_;
        private Set<NetLink> reducedLinks_;
        private Set<NetNode> loneNodeIDs_;
        private NetworkAlignment.NodeColorMap nodeColorMap_;
        private Map<NetNode, Boolean> mergedToCorrectNC_;
        private Map<NetNode, NetNode> perfectG1toG2_;
        private Set<NetLink> reducedLinksPerfect_;
        private Set<NetNode> loneNodeIDsPerfect_;
        private NetworkAlignment.NodeColorMap nodeColorMapPerfect_;
        private ArrayList<NetLink> linksSmall_;
        private ArrayList<NetLink> linksLarge_;
        private HashSet<NetNode> lonersSmall_;
        private HashSet<NetNode> lonersLarge_;
        private NetAlignStats report_;
        private BFWorker bfwk_;
        private PluginResourceManager rMan_;

        public NetAlignMeasureRunner(Set<NetLink> reducedLinks, Set<NetNode> loneNodeIDs, NetworkAlignment.NodeColorMap nodeColorMap, Map<NetNode, Boolean> mergedToCorrectNC, Set<NetLink> reducedLinksPerfect, Set<NetNode> loneNodeIDsPerfect, NetworkAlignment.NodeColorMap nodeColorMapPerfect, NetAlignStats report, ArrayList<NetLink> linksSmall, HashSet<NetNode> lonersSmall, ArrayList<NetLink> linksLarge, HashSet<NetNode> lonersLarge, Map<NetNode, NetNode> mapG1toG2, Map<NetNode, NetNode> perfectG1toG2, BFWorker bfwk, PluginResourceManager rMan) {
            this.rMan_ = rMan;
            this.bfwk_ = bfwk;
            this.reducedLinks_ = reducedLinks;
            this.loneNodeIDs_ = loneNodeIDs;
            this.nodeColorMap_ = nodeColorMap;
            this.nodeColorMapPerfect_ = nodeColorMapPerfect;
            this.mergedToCorrectNC_ = mergedToCorrectNC;
            this.reducedLinksPerfect_ = reducedLinksPerfect;
            this.loneNodeIDsPerfect_ = loneNodeIDsPerfect;
            this.report_ = report;
            this.linksSmall_ = linksSmall;
            this.lonersSmall_ = lonersSmall;
            this.linksLarge_ = linksLarge;
            this.lonersLarge_ = lonersLarge;
            this.mapG1toG2_ = mapG1toG2;
            this.perfectG1toG2_ = perfectG1toG2;
        }

        public Object getEarlyResult() {
            return new Boolean(false);
        }

        public Object runCore() throws AsynchExitRequestException {
            NetworkAlignmentScorer scorer = new NetworkAlignmentScorer(this.reducedLinks_, this.loneNodeIDs_, this.mergedToCorrectNC_, this.nodeColorMap_, this.nodeColorMapPerfect_, this.reducedLinksPerfect_, this.loneNodeIDsPerfect_, this.linksSmall_, this.lonersSmall_, this.linksLarge_, this.lonersLarge_, this.mapG1toG2_, this.perfectG1toG2_, this.bfwk_.getMonitor(), this.rMan_);
            this.report_.replaceValuesTo(scorer.getNetAlignStats());
            return new Boolean(true);
        }

        public Object postRunCore() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NetAlignMeasureBuilder
    implements BackgroundWorkerOwner {
        private File holdIt_;
        private boolean finished_;

        private NetAlignMeasureBuilder() {
        }

        public boolean processNetAlignMeasures(Set<NetLink> reducedLinks, Set<NetNode> loneNodeIDs, NetworkAlignment.NodeColorMap nodeColorMap, Map<NetNode, Boolean> mergedToCorrectNC, Set<NetLink> reducedLinksPerfect, Set<NetNode> loneNodeIDsPerfect, NetworkAlignment.NodeColorMap nodeColorMapPerfect, NetAlignStats report, ArrayList<NetLink> linksSmall, HashSet<NetNode> lonersSmall, ArrayList<NetLink> linksLarge, HashSet<NetNode> lonersLarge, Map<NetNode, NetNode> mapG1toG2, Map<NetNode, NetNode> perfectG1toG2, File holdIt) {
            this.finished_ = true;
            this.holdIt_ = holdIt;
            try {
                BFWorker bfw = PluginSupportFactory.getBFWorker((BackgroundWorkerOwner)this, (JFrame)NetworkAlignmentPlugIn.this.topWindow_, (BackgroundWorkerControlManager)NetworkAlignmentPlugIn.this.bwcm_, (String)"fileLoad.waitTitle", (String)"fileLoad.wait", (boolean)true, (PluginResourceManager)NetworkAlignmentPlugIn.this.rMan_);
                NetAlignMeasureRunner runner = new NetAlignMeasureRunner(reducedLinks, loneNodeIDs, nodeColorMap, mergedToCorrectNC, reducedLinksPerfect, loneNodeIDsPerfect, nodeColorMapPerfect, report, linksSmall, lonersSmall, linksLarge, lonersLarge, mapG1toG2, perfectG1toG2, bfw, NetworkAlignmentPlugIn.this.rMan_);
                bfw.setCore((BackgroundCore)runner);
                bfw.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this.finished_;
        }

        public boolean handleRemoteException(Exception remoteEx) {
            this.finished_ = false;
            return false;
        }

        public boolean handleCancellation() {
            this.finished_ = false;
            return NetworkAlignmentPlugIn.this.flf_.cancelAndRestore(this.holdIt_);
        }

        public void cleanUpPreEnable(Object result) {
        }

        public void cleanUpPostRepaint(Object result, boolean skipImage) {
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NetworkAlignmentRunner
    implements BackgroundCore {
        private ArrayList<NetLink> mergedLinks_;
        private Set<NetNode> mergedLoneNodeIDs_;
        private Map<NetNode, NetNode> mapG1toG2_;
        private Map<NetNode, NetNode> perfectG1toG2_;
        private Map<NetNode, Boolean> mergedToCorrect_;
        private NetworkAlignment.NodeColorMap nodeColorMap_;
        private ArrayList<NetLink> linksG1_;
        private ArrayList<NetLink> linksG2_;
        private HashSet<NetNode> lonersG1_;
        private HashSet<NetNode> lonersG2_;
        private SortedMap<AugRelation, Boolean> relMap_;
        private NetworkAlignmentBuildData.ViewType outType_;
        private UniqueLabeller idGen_;
        private BFWorker bfwk_;

        public NetworkAlignmentRunner(ArrayList<NetLink> mergedLinks, Set<NetNode> mergedLoners, Map<NetNode, NetNode> mapG1toG2, Map<NetNode, NetNode> perfectG1toG2, Map<NetNode, Boolean> mergedToCorrect, NetworkAlignment.NodeColorMap nodeColorMap, ArrayList<NetLink> linksG1, HashSet<NetNode> lonersG1, ArrayList<NetLink> linksG2, HashSet<NetNode> lonersG2, SortedMap<AugRelation, Boolean> relMap, NetworkAlignmentBuildData.ViewType outType, UniqueLabeller idGen, BFWorker bfwk) {
            this.bfwk_ = bfwk;
            this.mergedLinks_ = mergedLinks;
            this.mergedLoneNodeIDs_ = mergedLoners;
            this.mapG1toG2_ = mapG1toG2;
            this.perfectG1toG2_ = perfectG1toG2;
            this.mergedToCorrect_ = mergedToCorrect;
            this.nodeColorMap_ = nodeColorMap;
            this.linksG1_ = linksG1;
            this.lonersG1_ = lonersG1;
            this.linksG2_ = linksG2;
            this.lonersG2_ = lonersG2;
            this.relMap_ = relMap;
            this.outType_ = outType;
            this.idGen_ = idGen;
        }

        public Object getEarlyResult() {
            return new Boolean(false);
        }

        public Object runCore() throws AsynchExitRequestException {
            BTProgressMonitor monitor = this.bfwk_.getMonitor();
            NetworkAlignment netAlign = new NetworkAlignment(this.mergedLinks_, this.mergedLoneNodeIDs_, this.mapG1toG2_, this.perfectG1toG2_, this.linksG1_, this.lonersG1_, this.linksG2_, this.lonersG2_, this.mergedToCorrect_, this.nodeColorMap_, this.outType_, this.idGen_, monitor);
            netAlign.mergeNetworks();
            BuildExtractor bex = PluginSupportFactory.getBuildExtractor();
            bex.extractRelations(this.mergedLinks_, this.relMap_, monitor);
            return new Boolean(true);
        }

        public Object postRunCore() {
            return null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class NetworkAlignmentBuilder
    implements BackgroundWorkerOwner {
        private File holdIt_;
        private boolean finished_;

        private NetworkAlignmentBuilder() {
        }

        public boolean processNetAlign(ArrayList<NetLink> mergedLinks, Set<NetNode> mergedLoneNodeIDs, Map<NetNode, NetNode> mapG1toG2, Map<NetNode, NetNode> perfectG1toG2, Map<NetNode, Boolean> mergedToCorrect, NetworkAlignment.NodeColorMap nodeColorMap, ArrayList<NetLink> linksG1, HashSet<NetNode> lonersG1, ArrayList<NetLink> linksG2, HashSet<NetNode> lonersG2, SortedMap<AugRelation, Boolean> relMap, NetworkAlignmentBuildData.ViewType outType, UniqueLabeller idGen, File holdIt) {
            this.finished_ = true;
            this.holdIt_ = holdIt;
            try {
                BFWorker bfw = PluginSupportFactory.getBFWorker((BackgroundWorkerOwner)this, (JFrame)NetworkAlignmentPlugIn.this.topWindow_, (BackgroundWorkerControlManager)NetworkAlignmentPlugIn.this.bwcm_, (String)"fileLoad.waitTitle", (String)"fileLoad.wait", (boolean)true, (PluginResourceManager)NetworkAlignmentPlugIn.this.rMan_);
                NetworkAlignmentRunner runner = new NetworkAlignmentRunner(mergedLinks, mergedLoneNodeIDs, mapG1toG2, perfectG1toG2, mergedToCorrect, nodeColorMap, linksG1, lonersG1, linksG2, lonersG2, relMap, outType, idGen, bfw);
                bfw.setCore((BackgroundCore)runner);
                bfw.launchWorker();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this.finished_;
        }

        public boolean handleRemoteException(Exception remoteEx) {
            this.finished_ = false;
            return false;
        }

        public boolean handleCancellation() {
            this.finished_ = false;
            return NetworkAlignmentPlugIn.this.flf_.cancelAndRestore(this.holdIt_);
        }

        public void cleanUpPreEnable(Object result) {
        }

        public void cleanUpPostRepaint(Object result, boolean skipImage) {
        }
    }

    public static class NetAlignMeasure {
        public final Double val;
        public final String name;

        public NetAlignMeasure(String name, Double val) {
            this.val = val;
            this.name = name;
        }

        public void writeXML(PrintWriter out, Indenter ind) {
            ind.indent();
            out.print("<NetAlignMeasure name=\"");
            out.print(CharacterEntityMapper.mapEntities((String)this.name, (boolean)false));
            out.print("\" val=\"");
            out.print(this.val);
            out.println("\"/>");
        }

        public String toString() {
            return "NetAlignMeasure{val=" + this.val + ", name='" + this.name + '\'' + '}';
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NetAlignStats
    implements BioFabricToolPlugInData {
        private List<NetAlignMeasure> measures_;

        public NetAlignStats() {
            this.measures_ = new ArrayList<NetAlignMeasure>();
        }

        public NetAlignStats(List<NetAlignMeasure> measures) {
            this.measures_ = measures;
        }

        public void addAMeasure(NetAlignMeasure measure) {
            this.measures_.add(measure);
        }

        public boolean hasStats() {
            return !this.measures_.isEmpty();
        }

        public List<NetAlignMeasure> getMeasures() {
            return this.measures_;
        }

        public String toString() {
            StringBuilder ret = new StringBuilder("Measures");
            for (NetAlignMeasure msr : this.measures_) {
                ret.append('\n').append(msr.name).append(':').append(String.format("%4.4f", msr.val));
            }
            return ret.toString();
        }

        public void replaceValuesTo(NetAlignStats other) {
            this.measures_ = new ArrayList<NetAlignMeasure>(other.measures_);
        }

        public void writeXML(PrintWriter out, Indenter ind) {
            ind.indent();
            out.println("<NetAlignStats>");
            ind.up();
            for (NetAlignMeasure msr : this.measures_) {
                msr.writeXML(out, ind);
            }
            ind.down();
            ind.indent();
            out.println("</NetAlignStats>");
        }
    }

    private class LoadNetAlignOrphanCmd
    implements BioFabricToolPlugInCmd,
    Enabler {
        private LoadNetAlignOrphanCmd() {
        }

        public void setEnabled(boolean isEnabled) {
        }

        public String getCommandName() {
            return NetworkAlignmentPlugIn.this.rMan_.getPluginString("command.orphanLayout");
        }

        public boolean performOperation(JFrame topFrame) {
            boolean filesNotOkay;
            NetworkAlignmentDialog nad = new NetworkAlignmentDialog(topFrame, NetworkAlignmentBuildData.ViewType.ORPHAN, NetworkAlignmentPlugIn.this.className_, NetworkAlignmentPlugIn.this.flf_, NetworkAlignmentPlugIn.this.rMan_);
            nad.setVisible(true);
            if (!nad.haveResult()) {
                return false;
            }
            NetworkAlignmentDialog.NetworkAlignmentDialogInfo nai = nad.getNAInfo();
            boolean bl = filesNotOkay = !NetworkAlignmentPlugIn.this.flf_.standardFileChecks(nai.graph1, true, false, false, false, false, true) || !NetworkAlignmentPlugIn.this.flf_.standardFileChecks(nai.graph2, true, false, false, false, false, true) || !NetworkAlignmentPlugIn.this.flf_.standardFileChecks(nai.align, true, false, false, false, false, true);
            if (filesNotOkay) {
                return false;
            }
            return NetworkAlignmentPlugIn.this.networkAlignmentFromSources(nai, NetworkAlignmentBuildData.ViewType.ORPHAN);
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class LoadNetAlignCaseIICmd
    implements BioFabricToolPlugInCmd,
    Enabler {
        private LoadNetAlignCaseIICmd() {
        }

        public void setEnabled(boolean isEnabled) {
        }

        public String getCommandName() {
            return NetworkAlignmentPlugIn.this.rMan_.getPluginString("command.netAlignCaseIILayout");
        }

        public boolean performOperation(JFrame topFrame) {
            boolean filesNotOkay;
            NetworkAlignmentDialog nad = new NetworkAlignmentDialog(topFrame, NetworkAlignmentBuildData.ViewType.CYCLE, NetworkAlignmentPlugIn.this.className_, NetworkAlignmentPlugIn.this.flf_, NetworkAlignmentPlugIn.this.rMan_);
            nad.setVisible(true);
            if (!nad.haveResult()) {
                return false;
            }
            NetworkAlignmentDialog.NetworkAlignmentDialogInfo nai = nad.getNAInfo();
            boolean bl = filesNotOkay = !NetworkAlignmentPlugIn.this.flf_.standardFileChecks(nai.graph1, true, false, false, false, false, true) || !NetworkAlignmentPlugIn.this.flf_.standardFileChecks(nai.graph2, true, false, false, false, false, true) || !NetworkAlignmentPlugIn.this.flf_.standardFileChecks(nai.align, true, false, false, false, false, true);
            if (filesNotOkay) {
                return false;
            }
            if (!NetworkAlignmentPlugIn.this.api_.getDisplayShadows()) {
                ShadowsAndGroupsDialog sagd = new ShadowsAndGroupsDialog(NetworkAlignmentPlugIn.this.topWindow_, NetworkAlignmentPlugIn.this.rMan_);
                sagd.setVisible(true);
                if (!sagd.haveResult()) {
                    return false;
                }
                nai.turnOnShadows = sagd.turnShadowsOn();
                nai.useNodeGroups = !nai.turnOnShadows;
            } else {
                nai.useNodeGroups = false;
            }
            return NetworkAlignmentPlugIn.this.networkAlignmentFromSources(nai, NetworkAlignmentBuildData.ViewType.CYCLE);
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class LoadNetAlignGroupsCmd
    implements BioFabricToolPlugInCmd,
    Enabler {
        private LoadNetAlignGroupsCmd() {
        }

        public void setEnabled(boolean isEnabled) {
        }

        public String getCommandName() {
            return NetworkAlignmentPlugIn.this.rMan_.getPluginString("command.netAlignGroupLayout");
        }

        public boolean performOperation(JFrame topFrame) {
            boolean filesNotOkay;
            NetworkAlignmentDialog nad = new NetworkAlignmentDialog(topFrame, NetworkAlignmentBuildData.ViewType.GROUP, NetworkAlignmentPlugIn.this.className_, NetworkAlignmentPlugIn.this.flf_, NetworkAlignmentPlugIn.this.rMan_);
            nad.setVisible(true);
            if (!nad.haveResult()) {
                return false;
            }
            NetworkAlignmentDialog.NetworkAlignmentDialogInfo nai = nad.getNAInfo();
            boolean bl = filesNotOkay = !NetworkAlignmentPlugIn.this.flf_.standardFileChecks(nai.graph1, true, false, false, false, false, true) || !NetworkAlignmentPlugIn.this.flf_.standardFileChecks(nai.graph2, true, false, false, false, false, true) || !NetworkAlignmentPlugIn.this.flf_.standardFileChecks(nai.align, true, false, false, false, false, true);
            if (nai.perfect != null) {
                boolean bl2 = filesNotOkay = !NetworkAlignmentPlugIn.this.flf_.standardFileChecks(nai.perfect, true, false, false, false, false, true);
            }
            if (filesNotOkay) {
                return false;
            }
            return NetworkAlignmentPlugIn.this.networkAlignmentFromSources(nai, NetworkAlignmentBuildData.ViewType.GROUP);
        }

        public boolean isEnabled() {
            return true;
        }
    }

    private class NetAlignMeasuresCmd
    implements BioFabricToolPlugInCmd,
    Enabler {
        private boolean enabled_;

        private NetAlignMeasuresCmd() {
        }

        public void setEnabled(boolean isEnabled) {
            this.enabled_ = isEnabled;
        }

        public String getCommandName() {
            return NetworkAlignmentPlugIn.this.rMan_.getPluginString("command.netAlignMeasures");
        }

        public boolean performOperation(JFrame topFrame) {
            if (!NetworkAlignmentPlugIn.this.publishedNetAlignStats_.hasStats() || !this.enabled_) {
                return false;
            }
            NetAlignMeasureDialog scoreDialog = new NetAlignMeasureDialog(topFrame, NetworkAlignmentPlugIn.this.publishedNetAlignStats_, NetworkAlignmentPlugIn.this.rMan_);
            scoreDialog.setVisible(true);
            return true;
        }

        public boolean isEnabled() {
            return this.enabled_ && NetworkAlignmentPlugIn.this.publishedNetAlignStats_.hasStats();
        }
    }

    static interface Enabler {
        public void setEnabled(boolean var1);
    }
}

