/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin.core.align;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.DefaultLayout;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.Annot;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.plugin.core.align.AlignCycleLayout;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignmentBuildData;
import org.systemsbiology.biofabric.plugin.core.align.NodeGroupMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkAlignmentLayout
extends NodeLayout {
    public List<NetNode> doNodeLayout(BuildData rbd, NodeLayout.Params params, BTProgressMonitor monitor) throws AsynchExitRequestException {
        List targetIDs;
        NetworkAlignmentBuildData nabd = (NetworkAlignmentBuildData)rbd.getPluginBuildData();
        switch (nabd.view) {
            case GROUP: {
                targetIDs = this.bfsNodeGroupLayout(rbd, monitor);
                break;
            }
            case ORPHAN: {
                targetIDs = new DefaultLayout().defaultNodeOrder(rbd.getLinks(), rbd.getSingletonNodes(), null, monitor);
                break;
            }
            case CYCLE: {
                targetIDs = new AlignCycleLayout().doNodeOrder(rbd, params, monitor);
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        this.installNodeOrder(targetIDs, rbd, monitor);
        return new ArrayList<NetNode>(targetIDs);
    }

    private List<NetNode> bfsNodeGroupLayout(BuildData bd, BTProgressMonitor monitor) throws AsynchExitRequestException {
        HashMap<NetNode, Integer> linkCounts = new HashMap<NetNode, Integer>();
        HashMap<NetNode, Set<NetNode>> targsPerSource = new HashMap<NetNode, Set<NetNode>>();
        HashSet<NetNode> targsToGo = new HashSet<NetNode>();
        int numLink = bd.getLinks().size();
        LoopReporter lr = new LoopReporter((long)numLink, 20, monitor, 0.0, 0.25, "progress.calculateNodeDegree");
        for (NetLink nextLink : bd.getLinks()) {
            lr.report();
            NetNode sidwn = nextLink.getSrcNode();
            NetNode tidwn = nextLink.getTrgNode();
            Set<NetNode> targs = (HashSet<NetNode>)targsPerSource.get(sidwn);
            if (targs == null) {
                targs = new HashSet<NetNode>();
                targsPerSource.put(sidwn, targs);
            }
            targs.add(tidwn);
            targs = (Set)targsPerSource.get(tidwn);
            if (targs == null) {
                targs = new HashSet();
                targsPerSource.put(tidwn, targs);
            }
            targs.add(sidwn);
            targsToGo.add(sidwn);
            targsToGo.add(tidwn);
            Iterator srcCount = (Integer)linkCounts.get(sidwn);
            linkCounts.put(sidwn, srcCount == null ? Integer.valueOf(1) : Integer.valueOf((Integer)((Object)srcCount) + 1));
            Integer trgCount = (Integer)linkCounts.get(tidwn);
            linkCounts.put(tidwn, trgCount == null ? Integer.valueOf(1) : Integer.valueOf(trgCount + 1));
        }
        lr.finish();
        NetworkAlignmentBuildData nabd = (NetworkAlignmentBuildData)bd.getPluginBuildData();
        NodeGroupMap grouper = nabd.mode == NodeGroupMap.PerfectNGMode.NODE_CORRECTNESS || nabd.mode == NodeGroupMap.PerfectNGMode.JACCARD_SIMILARITY ? new NodeGroupMap(bd, NodeGroupMap.nodeGroupOrderPerfectNG, NodeGroupMap.nodeGroupAnnotsPerfectNG, monitor) : new NodeGroupMap(bd, NodeGroupMap.nodeGroupOrder, NodeGroupMap.nodeGroupAnnots, monitor);
        TreeMap classToGroup = new TreeMap();
        for (int i = 0; i < grouper.numGroups(); ++i) {
            classToGroup.put(i, new ArrayList());
        }
        Set allNodes = PluginSupportFactory.getBuildExtractor().extractNodes((Collection)bd.getLinks(), bd.getSingletonNodes(), monitor);
        for (NetNode node : allNodes) {
            int nodeClass = grouper.getIndex(node);
            ((List)classToGroup.get(nodeClass)).add(node);
        }
        for (List group : classToGroup.values()) {
            Collections.sort(group, grouper.sortDecrDegree());
        }
        TreeMap<Integer, List<NetNode>> targetsGroup = new TreeMap<Integer, List<NetNode>>();
        TreeMap<Integer, List<NetNode>> queueGroup = new TreeMap<Integer, List<NetNode>>();
        TreeMap<Integer, List<NetNode>> targsLeftToGoGroup = new TreeMap<Integer, List<NetNode>>();
        for (int i = 0; i < grouper.numGroups(); ++i) {
            targetsGroup.put(i, new ArrayList());
            queueGroup.put(i, new ArrayList());
            targsLeftToGoGroup.put(i, new ArrayList());
            for (NetNode node : (List)classToGroup.get(i)) {
                ((List)targsLeftToGoGroup.get(i)).add(node);
            }
        }
        LoopReporter lr2 = new LoopReporter((long)targsToGo.size(), 20, monitor, 0.0, 1.0, "progress.nodeOrdering");
        int currGroup = 0;
        while (currGroup < grouper.numGroups()) {
            if (((List)targsLeftToGoGroup.get(currGroup)).isEmpty()) {
                ++currGroup;
                continue;
            }
            if (((List)queueGroup.get(currGroup)).isEmpty()) {
                NetNode head = (NetNode)((List)targsLeftToGoGroup.get(currGroup)).remove(0);
                ((List)queueGroup.get(currGroup)).add(head);
            }
            this.flushQueue(targetsGroup, targsPerSource, linkCounts, targsToGo, targsLeftToGoGroup, queueGroup, currGroup, grouper, lr2);
        }
        lr2.finish();
        ArrayList<NetNode> targets = new ArrayList<NetNode>();
        for (int i = 0; i < grouper.numGroups(); ++i) {
            List group = (List)targetsGroup.get(i);
            for (NetNode node : group) {
                targets.add(node);
            }
        }
        if (targets.size() != allNodes.size()) {
            throw new IllegalStateException("target numGroups not equal to all-nodes numGroups");
        }
        this.installAnnotations(bd, targetsGroup, grouper);
        return targets;
    }

    private void flushQueue(SortedMap<Integer, List<NetNode>> targetsGroup, Map<NetNode, Set<NetNode>> targsPerSource, Map<NetNode, Integer> linkCounts, Set<NetNode> targsToGo, SortedMap<Integer, List<NetNode>> targsLeftToGoGroup, SortedMap<Integer, List<NetNode>> queuesGroup, int currGroup, NodeGroupMap grouper, LoopReporter lr) throws AsynchExitRequestException {
        List queue = (List)queuesGroup.get(currGroup);
        List leftToGo = (List)targsLeftToGoGroup.get(currGroup);
        while (!queue.isEmpty()) {
            NetNode node = (NetNode)queue.remove(0);
            if (((List)targetsGroup.get(currGroup)).contains(node)) continue;
            ((List)targetsGroup.get(currGroup)).add(node);
            lr.report();
            if (grouper.getIndex(node) != currGroup) {
                throw new IllegalStateException("Node of incorrect group in queue");
            }
            List<NetNode> myKids = this.orderMyKids(targsPerSource, linkCounts, targsToGo, node);
            for (NetNode kid : myKids) {
                if (!targsToGo.contains(kid)) {
                    throw new IllegalStateException("kid not in targsToGo");
                }
                int kidGroup = grouper.getIndex(kid);
                if (kidGroup == currGroup) {
                    if (!leftToGo.contains(kid)) continue;
                    queue.add(kid);
                    leftToGo.remove(kid);
                    targsToGo.remove(kid);
                    continue;
                }
                if (((List)queuesGroup.get(kidGroup)).contains(kid)) continue;
                ((List)queuesGroup.get(kidGroup)).add(kid);
            }
        }
    }

    private List<NetNode> orderMyKids(Map<NetNode, Set<NetNode>> targsPerSource, Map<NetNode, Integer> linkCounts, Set<NetNode> targsToGo, NetNode node) {
        Set<NetNode> targs = targsPerSource.get(node);
        if (targs == null) {
            return new ArrayList<NetNode>();
        }
        TreeMap kidMap = new TreeMap(Collections.reverseOrder());
        for (NetNode nextTarg : targs) {
            Integer count = linkCounts.get(nextTarg);
            TreeSet<NetNode> perCount = (TreeSet<NetNode>)kidMap.get(count);
            if (perCount == null) {
                perCount = new TreeSet<NetNode>();
                kidMap.put(count, perCount);
            }
            perCount.add(nextTarg);
        }
        ArrayList<NetNode> myKidsToProc = new ArrayList<NetNode>();
        for (TreeSet<NetNode> perCount : kidMap.values()) {
            for (NetNode kid : perCount) {
                if (!targsToGo.contains(kid)) continue;
                myKidsToProc.add(kid);
            }
        }
        return myKidsToProc;
    }

    private void installAnnotations(BuildData bd, SortedMap<Integer, List<NetNode>> targetsGroup, NodeGroupMap grouper) {
        AnnotationSet layerZeroAnnots = PluginSupportFactory.buildAnnotationSet();
        int min = 0;
        for (int i = 0; i < grouper.numGroups(); ++i) {
            List group = (List)targetsGroup.get(i);
            if (group.isEmpty()) continue;
            int max = min + group.size() - 1;
            Annot annot = PluginSupportFactory.buildAnnotation((String)grouper.getKey(i), (int)min, (int)max, (int)0, (String)grouper.getColor(i));
            layerZeroAnnots.addAnnot(annot);
            min += group.size();
        }
        bd.setNodeAnnotations(layerZeroAnnots);
    }
}

