/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin.core.align;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Map;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.DefaultEdgeLayout;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.Network;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkAlignmentEdgeLayout
extends DefaultEdgeLayout {
    public void preProcessEdges(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException {
        this.installLinkGroups(rbd, monitor);
    }

    protected String getColor(String type, Map<String, String> colorMap) {
        return null;
    }

    private void installLinkGroups(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter((long)rbd.getLinks().size(), 20, monitor, 0.0, 1.0, "progress.orderingLinkGroups");
        HashSet<String> relations = new HashSet<String>();
        for (NetLink link : rbd.getLinks()) {
            relations.add(link.getRelation());
            lr.report();
        }
        lr.finish();
        ArrayList groupOrder = new ArrayList(relations);
        Collections.sort(groupOrder, new NetAlignLinkGroupLocator());
        rbd.setGroupOrderAndMode(groupOrder, Network.LayoutMode.PER_NETWORK_MODE, true);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NetAlignLinkGroupLocator
    implements Comparator<String> {
        private NetAlignLinkGroupLocator() {
        }

        @Override
        public int compare(String rel1, String rel2) {
            return this.getIndex(rel1) - this.getIndex(rel2);
        }

        private int getIndex(String rel) {
            for (NetworkAlignment.EdgeType type : NetworkAlignment.LINK_GROUPS) {
                if (!rel.equals(type.tag)) continue;
                return type.index;
            }
            throw new IllegalArgumentException();
        }
    }
}

