/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin.core.align;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.systemsbiology.biofabric.api.dialog.BTStashResultsDialog;
import org.systemsbiology.biofabric.api.dialog.DialogObj;
import org.systemsbiology.biofabric.api.io.FileLoadFlows;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.api.util.MatchingJLabel;
import org.systemsbiology.biofabric.api.util.PluginResourceManager;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignmentBuildData;
import org.systemsbiology.biofabric.plugin.core.align.NodeGroupMap;

public class NetworkAlignmentDialog
extends BTStashResultsDialog {
    private static final long serialVersionUID = 1L;
    private final JFrame parent_;
    private final NetworkAlignmentBuildData.ViewType analysisType_;
    private JButton perfectBrowse;
    private MatchingJLabel perfectFileMatch_;
    private JTextField graph1Field_;
    private JTextField graph2Field_;
    private JTextField alignField_;
    private JTextField perfectField_;
    private File graph1File_;
    private File graph2File_;
    private File alignmentFile_;
    private File perfectAlignFile_;
    private FixedJButton buttonOK_;
    private JCheckBox undirectedConfirm_;
    private JComboBox perfectNGsCombo_;
    private JLabel jaccSimLabel_;
    private JTextField jaccSimField_;
    private FileLoadFlows flf_;
    private PluginResourceManager rMan_;
    private final int NO_PERFECT_IDX = 0;
    private final int WITH_PERFECT_IDX = 1;
    private final int NC_IDX = 2;
    private final int JS_IDX = 3;
    private final double JACCARD_SIMILARITY_DEFAULT = 0.75;

    public NetworkAlignmentDialog(JFrame parent, NetworkAlignmentBuildData.ViewType analysisType, String pluginClassName, FileLoadFlows flf, PluginResourceManager rMan) {
        super(parent, rMan.getPluginString("networkAlignment.title"), new Dimension(700, 500), 3);
        this.parent_ = parent;
        this.analysisType_ = analysisType;
        this.flf_ = flf;
        this.rMan_ = rMan;
        JPanel cp = (JPanel)this.getContentPane();
        cp.setBorder(new EmptyBorder(20, 20, 20, 20));
        cp.setLayout(new GridBagLayout());
        JButton graph1Browse = new JButton(this.rMan_.getPluginString("networkAlignment.browse"));
        JButton graph2Browse = new JButton(this.rMan_.getPluginString("networkAlignment.browse"));
        JButton alignmentBrowse = new JButton(this.rMan_.getPluginString("networkAlignment.browse"));
        this.perfectBrowse = new JButton(this.rMan_.getPluginString("networkAlignment.browse"));
        this.initBrowseButtons(graph1Browse, graph2Browse, alignmentBrowse, this.perfectBrowse);
        this.graph1Field_ = new JTextField(30);
        this.graph2Field_ = new JTextField(30);
        this.alignField_ = new JTextField(30);
        this.perfectField_ = new JTextField(30);
        this.undirectedConfirm_ = new JCheckBox(this.rMan_.getPluginString("networkAlignment.confirmUndirected"));
        this.initTextFields();
        JLabel jaccSimLabelMatch = new JLabel(this.rMan_.getPluginString("networkAlignment.jaccardSimilarityLabel"));
        this.perfectFileMatch_ = new MatchingJLabel(this.rMan_.getPluginString("networkAlignment.perfect"), jaccSimLabelMatch);
        MatchingJLabel graph1FileMatch = new MatchingJLabel(this.rMan_.getPluginString("networkAlignment.graph1"), jaccSimLabelMatch);
        MatchingJLabel graph2FileMatch = new MatchingJLabel(this.rMan_.getPluginString("networkAlignment.graph2"), jaccSimLabelMatch);
        MatchingJLabel alignFileMatch = new MatchingJLabel(this.rMan_.getPluginString("networkAlignment.alignment"), jaccSimLabelMatch);
        graph1FileMatch.setHorizontalAlignment(0);
        graph2FileMatch.setHorizontalAlignment(0);
        alignFileMatch.setHorizontalAlignment(0);
        this.perfectFileMatch_.setHorizontalAlignment(0);
        this.undirectedConfirm_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    NetworkAlignmentDialog.this.manageOKButton();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        JPanel panGraphInfo = new JPanel(new FlowLayout(0));
        JPanel panGraphInfoTwo = null;
        switch (this.analysisType_) {
            case ORPHAN: {
                panGraphInfo.add(new JLabel(this.rMan_.getPluginString("networkAlignment.message")));
                break;
            }
            case CYCLE: {
                panGraphInfo.add(new JLabel(this.rMan_.getPluginString("networkAlignment.message")));
                panGraphInfoTwo = new JPanel(new FlowLayout(0));
                panGraphInfoTwo.add(new JLabel(this.rMan_.getPluginString("networkAlignment.messageCycleTwo")));
                break;
            }
            case GROUP: {
                panGraphInfo.add(new JLabel(this.rMan_.getPluginString("networkAlignment.message")));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        JPanel panGraphConfirm = new JPanel(new FlowLayout(0));
        panGraphConfirm.add(this.undirectedConfirm_);
        this.addWidgetFullRow(panGraphInfo, true);
        if (panGraphInfoTwo != null) {
            this.addWidgetFullRow(panGraphInfoTwo, true);
        }
        this.addWidgetFullRow(panGraphConfirm, true);
        this.addLabeledFileBrowse((JLabel)graph1FileMatch, this.graph1Field_, graph1Browse);
        this.addWidgetFullRow(new JLabel(this.rMan_.getPluginString("networkAlignment.hasBeen"), 0), true);
        this.addLabeledFileBrowse((JLabel)graph2FileMatch, this.graph2Field_, graph2Browse);
        this.addLabeledFileBrowse((JLabel)alignFileMatch, this.alignField_, alignmentBrowse);
        MatchingJLabel perfectNGLabel = new MatchingJLabel(this.rMan_.getPluginString("networkAlignment.perfectNodeGroups"), jaccSimLabelMatch);
        perfectNGLabel.setHorizontalAlignment(0);
        int numChoices = this.analysisType_ == NetworkAlignmentBuildData.ViewType.CYCLE ? 2 : 4;
        String[] choices = new String[numChoices];
        choices[0] = this.rMan_.getPluginString("networkAlignment.nonePerfect");
        choices[1] = this.rMan_.getPluginString("networkAlignment.noneWithPerfect");
        if (this.analysisType_ != NetworkAlignmentBuildData.ViewType.CYCLE) {
            choices[2] = this.rMan_.getPluginString("networkAlignment.nodeCorrectnessGroupOption");
            choices[3] = this.rMan_.getPluginString("networkAlignment.jaccardSimilarityGroupOption");
        }
        this.perfectNGsCombo_ = new JComboBox<String>(choices);
        this.perfectNGsCombo_.setEnabled(true);
        this.perfectNGsCombo_.setSelectedIndex(0);
        this.perfectNGsCombo_.addItemListener(new ItemListener(){

            public void itemStateChanged(ItemEvent e) {
                try {
                    NetworkAlignmentDialog.this.managePerfectButtons();
                    NetworkAlignmentDialog.this.manageOKButton();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.jaccSimLabel_ = new MatchingJLabel(this.rMan_.getPluginString("networkAlignment.jaccardSimilarityLabel"), jaccSimLabelMatch);
        this.jaccSimLabel_.setHorizontalAlignment(0);
        this.jaccSimField_ = new JTextField(Double.toString(0.75));
        if (this.analysisType_ != NetworkAlignmentBuildData.ViewType.ORPHAN) {
            this.addLabeledWidget((JLabel)perfectNGLabel, this.perfectNGsCombo_, true, true);
            this.addLabeledFileBrowse((JLabel)this.perfectFileMatch_, this.perfectField_, this.perfectBrowse);
        }
        if (this.analysisType_ == NetworkAlignmentBuildData.ViewType.GROUP) {
            this.addLabeledWidget(this.jaccSimLabel_, this.jaccSimField_, true, true);
        }
        this.managePerfectButtons();
        DialogObj.Buttons buttons = this.finishConstruction();
        this.buttonOK_ = buttons.okButton;
        this.buttonOK_.setEnabled(false);
        this.setLocationRelativeTo(parent);
    }

    private void initBrowseButtons(JButton graph1Browse, JButton graph2Browse, JButton alignmentBrowse, JButton perfectBrowse) {
        graph1Browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    NetworkAlignmentDialog.this.loadFromFile(FileIndex.GRAPH_ONE_FILE);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        graph2Browse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    NetworkAlignmentDialog.this.loadFromFile(FileIndex.GRAPH_TWO_FILE);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        alignmentBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    NetworkAlignmentDialog.this.loadFromFile(FileIndex.ALIGNMENT_FILE);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        perfectBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    NetworkAlignmentDialog.this.loadFromFile(FileIndex.PERFECT_FILE);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
    }

    private void initTextFields() {
        this.graph1Field_.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                try {
                    NetworkAlignmentDialog.this.manageOKButton();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }

            public void removeUpdate(DocumentEvent e) {
                try {
                    NetworkAlignmentDialog.this.manageOKButton();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.graph2Field_.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                try {
                    NetworkAlignmentDialog.this.manageOKButton();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }

            public void removeUpdate(DocumentEvent e) {
                try {
                    NetworkAlignmentDialog.this.manageOKButton();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.alignField_.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                try {
                    NetworkAlignmentDialog.this.manageOKButton();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }

            public void removeUpdate(DocumentEvent e) {
                try {
                    NetworkAlignmentDialog.this.manageOKButton();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
        this.perfectField_.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                try {
                    NetworkAlignmentDialog.this.manageOKButton();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }

            public void removeUpdate(DocumentEvent e) {
                try {
                    NetworkAlignmentDialog.this.manageOKButton();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }

            public void changedUpdate(DocumentEvent e) {
            }
        });
    }

    private void manageOKButton() {
        if (this.hasMinRequirements()) {
            this.buttonOK_.setEnabled(true);
        } else {
            this.buttonOK_.setEnabled(false);
        }
    }

    private void managePerfectButtons() {
        if (this.perfectNGsCombo_.getSelectedIndex() == 0) {
            this.perfectField_.setEnabled(false);
            this.perfectBrowse.setEnabled(false);
            this.perfectFileMatch_.setEnabled(false);
        } else {
            this.perfectField_.setEnabled(true);
            this.perfectBrowse.setEnabled(true);
            this.perfectFileMatch_.setEnabled(true);
        }
        if (this.perfectNGsCombo_.getSelectedIndex() == 3) {
            this.jaccSimLabel_.setEnabled(true);
            this.jaccSimField_.setEnabled(true);
        } else {
            this.jaccSimLabel_.setEnabled(false);
            this.jaccSimField_.setEnabled(false);
        }
    }

    private void manageFieldToFile() {
        String g1Field = this.graph1Field_.getText().trim();
        String g2Field = this.graph2Field_.getText().trim();
        String alignField = this.alignField_.getText().trim();
        String perfectField = this.perfectField_.getText().trim();
        if (this.graph1File_ == null || !g1Field.equals(this.graph1File_.getAbsolutePath())) {
            this.graph1File_ = new File(g1Field);
        }
        if (this.graph2File_ == null || !g2Field.equals(this.graph2File_.getAbsolutePath())) {
            this.graph2File_ = new File(g2Field);
        }
        if (this.alignmentFile_ == null || !alignField.equals(this.alignmentFile_.getAbsolutePath())) {
            this.alignmentFile_ = new File(alignField);
        }
        if (this.perfectNGsCombo_.getSelectedIndex() != 0 && this.perfectAlignFile_ == null || this.perfectAlignFile_ != null && !perfectField.equals(this.perfectAlignFile_.getAbsolutePath())) {
            this.perfectAlignFile_ = new File(perfectField);
        }
    }

    private boolean hasMinRequirements() {
        boolean ret = this.undirectedConfirm_.isSelected();
        boolean bl = ret = ret && !this.graph1Field_.getText().isEmpty() && !this.graph2Field_.getText().isEmpty() && !this.alignField_.getText().isEmpty();
        if (this.perfectNGsCombo_.getSelectedIndex() != 0 && this.perfectField_.getText().isEmpty()) {
            ret = false;
        }
        return ret;
    }

    private void loadFromFile(FileIndex mode) {
        File file;
        switch (mode) {
            case GRAPH_ONE_FILE: 
            case GRAPH_TWO_FILE: {
                file = this.flf_.getTheFile(".gw", ".sif", "LoadDirectory", "filterName.graph", (Component)((Object)this));
                break;
            }
            case ALIGNMENT_FILE: 
            case PERFECT_FILE: {
                file = this.flf_.getTheFile(".align", null, "LoadDirectory", "filterName.align", (Component)((Object)this));
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        if (file == null) {
            return;
        }
        PluginSupportFactory.getPreferenceStorage().setPreference("LoadDirectory", file.getAbsoluteFile().getParent());
        switch (mode) {
            case GRAPH_ONE_FILE: {
                this.graph1Field_.setText(file.getAbsolutePath());
                this.graph1File_ = file;
                break;
            }
            case GRAPH_TWO_FILE: {
                this.graph2Field_.setText(file.getAbsolutePath());
                this.graph2File_ = file;
                break;
            }
            case ALIGNMENT_FILE: {
                this.alignField_.setText(file.getAbsolutePath());
                this.alignmentFile_ = file;
                break;
            }
            case PERFECT_FILE: {
                this.perfectField_.setText(file.getAbsolutePath());
                this.perfectAlignFile_ = file;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.manageOKButton();
    }

    private boolean jaccSimThresholdOK() {
        try {
            String text = this.jaccSimField_.getText();
            double val = Double.parseDouble(text);
            boolean ok = Double.compare(val, 1.0) <= 0 && Double.compare(val, 0.0) >= 0;
            return ok;
        }
        catch (NumberFormatException nfe) {
            return false;
        }
    }

    private Double getJaccSimThreshold() {
        return this.jaccSimThresholdOK() ? Double.valueOf(Double.parseDouble(this.jaccSimField_.getText())) : null;
    }

    public void okAction() {
        if (this.perfectNGsCombo_.getSelectedIndex() == 3 && !this.jaccSimThresholdOK()) {
            JOptionPane.showMessageDialog(this.parent_, this.rMan_.getPluginString("networkAlignment.jaccardSimilarityMsg"), this.rMan_.getPluginString("networkAlignment.jaccardSimilarityMsgTitle"), 0);
            return;
        }
        try {
            this.manageFieldToFile();
            super.okAction();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void closeAction() {
        try {
            super.closeAction();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    protected boolean stashForOK() {
        return this.hasMinRequirements();
    }

    public NetworkAlignmentDialogInfo getNAInfo() {
        NodeGroupMap.PerfectNGMode mode;
        if (!this.hasMinRequirements()) {
            throw new IllegalStateException("Graph file(s) or alignment file missing.");
        }
        Double jaccSimThreshold = null;
        switch (this.perfectNGsCombo_.getSelectedIndex()) {
            case 0: {
                mode = NodeGroupMap.PerfectNGMode.NONE;
                this.perfectAlignFile_ = null;
                break;
            }
            case 1: {
                mode = NodeGroupMap.PerfectNGMode.NONE;
                break;
            }
            case 2: {
                mode = NodeGroupMap.PerfectNGMode.NODE_CORRECTNESS;
                break;
            }
            case 3: {
                mode = NodeGroupMap.PerfectNGMode.JACCARD_SIMILARITY;
                jaccSimThreshold = this.getJaccSimThreshold();
                break;
            }
            default: {
                throw new IllegalStateException("Illegal perfect NG mode");
            }
        }
        return new NetworkAlignmentDialogInfo(this.graph1File_, this.graph2File_, this.alignmentFile_, this.perfectAlignFile_, this.analysisType_, mode, jaccSimThreshold);
    }

    public static class NetworkAlignmentDialogInfo {
        public final File graph1;
        public final File graph2;
        public final File align;
        public final File perfect;
        public final NetworkAlignmentBuildData.ViewType analysisType;
        public final NodeGroupMap.PerfectNGMode mode;
        public final Double jaccSimThreshold;
        public boolean turnOnShadows;
        public boolean useNodeGroups;

        public NetworkAlignmentDialogInfo(File graph1, File graph2, File align, File perfect, NetworkAlignmentBuildData.ViewType analysisType, NodeGroupMap.PerfectNGMode mode, Double jaccSimThreshold) {
            this.graph1 = graph1;
            this.graph2 = graph2;
            this.align = align;
            this.perfect = perfect;
            this.analysisType = analysisType;
            this.mode = mode;
            this.jaccSimThreshold = jaccSimThreshold;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum FileIndex {
        GRAPH_ONE_FILE,
        GRAPH_TWO_FILE,
        ALIGNMENT_FILE,
        PERFECT_FILE;

    }
}

