/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin.core.align;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.NID;
import org.systemsbiology.biofabric.api.util.UniqueLabeller;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.io.BuildExtractorImpl;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignmentBuildData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NetworkAlignment {
    public static final EdgeType[] LINK_GROUPS = new EdgeType[]{EdgeType.COVERED, EdgeType.INDUCED_GRAPH1, EdgeType.HALF_ORPHAN_GRAPH1, EdgeType.FULL_ORPHAN_GRAPH1, EdgeType.INDUCED_GRAPH2, EdgeType.HALF_UNALIGNED_GRAPH2, EdgeType.FULL_UNALIGNED_GRAPH2};
    private Map<NetNode, NetNode> mapG1toG2_;
    private Map<NetNode, NetNode> perfectG1toG2_;
    private ArrayList<NetLink> linksG1_;
    private HashSet<NetNode> lonersG1_;
    private ArrayList<NetLink> linksG2_;
    private HashSet<NetNode> lonersG2_;
    private NetworkAlignmentBuildData.ViewType outType_;
    private UniqueLabeller idGen_;
    private BTProgressMonitor monitor_;
    private final String TEMPORARY = "TEMP";
    private Map<NetNode, NetNode> smallToMergedID_;
    private Map<NetNode, NetNode> largeToMergedID_;
    private Map<NetNode, NetNode> mergedIDToSmall_;
    private Map<NetNode, NetNode> smallToUnmergedID_;
    private Map<NetNode, NetNode> largeToUnmergedID_;
    private ArrayList<NetLink> mergedLinks_;
    private Set<NetNode> mergedLoners_;
    private Map<NetNode, Boolean> mergedToCorrectNC_;
    private NodeColorMap nodeColorMap_;

    public NetworkAlignment(ArrayList<NetLink> mergedLinks, Set<NetNode> mergedLoneNodeIDs, Map<NetNode, NetNode> mapG1toG2, Map<NetNode, NetNode> perfectG1toG2_, ArrayList<NetLink> linksG1, HashSet<NetNode> lonersG1, ArrayList<NetLink> linksG2, HashSet<NetNode> lonersG2, Map<NetNode, Boolean> mergedToCorrectNC, NodeColorMap nodeColorMap, NetworkAlignmentBuildData.ViewType outType, UniqueLabeller idGen, BTProgressMonitor monitor) {
        this.mapG1toG2_ = mapG1toG2;
        this.perfectG1toG2_ = perfectG1toG2_;
        this.linksG1_ = linksG1;
        this.lonersG1_ = lonersG1;
        this.linksG2_ = linksG2;
        this.lonersG2_ = lonersG2;
        this.outType_ = outType;
        this.idGen_ = idGen;
        this.monitor_ = monitor;
        this.mergedLinks_ = mergedLinks;
        this.mergedLoners_ = mergedLoneNodeIDs;
        this.mergedToCorrectNC_ = mergedToCorrectNC;
        this.nodeColorMap_ = nodeColorMap;
        this.smallToUnmergedID_ = new HashMap<NetNode, NetNode>();
        this.largeToUnmergedID_ = new HashMap<NetNode, NetNode>();
    }

    public void mergeNetworks() throws AsynchExitRequestException {
        this.createMergedNodes();
        this.createUnmergedNodes(GraphType.SMALL);
        this.createUnmergedNodes(GraphType.LARGE);
        ArrayList<NetLink> newLinksG1 = new ArrayList<NetLink>();
        HashSet<NetNode> newLonersG1 = new HashSet<NetNode>();
        this.createNewLinkList(newLinksG1, newLonersG1, GraphType.SMALL);
        ArrayList<NetLink> newLinksG2 = new ArrayList<NetLink>();
        HashSet<NetNode> newLonersG2 = new HashSet<NetNode>();
        this.createNewLinkList(newLinksG2, newLonersG2, GraphType.LARGE);
        this.createMergedLinkList(newLinksG1, newLinksG2);
        this.finalizeLoneNodeIDs(newLonersG1, newLonersG2);
        this.createNodeColorMap(newLinksG1, newLonersG1, newLinksG2, newLonersG2);
        if (this.outType_ == NetworkAlignmentBuildData.ViewType.ORPHAN) {
            new OrphanEdgeLayout().process(this.mergedLinks_, this.mergedLoners_, this.monitor_);
        }
    }

    private void createMergedNodes() {
        this.smallToMergedID_ = new HashMap<NetNode, NetNode>();
        this.largeToMergedID_ = new HashMap<NetNode, NetNode>();
        this.mergedIDToSmall_ = new HashMap<NetNode, NetNode>();
        boolean doingPerfectGroup = this.outType_ == NetworkAlignmentBuildData.ViewType.GROUP && this.perfectG1toG2_ != null;
        for (Map.Entry<NetNode, NetNode> entry : this.mapG1toG2_.entrySet()) {
            NetNode smallNode = entry.getKey();
            NetNode largeNode = entry.getValue();
            String smallName = smallNode.getName();
            String largeName = largeNode.getName();
            String mergedName = String.format("%s::%s", smallName, largeName);
            NID nid = this.idGen_.getNextOID();
            NetNode merged_node = PluginSupportFactory.buildNode((NID)nid, (String)mergedName);
            this.smallToMergedID_.put(smallNode, merged_node);
            this.largeToMergedID_.put(largeNode, merged_node);
            this.mergedIDToSmall_.put(merged_node, smallNode);
            if (!doingPerfectGroup) continue;
            NetNode perfectLarge = this.perfectG1toG2_.get(smallNode);
            boolean alignedCorrect = perfectLarge != null && perfectLarge.equals(largeNode);
            this.mergedToCorrectNC_.put(merged_node, alignedCorrect);
        }
    }

    private void createUnmergedNodes(GraphType type) throws AsynchExitRequestException {
        Map<NetNode, NetNode> oldToUnmerged;
        Map<NetNode, NetNode> oldToMerged;
        Set nodes;
        boolean doingPerfectGroup = this.outType_ == NetworkAlignmentBuildData.ViewType.GROUP && this.perfectG1toG2_ != null;
        switch (type) {
            case SMALL: {
                nodes = PluginSupportFactory.getBuildExtractor().extractNodes(this.linksG1_, this.lonersG1_, this.monitor_);
                oldToMerged = this.smallToMergedID_;
                oldToUnmerged = this.smallToUnmergedID_;
                break;
            }
            case LARGE: {
                nodes = PluginSupportFactory.getBuildExtractor().extractNodes(this.linksG2_, this.lonersG2_, this.monitor_);
                oldToMerged = this.largeToMergedID_;
                oldToUnmerged = this.largeToUnmergedID_;
                break;
            }
            default: {
                throw new IllegalArgumentException("Incorrect graph type");
            }
        }
        for (NetNode node : nodes) {
            if (oldToMerged.get(node) != null) continue;
            NetNode unalignedNewNode = this.modifyName(node, type);
            oldToUnmerged.put(node, unalignedNewNode);
            if (type != GraphType.SMALL || !doingPerfectGroup) continue;
            NetNode perfectLarge = this.perfectG1toG2_.get(node);
            boolean unalignedCorrectly = perfectLarge == null;
            this.mergedToCorrectNC_.put(unalignedNewNode, unalignedCorrectly);
        }
    }

    private NetNode modifyName(NetNode node, GraphType type) {
        String newName;
        NID newID = this.idGen_.getNextOID();
        if (type == GraphType.SMALL) {
            newName = String.format("%s::", node.getName());
        } else if (type == GraphType.LARGE) {
            newName = String.format("::%s", node.getName());
        } else {
            throw new IllegalArgumentException("Incorrect graph type");
        }
        return PluginSupportFactory.buildNode((NID)newID, (String)newName);
    }

    private void createNewLinkList(List<NetLink> newLinks, Set<NetNode> newLoners, GraphType type) throws AsynchExitRequestException {
        String msg;
        Map<NetNode, NetNode> oldToNewUnmergedID;
        Map<NetNode, NetNode> oldToNewMergedID;
        HashSet<NetNode> oldLoners;
        ArrayList<NetLink> oldLinks;
        switch (type) {
            case SMALL: {
                oldLinks = this.linksG1_;
                oldLoners = this.lonersG1_;
                oldToNewMergedID = this.smallToMergedID_;
                oldToNewUnmergedID = this.smallToUnmergedID_;
                msg = "progress.mergingSmallLinks";
                break;
            }
            case LARGE: {
                oldLinks = this.linksG2_;
                oldLoners = this.lonersG2_;
                oldToNewMergedID = this.largeToMergedID_;
                oldToNewUnmergedID = this.largeToUnmergedID_;
                msg = "progress.mergingLargeLinks";
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        LoopReporter lr = new LoopReporter((long)oldLinks.size(), 20, this.monitor_, 0.0, 1.0, msg);
        HashSet<NetLink> newLinkSet = new HashSet<NetLink>();
        for (NetLink oldLink : oldLinks) {
            NetNode oldA = oldLink.getSrcNode();
            NetNode oldB = oldLink.getTrgNode();
            NetNode newA = oldToNewMergedID.containsKey(oldA) ? oldToNewMergedID.get(oldA) : oldToNewUnmergedID.get(oldA);
            NetNode newB = oldToNewMergedID.containsKey(oldB) ? oldToNewMergedID.get(oldB) : oldToNewUnmergedID.get(oldB);
            NetLink newLink = PluginSupportFactory.buildLink((NetNode)newA, (NetNode)newB, (String)"TEMP", (boolean)false, (Boolean)false);
            newLinkSet.add(newLink);
            lr.report();
        }
        newLinks.addAll(newLinkSet);
        lr.finish();
        for (NetNode oldLoner : oldLoners) {
            NetNode newLoner = oldToNewMergedID.containsKey(oldLoner) ? oldToNewMergedID.get(oldLoner) : oldToNewUnmergedID.get(oldLoner);
            newLoners.add(newLoner);
        }
    }

    private void createMergedLinkList(List<NetLink> newLinksG1, List<NetLink> newLinksG2) throws AsynchExitRequestException {
        boolean containsTRG;
        boolean containsSRC;
        NetNode trg;
        NetNode src;
        int index;
        LoopReporter lr = new LoopReporter((long)newLinksG2.size(), 20, this.monitor_, 0.0, 1.0, "progress.separatingLinksA");
        NetAlignFabricLinkLocator comp = new NetAlignFabricLinkLocator();
        this.sortLinks(newLinksG1);
        HashSet<NetNode> alignedNodesG1 = new HashSet<NetNode>(this.smallToMergedID_.values());
        HashSet<NetNode> alignedNodesG2 = new HashSet<NetNode>(this.largeToMergedID_.values());
        for (NetLink linkG2 : newLinksG2) {
            index = Collections.binarySearch(newLinksG1, linkG2, comp);
            src = linkG2.getSrcNode();
            trg = linkG2.getTrgNode();
            if (index >= 0) {
                this.addMergedLink(src, trg, EdgeType.COVERED.tag);
            } else {
                containsSRC = alignedNodesG2.contains(src);
                containsTRG = alignedNodesG2.contains(trg);
                if (containsSRC && containsTRG) {
                    this.addMergedLink(src, trg, EdgeType.INDUCED_GRAPH2.tag);
                } else if (containsSRC || containsTRG) {
                    this.addMergedLink(src, trg, EdgeType.HALF_UNALIGNED_GRAPH2.tag);
                } else {
                    this.addMergedLink(src, trg, EdgeType.FULL_UNALIGNED_GRAPH2.tag);
                }
            }
            lr.report();
        }
        lr = new LoopReporter((long)newLinksG1.size(), 20, this.monitor_, 0.0, 1.0, "progress.separatingLinksB");
        this.sortLinks(newLinksG2);
        for (NetLink linkG1 : newLinksG1) {
            index = Collections.binarySearch(newLinksG2, linkG1, comp);
            src = linkG1.getSrcNode();
            trg = linkG1.getTrgNode();
            if (index < 0) {
                containsSRC = alignedNodesG1.contains(src);
                containsTRG = alignedNodesG1.contains(trg);
                if (containsSRC && containsTRG) {
                    this.addMergedLink(src, trg, EdgeType.INDUCED_GRAPH1.tag);
                } else if (containsSRC || containsTRG) {
                    this.addMergedLink(src, trg, EdgeType.HALF_ORPHAN_GRAPH1.tag);
                } else {
                    this.addMergedLink(src, trg, EdgeType.FULL_ORPHAN_GRAPH1.tag);
                }
            }
            lr.report();
        }
    }

    private void addMergedLink(NetNode src, NetNode trg, String tag) {
        NetLink newMergedLink = PluginSupportFactory.buildLink((NetNode)src, (NetNode)trg, (String)tag, (boolean)false);
        this.mergedLinks_.add(newMergedLink);
        if (!src.equals(trg)) {
            NetLink newMergedLinkShadow = PluginSupportFactory.buildLink((NetNode)src, (NetNode)trg, (String)tag, (boolean)true);
            this.mergedLinks_.add(newMergedLinkShadow);
        }
    }

    private void finalizeLoneNodeIDs(Set<NetNode> newLonersG1, Set<NetNode> newLonersG2) {
        this.mergedLoners_.addAll(newLonersG1);
        this.mergedLoners_.addAll(newLonersG2);
    }

    private void createNodeColorMap(List<NetLink> newLinksG1, Set<NetNode> newLonersG1, List<NetLink> newLinksG2, Set<NetNode> newLonersG2) throws AsynchExitRequestException {
        Set nodesG1 = new BuildExtractorImpl().extractNodes(newLinksG1, newLonersG1, this.monitor_);
        Set nodesG2 = new BuildExtractorImpl().extractNodes(newLinksG2, newLonersG2, this.monitor_);
        Set<NetNode> alignedNodes = this.mergedIDToSmall_.keySet();
        HashMap<NetNode, NodeColor> map = new HashMap<NetNode, NodeColor>();
        for (NetNode node : nodesG1) {
            if (alignedNodes.contains(node)) {
                map.put(node, NodeColor.PURPLE);
                continue;
            }
            map.put(node, NodeColor.BLUE);
        }
        for (NetNode node : nodesG2) {
            if (alignedNodes.contains(node)) {
                map.put(node, NodeColor.PURPLE);
                continue;
            }
            map.put(node, NodeColor.RED);
        }
        this.nodeColorMap_.setMap(map);
    }

    private void sortLinks(List<NetLink> newLinks) throws AsynchExitRequestException {
        NetAlignFabricLinkLocator comp = new NetAlignFabricLinkLocator();
        TreeSet<NetLink> sorted = new TreeSet<NetLink>(comp);
        LoopReporter lr = new LoopReporter((long)newLinks.size(), 20, this.monitor_, 0.0, 1.0, "progress.sortingLinks");
        for (NetLink link : newLinks) {
            sorted.add(link);
            lr.report();
        }
        newLinks.clear();
        newLinks.addAll(sorted);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NetAlignFabricLinkLocator
    implements Comparator<NetLink> {
        private NetAlignFabricLinkLocator() {
        }

        @Override
        public int compare(NetLink link1, NetLink link2) {
            if (link1.synonymous(link2)) {
                return 0;
            }
            Object[] arr1 = new String[]{link1.getSrcNode().getName(), link1.getTrgNode().getName()};
            Arrays.sort(arr1);
            Object[] arr2 = new String[]{link2.getSrcNode().getName(), link2.getTrgNode().getName()};
            Arrays.sort(arr2);
            String concat1 = String.format("%s___%s", arr1[0], arr1[1]);
            String concat2 = String.format("%s___%s", arr2[0], arr2[1]);
            return concat1.compareTo(concat2);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class OrphanEdgeLayout {
        private void process(List<NetLink> mergedLinks, Set<NetNode> mergedLoneNodeIDs, BTProgressMonitor monitor) throws AsynchExitRequestException {
            LoopReporter reporter = new LoopReporter((long)mergedLinks.size(), 20, monitor, 0.0, 1.0, "progress.findingOrphanEdges");
            TreeSet<NetNode> blueNodesG1 = new TreeSet<NetNode>();
            for (NetLink link : mergedLinks) {
                if (link.getRelation().equals(EdgeType.INDUCED_GRAPH1.tag)) {
                    blueNodesG1.add(link.getSrcNode());
                    blueNodesG1.add(link.getTrgNode());
                }
                reporter.report();
            }
            reporter = new LoopReporter((long)mergedLinks.size(), 20, monitor, 0.0, 1.0, "progress.orphanEdgesContext");
            ArrayList<NetLink> blueEdgesPlusContext = new ArrayList<NetLink>();
            for (NetLink link : mergedLinks) {
                NetNode src = link.getSrcNode();
                NetNode trg = link.getTrgNode();
                if (blueNodesG1.contains(src) || blueNodesG1.contains(trg)) {
                    blueEdgesPlusContext.add(link);
                }
                reporter.report();
            }
            mergedLinks.clear();
            mergedLoneNodeIDs.clear();
            mergedLinks.addAll(blueEdgesPlusContext);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class NodeColorMap {
        private Map<NetNode, NodeColor> map;

        public void setMap(Map<NetNode, NodeColor> map) {
            this.map = map;
        }

        public NodeColor getColor(NetNode node) {
            return this.map.get(node);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum GraphType {
        SMALL,
        LARGE;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum NodeColor {
        PURPLE("P"),
        BLUE("B"),
        RED("R");

        public final String tag;

        private NodeColor(String tag) {
            this.tag = tag;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum EdgeType {
        COVERED("P", 0),
        INDUCED_GRAPH1("pBp", 1),
        HALF_ORPHAN_GRAPH1("pBb", 2),
        FULL_ORPHAN_GRAPH1("bBb", 3),
        INDUCED_GRAPH2("pRp", 4),
        HALF_UNALIGNED_GRAPH2("pRr", 5),
        FULL_UNALIGNED_GRAPH2("rRr", 6);

        public final String tag;
        public final int index;

        private EdgeType(String tag, int index) {
            this.tag = tag;
            this.index = index;
        }
    }
}

