/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin.core.align;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biofabric.api.io.BuildExtractor;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignment;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JaccardSimilarity {
    private ArrayList<NetLink> linksSmall_;
    private ArrayList<NetLink> linksLarge_;
    private HashSet<NetNode> lonersSmall_;
    private HashSet<NetNode> lonersLarge_;
    private Map<NetNode, NetNode> mapG1toG2_;
    private Map<NetNode, NetNode> perfectG1toG2_;
    private Map<NetNode, NetNode> invMainG2toG1_;
    private Map<NetNode, NetNode> invPerfectG2toG1_;
    private Map<NetNode, Set<NetNode>> nodeToNeighSmall_;
    private Map<NetNode, Set<NetNode>> nodeToNeighLarge_;
    private Map<String, NetNode> nameToSmall_;
    private Set<NetLink> allLinksMain_;
    private Set<NetLink> allLinksPerfect_;
    private Set<NetNode> loneNodeIDsMain_;
    private Set<NetNode> loneNodeIDsPerfect_;
    private NetworkAlignment.NodeColorMap colorMapMain_;
    private NetworkAlignment.NodeColorMap colorMapPerfect_;
    private Map<NetNode, Set<NetNode>> nodeToNeighborsMain_;
    private Map<NetNode, Set<NetNode>> nodeToNeighborsPerfect_;
    private Map<NetNode, Set<NetLink>> nodeToLinksMain_;
    private Map<NetNode, Set<NetLink>> nodeToLinksPerfect_;
    private BTProgressMonitor monitor_;
    private final Double jaccSimThreshold_;

    JaccardSimilarity(Set<NetLink> allLinksMain, Set<NetNode> loneNodeIDsMain, NetworkAlignment.NodeColorMap colorMapMain, Set<NetLink> allLinksPerfect, Set<NetNode> loneNodeIDsPerfect, NetworkAlignment.NodeColorMap colorMapPerfect, Map<NetNode, Set<NetNode>> nodeToNeighborsMain, Map<NetNode, Set<NetLink>> nodeToLinksMain, Map<NetNode, Set<NetNode>> nodeToNeighborsPerfect, Map<NetNode, Set<NetLink>> nodeToLinksPerfect, ArrayList<NetLink> linksSmall, HashSet<NetNode> lonersSmall, ArrayList<NetLink> linksLarge, HashSet<NetNode> lonersLarge, Map<NetNode, NetNode> mapG1toG2, Map<NetNode, NetNode> perfectG1toG2, Double jaccSimThreshold, BTProgressMonitor monitor) throws AsynchExitRequestException {
        this.allLinksMain_ = allLinksMain;
        this.loneNodeIDsMain_ = loneNodeIDsMain;
        this.colorMapMain_ = colorMapMain;
        this.nodeToNeighborsMain_ = nodeToNeighborsMain;
        this.nodeToLinksMain_ = nodeToLinksMain;
        this.allLinksPerfect_ = allLinksPerfect;
        this.loneNodeIDsPerfect_ = loneNodeIDsPerfect;
        this.colorMapPerfect_ = colorMapPerfect;
        this.nodeToNeighborsPerfect_ = nodeToNeighborsPerfect;
        this.nodeToLinksPerfect_ = nodeToLinksPerfect;
        this.monitor_ = monitor;
        this.jaccSimThreshold_ = jaccSimThreshold;
        this.linksSmall_ = linksSmall;
        this.lonersSmall_ = lonersSmall;
        this.linksLarge_ = linksLarge;
        this.lonersLarge_ = lonersLarge;
        this.mapG1toG2_ = mapG1toG2;
        this.perfectG1toG2_ = perfectG1toG2;
        this.generateStructures();
    }

    private void generateStructures() throws AsynchExitRequestException {
        this.nodeToNeighSmall_ = new HashMap<NetNode, Set<NetNode>>();
        this.nodeToNeighLarge_ = new HashMap<NetNode, Set<NetNode>>();
        BuildExtractor bex = PluginSupportFactory.getBuildExtractor();
        bex.createNeighborLinkMap(this.linksSmall_, this.lonersSmall_, this.nodeToNeighSmall_, new HashMap(), this.monitor_);
        bex.createNeighborLinkMap(this.linksLarge_, this.lonersLarge_, this.nodeToNeighLarge_, new HashMap(), this.monitor_);
        this.invMainG2toG1_ = new HashMap<NetNode, NetNode>();
        this.invPerfectG2toG1_ = new HashMap<NetNode, NetNode>();
        this.makeInverseMap(this.mapG1toG2_, this.invMainG2toG1_);
        this.makeInverseMap(this.perfectG1toG2_, this.invPerfectG2toG1_);
        this.nameToSmall_ = new HashMap<String, NetNode>();
        Set smallNodes = PluginSupportFactory.getBuildExtractor().extractNodes(this.linksSmall_, this.lonersSmall_, this.monitor_);
        for (NetNode smallNode : smallNodes) {
            this.nameToSmall_.put(smallNode.getName(), smallNode);
        }
    }

    boolean isCorrectJS(NetNode nodeV12) {
        String smallName = StringUtilities.separateNodeOne(nodeV12.getName());
        NetNode smallNode = this.nameToSmall_.get(smallName);
        if (smallNode == null) {
            throw new IllegalStateException("Small node for " + nodeV12.getName() + " not found for Jaccard Similarity");
        }
        double jsVal = this.jaccSimDecision(smallNode);
        if (this.jaccSimThreshold_ == null) {
            throw new IllegalStateException("JS Threshold is null");
        }
        boolean isCorrect = Double.compare(jsVal, this.jaccSimThreshold_) >= 0;
        return isCorrect;
    }

    double calcScore() throws AsynchExitRequestException {
        double totJ = 0.0;
        Set smallNodes = PluginSupportFactory.getBuildExtractor().extractNodes(this.linksSmall_, this.lonersSmall_, this.monitor_);
        for (NetNode node : smallNodes) {
            totJ += this.jaccSimDecision(node);
        }
        double measure = totJ / (double)smallNodes.size();
        return measure;
    }

    private double jaccSimDecision(NetNode nodeG1) {
        double jsVal;
        boolean isBluePerf;
        boolean isBlueTest = this.mapG1toG2_.get(nodeG1) == null;
        boolean bl = isBluePerf = this.perfectG1toG2_.get(nodeG1) == null;
        if (isBlueTest && isBluePerf) {
            jsVal = 1.0;
        } else if (isBlueTest) {
            NetNode match = this.findMatch(nodeG1, CaseType.PERFECT_PURPLE_MAIN_BLUE);
            jsVal = this.jaccSimValue(nodeG1, match, NetworkAlignment.GraphType.SMALL);
        } else if (isBluePerf) {
            NetNode match = this.findMatch(nodeG1, CaseType.PERFECT_BLUE_MAIN_PURPLE);
            jsVal = this.jaccSimValue(nodeG1, match, NetworkAlignment.GraphType.SMALL);
        } else {
            NetNode alignTest = this.mapG1toG2_.get(nodeG1);
            NetNode alignPerf = this.perfectG1toG2_.get(nodeG1);
            jsVal = this.jaccSimValue(alignTest, alignPerf, NetworkAlignment.GraphType.LARGE);
        }
        return jsVal;
    }

    private double jaccSimValue(NetNode nodeA, NetNode nodeB, NetworkAlignment.GraphType type) {
        HashSet scratchB;
        HashSet scratchA;
        int lenAdjust = 0;
        if (type == NetworkAlignment.GraphType.SMALL) {
            scratchA = new HashSet(this.nodeToNeighSmall_.get(nodeA));
            scratchB = new HashSet(this.nodeToNeighSmall_.get(nodeB));
        } else if (type == NetworkAlignment.GraphType.LARGE) {
            scratchA = new HashSet(this.nodeToNeighLarge_.get(nodeA));
            scratchB = new HashSet(this.nodeToNeighLarge_.get(nodeB));
        } else {
            throw new IllegalArgumentException("Graph type not allowed");
        }
        if (scratchA.contains(nodeB)) {
            scratchA.remove(nodeB);
            scratchB.remove(nodeA);
            lenAdjust = 1;
        }
        HashSet union = new HashSet();
        HashSet intersect = new HashSet();
        this.union(scratchA, scratchB, union);
        this.intersection(scratchA, scratchB, intersect);
        int iSize = intersect.size() + lenAdjust;
        int uSize = union.size() + lenAdjust;
        Double jaccard = (double)iSize / (double)uSize;
        if (jaccard.isNaN()) {
            jaccard = 1.0;
        }
        return jaccard;
    }

    private NetNode findMatch(NetNode nodeG1, CaseType type) {
        NetNode nodeG1Match;
        if (type == CaseType.PERFECT_BLUE_MAIN_PURPLE) {
            NetNode nodeG2Main = this.mapG1toG2_.get(nodeG1);
            nodeG1Match = this.invPerfectG2toG1_.get(nodeG2Main);
        } else if (type == CaseType.PERFECT_PURPLE_MAIN_BLUE) {
            NetNode nodeG2Perf = this.perfectG1toG2_.get(nodeG1);
            nodeG1Match = this.invMainG2toG1_.get(nodeG2Perf);
        } else {
            throw new IllegalArgumentException("Incorrect case type");
        }
        return nodeG1Match;
    }

    private void makeInverseMap(Map<NetNode, NetNode> in, Map<NetNode, NetNode> out) {
        for (Map.Entry<NetNode, NetNode> entry : in.entrySet()) {
            out.put(entry.getValue(), entry.getKey());
        }
    }

    private <T> void intersection(Set<T> one, Set<T> two, Set<T> result) {
        result.clear();
        result.addAll(one);
        result.retainAll(two);
    }

    private <T> void union(Set<T> one, Set<T> two, Set<T> result) {
        result.clear();
        result.addAll(one);
        result.addAll(two);
    }

    private static class StringUtilities {
        private StringUtilities() {
        }

        static String separateNodeOne(String in) {
            if (!in.contains("::")) {
                throw new IllegalArgumentException("Node name needs ::");
            }
            String ret = in.split("::")[0];
            return ret;
        }

        static String separateNodeTwo(String in) {
            if (!in.contains("::")) {
                throw new IllegalArgumentException("Node name needs ::");
            }
            String ret = in.split("::")[1];
            return ret;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum CaseType {
        PERFECT_BLUE_MAIN_PURPLE,
        PERFECT_PURPLE_MAIN_BLUE;

    }
}

