/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin.core.align;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.StringTokenizer;
import org.systemsbiology.biofabric.api.io.BuildExtractor;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.PluginResourceManager;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignmentLoader {
    private PluginResourceManager rMan_;

    public AlignmentLoader(String pluginClassName, PluginResourceManager rMan) {
        this.rMan_ = rMan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String readAlignment(File infile, Map<NetNode, NetNode> mapG1ToG2, NetAlignFileStats stats, ArrayList<NetLink> linksGraph1, HashSet<NetNode> loneNodesGraph1, ArrayList<NetLink> linksGraph2, HashSet<NetNode> loneNodesGraph2) throws IOException {
        Map<String, NetNode> G2nameToNID;
        Map<String, NetNode> G1nameToNID;
        try {
            BuildExtractor bex = PluginSupportFactory.getBuildExtractor();
            G1nameToNID = AlignmentLoader.makeStringMap(bex.extractNodes(linksGraph1, loneNodesGraph1, null));
            G2nameToNID = AlignmentLoader.makeStringMap(bex.extractNodes(linksGraph2, loneNodesGraph2, null));
        }
        catch (AsynchExitRequestException aere) {
            throw new IllegalStateException();
        }
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(infile), "UTF-8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                String msg;
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() != 2) {
                    stats.badLines.add(line);
                    continue;
                }
                String strNameG1 = st.nextToken();
                String strNameG2 = st.nextToken();
                boolean existsInG1 = G1nameToNID.containsKey(strNameG1);
                boolean existsInG2 = G2nameToNID.containsKey(strNameG2);
                if (!existsInG1) {
                    msg = MessageFormat.format(this.rMan_.getPluginString("networkAlignment.nodeNotFoundG1"), strNameG1);
                    throw new IOException(msg);
                }
                if (!existsInG2) {
                    msg = MessageFormat.format(this.rMan_.getPluginString("networkAlignment.nodeNotFoundG2"), strNameG2);
                    throw new IOException(msg);
                }
                NetNode nodeG1 = G1nameToNID.get(strNameG1);
                NetNode nodeG2 = G2nameToNID.get(strNameG2);
                if (mapG1ToG2.containsKey(nodeG1)) {
                    if (!mapG1ToG2.get(nodeG1).equals(nodeG2)) {
                        String msg2 = MessageFormat.format(this.rMan_.getPluginString("networkAlignment.mapError"), strNameG1);
                        throw new IOException(msg2);
                    }
                    stats.dupLines.add(line);
                    continue;
                }
                mapG1ToG2.put(nodeG1, nodeG2);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Map<String, String> readAlignment(File infile, NetAlignFileStats stats) throws IOException {
        HashMap<String, String> mapG1ToG2Str = new HashMap<String, String>();
        BufferedReader in = null;
        try {
            in = new BufferedReader(new InputStreamReader((InputStream)new FileInputStream(infile), "UTF-8"));
            String line = null;
            while ((line = in.readLine()) != null) {
                StringTokenizer st = new StringTokenizer(line);
                if (st.countTokens() != 2) {
                    stats.badLines.add(line);
                    continue;
                }
                String strNameG1 = st.nextToken();
                String strNameG2 = st.nextToken();
                if (mapG1ToG2Str.containsKey(strNameG1)) {
                    if (!((String)mapG1ToG2Str.get(strNameG1)).equals(strNameG2)) {
                        String msg = MessageFormat.format(this.rMan_.getPluginString("networkAlignment.mapError"), strNameG1);
                        throw new IOException(msg);
                    }
                    stats.dupLines.add(line);
                    continue;
                }
                mapG1ToG2Str.put(strNameG1, strNameG2);
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        return mapG1ToG2Str;
    }

    private static Map<String, NetNode> makeStringMap(Set<NetNode> nodes) {
        HashMap<String, NetNode> retval = new HashMap<String, NetNode>();
        for (NetNode node : nodes) {
            retval.put(node.getName(), node);
        }
        return retval;
    }

    public static class NetAlignFileStats {
        public ArrayList<String> dupLines;
        public ArrayList<String> badLines = new ArrayList();

        public NetAlignFileStats() {
            this.dupLines = new ArrayList();
        }
    }
}

