/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin.core.align;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.LayoutCriterionFailureException;
import org.systemsbiology.biofabric.api.layout.NodeLayout;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignmentBuildData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignCycleLayout
extends NodeLayout {
    private NodeMaps maps_ = null;

    public boolean criteriaMet(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException, LayoutCriterionFailureException {
        NetworkAlignmentBuildData narbd = (NetworkAlignmentBuildData)rbd.getPluginBuildData();
        this.maps_ = this.normalizeAlignMap(narbd.mapG1toG2, narbd.perfectG1toG2, narbd.allLargerNodes, narbd.allSmallerNodes, monitor);
        if (this.maps_ == null) {
            throw new LayoutCriterionFailureException();
        }
        return true;
    }

    public void clearCache() {
        this.maps_ = null;
    }

    public List<NetNode> doNodeLayout(BuildData rbd, NodeLayout.Params params, BTProgressMonitor monitor) throws AsynchExitRequestException {
        List<NetNode> targetIDs = this.doNodeOrder(rbd, params, monitor);
        this.installNodeOrder(targetIDs, rbd, monitor);
        NetworkAlignmentBuildData narbd = (NetworkAlignmentBuildData)rbd.getPluginBuildData();
        rbd.setTurnOnShadows(narbd.turnShadowsOn);
        if (rbd.getSingletonNodes().size() > 0) {
            narbd.useNodeGroups = true;
        }
        if (narbd.useNodeGroups) {
            TreeMap invert = new TreeMap();
            for (NetNode node : rbd.getNodeOrder().keySet()) {
                invert.put(rbd.getNodeOrder().get(node), node);
            }
            ArrayList<NetNode> order = new ArrayList<NetNode>(invert.values());
            AnnotationSet nAnnots = this.generateNodeAnnotations(order, monitor, narbd.cycleBounds);
            rbd.setNodeAnnotations(nAnnots);
        }
        return targetIDs;
    }

    private AnnotationSet generateNodeAnnotations(List<NetNode> nodes, BTProgressMonitor monitor, List<CycleBounds> bounds) throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter((long)nodes.size(), 20, monitor, 0.0, 1.0, "progress.nodeAnnotation");
        HashMap<NetNode, Integer> nodeOrder = new HashMap<NetNode, Integer>();
        for (int i = 0; i < nodes.size(); ++i) {
            nodeOrder.put(nodes.get(i), i);
        }
        int cycle = 0;
        AnnotationSet retval = PluginSupportFactory.buildAnnotationSet();
        for (CycleBounds bound : bounds) {
            lr.report();
            if (bound.isCorrect) continue;
            String type = bound.isCycle ? "cycle " : "path ";
            int startPos = (Integer)nodeOrder.get(bound.boundStart);
            int endPos = (Integer)nodeOrder.get(bound.boundEnd);
            String color = cycle % 2 == 0 ? "Orange" : "Green";
            retval.addAnnot(PluginSupportFactory.buildAnnotation((String)(type + cycle++), (int)startPos, (int)endPos, (int)0, (String)color));
        }
        lr.finish();
        return retval;
    }

    public List<NetNode> doNodeOrder(BuildData rbd, NodeLayout.Params params, BTProgressMonitor monitor) throws AsynchExitRequestException {
        List<NetNode> startNodeIDs = null;
        NetworkAlignmentBuildData narbd = (NetworkAlignmentBuildData)rbd.getPluginBuildData();
        if (this.maps_ == null) {
            this.maps_ = this.normalizeAlignMap(narbd.mapG1toG2, narbd.perfectG1toG2, narbd.allLargerNodes, narbd.allSmallerNodes, monitor);
        }
        Set<NetNode> allNodes = this.genAllNodes(rbd);
        Map<NetNode, PathElem> nodesToPathElem = this.genNodeToPathElem(allNodes);
        Map<PathElem, NetNode> pathElemToNode = this.genPathElemToNode(allNodes);
        HashMap<String, PathElem> smallToElem = new HashMap<String, PathElem>();
        HashMap<String, PathElem> largeToElem = new HashMap<String, PathElem>();
        HashMap<PathElem, PathElem> elemToNext = new HashMap<PathElem, PathElem>();
        this.genNamesToPathElem(this.maps_, nodesToPathElem, smallToElem, largeToElem, elemToNext);
        Map<PathElem, AlignPath> alignPaths = this.calcAlignPathsV2(this.maps_, nodesToPathElem, elemToNext, smallToElem, largeToElem);
        ArrayList<CycleBounds> cycleBounds = new ArrayList<CycleBounds>();
        List<NetNode> targetIDs = this.alignPathNodeOrder(rbd.getLinks(), rbd.getSingletonNodes(), startNodeIDs, alignPaths, nodesToPathElem, pathElemToNode, cycleBounds, monitor);
        narbd.cycleBounds = cycleBounds;
        return targetIDs;
    }

    private List<NetNode> alignPathNodeOrder(Set<NetLink> allLinks, Set<NetNode> loneNodes, List<NetNode> startNodes, Map<PathElem, AlignPath> alignPaths, Map<NetNode, PathElem> nodesToPathElem, Map<PathElem, NetNode> pathElemToNode, List<CycleBounds> cycleBounds, BTProgressMonitor monitor) throws AsynchExitRequestException {
        AlignPath ac;
        PathElem nodeKey;
        TreeSet<NetNode> perCount;
        HashMap<NetNode, Integer> linkCounts = new HashMap<NetNode, Integer>();
        HashMap<NetNode, Set<NetNode>> targsPerSource = new HashMap<NetNode, Set<NetNode>>();
        ArrayList<NetNode> targets = new ArrayList<NetNode>();
        HashSet<NetNode> targsToGo = new HashSet<NetNode>();
        int numLink = allLinks.size();
        LoopReporter lr = new LoopReporter((long)numLink, 20, monitor, 0.0, 0.25, "progress.calculateNodeDegree");
        for (NetLink nextLink : allLinks) {
            lr.report();
            NetNode sidwn = nextLink.getSrcNode();
            NetNode tidwn = nextLink.getTrgNode();
            Set<NetNode> targs = (HashSet<NetNode>)targsPerSource.get(sidwn);
            if (targs == null) {
                targs = new HashSet<NetNode>();
                targsPerSource.put(sidwn, targs);
            }
            targs.add(tidwn);
            targs = (Set)targsPerSource.get(tidwn);
            if (targs == null) {
                targs = new HashSet();
                targsPerSource.put(tidwn, targs);
            }
            targs.add(sidwn);
            targsToGo.add(sidwn);
            targsToGo.add(tidwn);
            Integer srcCount = (Integer)linkCounts.get(sidwn);
            linkCounts.put(sidwn, srcCount == null ? Integer.valueOf(1) : Integer.valueOf(srcCount + 1));
            Integer trgCount = (Integer)linkCounts.get(tidwn);
            linkCounts.put(tidwn, trgCount == null ? Integer.valueOf(1) : Integer.valueOf(trgCount + 1));
        }
        lr.finish();
        lr = new LoopReporter((long)linkCounts.size(), 20, monitor, 0.25, 0.5, "progress.rankByDegree");
        TreeMap countRank = new TreeMap(Collections.reverseOrder());
        for (NetNode src : linkCounts.keySet()) {
            lr.report();
            Integer count = (Integer)linkCounts.get(src);
            perCount = (TreeSet<NetNode>)countRank.get(count);
            if (perCount == null) {
                perCount = new TreeSet<NetNode>();
                countRank.put(count, perCount);
            }
            perCount.add(src);
        }
        lr.finish();
        while (!targsToGo.isEmpty()) {
            for (Integer key : countRank.keySet()) {
                perCount = (SortedSet)countRank.get(key);
                for (NetNode node : perCount) {
                    if (!targsToGo.contains(node)) continue;
                    nodeKey = nodesToPathElem.get(node);
                    ac = alignPaths.get(nodeKey);
                    ArrayList<NetNode> queue = new ArrayList<NetNode>();
                    List<PathElem> unlooped = ac.getReorderedKidsStartingAtKidOrStart(nodeKey);
                    for (PathElem ulnode : unlooped) {
                        NetNode daNode = pathElemToNode.get(ulnode);
                        targsToGo.remove(daNode);
                        targets.add(daNode);
                        queue.add(daNode);
                    }
                    NetNode boundsStart = pathElemToNode.get(unlooped.get(0));
                    NetNode boundsEnd = pathElemToNode.get(unlooped.get(unlooped.size() - 1));
                    cycleBounds.add(new CycleBounds(boundsStart, boundsEnd, ac.correct, ac.isCycle));
                    this.flushQueue(targets, targsPerSource, linkCounts, targsToGo, queue, alignPaths, nodesToPathElem, pathElemToNode, cycleBounds, monitor, 0.75, 1.0);
                }
            }
        }
        LoopReporter lr2 = new LoopReporter((long)loneNodes.size(), 20, monitor, 0.0, 0.25, "progress.addSingletonsToTargets");
        HashSet<NetNode> targSet = new HashSet<NetNode>(targets);
        TreeSet<NetNode> orderedTargSet = new TreeSet<NetNode>(loneNodes);
        for (NetNode lnod : orderedTargSet) {
            if (targSet.contains(lnod)) continue;
            lr2.report();
            nodeKey = nodesToPathElem.get(lnod);
            ac = alignPaths.get(nodeKey);
            List<PathElem> unlooped = ac.getReorderedKidsStartingAtKidOrStart(nodeKey);
            NetNode firstNode = null;
            NetNode lastNode = null;
            for (PathElem ulnode : unlooped) {
                NetNode daNode = pathElemToNode.get(ulnode);
                if (firstNode == null) {
                    firstNode = daNode;
                }
                lastNode = daNode;
                targSet.add(daNode);
                targets.add(daNode);
            }
            cycleBounds.add(new CycleBounds(firstNode, lastNode, ac.correct, ac.isCycle));
        }
        lr2.finish();
        return targets;
    }

    private List<NetNode> orderMyKids(Map<NetNode, Set<NetNode>> targsPerSource, Map<NetNode, Integer> linkCounts, Set<NetNode> targsToGo, NetNode node) {
        Set<NetNode> targs = targsPerSource.get(node);
        if (targs == null) {
            return new ArrayList<NetNode>();
        }
        TreeMap kidMap = new TreeMap(Collections.reverseOrder());
        for (NetNode nextTarg : targs) {
            Integer count = linkCounts.get(nextTarg);
            TreeSet<NetNode> perCount = (TreeSet<NetNode>)kidMap.get(count);
            if (perCount == null) {
                perCount = new TreeSet<NetNode>();
                kidMap.put(count, perCount);
            }
            perCount.add(nextTarg);
        }
        ArrayList<NetNode> myKidsToProc = new ArrayList<NetNode>();
        for (TreeSet<NetNode> perCount : kidMap.values()) {
            for (NetNode kid : perCount) {
                if (!targsToGo.contains(kid)) continue;
                myKidsToProc.add(kid);
            }
        }
        return myKidsToProc;
    }

    private void flushQueue(List<NetNode> targets, Map<NetNode, Set<NetNode>> targsPerSource, Map<NetNode, Integer> linkCounts, Set<NetNode> targsToGo, List<NetNode> queue, Map<PathElem, AlignPath> alignPaths, Map<NetNode, PathElem> nodesToPathElem, Map<PathElem, NetNode> pathElemToNode, List<CycleBounds> cycleBounds, BTProgressMonitor monitor, double startFrac, double endFrac) throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter((long)targsToGo.size(), 20, monitor, startFrac, endFrac, "progress.nodeOrdering");
        int lastSize = targsToGo.size();
        while (!queue.isEmpty()) {
            NetNode node = queue.remove(0);
            int ttgSize = targsToGo.size();
            lr.report((long)(lastSize - ttgSize));
            lastSize = ttgSize;
            List<NetNode> myKids = this.orderMyKids(targsPerSource, linkCounts, targsToGo, node);
            for (NetNode kid : myKids) {
                if (!targsToGo.contains(kid)) continue;
                PathElem kidKey = nodesToPathElem.get(kid);
                AlignPath ac = alignPaths.get(kidKey);
                targsToGo.removeAll(ac.pathNodes);
                List<PathElem> unlooped = ac.getReorderedKidsStartingAtKidOrStart(kidKey);
                for (PathElem ulnode : unlooped) {
                    NetNode daNode = pathElemToNode.get(ulnode);
                    targsToGo.remove(daNode);
                    targets.add(daNode);
                    queue.add(daNode);
                }
                NetNode boundsStart = pathElemToNode.get(unlooped.get(0));
                NetNode boundsEnd = pathElemToNode.get(unlooped.get(unlooped.size() - 1));
                cycleBounds.add(new CycleBounds(boundsStart, boundsEnd, ac.correct, ac.isCycle));
            }
        }
        lr.finish();
    }

    private NodeMaps normalizeAlignMap(Map<NetNode, NetNode> align, Map<NetNode, NetNode> perfectAlign, Set<NetNode> allLargerNodes, Set<NetNode> allSmallerNodes, BTProgressMonitor monitor) throws AsynchExitRequestException {
        LoopReporter lr = new LoopReporter((long)align.size(), 20, monitor, 0.0, 1.0, "progress.normalizeAlignMapA");
        HashSet<String> keyNames = new HashSet<String>();
        for (NetNode key : align.keySet()) {
            if (keyNames.contains(key.getName())) {
                lr.finish();
                System.err.println("Duplicated key " + key.getName());
                return null;
            }
            keyNames.add(key.getName());
            lr.report();
        }
        lr.finish();
        LoopReporter lr2 = new LoopReporter((long)align.size(), 20, monitor, 0.0, 1.0, "progress.normalizeAlignMapB");
        HashSet<String> valNames = new HashSet<String>();
        for (NetNode value : align.values()) {
            if (valNames.contains(value.getName())) {
                lr2.finish();
                System.err.println("Duplicated value " + value.getName());
                return null;
            }
            valNames.add(value.getName());
            lr2.report();
        }
        lr2.finish();
        LoopReporter lr3 = new LoopReporter((long)allLargerNodes.size(), 20, monitor, 0.0, 1.0, "progress.identityMapCheckA");
        HashSet<String> largeNames = new HashSet<String>();
        for (NetNode large : allLargerNodes) {
            if (largeNames.contains(large.getName())) {
                lr3.finish();
                return null;
            }
            largeNames.add(large.getName());
            lr3.report();
        }
        lr3.finish();
        LoopReporter lr4 = new LoopReporter((long)allSmallerNodes.size(), 20, monitor, 0.0, 1.0, "progress.identityMapCheckB");
        HashSet<String> smallNames = new HashSet<String>();
        for (NetNode small : allSmallerNodes) {
            if (smallNames.contains(small.getName())) {
                lr4.finish();
                return null;
            }
            smallNames.add(small.getName());
            lr4.report();
        }
        lr4.finish();
        boolean identityOK = largeNames.containsAll(keyNames);
        HashMap<String, String> backMap = null;
        if (!identityOK) {
            if (perfectAlign == null || perfectAlign.isEmpty()) {
                return null;
            }
            backMap = new HashMap<String, String>();
            LoopReporter lr5 = new LoopReporter((long)perfectAlign.size(), 20, monitor, 0.0, 1.0, "progress.namespaceMapBuilding");
            for (NetNode key : perfectAlign.keySet()) {
                NetNode val = perfectAlign.get(key);
                backMap.put(val.getName(), key.getName());
                lr5.report();
            }
            lr5.finish();
        }
        return new NodeMaps(backMap);
    }

    private Set<NetNode> genAllNodes(BuildData narbd) {
        HashSet<NetNode> allNodes = new HashSet<NetNode>();
        for (NetLink link : narbd.getLinks()) {
            allNodes.add(link.getSrcNode());
            allNodes.add(link.getTrgNode());
        }
        allNodes.addAll(narbd.getSingletonNodes());
        return allNodes;
    }

    private Map<NetNode, PathElem> genNodeToPathElem(Set<NetNode> allNodes) {
        HashMap<NetNode, PathElem> n2pe = new HashMap<NetNode, PathElem>();
        for (NetNode key : allNodes) {
            PathElem elem = new PathElem(key);
            n2pe.put(key, elem);
        }
        return n2pe;
    }

    private void genNamesToPathElem(NodeMaps maps, Map<NetNode, PathElem> elemMap, Map<String, PathElem> smallToElem, Map<String, PathElem> largeToElem, Map<PathElem, PathElem> elemToNext) {
        PathElem elem;
        for (NetNode key : elemMap.keySet()) {
            elem = elemMap.get(key);
            if (elem.color != PathElem.NodeColor.RED) {
                smallToElem.put(elem.smallNodeName, elem);
            }
            if (elem.color == PathElem.NodeColor.BLUE) continue;
            largeToElem.put(elem.largeNodeName, elem);
        }
        for (NetNode key : elemMap.keySet()) {
            String nextSmallKey;
            elem = elemMap.get(key);
            if (elem.color == PathElem.NodeColor.BLUE || (nextSmallKey = maps.backMap != null ? maps.backMap.get(elem.largeNodeName) : elem.largeNodeName) == null) continue;
            elemToNext.put(elem, smallToElem.get(nextSmallKey));
        }
    }

    private Map<PathElem, NetNode> genPathElemToNode(Set<NetNode> allNodes) {
        HashMap<PathElem, NetNode> pe2n = new HashMap<PathElem, NetNode>();
        for (NetNode key : allNodes) {
            PathElem elem = new PathElem(key);
            pe2n.put(elem, key);
        }
        return pe2n;
    }

    private Map<PathElem, AlignPath> calcAlignPathsV2(NodeMaps align, Map<NetNode, PathElem> nodesToPathElem, Map<PathElem, PathElem> elemToNext, Map<String, PathElem> smallToElem, Map<String, PathElem> largeToElem) {
        HashMap<PathElem, AlignPath> pathsPerStart = new HashMap<PathElem, AlignPath>();
        HashSet<PathElem> working = new HashSet<PathElem>(nodesToPathElem.values());
        block0: while (!working.isEmpty()) {
            PathElem startElem = working.iterator().next();
            working.remove(startElem);
            AlignPath path = new AlignPath();
            pathsPerStart.put(startElem, path);
            path.pathNodes.add(startElem);
            PathElem nextElem = elemToNext.get(startElem);
            while (nextElem != null) {
                if (nextElem.equals(startElem)) {
                    path.isCycle = true;
                    path.correct = path.pathNodes.size() == 1;
                    continue block0;
                }
                AlignPath existing = (AlignPath)pathsPerStart.get(nextElem);
                if (existing != null) {
                    path.pathNodes.addAll(existing.pathNodes);
                    pathsPerStart.remove(nextElem);
                    if (working.contains(nextElem)) {
                        throw new IllegalStateException();
                    }
                    if (!existing.isCycle) continue block0;
                    throw new IllegalStateException();
                }
                path.pathNodes.add(nextElem);
                working.remove(nextElem);
                nextElem = elemToNext.get(nextElem);
            }
        }
        HashMap<PathElem, AlignPath> pathsPerEveryNode = new HashMap<PathElem, AlignPath>();
        for (PathElem keyName : pathsPerStart.keySet()) {
            AlignPath path = (AlignPath)pathsPerStart.get(keyName);
            if (path.pathNodes.size() == 1) {
                PathElem oneElem = path.pathNodes.get(0);
                if (oneElem.color == PathElem.NodeColor.PURPLE) {
                    if (path.isCycle ? !path.correct : path.correct) {
                        throw new IllegalStateException();
                    }
                } else {
                    path.correct = true;
                }
            }
            for (PathElem nextName : path.pathNodes) {
                pathsPerEveryNode.put(nextName, path);
            }
        }
        return pathsPerEveryNode;
    }

    public static class CycleBounds {
        public NetNode boundStart;
        public NetNode boundEnd;
        public boolean isCorrect;
        public boolean isCycle;

        CycleBounds(NetNode boundStart, NetNode boundEnd, boolean isCorrect, boolean isCycle) {
            this.boundStart = boundStart;
            this.boundEnd = boundEnd;
            this.isCorrect = isCorrect;
            this.isCycle = isCycle;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class NodeMaps {
        Map<String, String> backMap;

        NodeMaps(Map<String, String> backMap) {
            this.backMap = backMap;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DefaultParams
    implements NodeLayout.Params {
        public List<NetNode> startNodes;

        public DefaultParams(List<NetNode> startNodes) {
            this.startNodes = startNodes;
        }
    }

    private static class PathElem {
        String smallNodeName;
        String largeNodeName;
        NodeColor color;

        PathElem(NetNode node) {
            String[] toks = node.getName().split("::", -1);
            if (toks.length != 2) {
                throw new IllegalArgumentException();
            }
            boolean firstEmpty = toks[0].equals("");
            boolean secondEmpty = toks[1].equals("");
            if (firstEmpty && !secondEmpty) {
                this.color = NodeColor.RED;
                this.largeNodeName = toks[1];
            } else if (!firstEmpty && secondEmpty) {
                this.color = NodeColor.BLUE;
                this.smallNodeName = toks[0];
            } else if (!firstEmpty && !secondEmpty) {
                this.color = NodeColor.PURPLE;
                this.smallNodeName = toks[0];
                this.largeNodeName = toks[1];
            } else {
                throw new IllegalArgumentException();
            }
        }

        public String toString() {
            switch (this.color) {
                case RED: {
                    return (Object)((Object)this.color) + " node : ::" + this.largeNodeName;
                }
                case BLUE: {
                    return (Object)((Object)this.color) + " node : " + this.smallNodeName + "::";
                }
                case PURPLE: {
                    return (Object)((Object)this.color) + " node : " + this.smallNodeName + "::" + this.largeNodeName;
                }
            }
            throw new IllegalStateException();
        }

        public int hashCode() {
            int smallCode = this.smallNodeName == null ? 0 : this.smallNodeName.hashCode();
            int largeCode = this.largeNodeName == null ? 0 : this.largeNodeName.hashCode();
            return smallCode + largeCode + this.color.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof PathElem)) {
                return false;
            }
            PathElem otherElem = (PathElem)other;
            if (otherElem.color != this.color) {
                return false;
            }
            switch (this.color) {
                case RED: {
                    return this.largeNodeName.equals(otherElem.largeNodeName);
                }
                case BLUE: {
                    return this.smallNodeName.equals(otherElem.smallNodeName);
                }
                case PURPLE: {
                    return this.largeNodeName.equals(otherElem.largeNodeName) && this.smallNodeName.equals(otherElem.smallNodeName);
                }
            }
            throw new IllegalStateException();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum NodeColor {
            PURPLE,
            RED,
            BLUE;

        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class AlignPath {
        List<PathElem> pathNodes = new ArrayList<PathElem>();
        boolean isCycle = false;
        boolean correct = false;

        AlignPath() {
        }

        List<PathElem> getReorderedKidsStartingAtKidOrStart(PathElem start) {
            if (this.isCycle) {
                int startIndex = this.pathNodes.indexOf(start);
                int len = this.pathNodes.size();
                ArrayList<PathElem> retval = new ArrayList<PathElem>();
                for (int i = 0; i < len; ++i) {
                    int index = (startIndex + i) % len;
                    retval.add(this.pathNodes.get(index));
                }
                return retval;
            }
            return this.pathNodes;
        }
    }
}

