/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.plugin.core.align;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import org.systemsbiology.biofabric.api.io.BuildData;
import org.systemsbiology.biofabric.api.layout.DefaultEdgeLayout;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.NetLink;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.model.Network;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.plugin.PluginSupportFactory;
import org.systemsbiology.biofabric.plugin.core.align.AlignCycleLayout;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignment;
import org.systemsbiology.biofabric.plugin.core.align.NetworkAlignmentBuildData;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AlignCycleEdgeLayout
extends DefaultEdgeLayout {
    public void preProcessEdges(BuildData rbd, BTProgressMonitor monitor) throws AsynchExitRequestException {
        ArrayList<String> groupOrder = new ArrayList<String>();
        for (NetworkAlignment.EdgeType type : NetworkAlignment.LINK_GROUPS) {
            groupOrder.add(type.tag);
        }
        rbd.setGroupOrderAndMode(groupOrder, Network.LayoutMode.PER_NODE_MODE, true);
    }

    protected AnnotationSet calcGroupLinkAnnots(BuildData rbd, List<NetLink> links, BTProgressMonitor monitor, boolean shadow, List<String> linkGroups) throws AsynchExitRequestException {
        NetworkAlignmentBuildData narbd = (NetworkAlignmentBuildData)rbd.getPluginBuildData();
        if (narbd.useNodeGroups) {
            return PluginSupportFactory.buildAnnotationSet();
        }
        if (!shadow) {
            return PluginSupportFactory.buildAnnotationSet();
        }
        TreeMap invert = new TreeMap();
        for (NetNode node : rbd.getNodeOrder().keySet()) {
            invert.put(rbd.getNodeOrder().get(node), node);
        }
        ArrayList<NetNode> order = new ArrayList<NetNode>(invert.values());
        return this.calcGroupLinkAnnotsCycle(links, order, monitor, shadow, narbd.cycleBounds, linkGroups);
    }

    private AnnotationSet calcGroupLinkAnnotsCycle(List<NetLink> links, List<NetNode> nodes, BTProgressMonitor monitor, boolean shadow, List<AlignCycleLayout.CycleBounds> bounds, List<String> linkGroups) throws AsynchExitRequestException {
        String which = shadow ? "progress.linkAnnotationShad" : "progress.linkAnnotationNoShad";
        LoopReporter lr = new LoopReporter((long)links.size(), 20, monitor, 0.0, 1.0, which);
        HashMap<NetNode, Integer> nodeOrder = new HashMap<NetNode, Integer>();
        for (int i = 0; i < nodes.size(); ++i) {
            nodeOrder.put(nodes.get(i), i);
        }
        Object currZoner = null;
        AlignCycleLayout.CycleBounds currLooper = new AlignCycleLayout.CycleBounds(null, null, false, false);
        HashSet<NetNode> seen = new HashSet<NetNode>();
        int cycle = 0;
        AnnotationSet retval = PluginSupportFactory.buildAnnotationSet();
        int startPos = 0;
        int endPos = 0;
        int numLink = links.size();
        int count = 0;
        boolean first = true;
        for (int i = 0; i < numLink; ++i) {
            NetLink link = links.get(i);
            lr.report();
            if (link.isShadow() && !shadow) continue;
            NetNode zoner = this.getZoneNode(link, nodeOrder, link.isShadow());
            if (first) {
                first = false;
            }
            if (currZoner == null || !currZoner.equals(zoner)) {
                if (!(currZoner == null || !currZoner.equals(currLooper.boundEnd) || currLooper.boundStart.equals(currLooper.boundEnd) && currLooper.isCorrect)) {
                    String color = cycle % 2 == 0 ? "Orange" : "Green";
                    String type = currLooper.isCycle ? "cycle " : "path ";
                    retval.addAnnot(PluginSupportFactory.buildAnnotation((String)(type + cycle++), (int)startPos, (int)endPos, (int)0, (String)color));
                }
                currZoner = zoner;
                for (AlignCycleLayout.CycleBounds bound : bounds) {
                    if (seen.contains(bound.boundStart) || !bound.boundStart.equals(currZoner)) continue;
                    startPos = count;
                    seen.add(bound.boundStart);
                    currLooper = bound;
                }
            }
            endPos = count++;
        }
        if (!currLooper.boundStart.equals(currLooper.boundEnd) || !currLooper.isCorrect) {
            String color = cycle % 2 == 0 ? "Orange" : "Green";
            String type = currLooper.isCycle ? "cycle " : "path ";
            retval.addAnnot(PluginSupportFactory.buildAnnotation((String)(type + cycle++), (int)startPos, (int)endPos, (int)0, (String)color));
        }
        return retval;
    }

    private NetNode getZoneNode(NetLink link, Map<NetNode, Integer> nodes, boolean isShadow) {
        int zeroIndex = nodes.get(link.getSrcNode());
        int oneIndex = nodes.get(link.getTrgNode());
        if (isShadow) {
            NetNode botnode = zeroIndex < oneIndex ? link.getTrgNode() : link.getSrcNode();
            return botnode;
        }
        NetNode topnode = zeroIndex < oneIndex ? link.getSrcNode() : link.getTrgNode();
        return topnode;
    }

    protected String getColor(String type, Map<String, String> colorMap) {
        String trimmed = type.trim();
        if (trimmed.equals("G12")) {
            return "Purple";
        }
        if (trimmed.equals("G1A")) {
            return "PowderBlue";
        }
        if (trimmed.equals("G2A")) {
            return "Pink";
        }
        throw new IllegalArgumentException();
    }
}

