/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.worker;

import java.awt.Component;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.SortedMap;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JProgressBar;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.api.util.PluginResourceManager;
import org.systemsbiology.biofabric.api.worker.BackgroundWorkerControlManager;
import org.systemsbiology.biofabric.api.worker.BackgroundWorkerOwner;
import org.systemsbiology.biofabric.util.GoodnessChart;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.UiUtil;
import org.systemsbiology.biofabric.worker.BackgroundWorker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundWorkerClient {
    private JDialog progressDialog_;
    private GoodnessChart chart_;
    private JProgressBar progressBar_;
    private BackgroundWorker worker_;
    private BackgroundWorkerOwner owner_;
    private boolean done_ = false;
    private String waitTitle_;
    private String waitMsg_;
    private BackgroundWorkerControlManager suw_;
    private JFrame topWindow_;
    private boolean allowCancels_;
    private boolean cancelRequested_;
    private JLabel cancellingMessage_;
    private JLabel progressMessage_;
    private FixedJButton cancelButton_;
    private boolean isHeadless_;
    private PluginResourceManager pluginRMan_;

    public BackgroundWorkerClient(BackgroundWorkerOwner owner, BackgroundWorker worker, JFrame topWindow, BackgroundWorkerControlManager suw, String waitTitle, String waitMsg, boolean allowCancels, PluginResourceManager rMan) {
        this.worker_ = worker;
        this.owner_ = owner;
        this.waitTitle_ = waitTitle;
        this.waitMsg_ = waitMsg;
        this.suw_ = suw;
        this.topWindow_ = topWindow;
        this.allowCancels_ = allowCancels;
        this.cancelRequested_ = false;
        this.isHeadless_ = false;
        this.chart_ = null;
        this.pluginRMan_ = rMan;
    }

    public void makeSuperChart() {
        this.chart_ = new GoodnessChart();
    }

    public BackgroundWorkerClient(BackgroundWorkerOwner owner, BackgroundWorker worker) {
        this.worker_ = worker;
        this.owner_ = owner;
        this.waitTitle_ = null;
        this.waitMsg_ = null;
        this.suw_ = null;
        this.topWindow_ = null;
        this.allowCancels_ = false;
        this.cancelRequested_ = false;
        this.isHeadless_ = true;
        this.chart_ = null;
    }

    public void launchWorker(boolean doDisable) {
        try {
            if (this.suw_ != null) {
                this.suw_.disableControls();
            }
            this.done_ = false;
            this.progressDialog_ = null;
            this.progressBar_ = null;
            this.worker_.setTotal(100);
            if (!this.isHeadless_) {
                Thread runThread = new Thread(this.worker_);
                this.prepProgressDialog();
                runThread.start();
                this.progressDialog_.setVisible(true);
            } else {
                this.worker_.run();
            }
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void launchWorker() {
        this.launchWorker(true);
    }

    private void prepProgressDialog() {
        if (this.done_) {
            return;
        }
        ResourceManager rMan = ResourceManager.getManager();
        this.progressDialog_ = new JDialog(this.topWindow_, rMan.getString(this.waitTitle_), true);
        if (this.chart_ == null) {
            this.progressDialog_.setSize(350, 200);
        } else {
            this.progressDialog_.setSize(600, 500);
        }
        this.progressMessage_ = new JLabel(rMan.getString(this.waitMsg_), 0);
        Container cp = this.progressDialog_.getContentPane();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        int rowNum = 0;
        UiUtil.gbcSet(gbc, 0, rowNum, 5, 4, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        rowNum += 4;
        cp.add((Component)this.progressMessage_, gbc);
        if (this.allowCancels_) {
            this.progressDialog_.setDefaultCloseOperation(0);
            this.progressDialog_.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent e) {
                    try {
                        boolean cancelPending = BackgroundWorkerClient.this.cancelRequested_;
                        if (!cancelPending) {
                            ResourceManager rMan = ResourceManager.getManager();
                            int ok = JOptionPane.showConfirmDialog(BackgroundWorkerClient.this.progressDialog_, rMan.getString("dialogs.cancelWarning"), rMan.getString("dialogs.cancelWarningTitle"), 0);
                            if (ok != 0) {
                                return;
                            }
                            BackgroundWorkerClient.this.dialogCancelAndDisplay();
                        } else {
                            BackgroundWorkerClient.this.progressDialog_.setVisible(false);
                            BackgroundWorkerClient.this.progressDialog_.dispose();
                        }
                    }
                    catch (Exception ex) {
                        ExceptionHandler.getHandler().displayException(ex);
                    }
                }
            });
            this.cancelButton_ = new FixedJButton(rMan.getString("dialogs.cancel"));
            this.cancelButton_.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        BackgroundWorkerClient.this.dialogCancelAndDisplay();
                    }
                    catch (Exception ex) {
                        ExceptionHandler.getHandler().displayException(ex);
                    }
                }
            });
            UiUtil.gbcSet(gbc, 2, rowNum++, 1, 1, 0, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
            cp.add((Component)this.cancelButton_, gbc);
            this.cancellingMessage_ = new JLabel("", 0);
            UiUtil.gbcSet(gbc, 0, rowNum++, 5, 1, 0, 0, 0, 5, 5, 5, 5, 10, 1.0, 0.0);
            cp.add((Component)this.cancellingMessage_, gbc);
        }
        this.progressDialog_.setLocationRelativeTo(this.topWindow_);
        this.progressBar_ = new JProgressBar(0, 100);
        this.progressBar_.setValue(0);
        this.progressBar_.setStringPainted(true);
        this.progressBar_.setIndeterminate(true);
        UiUtil.gbcSet(gbc, 0, rowNum++, 5, 1, 1, 0, 0, 20, 20, 20, 20, 10, 1.0, 0.0);
        cp.add((Component)this.progressBar_, gbc);
        if (this.chart_ != null) {
            UiUtil.gbcSet(gbc, 0, rowNum, 5, 3, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
            cp.add((Component)this.chart_, gbc);
        }
    }

    public boolean updateRankings(SortedMap<Integer, Double> vals) {
        if (this.chart_ != null) {
            this.chart_.setProgress(vals);
            this.chart_.repaint();
        }
        return !this.cancelRequested_;
    }

    public boolean updateProgress(int percent) {
        if (this.progressBar_ != null) {
            this.progressBar_.setValue(percent);
            this.progressBar_.setIndeterminate(false);
        }
        return !this.cancelRequested_;
    }

    public boolean setToIndeterminate() {
        if (this.progressBar_ != null) {
            this.progressBar_.setIndeterminate(true);
        }
        UiUtil.fixMePrintout("No this should be separate. Proof of concept");
        if (this.cancelButton_ != null) {
            this.cancelButton_.setEnabled(false);
        }
        return !this.cancelRequested_;
    }

    public boolean updateProgressAndPhase(int percent, String message) {
        if (this.progressBar_ != null) {
            this.progressBar_.setValue(percent);
            this.progressBar_.setIndeterminate(false);
        }
        if (this.progressMessage_ != null) {
            String locMsg;
            ResourceManager rMan = ResourceManager.getManager();
            String string = locMsg = this.pluginRMan_ == null ? rMan.getString(message) : this.pluginRMan_.getPluginString(message);
            if (locMsg.equals(message)) {
                locMsg = rMan.getString(message);
            }
            this.progressMessage_.setText(locMsg);
            this.progressMessage_.invalidate();
            this.progressDialog_.validate();
        }
        return !this.cancelRequested_;
    }

    public boolean keepGoing() {
        return !this.cancelRequested_;
    }

    public void requestCancel() {
        this.cancelRequested_ = true;
    }

    public void finishedWork(Object result, Exception remoteEx, OutOfMemoryError memErr) {
        this.done_ = true;
        if (memErr != null) {
            ExceptionHandler.getHandler().displayOutOfMemory(memErr);
        }
        try {
            UiUtil.fixMePrintout("NO! If IO ERROR, DO NOT CLOSE, RIGHT??");
            if (this.progressDialog_ != null) {
                this.progressDialog_.setVisible(false);
                this.progressDialog_.dispose();
            }
            boolean didRestore = false;
            if (remoteEx != null) {
                if (!this.owner_.handleRemoteException(remoteEx)) {
                    ExceptionHandler.getHandler().displayException(remoteEx);
                }
                didRestore = this.owner_.handleCancellation();
            }
            this.owner_.cleanUpPreEnable(result);
            if (this.suw_ != null) {
                this.suw_.reenableControls();
                this.suw_.redraw();
            }
            this.owner_.cleanUpPostRepaint(result, didRestore);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void workCancelled() {
        this.done_ = true;
        try {
            if (!this.allowCancels_) {
                throw new IllegalStateException();
            }
            if (this.progressDialog_ != null) {
                this.progressDialog_.setVisible(false);
                this.progressDialog_.dispose();
            }
            this.owner_.handleCancellation();
            if (this.suw_ != null) {
                this.suw_.reenableControls();
                this.suw_.redraw();
            }
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void dialogCancelAndDisplay() {
        ResourceManager rMan = ResourceManager.getManager();
        this.cancelButton_.setEnabled(false);
        this.cancellingMessage_.setText(rMan.getString("dialogs.waitForCancel"));
        this.cancellingMessage_.invalidate();
        this.progressDialog_.validate();
        this.cancelRequested_ = true;
    }
}

