/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.worker;

import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.BackgroundCore;
import org.systemsbiology.biofabric.worker.BackgroundWorkerClient;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BackgroundWorker
implements Runnable,
BTProgressMonitor {
    protected Object myResult_;
    protected Object earlyResult_;
    protected Exception caughtException_;
    protected OutOfMemoryError memError_;
    protected int total_;
    protected int done_;
    protected boolean cancelRequested_;
    protected BackgroundWorkerClient client_;
    protected Timer checkCancelTimer_;
    protected boolean isForeground_;
    private BackgroundCore core_;

    public BackgroundWorker() {
        this(null, false);
    }

    public BackgroundWorker(Object earlyResult) {
        this(earlyResult, false);
    }

    public BackgroundWorker(Object earlyResult, boolean isForeground) {
        this.earlyResult_ = earlyResult;
        this.myResult_ = earlyResult;
        this.caughtException_ = null;
        this.memError_ = null;
        this.cancelRequested_ = false;
        this.isForeground_ = isForeground;
    }

    public void setClientAndCore(BackgroundWorkerClient client, BackgroundCore core) {
        this.earlyResult_ = core.getEarlyResult();
        this.client_ = client;
        this.core_ = core;
    }

    @Override
    public void run() {
        if (this.isForeground_) {
            this.runForeground();
        } else {
            this.runBackground();
        }
    }

    public void runBackground() {
        try {
            try {
                int delay = 1000;
                this.checkCancelTimer_ = new Timer(delay, new ActionListener(){

                    public void actionPerformed(ActionEvent evt) {
                        BackgroundWorker.this.cancelRequested_ = !BackgroundWorker.this.client_.keepGoing();
                    }
                });
                this.checkCancelTimer_.start();
                this.myResult_ = this.core_.runCore();
                this.checkCancelTimer_.stop();
            }
            catch (AsynchExitRequestException ex) {
                this.checkCancelTimer_.stop();
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        BackgroundWorker.this.client_.workCancelled();
                    }
                });
                return;
            }
            if (this.caughtException_ == null) {
                this.updateProgress(this.total_);
                this.core_.postRunCore();
            } else {
                this.myResult_ = this.earlyResult_;
            }
        }
        catch (Exception ex) {
            this.checkCancelTimer_.stop();
            this.caughtException_ = ex;
        }
        catch (OutOfMemoryError oom) {
            this.checkCancelTimer_.stop();
            this.memError_ = oom;
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                BackgroundWorker.this.client_.finishedWork(BackgroundWorker.this.myResult_, BackgroundWorker.this.caughtException_, BackgroundWorker.this.memError_);
            }
        });
    }

    public void runForeground() {
        try {
            try {
                this.myResult_ = this.core_.runCore();
            }
            catch (AsynchExitRequestException ex) {
                throw new IllegalStateException();
            }
            if (this.caughtException_ == null) {
                this.core_.postRunCore();
            } else {
                this.myResult_ = this.earlyResult_;
            }
        }
        catch (Exception ex) {
            this.caughtException_ = ex;
        }
        catch (OutOfMemoryError oom) {
            this.memError_ = oom;
        }
        this.client_.finishedWork(this.myResult_, this.caughtException_, this.memError_);
    }

    public void stashException(Exception ex) {
        this.caughtException_ = ex;
    }

    @Override
    public void setTotal(int total) {
        this.total_ = total;
    }

    @Override
    public int getTotal() {
        return this.total_;
    }

    @Override
    public int getProgress() {
        return this.done_;
    }

    @Override
    public boolean keepGoing() {
        return !this.cancelRequested_;
    }

    @Override
    public boolean updateRankings(SortedMap<Integer, Double> rankings) {
        RankProgresso prog = new RankProgresso(rankings);
        SwingUtilities.invokeLater(prog);
        return !this.cancelRequested_;
    }

    @Override
    public boolean updateProgress(int done) {
        this.done_ = done;
        int percent = (int)((double)done / (double)this.total_ * 100.0);
        Progresso prog = new Progresso(percent);
        SwingUtilities.invokeLater(prog);
        return !this.cancelRequested_;
    }

    @Override
    public boolean updateUnknownProgress() {
        Progresso prog = new Progresso();
        SwingUtilities.invokeLater(prog);
        return !this.cancelRequested_;
    }

    @Override
    public boolean updateProgressAndPhase(int done, String message) {
        this.done_ = done;
        int percent = (int)((double)done / (double)this.total_ * 100.0);
        Progresso prog = new Progresso(percent, message);
        SwingUtilities.invokeLater(prog);
        return !this.cancelRequested_;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RankProgresso
    implements Runnable {
        TreeMap<Integer, Double> ranks_;

        RankProgresso(SortedMap<Integer, Double> ranks) {
            this.ranks_ = new TreeMap<Integer, Double>(ranks);
        }

        @Override
        public void run() {
            BackgroundWorker.this.cancelRequested_ = !BackgroundWorker.this.client_.updateRankings(this.ranks_);
        }
    }

    private class Progresso
    implements Runnable {
        int percent_;
        String message_;

        Progresso() {
            this.percent_ = Integer.MIN_VALUE;
            this.message_ = null;
        }

        Progresso(int percent) {
            this.percent_ = percent;
            this.message_ = null;
        }

        Progresso(int percent, String message) {
            this.percent_ = percent;
            this.message_ = message;
        }

        public void run() {
            BackgroundWorker.this.cancelRequested_ = this.message_ == null ? !BackgroundWorker.this.client_.updateProgress(this.percent_) : (this.percent_ == Integer.MIN_VALUE ? !BackgroundWorker.this.client_.setToIndeterminate() : !BackgroundWorker.this.client_.updateProgressAndPhase(this.percent_, this.message_));
        }
    }
}

