/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.util;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.text.DecimalFormat;
import java.text.MessageFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.Vector2D;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UiUtil {
    public static final double GRID_SIZE = 10.0;
    public static final int GRID_SIZE_INT = 10;
    public static final int NONE = 0;
    public static final int HOR = 2;
    public static final int VERT = 3;
    public static final int BO = 1;
    public static final int REM = 0;
    public static final int CEN = 10;
    public static final int N = 11;
    public static final int E = 13;
    public static final int W = 17;
    public static final int S = 15;
    public static final int SE = 14;
    public static final int SW = 16;
    public static final int NE = 12;
    public static final int TOP = 0;
    public static final int BOTTOM = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private static NumberFormat regNumsHi_ = new DecimalFormat("##.###");
    private static NumberFormat regNums_ = new DecimalFormat("##.##");
    private static NumberFormat tinyNums_ = new DecimalFormat("0.00E0");
    private static NumberFormat hugeNums_ = new DecimalFormat("0.00E0");
    private static int macHeight_ = 0;
    private static HashSet<String> seenMsg_ = new HashSet();

    public static String doubleFormat(double val, boolean hiRes) {
        if (Double.isNaN(val)) {
            return "NaN";
        }
        double abs = Math.abs(val);
        if (abs == 0.0) {
            return "0.0";
        }
        double d = hiRes ? 0.01 : 0.1;
        if (abs < d) {
            return tinyNums_.format(val);
        }
        if (abs >= 100.0) {
            return hugeNums_.format(val);
        }
        return hiRes ? regNumsHi_.format(val) : regNums_.format(val);
    }

    public static boolean lineInSet(Line2D test, Set setOLines) {
        double checkX1 = test.getX1();
        double checkY1 = test.getY1();
        double checkX2 = test.getX2();
        double checkY2 = test.getY2();
        for (Line2D nextSkip : setOLines) {
            double nssX = nextSkip.getX1();
            double nssY = nextSkip.getY1();
            double nseX = nextSkip.getX2();
            double nseY = nextSkip.getY2();
            if (nssX != checkX1 || nssY != checkY1 || nseX != checkX2 || nseY != checkY2) continue;
            return true;
        }
        return false;
    }

    public static void locateWindow(JFrame parent, Dimension mySize, Dimension offset, JDialog me) {
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        Dimension parSize = parent.getSize();
        Point p = parent.getLocation();
        int rightX = p.x + parSize.width;
        if (rightX > screen.width) {
            rightX = screen.width;
        }
        int topY = p.y;
        Point myUL = new Point(rightX - mySize.width - offset.width, topY + offset.height);
        me.setLocation(myUL);
    }

    public static void xmlOpen(String xmlTag, PrintWriter out, boolean closeit) {
        out.print("<");
        out.print(xmlTag);
        if (closeit) {
            out.println(">");
        } else {
            out.print(" ");
        }
    }

    public static void xmlOpenOneLine(String xmlTag, PrintWriter out) {
        out.print("<");
        out.print(xmlTag);
        out.print(">");
    }

    public static void xmlClose(String xmlTag, PrintWriter out) {
        out.print("</");
        out.print(xmlTag);
        out.println(">");
    }

    public static String getNestedListDisplay(Collection toShow, boolean flatLeaves) {
        StringBuffer buf = new StringBuffer();
        UiUtil.getNestedListDisplayRec(toShow, buf, flatLeaves);
        return buf.toString();
    }

    private static void getNestedListDisplayRec(Collection toShow, StringBuffer buf, boolean flatLeaves) {
        Iterator rrit = toShow.iterator();
        while (rrit.hasNext()) {
            Object reg = rrit.next();
            if (reg instanceof Collection) {
                Collection creg = (Collection)reg;
                if (flatLeaves && creg.size() == 1) {
                    Object freg = creg.iterator().next();
                    if (freg instanceof Collection) {
                        buf.append("(");
                        UiUtil.getNestedListDisplayRec(creg, buf, flatLeaves);
                        buf.append(")");
                    } else {
                        buf.append(freg.toString());
                    }
                } else {
                    buf.append("(");
                    UiUtil.getNestedListDisplayRec(creg, buf, flatLeaves);
                    buf.append(")");
                }
            } else {
                buf.append(reg.toString());
            }
            if (!rrit.hasNext()) continue;
            buf.append(", ");
        }
    }

    public static String getListDisplay(Collection toShow) {
        StringBuffer buf = new StringBuffer();
        Iterator rrit = toShow.iterator();
        while (rrit.hasNext()) {
            Object reg = rrit.next();
            buf.append(reg.toString());
            if (!rrit.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public static String getNestedDoubleListDisplay(Collection toShow, boolean flatLeaves) {
        StringBuffer buf = new StringBuffer();
        UiUtil.getNestedListDoubleDisplayRec(toShow, buf, flatLeaves);
        return buf.toString();
    }

    private static void getNestedListDoubleDisplayRec(Collection toShow, StringBuffer buf, boolean flatLeaves) {
        Iterator rrit = toShow.iterator();
        while (rrit.hasNext()) {
            Object reg = rrit.next();
            if (reg instanceof Collection) {
                Collection creg = (Collection)reg;
                if (flatLeaves && creg.size() == 1) {
                    Object freg = creg.iterator().next();
                    if (freg instanceof Collection) {
                        buf.append("(");
                        UiUtil.getNestedListDoubleDisplayRec(creg, buf, flatLeaves);
                        buf.append(")");
                    } else {
                        Double dreg = (Double)freg;
                        buf.append(UiUtil.doubleFormat(dreg, false));
                    }
                } else {
                    buf.append("(");
                    UiUtil.getNestedListDoubleDisplayRec(creg, buf, flatLeaves);
                    buf.append(")");
                }
            } else {
                Double dreg = (Double)reg;
                buf.append(UiUtil.doubleFormat(dreg, false));
            }
            if (!rrit.hasNext()) continue;
            buf.append(", ");
        }
    }

    public static String getDoubleListDisplay(Collection toShow) {
        StringBuffer buf = new StringBuffer();
        Iterator rrit = toShow.iterator();
        while (rrit.hasNext()) {
            Double reg = (Double)rrit.next();
            buf.append(UiUtil.doubleFormat(reg, false));
            if (!rrit.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }

    public static String stripper(String target) {
        Pattern hOpen = Pattern.compile("<\\s*[Hh][Tt][Mm][Ll]\\s*>");
        Pattern hClose = Pattern.compile("</\\s*[Hh][Tt][Mm][Ll]\\s*>");
        Pattern bOpen = Pattern.compile("<\\s*[Bb][Oo][Dd][Yy]\\s*>");
        Pattern bClose = Pattern.compile("</\\s*[Bb][Oo][Dd][Yy]\\s*>");
        Pattern head = Pattern.compile("<\\s*[Hh][Ee][Aa][Dd]\\s*>\\s*</\\s*[Hh][Ee][Aa][Dd]\\s*>");
        Matcher m = hOpen.matcher(target);
        String retval = m.replaceAll("");
        m = head.matcher(retval);
        retval = m.replaceAll("");
        m = hClose.matcher(retval);
        retval = m.replaceAll("");
        m = bOpen.matcher(retval);
        retval = m.replaceAll("");
        m = bClose.matcher(retval);
        retval = m.replaceAll("");
        m = head.matcher(retval);
        retval = m.replaceAll("");
        return retval;
    }

    public static Dimension centerBigFrame(JFrame frame, int maxWidth, int maxHeight, double scaling, int minHeight) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int winWidth = screenSize.width - 40;
        int winHeight = screenSize.height - 150;
        if (winWidth > maxWidth) {
            winWidth = maxWidth;
        }
        if (winHeight > maxHeight) {
            winHeight = maxHeight;
        }
        winWidth = (int)(scaling * (double)winWidth);
        if ((winHeight = (int)(scaling * (double)winHeight)) < minHeight) {
            winHeight = minHeight > screenSize.height ? screenSize.height : minHeight;
        }
        frame.setSize(winWidth, winHeight);
        Dimension frameSize = frame.getSize();
        int x = (screenSize.width - frameSize.width) / 2;
        int y = (screenSize.height - frameSize.height) / 2;
        frame.setLocation(x, y);
        return new Dimension(winWidth, winHeight);
    }

    public static Rectangle rectFromRect2D(Rectangle2D rect) {
        return rect == null ? null : new Rectangle((int)rect.getX(), (int)rect.getY(), (int)rect.getWidth(), (int)rect.getHeight());
    }

    public static void gbcSet(GridBagConstraints gbc, int x, int y, int w, int h, int fill, int padx, int pady, int inst, int insl, int insb, int insr, int anc, double wx, double wy) {
        gbc.gridx = x;
        gbc.gridy = y;
        gbc.gridwidth = w;
        gbc.gridheight = h;
        gbc.fill = fill;
        gbc.ipadx = padx;
        gbc.ipady = pady;
        gbc.insets = new Insets(inst, insl, insb, insr);
        gbc.anchor = anc;
        gbc.weightx = wx;
        gbc.weighty = wy;
    }

    public static void forceToGrid(double x, double y, Point2D pt, double size) {
        pt.setLocation((double)Math.round(x / size) * size, (double)Math.round(y / size) * size);
    }

    public static void forceToGrid(Point2D pt, double size) {
        pt.setLocation((double)Math.round(pt.getX() / size) * size, (double)Math.round(pt.getY() / size) * size);
    }

    public static double forceToGridValue(double val, double size) {
        return (double)Math.round(val / size) * size;
    }

    public static int forceToGridValueInt(int val, double size) {
        return (int)((double)Math.round((double)val / size) * size);
    }

    public static double forceToGridValueMin(double val, double size) {
        return Math.floor(val / size) * size;
    }

    public static double forceToGridValueMax(double val, double size) {
        return Math.ceil(val / size) * size;
    }

    public static void forceToGrid(Rectangle rect, double size) {
        int maxX = rect.x + rect.width;
        int maxY = rect.y + rect.height;
        rect.x = (int)UiUtil.forceToGridValue(rect.x, size);
        rect.y = (int)UiUtil.forceToGridValue(rect.y, size);
        maxX = (int)UiUtil.forceToGridValue(maxX, size);
        maxY = (int)UiUtil.forceToGridValue(maxY, size);
        rect.width = maxX - rect.x;
        rect.height = maxY - rect.y;
    }

    public static void force2DToGrid(Rectangle2D rect, double size) {
        double height;
        double maxX = rect.getX() + rect.getWidth();
        double maxY = rect.getY() + rect.getHeight();
        double x = UiUtil.forceToGridValue(rect.getX(), size);
        double y = UiUtil.forceToGridValue(rect.getY(), size);
        maxX = UiUtil.forceToGridValue(maxX, size);
        maxY = UiUtil.forceToGridValue(maxY, size);
        double width = maxX - x;
        if (width < rect.getWidth()) {
            width += size;
        }
        if ((height = maxY - y) < rect.getHeight()) {
            height += size;
        }
        rect.setRect(x, y, width, height);
    }

    public static Point2D getRectCenter(Rectangle rect) {
        double x = rect.getX() + rect.getWidth() / 2.0;
        double y = rect.getY() + rect.getHeight() / 2.0;
        return new Point2D.Double(x, y);
    }

    public static Rectangle growTheRect(Rectangle rect, int factor) {
        return new Rectangle(rect.x * factor, rect.y * factor, rect.width * factor, rect.height * factor);
    }

    public static Rectangle2D padTheRect(Rectangle2D rect, double pad) {
        return new Rectangle2D.Double(rect.getX() - pad, rect.getY() - pad, rect.getWidth() + pad * 2.0, rect.getHeight() + pad * 2.0);
    }

    public static Rectangle2D padTheRect(Rectangle2D rect, double padH, double padW) {
        return new Rectangle2D.Double(rect.getX() - padW, rect.getY() - padH, rect.getWidth() + padW * 2.0, rect.getHeight() + padH * 2.0);
    }

    public static Point2D lineIntersection(Point2D line1Start, Point2D line1End, Point2D line2Start, Point2D line2End) {
        double nipY;
        double nipX;
        double lipY;
        double lipX;
        double nopY;
        double nopX;
        double lopY;
        double lopX = line1Start.getX();
        if (Line2D.linesIntersect(lopX, lopY = line1Start.getY(), nopX = line1End.getX(), nopY = line1End.getY(), lipX = line2Start.getX(), lipY = line2Start.getY(), nipX = line2End.getX(), nipY = line2End.getY())) {
            double a1;
            double y;
            double x;
            if (nopX == lopX) {
                x = nopX;
                if (nipY == lipY) {
                    y = nipY;
                } else if (nipX == lipX) {
                    y = nipY;
                } else {
                    double a2 = (nipY - lipY) / (nipX - lipX);
                    double b2 = lipY - a2 * lipX;
                    y = a2 * x + b2;
                }
            } else if (nipX == lipX) {
                x = nipX;
                if (nopY == lopY) {
                    y = nopY;
                } else if (nopX == lopX) {
                    y = nopY;
                } else {
                    a1 = (nopY - lopY) / (nopX - lopX);
                    double b1 = lopY - a1 * lopX;
                    y = a1 * x + b1;
                }
            } else {
                a1 = (nopY - lopY) / (nopX - lopX);
                double b1 = lopY - a1 * lopX;
                double a2 = (nipY - lipY) / (nipX - lipX);
                double b2 = lipY - a2 * lipX;
                if (a1 == a2) {
                    return null;
                }
                x = (b2 - b1) / (a1 - a2);
                y = a1 * x + b1;
            }
            Point2D.Double inter = new Point2D.Double(x, y);
            UiUtil.forceToGrid(inter, 10.0);
            return inter;
        }
        return null;
    }

    public static PointAndSide[] rectIntersections(Rectangle rect, Point2D lineStart, Point2D lineEnd) {
        if (!rect.intersectsLine(lineStart.getX(), lineStart.getY(), lineEnd.getX(), lineEnd.getY())) {
            return null;
        }
        Point2D.Double rul = new Point2D.Double(rect.getMinX(), rect.getMinY());
        Point2D.Double rur = new Point2D.Double(rect.getMaxX(), rect.getMinY());
        Point2D.Double rlr = new Point2D.Double(rect.getMaxX(), rect.getMaxY());
        Point2D.Double rll = new Point2D.Double(rect.getMinX(), rect.getMaxY());
        Point2D[] pts = new Point2D[]{UiUtil.lineIntersection(rul, rur, lineStart, lineEnd), UiUtil.lineIntersection(rur, rlr, lineStart, lineEnd), UiUtil.lineIntersection(rlr, rll, lineStart, lineEnd), UiUtil.lineIntersection(rll, rul, lineStart, lineEnd)};
        int[] sides = new int[]{0, 3, 1, 2};
        int retSize = 0;
        TreeMap<Double, ArrayList<PointAndSide>> forRet = new TreeMap<Double, ArrayList<PointAndSide>>();
        for (int i = 0; i < 4; ++i) {
            if (pts[i] == null) continue;
            double dist = pts[i].distanceSq(lineEnd);
            UiUtil.forceToGrid(pts[i], 10.0);
            Double distObj = new Double(dist);
            ArrayList<PointAndSide> forDist = (ArrayList<PointAndSide>)forRet.get(distObj);
            if (forDist == null) {
                forDist = new ArrayList<PointAndSide>();
                forRet.put(distObj, forDist);
            }
            forDist.add(new PointAndSide(pts[i], sides[i]));
            ++retSize;
        }
        if (retSize == 0) {
            return null;
        }
        PointAndSide[] retval = new PointAndSide[retSize];
        int count = 0;
        for (ArrayList fd : forRet.values()) {
            for (PointAndSide pas : fd) {
                retval[count++] = pas;
            }
        }
        return retval;
    }

    public static String convertMessageToHtml(String input) {
        if (input.indexOf("\n") == -1) {
            return input;
        }
        String retval = input.replaceAll("\n", "<br>");
        return "<html><center>" + retval + "</center></html>";
    }

    public static String createCopyName(String origName, int lastCopyNum) {
        Object[] objs;
        String form;
        ResourceManager rMan = ResourceManager.getManager();
        if (lastCopyNum == 0) {
            form = rMan.getString("copyName.singleCopyNameFormat");
            objs = new Object[]{origName};
        } else {
            form = rMan.getString("copyName.multiCopyNameFormat");
            Integer copyNum = new Integer(lastCopyNum + 1);
            objs = new Object[]{origName, copyNum};
        }
        String copyName = MessageFormat.format(form, objs);
        return copyName;
    }

    public static Rectangle2D compressRect(Rectangle2D rect, SortedSet emptyRows, SortedSet emptyCols, Rectangle bounds) {
        double orx = rect.getX();
        double ory = rect.getY();
        double orw = rect.getWidth();
        double orh = rect.getHeight();
        double orr = orx + orw;
        double orb = ory + orh;
        Point2D.Double toComp = new Point2D.Double(orx, ory);
        Point2D nrtl = UiUtil.compressPoint(toComp, emptyRows, emptyCols, bounds);
        if (nrtl == null) {
            nrtl = (Point2D)toComp.clone();
        }
        ((Point2D)toComp).setLocation(orr, orb);
        Point2D nrbr = UiUtil.compressPoint(toComp, emptyRows, emptyCols, bounds);
        if (nrbr == null) {
            nrbr = (Point2D)toComp.clone();
        }
        double nw = nrbr.getX() - nrtl.getX();
        double nh = nrbr.getY() - nrtl.getY();
        return new Rectangle2D.Double(nrtl.getX(), nrtl.getY(), nw, nh);
    }

    public static Point2D compressPoint(Point2D loc, SortedSet emptyRows, SortedSet emptyCols, Rectangle bounds) {
        double maxY;
        double dVal = 10.0;
        double minX = bounds == null ? 0.0 : (double)bounds.x;
        double maxX = bounds == null ? 0.0 : (double)(bounds.x + bounds.width);
        double minY = bounds == null ? 0.0 : (double)bounds.y;
        double d = maxY = bounds == null ? 0.0 : (double)(bounds.y + bounds.height);
        if (bounds != null) {
            double locY = loc.getY();
            double locX = loc.getX();
            if (locY < minY || locY > maxY || locX < minX || locX > maxX) {
                return null;
            }
        }
        Iterator rit = emptyRows.iterator();
        double rowDelta = 0.0;
        while (rit.hasNext()) {
            Integer row = (Integer)rit.next();
            if (!((double)row.intValue() * 10.0 < loc.getY())) continue;
            rowDelta += dVal;
        }
        double colDelta = 0.0;
        for (Integer col : emptyCols) {
            if (!((double)col.intValue() * 10.0 < loc.getX())) continue;
            colDelta += dVal;
        }
        double newX = loc.getX() - colDelta;
        double newY = loc.getY() - rowDelta;
        return new Point2D.Double(newX, newY);
    }

    public static Rectangle2D expandRect(Rectangle2D rect, SortedSet emptyRows, SortedSet emptyCols, int mult) {
        double orx = rect.getX();
        double ory = rect.getY();
        double orw = rect.getWidth();
        double orh = rect.getHeight();
        double orr = orx + orw;
        double orb = ory + orh;
        Point2D.Double toComp = new Point2D.Double(orx, ory);
        Point2D nrtl = UiUtil.expandPoint(toComp, emptyRows, emptyCols, mult);
        ((Point2D)toComp).setLocation(orr, orb);
        Point2D nrbr = UiUtil.expandPoint(toComp, emptyRows, emptyCols, mult);
        double nw = nrbr.getX() - nrtl.getX();
        double nh = nrbr.getY() - nrtl.getY();
        return new Rectangle2D.Double(nrtl.getX(), nrtl.getY(), nw, nh);
    }

    public static Point2D expandPoint(Point2D loc, SortedSet emptyRows, SortedSet emptyCols, int mult) {
        double dVal = 10.0 * (double)mult;
        Iterator rit = emptyRows.iterator();
        double rowDelta = 0.0;
        while (rit.hasNext()) {
            Integer row = (Integer)rit.next();
            if (!((double)row.intValue() * 10.0 < loc.getY())) continue;
            rowDelta += dVal;
        }
        double colDelta = 0.0;
        for (Integer col : emptyCols) {
            if (!((double)col.intValue() * 10.0 < loc.getX())) continue;
            colDelta += dVal;
        }
        double newX = loc.getX() + colDelta;
        double newY = loc.getY() + rowDelta;
        return new Point2D.Double(newX, newY);
    }

    public static void fixMePrintout(String msg) {
        if (seenMsg_.contains(msg)) {
            return;
        }
        seenMsg_.add(msg);
    }

    public static void platformTableRowHeight(JTable jtab, boolean forEdit) {
        boolean isAMac = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        if (isAMac) {
            if (forEdit) {
                if (macHeight_ == 0) {
                    Vector<String> condTypes = new Vector<String>();
                    condTypes.add("XXXjjggTT");
                    JComboBox testIt = new JComboBox(condTypes);
                    macHeight_ = testIt.getPreferredSize().height;
                }
                jtab.setRowHeight(macHeight_);
            }
            return;
        }
        jtab.setRowHeight(22);
    }

    public static void installDefaultCellRendererForPlatform(JTable jtab, Class whichClass, boolean forEdit) {
        boolean isAMac = System.getProperty("os.name").toLowerCase().startsWith("mac os x");
        if (isAMac) {
            DefaultTableCellRenderer dtcr = (DefaultTableCellRenderer)jtab.getDefaultRenderer(whichClass);
            jtab.setDefaultRenderer(whichClass, new ShadedRowRenderer(dtcr, forEdit));
        }
    }

    public static void replaceComboItems(JComboBox combo, Vector items) {
        combo.removeAllItems();
        Iterator scit = items.iterator();
        while (scit.hasNext()) {
            combo.addItem(scit.next());
        }
    }

    public static void initCombo(JComboBox combo) {
        combo.setSelectedIndex(combo.getItemCount() == 0 ? -1 : 0);
    }

    public static List<String> simpleFileRead(File infile) {
        ArrayList<String> retval = new ArrayList<String>();
        try {
            BufferedReader in = new BufferedReader(new FileReader(infile));
            String line = null;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                retval.add(line);
            }
            in.close();
        }
        catch (IOException ioex) {
            return null;
        }
        return retval;
    }

    private UiUtil() {
    }

    public static class ShadedRowRenderer
    extends DefaultTableCellRenderer {
        private static final Color EVEN_ROW_COLOR_ = new Color(241, 245, 250);
        private static final Color ODD_EDIT_ROW_COLOR_ = new Color(250, 250, 250);
        private DefaultTableCellRenderer defaultRenderer_;
        private boolean forEdit_;

        public ShadedRowRenderer(DefaultTableCellRenderer defaultRenderer, boolean forEdit) {
            this.defaultRenderer_ = defaultRenderer;
            this.forEdit_ = forEdit;
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                Component aComp = this.defaultRenderer_.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                if (!isSelected) {
                    if (row % 2 == 0) {
                        aComp.setBackground(EVEN_ROW_COLOR_);
                    } else {
                        aComp.setBackground(this.forEdit_ ? ODD_EDIT_ROW_COLOR_ : Color.WHITE);
                    }
                }
                return aComp;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }
    }

    public static class PointAndSide {
        public Point2D point;
        public int side;

        public PointAndSide(Point2D point, int side) {
            this.point = point;
            this.side = side;
        }

        public PointAndSide(PointAndSide other, Point2D forcedPoint) {
            this.point = (Point2D)forcedPoint.clone();
            this.side = other.side;
        }

        public Vector2D outboundSideVec() {
            switch (this.side) {
                case 0: {
                    return new Vector2D(0.0, -1.0);
                }
                case 1: {
                    return new Vector2D(0.0, 1.0);
                }
                case 2: {
                    return new Vector2D(-1.0, 0.0);
                }
                case 3: {
                    return new Vector2D(1.0, 0.0);
                }
            }
            throw new IllegalStateException();
        }
    }
}

