/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.util;

import java.util.HashMap;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.systemsbiology.biofabric.api.util.PluginResourceManager;
import org.systemsbiology.biofabric.plugin.PlugInManager;

public class ResourceManager {
    private static ResourceManager singleton_;
    private ResourceBundle bundle_;
    private HashMap<String, ResourceBundle> pluginBundles_;

    public String getString(String key) {
        String retval;
        try {
            retval = this.bundle_.getString(key);
        }
        catch (MissingResourceException mre) {
            retval = key;
        }
        return retval;
    }

    String getPluginString(String pluginKey, String key) {
        String retval = key;
        ResourceBundle bundle = this.pluginBundles_.get(pluginKey);
        if (bundle == null) {
            return retval;
        }
        try {
            retval = bundle.getString(key);
        }
        catch (MissingResourceException mre) {
            retval = key;
        }
        return retval;
    }

    void setPluginBundle(String pluginKey, String bundleName, PlugInManager pMan) {
        this.pluginBundles_.put(pluginKey, pMan.getResourceBundle(bundleName));
    }

    public char getChar(String key) {
        return this.getCharFromBundle(key, this.bundle_);
    }

    char getPluginChar(String pluginKey, String key) {
        ResourceBundle bundle = this.pluginBundles_.get(pluginKey);
        return this.getCharFromBundle(key, bundle);
    }

    private char getCharFromBundle(String key, ResourceBundle bundle) {
        String str;
        if (bundle == null) {
            str = "!";
        } else {
            try {
                str = bundle.getString(key);
            }
            catch (MissingResourceException mre) {
                str = "!";
            }
            if (str.length() == 0) {
                str = "!";
            }
        }
        return str.charAt(0);
    }

    public static synchronized ResourceManager initManager(String bundleName) {
        if (singleton_ != null) {
            throw new IllegalStateException();
        }
        singleton_ = new ResourceManager(bundleName);
        return singleton_;
    }

    public static synchronized ResourceManager getManager() {
        if (singleton_ == null) {
            throw new IllegalStateException();
        }
        return singleton_;
    }

    private ResourceManager(String bundleName) {
        this.bundle_ = ResourceBundle.getBundle(bundleName);
        this.pluginBundles_ = new HashMap();
    }

    public static class ForPlugins
    implements PluginResourceManager {
        private String pluginName_;
        private ResourceManager myMan_;
        private PlugInManager pMan_;

        public ForPlugins(String pluginName, PlugInManager pMan) {
            this.pluginName_ = pluginName;
            this.myMan_ = ResourceManager.getManager();
            this.pMan_ = pMan;
        }

        public void setPluginBundle(String bundleName) {
            this.myMan_.setPluginBundle(this.pluginName_, bundleName, this.pMan_);
        }

        public String getPluginString(String key) {
            return this.myMan_.getPluginString(this.pluginName_, key);
        }

        public char getPluginChar(String key) {
            return this.myMan_.getPluginChar(this.pluginName_, key);
        }
    }
}

