/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.util;

import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class QuadTree {
    private int maxDepth_;
    private Rectangle2D worldExtent_;
    private QuadTreeNode root_;

    public QuadTree(Rectangle2D worldExtent, int maxDepth) {
        this.maxDepth_ = maxDepth;
        this.worldExtent_ = worldExtent;
        this.root_ = new QuadTreeNode(worldExtent, maxDepth);
    }

    public void clear() {
        this.root_ = new QuadTreeNode(this.worldExtent_, this.maxDepth_);
    }

    public boolean insertPayload(Payload payload) {
        return this.root_.insertPayload(payload);
    }

    public boolean getPayloadKeys(Rectangle2D worldRect, Set<String> keys) {
        return this.root_.getPayloadKeys(worldRect, keys);
    }

    public boolean getPayloadKeys(Point2D worldPoint, Set<String> keys) {
        return this.root_.getPayloadKeys(worldPoint, keys);
    }

    public boolean getNodes(Rectangle2D worldRect, int atDepth, List<QuadTreeNode> nodes) {
        if (atDepth >= this.maxDepth_) {
            UiUtil.fixMePrintout("Get here if load SimpleGOT after WorldBank: zoom screwed up");
            UiUtil.fixMePrintout("Or any second-loaded network it appears");
            System.err.println("atDepth versus maxDepth: " + atDepth + " : " + this.maxDepth_);
            throw new IllegalArgumentException();
        }
        return this.root_.getNodes(worldRect, atDepth, nodes);
    }

    public boolean getPath(Rectangle2D worldRect, List<QuadTreeNode> path) {
        return this.root_.getPath(worldRect, path);
    }

    public boolean getAllNodesToDepth(int minDepth, int maxDepth, List<QuadTreeNode> nodes) {
        if (maxDepth > this.maxDepth_) {
            System.err.println(maxDepth + " versus " + this.maxDepth_);
            throw new IllegalArgumentException();
        }
        return this.root_.getAllNodesToDepth(minDepth, maxDepth, nodes);
    }

    public static class Payload {
        private Rectangle2D rect_;
        private String key_;

        public Payload(Rectangle2D rect, String key) {
            this.rect_ = rect;
            this.key_ = key;
        }

        public Rectangle2D getRect() {
            return this.rect_;
        }

        public String getKey() {
            return this.key_;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class QuadTreeNode {
        private int depth_;
        private int treeDepth_;
        private Rectangle2D worldExtent_;
        private Corner corner_;
        private QuadTreeNode parent_;
        private boolean needKidInit_;
        private QuadTreeNode ulKid_;
        private QuadTreeNode urKid_;
        private QuadTreeNode llKid_;
        private QuadTreeNode lrKid_;
        private List<Payload> payloads_;

        QuadTreeNode(Rectangle2D worldExtent, int treeDepth) {
            this.depth_ = 0;
            this.treeDepth_ = treeDepth;
            this.parent_ = null;
            this.corner_ = Corner.SINGLETON;
            this.worldExtent_ = worldExtent;
            this.needKidInit_ = true;
            this.payloads_ = null;
        }

        QuadTreeNode(QuadTreeNode parent, Corner corner, int depth, int treeDepth) {
            this.depth_ = depth;
            this.treeDepth_ = treeDepth;
            this.parent_ = parent;
            this.corner_ = corner;
            this.needKidInit_ = true;
            this.payloads_ = null;
            Rectangle2D parentWEx = parent.getWorldExtent();
            double dhalfw = parentWEx.getWidth() * 0.5;
            double dhalfh = parentWEx.getHeight() * 0.5;
            switch (this.corner_) {
                case UPPER_LEFT: {
                    this.worldExtent_ = new Rectangle2D.Double(parentWEx.getX(), parentWEx.getY(), dhalfw, dhalfh);
                    break;
                }
                case UPPER_RIGHT: {
                    this.worldExtent_ = new Rectangle2D.Double(parentWEx.getX() + dhalfw, parentWEx.getY(), dhalfw, dhalfh);
                    break;
                }
                case LOWER_LEFT: {
                    this.worldExtent_ = new Rectangle2D.Double(parentWEx.getX(), parentWEx.getY() + dhalfh, dhalfw, dhalfh);
                    break;
                }
                case LOWER_RIGHT: {
                    this.worldExtent_ = new Rectangle2D.Double(parentWEx.getX() + dhalfw, parentWEx.getY() + dhalfh, dhalfw, dhalfh);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        boolean getNodes(Rectangle2D worldRect, int atDepth, List<QuadTreeNode> nodes) {
            if (atDepth < this.depth_) {
                return false;
            }
            boolean weIntersect = this.worldExtent_.intersects(worldRect);
            if (weIntersect) {
                if (atDepth == this.depth_) {
                    nodes.add(this);
                    return true;
                }
                if (atDepth > this.treeDepth_) {
                    throw new IllegalArgumentException();
                }
                if (this.needKidInit_) {
                    this.needKidInit_ = false;
                    this.split();
                }
                this.ulKid_.getNodes(worldRect, atDepth, nodes);
                this.urKid_.getNodes(worldRect, atDepth, nodes);
                this.llKid_.getNodes(worldRect, atDepth, nodes);
                this.lrKid_.getNodes(worldRect, atDepth, nodes);
                return true;
            }
            return false;
        }

        boolean getPayloadKeys(Rectangle2D matchRect, Set<String> keys) {
            if (!this.worldExtent_.intersects(matchRect)) {
                return false;
            }
            if (this.depth_ == this.treeDepth_) {
                if (this.payloads_ == null) {
                    return false;
                }
                int numPayloads = this.payloads_.size();
                boolean match = false;
                for (int i = 0; i < numPayloads; ++i) {
                    Payload payload = this.payloads_.get(i);
                    if (!payload.getRect().intersects(matchRect)) continue;
                    keys.add(payload.getKey());
                    match = true;
                }
                return match;
            }
            if (this.needKidInit_) {
                return false;
            }
            boolean retval = false;
            retval |= this.ulKid_.getPayloadKeys(matchRect, keys);
            retval |= this.urKid_.getPayloadKeys(matchRect, keys);
            retval |= this.llKid_.getPayloadKeys(matchRect, keys);
            return retval |= this.lrKid_.getPayloadKeys(matchRect, keys);
        }

        boolean getPayloadKeys(Point2D matchPt, Set<String> keys) {
            if (!this.worldExtent_.contains(matchPt)) {
                return false;
            }
            if (this.depth_ == this.treeDepth_) {
                if (this.payloads_ == null) {
                    return false;
                }
                int numPayloads = this.payloads_.size();
                boolean match = false;
                for (int i = 0; i < numPayloads; ++i) {
                    Payload payload = this.payloads_.get(i);
                    if (!payload.getRect().contains(matchPt)) continue;
                    keys.add(payload.getKey());
                    match = true;
                }
                return match;
            }
            if (this.needKidInit_) {
                return false;
            }
            boolean retval = false;
            retval |= this.ulKid_.getPayloadKeys(matchPt, keys);
            retval |= this.urKid_.getPayloadKeys(matchPt, keys);
            retval |= this.llKid_.getPayloadKeys(matchPt, keys);
            return retval |= this.lrKid_.getPayloadKeys(matchPt, keys);
        }

        boolean getPath(Rectangle2D matchRect, List<QuadTreeNode> path) {
            if (this.worldExtent_.equals(matchRect)) {
                path.add(this);
                return true;
            }
            if (!this.worldExtent_.intersects(matchRect)) {
                return false;
            }
            path.add(this);
            if (this.needKidInit_) {
                throw new IllegalStateException();
            }
            if (this.ulKid_.getPath(matchRect, path)) {
                return true;
            }
            if (this.urKid_.getPath(matchRect, path)) {
                return true;
            }
            if (this.llKid_.getPath(matchRect, path)) {
                return true;
            }
            if (this.lrKid_.getPath(matchRect, path)) {
                return true;
            }
            throw new IllegalStateException();
        }

        boolean getAllNodesToDepth(int minDepth, int maxDepth, List<QuadTreeNode> nodes) {
            if (maxDepth < this.depth_) {
                return false;
            }
            if (minDepth <= this.depth_ && maxDepth >= this.depth_) {
                nodes.add(this);
            }
            if (maxDepth > this.treeDepth_) {
                throw new IllegalArgumentException();
            }
            if (maxDepth > this.depth_) {
                if (this.needKidInit_) {
                    this.needKidInit_ = false;
                    this.split();
                }
                this.ulKid_.getAllNodesToDepth(minDepth, maxDepth, nodes);
                this.urKid_.getAllNodesToDepth(minDepth, maxDepth, nodes);
                this.llKid_.getAllNodesToDepth(minDepth, maxDepth, nodes);
                this.lrKid_.getAllNodesToDepth(minDepth, maxDepth, nodes);
            }
            return true;
        }

        boolean insertPayload(Payload payload) {
            if (!this.worldExtent_.intersects(payload.getRect())) {
                return false;
            }
            if (this.depth_ == this.treeDepth_) {
                if (this.payloads_ == null) {
                    this.payloads_ = new ArrayList<Payload>();
                }
                this.payloads_.add(payload);
                return true;
            }
            if (this.needKidInit_) {
                this.needKidInit_ = false;
                this.split();
            }
            boolean retval = false;
            retval |= this.ulKid_.insertPayload(payload);
            retval |= this.urKid_.insertPayload(payload);
            retval |= this.llKid_.insertPayload(payload);
            if (!(retval |= this.lrKid_.insertPayload(payload))) {
                throw new IllegalStateException();
            }
            return true;
        }

        QuadTreeNode getChild(Corner corner) {
            switch (this.corner_) {
                case UPPER_LEFT: {
                    return this.ulKid_;
                }
                case UPPER_RIGHT: {
                    return this.urKid_;
                }
                case LOWER_LEFT: {
                    return this.llKid_;
                }
                case LOWER_RIGHT: {
                    return this.lrKid_;
                }
            }
            throw new IllegalStateException();
        }

        QuadTreeNode getParent() {
            return this.parent_;
        }

        public Rectangle2D getWorldExtent() {
            return this.worldExtent_;
        }

        public int getDepth() {
            return this.depth_;
        }

        void split() {
            this.ulKid_ = new QuadTreeNode(this, Corner.UPPER_LEFT, this.depth_ + 1, this.treeDepth_);
            this.urKid_ = new QuadTreeNode(this, Corner.UPPER_RIGHT, this.depth_ + 1, this.treeDepth_);
            this.llKid_ = new QuadTreeNode(this, Corner.LOWER_LEFT, this.depth_ + 1, this.treeDepth_);
            this.lrKid_ = new QuadTreeNode(this, Corner.LOWER_RIGHT, this.depth_ + 1, this.treeDepth_);
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static enum Corner {
            SINGLETON,
            UPPER_LEFT,
            UPPER_RIGHT,
            LOWER_LEFT,
            LOWER_RIGHT;

        }
    }
}

