/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.EventObject;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.event.CellEditorListener;
import javax.swing.event.ChangeEvent;
import javax.swing.table.TableCellEditor;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.util.NumberEditor;
import org.systemsbiology.biofabric.util.ProtoInteger;
import org.systemsbiology.biofabric.util.ResourceManager;

public class IntegerEditor
extends JTextField
implements TableCellEditor,
NumberEditor {
    private JFrame topWindow_;
    private ArrayList listeners_ = new ArrayList();
    private ProtoInteger origValue_;
    private int currRow_ = -1;
    private int currColumn_ = -1;
    boolean neverEdited_;
    private boolean blanksOK_;

    public IntegerEditor(JFrame topWindow) {
        this(topWindow, false);
    }

    public IntegerEditor(JFrame topWindow, boolean blanksOK) {
        this.topWindow_ = topWindow;
        this.neverEdited_ = true;
        this.blanksOK_ = blanksOK;
    }

    public static void triggerWarning(JFrame top) {
        ResourceManager rMan = ResourceManager.getManager();
        JOptionPane.showMessageDialog(top, rMan.getString("intEditor.notAnInt"), rMan.getString("intEditor.errorTitle"), 0);
    }

    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        try {
            this.currRow_ = row;
            this.currColumn_ = column;
            if (value == null) {
                this.setText(null);
            } else {
                this.setText(((ProtoInteger)value).textValue);
            }
            table.setRowSelectionInterval(row, row);
            table.setColumnSelectionInterval(column, column);
            this.origValue_ = (ProtoInteger)value;
            this.neverEdited_ = false;
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return this;
    }

    public int getCurrRow() {
        return this.currRow_;
    }

    public int getCurrColumn() {
        return this.currColumn_;
    }

    public boolean entryIsValid() {
        return this.currRow_ != -1 && this.currColumn_ != -1;
    }

    public void addCellEditorListener(CellEditorListener l) {
        try {
            this.listeners_.add(l);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public void cancelCellEditing() {
        try {
            this.editingCanceled();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public Object getCellEditorValue() {
        ProtoInteger retval = null;
        try {
            retval = new ProtoInteger(this.getText());
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return retval;
    }

    public boolean isCellEditable(EventObject anEvent) {
        return true;
    }

    public void removeCellEditorListener(CellEditorListener l) {
        try {
            this.listeners_.remove(l);
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    public boolean shouldSelectCell(EventObject anEvent) {
        return true;
    }

    public boolean stopCellEditing() {
        try {
            this.editingStopped();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
        return true;
    }

    private void editingCanceled() {
        this.setText(this.origValue_ == null ? null : this.origValue_.textValue);
        ChangeEvent cev = new ChangeEvent(this);
        ArrayList lCopy = new ArrayList(this.listeners_);
        for (CellEditorListener cel : lCopy) {
            cel.editingCanceled(cev);
        }
        this.currRow_ = -1;
        this.currColumn_ = -1;
    }

    private void editingStopped() {
        if (!this.neverEdited_) {
            String text = this.getText();
            if (!this.blanksOK_ || text == null || !text.trim().equals("")) {
                ProtoInteger test = new ProtoInteger(this.getText());
                if (!test.valid) {
                    this.setText(this.origValue_ == null ? null : this.origValue_.textValue);
                    IntegerEditor.triggerWarning(this.topWindow_);
                }
            }
        }
        ChangeEvent cev = new ChangeEvent(this);
        ArrayList lCopy = new ArrayList(this.listeners_);
        for (CellEditorListener cel : lCopy) {
            cel.editingStopped(cev);
        }
        this.currRow_ = -1;
        this.currColumn_ = -1;
    }
}

