/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.util;

import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import javax.swing.filechooser.FileFilter;
import org.systemsbiology.biofabric.util.ResourceManager;

public class FileExtensionFilters {
    public static boolean hasSuffix(String fileName, String suffix) {
        int sufl;
        int fnl = fileName.length();
        return fnl > (sufl = suffix.length()) && fileName.toLowerCase().lastIndexOf(suffix.toLowerCase()) == fnl - sufl;
    }

    public static boolean hasASuffix(String fileName, String suffixPrefix, List candidates) {
        int numCand = candidates.size();
        for (int i = 0; i < numCand; ++i) {
            String suffix = (String)candidates.get(i);
            suffix = suffixPrefix + suffix;
            if (!FileExtensionFilters.hasSuffix(fileName, suffix)) continue;
            return true;
        }
        return false;
    }

    public static class MultiExtensionFilter
    extends FileFilter {
        private List suffixes_;
        private String desc_;

        public MultiExtensionFilter(List suffixes, String desc) {
            this.suffixes_ = new ArrayList(suffixes);
            String format = ResourceManager.getManager().getString(desc);
            int numSuf = this.suffixes_.size();
            StringBuffer buf = new StringBuffer();
            for (int i = 0; i < numSuf; ++i) {
                buf.append("*.");
                buf.append(this.suffixes_.get(i));
                if (i >= numSuf - 1) continue;
                buf.append(", ");
            }
            this.desc_ = MessageFormat.format(format, buf.toString());
        }

        public boolean accept(File f) {
            String fileName = f.getName();
            if (f.isDirectory()) {
                return true;
            }
            int numSuf = this.suffixes_.size();
            for (int i = 0; i < numSuf; ++i) {
                String suf = (String)this.suffixes_.get(i);
                if (!FileExtensionFilters.hasSuffix(fileName, suf)) continue;
                return true;
            }
            return false;
        }

        public String getDescription() {
            return this.desc_;
        }
    }

    public static class DoubleExtensionFilter
    extends FileFilter {
        private String suffix_;
        private String suffix2_;
        private String desc_;

        public DoubleExtensionFilter(String suffix, String suffix2, String desc) {
            this.suffix_ = suffix;
            this.suffix2_ = suffix2;
            this.desc_ = ResourceManager.getManager().getString(desc);
        }

        public boolean accept(File f) {
            String fileName = f.getName();
            return f.isDirectory() || FileExtensionFilters.hasSuffix(fileName, this.suffix_) || FileExtensionFilters.hasSuffix(fileName, this.suffix2_);
        }

        public String getDescription() {
            return this.desc_;
        }
    }

    public static class SimpleFilter
    extends FileFilter {
        private String suffix_;
        private String desc_;

        public SimpleFilter(String suffix, String desc) {
            this.suffix_ = suffix;
            this.desc_ = ResourceManager.getManager().getString(desc);
        }

        public boolean accept(File f) {
            String fileName = f.getName();
            return f.isDirectory() || FileExtensionFilters.hasSuffix(fileName, this.suffix_);
        }

        public String getDescription() {
            return this.desc_;
        }
    }
}

