/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.util;

import java.awt.Component;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.swing.JComboBox;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;
import javax.swing.text.JTextComponent;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.util.ComboBoxEditor;
import org.systemsbiology.biofabric.util.EditableComboBoxEditor;
import org.systemsbiology.biofabric.util.TrackingUnit;

public class EnumCell {
    public int value;
    public int index;
    public String display;
    public String internal;

    public EnumCell(String display, String internal, int val, int index) {
        this.display = display;
        this.internal = internal;
        this.value = val;
        this.index = index;
    }

    public EnumCell(EnumCell other) {
        this.display = other.display;
        this.internal = other.internal;
        this.value = other.value;
        this.index = other.index;
    }

    public String toString() {
        return this.display;
    }

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof EnumCell)) {
            return false;
        }
        EnumCell occ = (EnumCell)other;
        if (this.internal == null ? occ.internal != null : !this.internal.equals(occ.internal)) {
            return false;
        }
        if (this.value != occ.value) {
            return false;
        }
        if (this.index != occ.index) {
            return false;
        }
        if (this.display == null) {
            return occ.display == null;
        }
        return this.display.equals(occ.display);
    }

    public int hashCode() {
        int discode = this.display == null ? 0 : this.display.hashCode();
        int intcode = this.internal == null ? 0 : this.internal.hashCode();
        return discode + intcode + this.index + this.value;
    }

    public int compareTo(Object other) {
        String useValOther;
        EnumCell otherOCC = (EnumCell)other;
        String useValThis = this.display == null ? "" : this.display;
        int compName = useValThis.compareToIgnoreCase(useValOther = otherOCC.display == null ? "" : otherOCC.display);
        if (compName != 0) {
            return compName;
        }
        compName = useValThis.compareTo(useValOther);
        if (compName != 0) {
            return compName;
        }
        if (this.internal == null) {
            return otherOCC.internal == null ? 0 : 1;
        }
        int compInt = this.internal.compareTo(otherOCC.internal);
        if (compInt != 0) {
            return compInt;
        }
        if (this.value != otherOCC.value) {
            return this.value - otherOCC.value;
        }
        return this.index - otherOCC.index;
    }

    public static class ReadOnlyEnumCellEditor
    extends ComboBoxEditor {
        private List<EnumCell> backing_;
        private static final long serialVersionUID = 1L;

        public ReadOnlyEnumCellEditor(List values) {
            super(values);
        }

        public Object indexToValue(int index) {
            return new EnumCell(this.backing_.get(index));
        }

        public void valueFill(Object valueObject) {
            List list = (List)valueObject;
            this.backing_ = new ArrayList<EnumCell>();
            for (int i = 0; i < list.size(); ++i) {
                this.addItem(list.get(i));
                this.backing_.add((EnumCell)list.get(i));
            }
        }

        public int valueToIndex(Object value) {
            return ((EnumCell)value).index;
        }

        public void reviseValue(Object value) {
            this.origValue_ = value;
            this.setSelectedIndex(((EnumCell)value).index);
        }
    }

    public static class EditableEnumCellEditor
    extends EditableComboBoxEditor {
        private HashMap<String, EnumCell> backing_;
        private static final long serialVersionUID = 1L;

        public EditableEnumCellEditor(Object valueObject) {
            super(valueObject);
        }

        public void valueFill(Object valueObject) {
            List list = (List)valueObject;
            this.backing_ = new HashMap();
            for (int i = 0; i < list.size(); ++i) {
                String display = ((EnumCell)list.get((int)i)).display;
                this.addItem(display);
                this.backing_.put(display, (EnumCell)list.get(i));
            }
        }

        public Object displayStringToValue(String display) {
            EnumCell region = this.backing_.get(display);
            if (region == null) {
                return new EnumCell(display, display, -1, -1);
            }
            return new EnumCell(this.backing_.get(display));
        }

        public String valueToDisplayString(Object value) {
            return ((EnumCell)value).display;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TrackingReadOnlyComboBoxRenderer
    extends ReadOnlyComboBoxRenderer {
        private HashMap<Integer, TrackingUnit> myTracks_;
        private static final long serialVersionUID = 1L;

        public TrackingReadOnlyComboBoxRenderer(List values, Map<Integer, TrackingUnit> toTrack) {
            super(values);
            this.myTracks_ = new HashMap<Integer, TrackingUnit>(toTrack);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                TrackingUnit tu = this.myTracks_.get(new Integer(column));
                this.setEnabled(tu.isEnabled(row));
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this;
        }
    }

    public static class ReadOnlyComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public ReadOnlyComboBoxRenderer(List values) {
            for (int i = 0; i < values.size(); ++i) {
                this.addItem(values.get(i));
            }
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                if (value == null) {
                    return this;
                }
                this.setSelectedItem(value);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EditableComboBoxRenderer
    extends JComboBox
    implements TableCellRenderer {
        private static final long serialVersionUID = 1L;

        public EditableComboBoxRenderer(List<EnumCell> values) {
            for (int i = 0; i < values.size(); ++i) {
                this.addItem(values.get((int)i).display);
            }
            this.setEditable(true);
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                JTextComponent jtc = (JTextComponent)this.getEditor().getEditorComponent();
                jtc.setBackground(isSelected ? table.getSelectionBackground() : table.getBackground());
                if (value == null) {
                    return this;
                }
                this.setSelectedItem(((EnumCell)value).display);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
            return this;
        }
    }
}

