/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.systemsbiology.biofabric.api.util.MinMax;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DataUtil {
    public static List listFromIterator(Iterator it) {
        ArrayList retval = new ArrayList();
        while (it.hasNext()) {
            retval.add(it.next());
        }
        return retval;
    }

    public static Set setFromIterator(Iterator it) {
        HashSet retval = new HashSet();
        while (it.hasNext()) {
            retval.add(it.next());
        }
        return retval;
    }

    public static void bumpCountMap(Map map, String key) {
        Integer countObj = (Integer)map.get(key);
        countObj = countObj == null ? new Integer(1) : new Integer(countObj + 1);
        map.put(key, countObj);
    }

    public static String buildPasswordString(URL saltUrl, String user, String passAsString) {
        try {
            String inputLine;
            URLConnection cc = saltUrl.openConnection();
            BufferedReader in = new BufferedReader(new InputStreamReader(cc.getInputStream()));
            ArrayList<String> lines = new ArrayList<String>();
            while ((inputLine = in.readLine()) != null) {
                lines.add(inputLine.trim());
            }
            in.close();
            if (lines.size() != 3) {
                return null;
            }
            String time = (String)lines.get(0);
            String ip = (String)lines.get(1);
            String salt = (String)lines.get(2);
            user = URLEncoder.encode(user, "UTF-8");
            StringBuffer retval = new StringBuffer();
            retval.append("time=");
            retval.append(time);
            retval.append("&ip=");
            retval.append(ip);
            retval.append("&salt=");
            retval.append(salt);
            retval.append("&uid=");
            retval.append(user);
            retval.append("&hash=");
            String concat = time + ":" + ip + ":" + user + ":" + passAsString + ":" + salt;
            byte[] concatAsBytes = concat.getBytes("UTF-8");
            MessageDigest md = MessageDigest.getInstance("MD5");
            md.reset();
            md.update(concatAsBytes);
            byte[] digest = md.digest();
            String hexString = DataUtil.toHexString(digest);
            retval.append(hexString);
            return retval.toString();
        }
        catch (UnsupportedEncodingException uee) {
            return null;
        }
        catch (IOException ioe) {
            return null;
        }
        catch (NoSuchAlgorithmException nsae) {
            return null;
        }
    }

    public static String toHexString(byte[] v) {
        String digits = "0123456789abcdef";
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < v.length; ++i) {
            int b = v[i] & 0xFF;
            sb.append(digits.charAt(b >>> 4)).append(digits.charAt(b & 0xF));
        }
        return sb.toString();
    }

    public static String normKey(String key) {
        return key.toUpperCase().replaceAll(" ", "");
    }

    public static boolean keysEqual(String key1, String key2) {
        return key1.replaceAll(" ", "").equalsIgnoreCase(key2.replaceAll(" ", ""));
    }

    public static boolean containsKey(Collection keys, String key) {
        for (String key1 : keys) {
            if (!key1.replaceAll(" ", "").equalsIgnoreCase(key.replaceAll(" ", ""))) continue;
            return true;
        }
        return false;
    }

    public static List normalizeList(List keys) {
        ArrayList<String> retval = new ArrayList<String>();
        for (String key1 : keys) {
            retval.add(key1.replaceAll(" ", "").toUpperCase());
        }
        return retval;
    }

    public static String normKeyWithGreek(String key) {
        String retval = DataUtil.normKey(key);
        Pattern p = Pattern.compile(".*\\p{InGreek}.*");
        Matcher m = p.matcher(retval);
        if (m.matches()) {
            Pattern p1 = Pattern.compile("\\p{InGreek}");
            Matcher m1 = p1.matcher("");
            StringBuffer buf = new StringBuffer();
            int len = retval.length();
            for (int i = 0; i < len; ++i) {
                String oneChar = retval.substring(i, i + 1);
                m1.reset(oneChar);
                if (m1.matches()) {
                    buf.append(oneChar.toLowerCase());
                    continue;
                }
                buf.append(oneChar);
            }
            retval = buf.toString();
        }
        return retval;
    }

    public static String greekToLowerCase(String val) {
        String retval = val;
        Pattern p = Pattern.compile(".*\\p{InGreek}.*");
        Matcher m = p.matcher(retval);
        if (m.matches()) {
            Pattern p1 = Pattern.compile("\\p{InGreek}");
            Matcher m1 = p1.matcher("");
            StringBuffer buf = new StringBuffer();
            int len = retval.length();
            for (int i = 0; i < len; ++i) {
                String oneChar = retval.substring(i, i + 1);
                m1.reset(oneChar);
                if (m1.matches()) {
                    buf.append(oneChar.toLowerCase());
                    continue;
                }
                buf.append(oneChar);
            }
            retval = buf.toString();
        }
        return retval;
    }

    public static SortedMap normalizedMapToOrig(Collection keys) {
        TreeMap<String, TreeSet<String>> retval = new TreeMap<String, TreeSet<String>>();
        for (String key1 : keys) {
            String normKey = DataUtil.normKey(key1);
            TreeSet<String> setForKey = (TreeSet<String>)retval.get(normKey);
            if (setForKey == null) {
                setForKey = new TreeSet<String>(String.CASE_INSENSITIVE_ORDER);
                retval.put(normKey, setForKey);
            }
            setForKey.add(key1);
        }
        return retval;
    }

    public static double maxAbsVal(List vals) {
        int num = vals.size();
        double maxVal = Double.NEGATIVE_INFINITY;
        for (int i = 0; i < num; ++i) {
            Double val0bj = (Double)vals.get(i);
            if (val0bj.isNaN()) {
                return val0bj;
            }
            double val = Math.abs(val0bj);
            if (!(val > maxVal)) continue;
            maxVal = val;
        }
        return maxVal == Double.NEGATIVE_INFINITY ? Double.NaN : maxVal;
    }

    public static double minAbsVal(List vals) {
        int num = vals.size();
        double minVal = Double.POSITIVE_INFINITY;
        for (int i = 0; i < num; ++i) {
            Double val0bj = (Double)vals.get(i);
            if (val0bj.isNaN()) {
                return val0bj;
            }
            double val = Math.abs(val0bj);
            if (!(val < minVal)) continue;
            minVal = val;
        }
        return minVal == Double.POSITIVE_INFINITY ? Double.NaN : minVal;
    }

    public static double avgAbsVal(Collection vals) {
        Iterator vit = vals.iterator();
        double sum = 0.0;
        int num = vals.size();
        if (num == 0) {
            return Double.NaN;
        }
        while (vit.hasNext()) {
            Double val0bj = (Double)vit.next();
            if (val0bj.isNaN()) {
                return val0bj;
            }
            double val = Math.abs(val0bj);
            sum += val;
        }
        return sum / (double)num;
    }

    public static double avgVal(List vals) {
        int num = vals.size();
        double sum = 0.0;
        if (num == 0) {
            return sum;
        }
        for (int i = 0; i < num; ++i) {
            Double val0bj = (Double)vals.get(i);
            sum += val0bj.doubleValue();
        }
        return sum / (double)num;
    }

    public static double medianAbsVal(List vals) {
        if (vals.isEmpty()) {
            return Double.NaN;
        }
        int num = vals.size();
        ArrayList<Double> sorted = new ArrayList<Double>();
        for (int i = 0; i < num; ++i) {
            Double val0bj = (Double)vals.get(i);
            if (val0bj.isNaN()) {
                return Double.NaN;
            }
            sorted.add(new Double(Math.abs(val0bj)));
        }
        Collections.sort(sorted);
        int lindex = num / 2;
        if (num % 2 == 0) {
            Double lower = (Double)sorted.get(lindex - 1);
            Double upper = (Double)sorted.get(lindex);
            return (lower + upper) / 2.0;
        }
        Double median = (Double)sorted.get(lindex);
        return median;
    }

    public static boolean avgValIsAboveThresh(List vals, double negThresh, double posThresh) {
        int num = vals.size();
        int count = 0;
        double sum = 0.0;
        for (int i = 0; i < num; ++i) {
            Double val0bj = (Double)vals.get(i);
            if (val0bj.isNaN()) continue;
            double valv = val0bj;
            sum += valv;
            ++count;
        }
        double avg = sum / (double)count;
        return avg <= negThresh || avg >= posThresh;
    }

    public static double medianAbsValAboveThresh(List vals, double thresh) {
        int num = vals.size();
        ArrayList<Double> above = new ArrayList<Double>();
        for (int i = 0; i < num; ++i) {
            Double valObj = (Double)vals.get(i);
            if (valObj.isNaN()) {
                return Double.NaN;
            }
            double val = Math.abs(valObj);
            if (!(val >= thresh)) continue;
            above.add(valObj);
        }
        return DataUtil.medianAbsVal(above);
    }

    public static double minAbsValAboveThresh(List vals, double thresh) {
        int num = vals.size();
        double minVal = Double.POSITIVE_INFINITY;
        for (int i = 0; i < num; ++i) {
            Double val0bj = (Double)vals.get(i);
            if (val0bj.isNaN()) {
                return Double.NaN;
            }
            double val = Math.abs(val0bj);
            if (!(val >= thresh) || !(val < minVal)) continue;
            minVal = val;
        }
        return minVal == Double.POSITIVE_INFINITY ? Double.NaN : minVal;
    }

    public static boolean signsMixed(List vals) {
        int num = vals.size();
        int runningSign = 0;
        for (int i = 0; i < num; ++i) {
            Double val = (Double)vals.get(i);
            double dVal = val;
            int currSign = 0;
            if (dVal < 0.0) {
                currSign = -1;
            } else if (dVal > 0.0) {
                currSign = 1;
            }
            if (i == 0 || runningSign == 0) {
                runningSign = currSign;
                continue;
            }
            if (currSign == 0 || currSign == runningSign) continue;
            return true;
        }
        return false;
    }

    public static boolean haveOne(List vals, double negThresh, double posThresh) {
        int numVals = vals.size();
        for (int i = 0; i < numVals; ++i) {
            Double val = (Double)vals.get(i);
            double valv = val;
            if (!(valv <= negThresh) && !(valv >= posThresh)) continue;
            return true;
        }
        return false;
    }

    public static boolean haveOneTrue(List vals) {
        int numVals = vals.size();
        for (int i = 0; i < numVals; ++i) {
            Boolean val = (Boolean)vals.get(i);
            if (!val.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean haveOneFalse(List vals) {
        int numVals = vals.size();
        for (int i = 0; i < numVals; ++i) {
            Boolean val = (Boolean)vals.get(i);
            if (val.booleanValue()) continue;
            return true;
        }
        return false;
    }

    public static boolean haveMajority(List vals, double negThresh, double posThresh, boolean tieWins) {
        int numVals = vals.size();
        int goodCount = 0;
        int badCount = 0;
        for (int i = 0; i < numVals; ++i) {
            Double val = (Double)vals.get(i);
            double valv = val;
            if (valv <= negThresh || valv >= posThresh) {
                ++goodCount;
                continue;
            }
            ++badCount;
        }
        return numVals % 2 == 0 && tieWins ? goodCount >= badCount : goodCount > badCount;
    }

    public static boolean haveMajorityTrue(List vals, boolean tieWins) {
        int numVals = vals.size();
        int goodCount = 0;
        int badCount = 0;
        for (int i = 0; i < numVals; ++i) {
            Boolean val = (Boolean)vals.get(i);
            if (val.booleanValue()) {
                ++goodCount;
                continue;
            }
            ++badCount;
        }
        return numVals % 2 == 0 && tieWins ? goodCount >= badCount : goodCount > badCount;
    }

    public static boolean hasANaN(List vals) {
        int numVals = vals.size();
        for (int i = 0; i < numVals; ++i) {
            Double val = (Double)vals.get(i);
            if (!val.isNaN()) continue;
            return true;
        }
        return false;
    }

    public static int numberAboveThresh(List vals, double thresh) {
        int numVals = vals.size();
        int count = 0;
        thresh = Math.abs(thresh);
        for (int i = 0; i < numVals; ++i) {
            Double val = (Double)vals.get(i);
            if (val.isNaN() || !(Math.abs(val) >= thresh)) continue;
            ++count;
        }
        return count;
    }

    public static double geometricMean(List vals, double replacement) {
        int numVals = vals.size();
        double product = 1.0;
        for (int i = 0; i < numVals; ++i) {
            double dval;
            Double val = (Double)vals.get(i);
            double d = dval = val.isNaN() ? replacement : val;
            if (dval == 0.0) {
                dval = replacement;
            }
            product *= Math.abs(dval);
        }
        return Math.pow(product, 1.0 / (double)numVals);
    }

    public static SortedSet<Integer> fillOutHourly(SortedSet<Integer> hours) {
        TreeSet<Integer> retval = new TreeSet<Integer>(hours);
        if (hours.isEmpty() || hours.size() == 1) {
            return retval;
        }
        int minTime = hours.first() + 1;
        int maxTime = hours.last() - 1;
        for (int i = minTime; i <= maxTime; ++i) {
            retval.add(new Integer(i));
        }
        return retval;
    }

    public static Integer closestInt(Set vals, int want, boolean tieBreakBelow) {
        if (vals.isEmpty()) {
            return null;
        }
        Integer candBelow = null;
        Integer candAbove = null;
        int absDiffBelow = Integer.MAX_VALUE;
        int absDiffAbove = Integer.MAX_VALUE;
        for (Integer next : vals) {
            int nVal = next;
            if (nVal == want) {
                return next;
            }
            int diff = want - nVal;
            int absDiff = Math.abs(diff);
            if (diff > 0) {
                if (absDiff >= absDiffBelow) continue;
                candBelow = next;
                absDiffBelow = absDiff;
                continue;
            }
            if (diff >= absDiffAbove) continue;
            candAbove = next;
            absDiffAbove = absDiff;
        }
        if (absDiffBelow == absDiffAbove) {
            return tieBreakBelow ? candBelow : candAbove;
        }
        return absDiffBelow < absDiffAbove ? candBelow : candAbove;
    }

    public static MinMax boundingInts(SortedSet vals, int want) {
        MinMax retval = new MinMax();
        retval.init();
        if (vals.isEmpty()) {
            return null;
        }
        Integer candBelow = null;
        Integer candAbove = null;
        int absDiffBelow = Integer.MAX_VALUE;
        int absDiffAbove = Integer.MAX_VALUE;
        boolean isFirst = true;
        Iterator vit = vals.iterator();
        while (vit.hasNext()) {
            Integer next = (Integer)vit.next();
            int nVal = next;
            if (nVal == want) {
                retval.update(nVal);
                return retval;
            }
            if (isFirst) {
                isFirst = false;
                if (want < nVal) {
                    retval.update(nVal);
                    return retval;
                }
            }
            if (!vit.hasNext() && want > nVal) {
                retval.update(nVal);
                return retval;
            }
            int diff = want - nVal;
            int absDiff = Math.abs(diff);
            if (diff > 0) {
                if (absDiff >= absDiffBelow) continue;
                candBelow = next;
                absDiffBelow = absDiff;
                continue;
            }
            if (diff >= absDiffAbove) continue;
            candAbove = next;
            absDiffAbove = absDiff;
        }
        retval.update(candAbove);
        retval.update(candBelow);
        return retval;
    }

    public static SortedSet trimOut(SortedSet argSet, int min, int max) {
        TreeSet<Integer> retval = new TreeSet<Integer>();
        if (argSet.isEmpty()) {
            return retval;
        }
        for (Integer nint : argSet) {
            int intval = nint;
            if (intval < min || intval > max) continue;
            retval.add(nint);
        }
        return retval;
    }

    public static SortedSet doubleForDescreteStartAndEnds(SortedSet hours) {
        TreeSet<Integer> retval = new TreeSet<Integer>();
        if (hours.isEmpty()) {
            return retval;
        }
        for (Integer time : hours) {
            int start = time * 2;
            retval.add(new Integer(start));
            retval.add(new Integer(start + 1));
        }
        return retval;
    }

    public static Set intersection(Set one, Set two, Set result) {
        result.clear();
        result.addAll(one);
        result.retainAll(two);
        return result;
    }

    public static Set union(Set one, Set two, Set result) {
        result.clear();
        result.addAll(one);
        result.addAll(two);
        return result;
    }

    public static Set coaleseSets(Set setOfSets, Set newSet) {
        HashSet<Set> result = new HashSet<Set>(setOfSets);
        result.add(newSet);
        HashSet allMembers = new HashSet();
        for (Set nextSet : result) {
            allMembers.addAll(nextSet);
        }
        ArrayList fixedOrder = new ArrayList(allMembers);
        for (Object member : fixedOrder) {
            boolean done = false;
            while (!done) {
                Set firstSet = null;
                boolean collision = false;
                for (Set nextSet : result) {
                    if (!nextSet.contains(member)) continue;
                    if (firstSet == null) {
                        firstSet = nextSet;
                        continue;
                    }
                    result.remove(nextSet);
                    result.remove(firstSet);
                    HashSet union = new HashSet();
                    DataUtil.union(nextSet, firstSet, union);
                    result.add(union);
                    collision = true;
                    break;
                }
                if (collision) continue;
                done = true;
            }
        }
        return result;
    }

    public static int strDiff(String str1, String str2) {
        int len2;
        int len1 = str1.length();
        int uselen = len1 > (len2 = str2.length()) ? len2 : len1;
        for (int i = 0; i < uselen; ++i) {
            char ch2;
            char ch1 = str1.charAt(i);
            if (ch1 == (ch2 = str2.charAt(i))) continue;
            return i;
        }
        return len1 == len2 ? -1 : uselen;
    }

    public static String getMultiDisplayString(List asNames) {
        StringBuffer buf = new StringBuffer();
        int numSrc = asNames.size();
        for (int i = 0; i < numSrc; ++i) {
            String invest = (String)asNames.get(i);
            buf.append(invest);
            if (i < numSrc - 2) {
                buf.append(", ");
                continue;
            }
            if (i >= numSrc - 1) continue;
            buf.append(" & ");
        }
        return buf.toString();
    }

    public static int levenshteinDistance(String s, String t) {
        int j;
        int m = s.length();
        int n = t.length();
        int[][] dtable = new int[m + 1][n + 1];
        for (int i = 0; i <= m; ++i) {
            dtable[i][0] = i;
        }
        for (j = 0; j <= n; ++j) {
            dtable[0][j] = j;
        }
        for (j = 1; j <= n; ++j) {
            for (int i = 1; i <= m; ++i) {
                if (s.charAt(i - 1) == t.charAt(j - 1)) {
                    dtable[i][j] = dtable[i - 1][j - 1];
                    continue;
                }
                int delDist = dtable[i - 1][j] + 1;
                int insDist = dtable[i][j - 1] + 1;
                int subDist = dtable[i - 1][j - 1] + 1;
                dtable[i][j] = Math.min(Math.min(delDist, insDist), subDist);
            }
        }
        return dtable[m][n];
    }

    public static String getClosestStringToName(String targName, int distThresh, Set sources) {
        String normName = DataUtil.normKey(targName);
        int minDist = distThresh + 1;
        String minStr = null;
        for (String trg : sources) {
            int editDist = DataUtil.levenshteinDistance(normName, DataUtil.normKey(trg));
            if (editDist >= minDist) continue;
            minDist = editDist;
            minStr = trg;
        }
        return minStr;
    }

    public static int setDistance(SortedSet s1, SortedSet s2) {
        TreeSet union = new TreeSet(s1);
        union.addAll(s2);
        int sum = 0;
        for (String unext : union) {
            int increment = s1.contains(unext) && s2.contains(unext) ? 0 : 1;
            sum += increment;
        }
        return sum;
    }

    public static boolean allAboveThreshold(List values, double threshold) {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException();
        }
        int numVal = values.size();
        for (int i = 0; i < numVal; ++i) {
            Double val = (Double)values.get(i);
            if (!(Math.abs(val) < threshold)) continue;
            return false;
        }
        return true;
    }

    public static double listAverage(List values) {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException();
        }
        double sum = 0.0;
        int count = 0;
        int numVal = values.size();
        for (int i = 0; i < numVal; ++i) {
            Double val = (Double)values.get(i);
            sum += val.doubleValue();
            ++count;
        }
        return sum / (double)count;
    }

    public static double listMaxAbs(List values) {
        if (values == null || values.isEmpty()) {
            throw new IllegalArgumentException();
        }
        double maxAbs = 0.0;
        double max = 0.0;
        int numVal = values.size();
        for (int i = 0; i < numVal; ++i) {
            Double valObj = (Double)values.get(i);
            double val = valObj;
            double abs = Math.abs(val);
            if (!(abs > maxAbs)) continue;
            maxAbs = abs;
            max = val;
        }
        return max;
    }

    public static Map negateMapToIntegers(Map values) {
        HashMap retval = new HashMap();
        for (Object key : values.keySet()) {
            Integer val = (Integer)values.get(key);
            retval.put(key, new Integer(-val.intValue()));
        }
        return retval;
    }

    private DataUtil() {
    }
}

