/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.render;

import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TextPath {
    private Color col;
    private String name;
    private double nameX;
    private double nameY;
    private boolean doRotateName;
    private Rectangle2D nameRect;
    private FontSizes font;

    public TextPath(Color col, String name, double x, double y, Rectangle2D nameRect, boolean doRotateName, FontSizes font) {
        this.col = col;
        this.name = name;
        this.nameX = x;
        this.nameY = y;
        this.nameRect = nameRect;
        this.doRotateName = doRotateName;
        this.font = font;
    }

    int paint(Graphics2D g2, Rectangle bounds, Map<FontSizes, Font> fonts) {
        int didPaint = 0;
        g2.setPaint(this.col);
        if (this.nameRect != null && (bounds == null || this.nameRect.getMaxX() > bounds.getMinX() && this.nameRect.getMinX() < bounds.getMaxX() && this.nameRect.getMaxY() > bounds.getMinY() && this.nameRect.getMinY() < bounds.getMaxY())) {
            if (this.doRotateName) {
                g2.setFont(fonts.get((Object)FontSizes.TINY));
                this.drawRotString(g2, this.name, this.nameX, this.nameY, 0.0, 0.0);
                ++didPaint;
            } else {
                Font useit = fonts.get((Object)this.font);
                g2.setFont(useit);
                g2.drawString(this.name, (int)this.nameX, (int)this.nameY);
                ++didPaint;
            }
        }
        return didPaint;
    }

    private void drawRotString(Graphics2D g2, String name, double x, double y, double ptx, double pty) {
        AffineTransform sav = g2.getTransform();
        AffineTransform forRot = (AffineTransform)sav.clone();
        if (ptx != 0.0 || pty != 0.0) {
            forRot.translate(ptx, pty);
        }
        forRot.rotate(-1.5707963267948966, x, y);
        g2.setTransform(forRot);
        g2.drawString(name, (float)x, (float)y);
        g2.setTransform(sav);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum FontSizes {
        TINY,
        HUGE,
        MED,
        MED_SMALL,
        SMALL,
        GINORMOUS;

    }
}

