/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.render;

import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FilterOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.zip.DataFormatException;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.systemsbiology.biofabric.ui.render.ImgAndBufPool;
import org.systemsbiology.biofabric.util.UiUtil;

public class RasterCache {
    private String cachePref_;
    private HashMap<String, BytesWithMeta> bufferCache_;
    private HashMap<String, String> handleToFile_;
    private HashMap<String, InfoForImage> infoForImage_;
    private ArrayList<String> queue_;
    private int nextHandle_;
    private int maxMeg_;
    private int currSize_;
    private ShiftData shiftData_;

    public RasterCache(String cachePref, int maxMeg, DirectColorModel cMod) {
        this.cachePref_ = cachePref;
        this.bufferCache_ = new HashMap();
        this.handleToFile_ = new HashMap();
        this.infoForImage_ = new HashMap();
        this.queue_ = new ArrayList();
        this.nextHandle_ = 0;
        if (maxMeg == 0) {
            throw new IllegalArgumentException();
        }
        this.maxMeg_ = maxMeg * 1000000;
        this.currSize_ = 0;
        this.shiftData_ = new ShiftData(cMod);
    }

    public BufferedImage getAnImage(String handle, ImgAndBufPool bis) throws IOException {
        BytesWithMeta bwm = this.getADataBuffer(handle, bis);
        if (bwm == null) {
            return null;
        }
        InfoForImage ifi = this.infoForImage_.get(handle);
        BufferedImage bi = this.bufToImage(bwm, bis, ifi);
        return bi;
    }

    public String cacheAnImage(BufferedImage bi, ImgAndBufPool bis) throws IOException {
        InfoForImage ifi = new InfoForImage(bi);
        BytesWithMeta bwm = this.imageToBuf(bi, bis, ifi);
        bis.returnImage(bi);
        this.maintainSize(bwm.buf.length, bis);
        String handle = Integer.toString(this.nextHandle_++);
        this.bufferCache_.put(handle, bwm);
        this.infoForImage_.put(handle, ifi);
        this.queue_.add(0, handle);
        this.currSize_ += bwm.buf.length;
        return handle;
    }

    public void releaseResources() {
        UiUtil.fixMePrintout("DO THIS IN A THREAD_SAFE FASHION!!");
    }

    public static void threeBytesToOneInt(byte[] input, int[] output, ShiftData sd) {
        int byteIndex = 0;
        int intIndex = 0;
        while (intIndex < output.length) {
            output[intIndex] = 0;
            int n = intIndex;
            output[n] = output[n] | (input[byteIndex++] & 0xFF) << sd.redShift_;
            int n2 = intIndex;
            output[n2] = output[n2] | (input[byteIndex++] & 0xFF) << sd.greenShift_;
            int n3 = intIndex++;
            output[n3] = output[n3] | (input[byteIndex++] & 0xFF) << sd.blueShift_;
        }
    }

    public static int shiftForMask(int mask) {
        for (int i = 0; i < 32; ++i) {
            if ((mask >> i & 1) != 1) continue;
            return i;
        }
        throw new IllegalArgumentException();
    }

    public static void oneIntToThreeBytes(int[] input, byte[] output, ShiftData sd) {
        for (int intIndex = 0; intIndex < input.length; ++intIndex) {
            int byteBase = 3 * intIndex;
            output[byteBase] = (byte)((input[intIndex] & sd.redMask_) >> sd.redShift_);
            output[byteBase + 1] = (byte)((input[intIndex] & sd.greenMask_) >> sd.greenShift_);
            output[byteBase + 2] = (byte)((input[intIndex] & sd.blueMask_) >> sd.blueShift_);
        }
    }

    public void dropAnImage(String handle, ImgAndBufPool bis) throws IOException {
        BytesWithMeta bye = this.getADataBuffer(handle, bis);
        if (bye == null) {
            return;
        }
        this.currSize_ -= bye.buf.length;
        if (this.currSize_ < 0) {
            this.currSize_ = 0;
        }
        this.queue_.remove(handle);
        this.bufferCache_.remove(handle);
        this.infoForImage_.remove(handle);
        bis.returnByteBuf(bye.buf);
        String fileName = this.handleToFile_.get(handle);
        if (fileName != null) {
            File dropFile = new File(fileName);
            if (dropFile.exists()) {
                dropFile.delete();
            }
            this.handleToFile_.remove(handle);
        }
    }

    public String replaceAnImage(String handle, BufferedImage bi, ImgAndBufPool bis) throws IOException {
        BytesWithMeta bye = this.getADataBuffer(handle, bis);
        this.currSize_ -= bye.buf.length;
        if (this.currSize_ < 0) {
            this.currSize_ = 0;
        }
        bis.returnByteBuf(bye.buf);
        InfoForImage ifi = new InfoForImage(bi);
        BytesWithMeta bwm = this.imageToBuf(bi, bis, ifi);
        bis.returnImage(bi);
        this.maintainSize(bwm.buf.length, bis);
        this.bufferCache_.put(handle, bwm);
        this.infoForImage_.put(handle, ifi);
        this.queue_.add(0, handle);
        this.currSize_ += bwm.buf.length;
        String fileName = this.handleToFile_.get(handle);
        if (fileName != null) {
            File holdFile = new File(fileName);
            this.writeBufferToFile(bwm, holdFile, bis);
        }
        return handle;
    }

    private void maintainSize(int sizeEst, ImgAndBufPool bis) throws IOException {
        while (sizeEst + this.currSize_ > this.maxMeg_ && this.queue_.size() > 0) {
            String goodBye = this.queue_.remove(this.queue_.size() - 1);
            BytesWithMeta bwm = this.bufferCache_.remove(goodBye);
            String fileName = this.handleToFile_.get(goodBye);
            if (fileName != null) continue;
            File holdFile = this.getAFile();
            this.currSize_ -= bwm.buf.length;
            if (this.currSize_ < 0) {
                this.currSize_ = 0;
            }
            this.writeBufferToFile(bwm, holdFile, bis);
            bis.returnByteBuf(bwm.buf);
            this.handleToFile_.put(goodBye, holdFile.getAbsolutePath());
            this.fileCacheReport();
        }
    }

    private File getAFile() throws IOException {
        File file = null;
        File dir = null;
        if (this.cachePref_ != null) {
            dir = new File(this.cachePref_);
            if (!dir.exists() || !dir.isDirectory()) {
                throw new IOException();
            }
            file = File.createTempFile("BioFabric", ".tmp", dir);
        } else {
            file = File.createTempFile("BioFabric", ".tmp");
        }
        file.deleteOnExit();
        return file;
    }

    public long fileCacheReport() {
        long length = 0L;
        int numFile = 0;
        for (String holdFilePath : this.handleToFile_.values()) {
            File holdFile = new File(holdFilePath);
            if (!holdFile.exists()) continue;
            if (numFile == 0) {
                System.out.println("Directory: " + holdFile.getParentFile().getAbsolutePath());
            }
            length += holdFile.length();
            ++numFile;
        }
        System.out.println("Total bytes used: " + length);
        System.out.println("Total file count: " + numFile);
        return length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeBufferToFile(BytesWithMeta bwm, File file, ImgAndBufPool bis) throws IOException {
        long prewrite = Runtime.getRuntime().freeMemory();
        FilterOutputStream out = null;
        try {
            out = new BufferedOutputStream(new FileOutputStream(file));
            ((BufferedOutputStream)out).write(bwm.buf, 0, bwm.used);
        }
        finally {
            if (out != null) {
                out.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BytesWithMeta readBufferFromFile(File file, InfoForImage ifi, ImgAndBufPool bis) throws IOException {
        long preread = Runtime.getRuntime().freeMemory();
        byte[] buf = bis.fetchByteBuf(ifi.compressedNumBytes);
        BufferedInputStream in = null;
        int off = 0;
        try {
            int num;
            in = new BufferedInputStream(new FileInputStream(file));
            while ((num = in.read(buf, off, buf.length - off)) != -1) {
                off += num;
            }
        }
        finally {
            if (in != null) {
                in.close();
            }
        }
        if (ifi.compressedNumBytes != off) {
            throw new IOException();
        }
        return new BytesWithMeta(buf, off);
    }

    private BytesWithMeta getADataBuffer(String handle, ImgAndBufPool bis) throws IOException {
        BytesWithMeta retval = this.bufferCache_.get(handle);
        if (retval != null) {
            this.queue_.remove(handle);
            this.queue_.add(0, handle);
            return retval;
        }
        String fileName = this.handleToFile_.get(handle);
        if (fileName == null) {
            return null;
        }
        File holdFile = new File(fileName);
        if (!holdFile.exists()) {
            return null;
        }
        InfoForImage ifi = this.infoForImage_.get(handle);
        retval = this.readBufferFromFile(holdFile, ifi, bis);
        int size = retval.buf.length;
        this.maintainSize(size, bis);
        this.bufferCache_.put(handle, retval);
        this.queue_.add(0, handle);
        this.currSize_ += size;
        return retval;
    }

    private BytesWithMeta imageToBuf(BufferedImage bi, ImgAndBufPool bis, InfoForImage ifi) {
        WritableRaster rast = bi.getRaster();
        DataBufferInt dbb = (DataBufferInt)rast.getDataBuffer();
        int[] data = dbb.getData();
        byte[] byteData = bis.fetchByteBuf(data.length * 3);
        RasterCache.oneIntToThreeBytes(data, byteData, this.shiftData_);
        byte[] output = bis.fetchByteBuf(byteData.length);
        Deflater deflate = new Deflater();
        deflate.setInput(byteData);
        deflate.finish();
        int compressedDataLength = deflate.deflate(output);
        byte[] result = bis.fetchByteBuf(compressedDataLength);
        System.arraycopy(output, 0, result, 0, compressedDataLength);
        bis.returnByteBuf(output);
        bis.returnByteBuf(byteData);
        ifi.setCompressedSize(compressedDataLength);
        return new BytesWithMeta(result, compressedDataLength);
    }

    private BufferedImage bufToImage(BytesWithMeta bwm, ImgAndBufPool bis, InfoForImage ifi) throws IOException {
        Inflater inflate = new Inflater();
        byte[] decomp = bis.fetchByteBuf(ifi.uncompressedNumBytes);
        inflate.setInput(bwm.buf, 0, bwm.used);
        try {
            int resultLength = inflate.inflate(decomp);
        }
        catch (DataFormatException dfex) {
            throw new IOException();
        }
        inflate.end();
        int[] intData = bis.fetchBuf(decomp.length / 3);
        RasterCache.threeBytesToOneInt(decomp, intData, this.shiftData_);
        BufferedImage bi = bis.fetchImage(ifi.width, ifi.height, ifi.type);
        WritableRaster biRast = bi.getRaster();
        biRast.setDataElements(0, 0, ifi.width, ifi.height, intData);
        bis.returnByteBuf(decomp);
        bis.returnBuf(intData);
        return bi;
    }

    public static class ShiftData {
        int redMask_;
        int greenMask_;
        int blueMask_;
        int redShift_;
        int greenShift_;
        int blueShift_;

        public ShiftData(DirectColorModel cMod) {
            this.redMask_ = cMod.getRedMask();
            this.greenMask_ = cMod.getGreenMask();
            this.blueMask_ = cMod.getBlueMask();
            this.redShift_ = RasterCache.shiftForMask(this.redMask_);
            this.greenShift_ = RasterCache.shiftForMask(this.greenMask_);
            this.blueShift_ = RasterCache.shiftForMask(this.blueMask_);
        }
    }

    private static class InfoForImage {
        int uncompressedNumBytes;
        int compressedNumBytes;
        int width;
        int height;
        int type;

        InfoForImage(BufferedImage bi) {
            WritableRaster rast = bi.getRaster();
            DataBufferInt dbb = (DataBufferInt)rast.getDataBuffer();
            int[] dest = dbb.getData();
            this.uncompressedNumBytes = dest.length * 3;
            this.compressedNumBytes = 0;
            this.width = bi.getWidth();
            this.height = bi.getHeight();
            this.type = bi.getType();
        }

        void setCompressedSize(int size) {
            this.compressedNumBytes = size;
        }
    }

    private static class BytesWithMeta {
        byte[] buf;
        int used;

        BytesWithMeta(byte[] buf, int used) {
            this.buf = buf;
            this.used = used;
        }
    }
}

