/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.render;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.font.FontRenderContext;
import java.awt.font.LineMetrics;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.systemsbiology.biofabric.api.layout.AnnotColorSource;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.MinMax;
import org.systemsbiology.biofabric.api.util.NID;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.model.BioFabricNetwork;
import org.systemsbiology.biofabric.ui.FabricColorGenerator;
import org.systemsbiology.biofabric.ui.FabricDisplayOptions;
import org.systemsbiology.biofabric.ui.FabricDisplayOptionsManager;
import org.systemsbiology.biofabric.ui.render.BoxPath;
import org.systemsbiology.biofabric.ui.render.GlyphPath;
import org.systemsbiology.biofabric.ui.render.LinePath;
import org.systemsbiology.biofabric.ui.render.TextPath;
import org.systemsbiology.biofabric.util.DoubMinMax;
import org.systemsbiology.biofabric.util.QuadTree;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PaintCacheSmall {
    private static final double BB_HALF_WIDTH_ = 5.0;
    private static final double PERCENT_PAD_ = 0.1;
    private static final int MINIMUM_PAD_ = 10;
    private static final double DRAIN_ZONE_ROW_OFFSET_ = 0.5;
    private static final double NODE_LABEL_X_SHIM_ = 5.0;
    private static final double LABEL_FONT_HEIGHT_SCALE_ = 0.6666666666666666;
    public static final int STROKE_SIZE = 3;
    private HashMap<TextPath.FontSizes, Font> fonts_ = new HashMap();
    private ArrayList<TextPath.FontSizes> bigToLittle_ = new ArrayList();
    private List<BioFabricNetwork.NodeInfo> nodeRefs_;
    private List<BioFabricNetwork.LinkInfo> linkRefs_;
    private int[] linkIndex_;
    private int indexOffset_;
    private int[] nodeIndex_;
    private int nodeIndexOffset_;
    private boolean nodesForShadow_;
    private QuadTree names_;
    private HashMap<String, BoxPath> nameKeyToPaintZero_;
    private HashMap<String, BoxPath> nameKeyToPaintOneQuarter_;
    private HashMap<String, TextPath> nameKeyToPaintOneHalf_;
    private HashMap<String, BoxPath> nameKeyToPaintFirst_;
    private HashMap<String, TextPath> nameKeyToPaintSecond_;
    private HashMap<String, TextPath> nameKeyToPaintThird_;
    private int nameKeyCount_;
    private HashMap<String, NID> nameKeyToNodeID_;
    private FabricColorGenerator colGen_;
    private Color superLightPink_;
    private Color superLightBlue_;
    private AnnotColorSource.AnnotColor[] annotColors_;
    private Color[] annotGrays_;

    public PaintCacheSmall(FabricColorGenerator colGen) {
        this.bigToLittle_.add(TextPath.FontSizes.GINORMOUS);
        this.fonts_.put(TextPath.FontSizes.GINORMOUS, new Font("SansSerif", 0, 400));
        this.bigToLittle_.add(TextPath.FontSizes.HUGE);
        this.fonts_.put(TextPath.FontSizes.HUGE, new Font("SansSerif", 0, 200));
        this.bigToLittle_.add(TextPath.FontSizes.MED);
        this.fonts_.put(TextPath.FontSizes.MED, new Font("SansSerif", 0, 100));
        this.bigToLittle_.add(TextPath.FontSizes.MED_SMALL);
        this.fonts_.put(TextPath.FontSizes.MED_SMALL, new Font("SansSerif", 0, 70));
        this.bigToLittle_.add(TextPath.FontSizes.SMALL);
        this.fonts_.put(TextPath.FontSizes.SMALL, new Font("SansSerif", 0, 30));
        this.bigToLittle_.add(TextPath.FontSizes.TINY);
        this.fonts_.put(TextPath.FontSizes.TINY, new Font("SansSerif", 0, 10));
        this.nameKeyToPaintZero_ = new HashMap();
        this.nameKeyToPaintOneQuarter_ = new HashMap();
        this.nameKeyToPaintOneHalf_ = new HashMap();
        this.nameKeyToPaintFirst_ = new HashMap();
        this.nameKeyToPaintSecond_ = new HashMap();
        this.nameKeyToPaintThird_ = new HashMap();
        this.nameKeyToNodeID_ = new HashMap();
        this.colGen_ = colGen;
        this.superLightPink_ = new Color(255, 244, 244);
        this.superLightBlue_ = new Color(244, 244, 255);
        this.annotColors_ = AnnotColorSource.getColorCycle();
        this.annotGrays_ = AnnotColorSource.getGrayCycle();
    }

    public void clear() {
        this.nameKeyToPaintZero_.clear();
        this.nameKeyToPaintOneQuarter_.clear();
        this.nameKeyToPaintOneHalf_.clear();
        this.nameKeyToPaintFirst_.clear();
        this.nameKeyToPaintSecond_.clear();
        this.nameKeyToPaintThird_.clear();
        this.nameKeyToNodeID_.clear();
        this.nodeRefs_ = null;
        this.linkRefs_ = null;
        this.nodeIndex_ = null;
        this.nodeIndexOffset_ = 0;
        this.nodesForShadow_ = false;
        this.linkIndex_ = null;
        this.indexOffset_ = 0;
        if (this.names_ != null) {
            this.names_.clear();
        }
    }

    public boolean paintIt(Graphics2D g2, Rectangle clip, Reduction reduce) {
        MinMax mm;
        LinePath lp;
        Line2D.Double line;
        int result;
        int result2;
        Object pp;
        boolean retval = false;
        HashSet<String> pKeys = new HashSet<String>();
        if (this.names_ != null) {
            this.names_.getPayloadKeys(clip, pKeys);
        }
        if (reduce == null) {
            for (String pkey : pKeys) {
                pp = this.nameKeyToPaintZero_.get(pkey);
                if (pp == null) continue;
                result2 = ((BoxPath)pp).paint(g2, clip);
                retval = retval || result2 > 0;
            }
        }
        if (reduce == null) {
            for (String pkey : pKeys) {
                pp = this.nameKeyToPaintOneQuarter_.get(pkey);
                if (pp == null) continue;
                result2 = ((BoxPath)pp).paint(g2, clip);
                retval = retval || result2 > 0;
            }
        }
        if (reduce == null) {
            for (String pkey : pKeys) {
                pp = this.nameKeyToPaintOneHalf_.get(pkey);
                if (pp == null) continue;
                result2 = ((TextPath)pp).paint(g2, clip, this.fonts_);
                retval = retval || result2 > 0;
            }
        }
        if (reduce == null) {
            for (String pkey : pKeys) {
                pp = this.nameKeyToPaintFirst_.get(pkey);
                if (pp == null) continue;
                result2 = ((BoxPath)pp).paint(g2, clip);
                retval = retval || result2 > 0;
            }
        }
        for (String pkey : pKeys) {
            TextPath pp2;
            NID forKey = this.nameKeyToNodeID_.get(pkey);
            if (reduce != null && !reduce.paintNames.contains(forKey) || (pp2 = this.nameKeyToPaintSecond_.get(pkey)) == null) continue;
            result = pp2.paint(g2, clip, this.fonts_);
            retval = retval || result > 0;
        }
        if (this.nodeRefs_ != null) {
            double minY = clip.getMinY() / 18.0;
            double maxY = clip.getMaxY() / 18.0;
            int extraRows = (int)Math.round((maxY - minY) * 0.1 * 0.5);
            if (extraRows < 10) {
                extraRows = 10;
            }
            int startRow = (int)Math.floor(minY) - extraRows;
            int endRow = (int)Math.floor(maxY) + extraRows;
            startRow = startRow < this.nodeIndexOffset_ ? this.nodeIndexOffset_ : startRow;
            endRow = endRow >= this.nodeIndex_.length + this.nodeIndexOffset_ ? this.nodeIndex_.length - 1 + this.nodeIndexOffset_ : endRow;
            line = new Line2D.Double();
            lp = new LinePath();
            mm = new MinMax();
            for (int i = startRow; i <= endRow; ++i) {
                if (this.nodeIndex_[i - this.nodeIndexOffset_] == -1 || reduce != null && !reduce.paintRows.contains(i)) continue;
                BioFabricNetwork.NodeInfo ni = this.nodeRefs_.get(this.nodeIndex_[i - this.nodeIndexOffset_]);
                MinMax nmm = ni.getColRange(this.nodesForShadow_);
                int sCol = nmm.min;
                int eCol = nmm.max;
                Color paintCol = this.getColorForNode(ni, this.colGen_);
                int xStrt = sCol * 18;
                int xEnd = eCol * 18;
                int y = i * 18;
                ((Line2D)line).setLine(xStrt, y, xEnd, y);
                int result3 = lp.reset(paintCol, line, Integer.MIN_VALUE, y, mm.reset(xStrt, xEnd)).paint(g2, clip);
                retval = retval || result3 > 0;
            }
        }
        if (this.linkRefs_ != null) {
            double minX = clip.getMinX() / 18.0;
            double maxX = clip.getMaxX() / 18.0;
            int extraCols = (int)Math.round((maxX - minX) * 0.1 * 0.5);
            if (extraCols < 10) {
                extraCols = 10;
            }
            int startCol = (int)Math.floor(minX) - extraCols;
            int endCol = (int)Math.floor(maxX) + extraCols;
            startCol = startCol < this.indexOffset_ ? this.indexOffset_ : startCol;
            endCol = endCol >= this.linkIndex_.length + this.indexOffset_ ? this.linkIndex_.length - 1 + this.indexOffset_ : endCol;
            line = new Line2D.Double();
            lp = new LinePath();
            mm = new MinMax();
            GlyphPath gp = new GlyphPath();
            int count = 0;
            for (int i = startCol; i <= endCol; ++i) {
                if (this.linkIndex_[i - this.indexOffset_] == -1 || reduce != null && !reduce.paintCols.contains(i)) continue;
                BioFabricNetwork.LinkInfo li = this.linkRefs_.get(this.linkIndex_[i - this.indexOffset_]);
                int sRow = li.topRow();
                int eRow = li.bottomRow();
                Color paintCol = this.getColorForLink(li, this.colGen_);
                int yStrt = sRow * 18;
                int yEnd = eRow * 18;
                int x = i * 18;
                ((Line2D)line).setLine(x, yStrt, x, yEnd);
                int result4 = lp.reset(paintCol, line, x, Integer.MIN_VALUE, mm.reset(yStrt, yEnd)).paint(g2, clip);
                retval = retval || result4 > 0;
                count += result4 > 0 ? 1 : 0;
                if (!li.isDirected()) {
                    result4 = gp.reuse(paintCol, x, yStrt, yEnd, 5.0, false).paint(g2, clip);
                    retval = retval || result4 > 0;
                    continue;
                }
                int ySrc = li.getStartRow() * 18;
                int yTrg = li.getEndRow() * 18;
                result4 = gp.reuse(paintCol, x, ySrc, yTrg, 5.0, true).paint(g2, clip);
                retval = retval || result4 > 0;
            }
        }
        for (String pkey : pKeys) {
            TextPath pp3;
            NID forKey = this.nameKeyToNodeID_.get(pkey);
            if (reduce != null && !reduce.paintNames.contains(forKey) || (pp3 = this.nameKeyToPaintThird_.get(pkey)) == null) continue;
            result = pp3.paint(g2, clip, this.fonts_);
            retval = retval || result > 0;
        }
        return retval;
    }

    public void drawFloater(Graphics2D g2, FloaterSet floaters) {
        if (floaters.floater == null && floaters.tourRect == null && floaters.currSelRect == null) {
            return;
        }
        BasicStroke selectedStroke = new BasicStroke(6.0f, 2, 0);
        g2.setStroke(selectedStroke);
        g2.setPaint(Color.BLACK);
        if (floaters.floater != null) {
            g2.drawRect(floaters.floater.x, floaters.floater.y, floaters.floater.width, floaters.floater.height);
        }
        if (floaters.tourRect != null) {
            g2.setPaint(new Color(0, 0, 255, 125));
            g2.drawArc(floaters.tourRect.x, floaters.tourRect.y, floaters.tourRect.width, floaters.tourRect.height, 0, 360);
        }
        if (floaters.currSelRect != null) {
            g2.setPaint(new Color(Color.orange.getRed(), Color.orange.getGreen(), Color.orange.getBlue(), 125));
            g2.drawArc(floaters.currSelRect.x, floaters.currSelRect.y, floaters.currSelRect.width, floaters.currSelRect.height, 0, 360);
        }
    }

    public Rectangle2D buildObjCache(List<BioFabricNetwork.NodeInfo> targets, List<BioFabricNetwork.LinkInfo> links, boolean shadeNodes, boolean showShadows, BioFabricNetwork.Extents ext, Map<NetNode, Rectangle2D> nameMap, Map<NetNode, List<Rectangle2D>> drainMap, Rectangle2D netBounds, AnnotationSet nodeAnnot, AnnotationSet linkAnnot, BTProgressMonitor monitor) throws AsynchExitRequestException {
        this.nameKeyToPaintZero_.clear();
        this.nameKeyToPaintOneQuarter_.clear();
        this.nameKeyToPaintOneHalf_.clear();
        this.nameKeyToPaintFirst_.clear();
        this.nameKeyToPaintSecond_.clear();
        this.nameKeyToPaintThird_.clear();
        this.nameKeyCount_ = 0;
        ArrayList<QuadTree.Payload> qtpc = new ArrayList<QuadTree.Payload>();
        FontRenderContext frc = new FontRenderContext(new AffineTransform(), true, true);
        int numLinks = links.size();
        Map linkExtents = ext.allLinkExtents.get(showShadows);
        MinMax linkCols = ext.allLinkFullRange.get(showShadows);
        this.linkIndex_ = new int[numLinks == 0 ? 0 : linkCols.max + 1 - linkCols.min];
        this.indexOffset_ = linkCols.min;
        Arrays.fill(this.linkIndex_, -1);
        this.linkRefs_ = links;
        int numNodes = targets.size();
        LoopReporter lr = new LoopReporter(targets.size(), 20, monitor, 0.0, 1.0, "progress.buildNodeGraphics");
        HashMap<Integer, MinMax> nodeExtents = ext.allNodeExtents.get(showShadows);
        Integer singletonMinRow = ext.singletonNodeStart.get(showShadows);
        MinMax nodeRows = ext.allNodeFullRange.get(showShadows);
        for (int i = 0; i < numNodes; ++i) {
            BioFabricNetwork.NodeInfo node = targets.get(i);
            int num = node.nodeRow;
            lr.report();
            this.buildNodeTextAndRect(node, frc, this.colGen_, linkExtents, shadeNodes, showShadows, nameMap, drainMap, qtpc);
        }
        this.nodeIndex_ = new int[numNodes == 0 ? 0 : nodeRows.max + 1 - nodeRows.min];
        this.nodeIndexOffset_ = nodeRows.min;
        Arrays.fill(this.nodeIndex_, -1);
        this.nodeRefs_ = targets;
        this.nodesForShadow_ = showShadows;
        LoopReporter lr2 = new LoopReporter(numLinks, 20, monitor, 0.0, 1.0, "progress.buildLinkGraphics");
        int i = 0;
        while (i < numLinks) {
            BioFabricNetwork.LinkInfo link = links.get(i);
            lr2.report();
            this.linkIndex_[link.getUseColumn((boolean)showShadows) - this.indexOffset_] = i++;
        }
        LoopReporter lr3 = new LoopReporter(numLinks, 20, monitor, 0.0, 1.0, "progress.buildNodeGraphicsToo");
        int i2 = 0;
        while (i2 < numNodes) {
            BioFabricNetwork.NodeInfo node = targets.get(i2);
            lr3.report();
            this.nodeIndex_[node.nodeRow - this.nodeIndexOffset_] = i2++;
        }
        int annotCount = 0;
        if (nodeAnnot != null) {
            LoopReporter lr4 = new LoopReporter(nodeAnnot.size(), 20, monitor, 0.0, 1.0, "progress.buildNodeAnnots");
            for (Object an : nodeAnnot) {
                AnnotColorSource.AnnotColor acol = an.getColor();
                AnnotColorSource.AnnotColor col = acol == null ? this.annotColors_[annotCount++ % this.annotColors_.length] : acol;
                lr4.report();
                this.buildAnAnnotationRect(an.getRange(), an.getName(), col.getColor(), true, nodeExtents, frc, linkCols, qtpc, null);
            }
        }
        annotCount = 0;
        if (linkAnnot != null) {
            LoopReporter lr5 = new LoopReporter(linkAnnot.size(), 20, monitor, 0.0, 1.0, "progress.buildLinkAnnots");
            for (Object an : linkAnnot) {
                AnnotColorSource.AnnotColor acol;
                Color col = nodeAnnot != null && nodeAnnot.size() > 0 ? this.annotGrays_[annotCount++ % this.annotGrays_.length] : ((acol = an.getColor()) == null ? this.annotColors_[annotCount++ % this.annotColors_.length].getColor() : acol.getColor());
                lr5.report();
                this.buildAnAnnotationRect(an.getRange(), an.getName(), col, false, linkExtents, frc, nodeRows, qtpc, singletonMinRow);
            }
        }
        DoubMinMax dmmw = new DoubMinMax(netBounds.getMinX(), netBounds.getMaxX());
        DoubMinMax dmmh = new DoubMinMax(netBounds.getMinY(), netBounds.getMaxY());
        for (QuadTree.Payload qtp : qtpc) {
            Rectangle2D qtpr = qtp.getRect();
            dmmw.update(qtpr.getMinX());
            dmmw.update(qtpr.getMaxX());
            dmmh.update(qtpr.getMinY());
            dmmh.update(qtpr.getMaxY());
        }
        Rectangle2D.Double worldRect = new Rectangle2D.Double(dmmw.min, dmmh.min, dmmw.max - dmmw.min, dmmh.max - dmmh.min);
        this.names_ = new QuadTree(worldRect, 5);
        for (QuadTree.Payload qtp : qtpc) {
            this.names_.insertPayload(qtp);
        }
        qtpc.clear();
        return worldRect;
    }

    public Color getColorForLink(BioFabricNetwork.LinkInfo link, FabricColorGenerator colGen) {
        return colGen.getModifiedColor(link.getColorKey(), 2);
    }

    public Color getColorForNode(BioFabricNetwork.NodeInfo node, FabricColorGenerator colGen) {
        return colGen.getModifiedColor(node.colorKey, 1);
    }

    private void buildNodeTextAndRect(BioFabricNetwork.NodeInfo target, FontRenderContext frc, FabricColorGenerator colGen, Map<Integer, MinMax> linkExtents, boolean shadeNodes, boolean showShadows, Map<NetNode, Rectangle2D> nameMap, Map<NetNode, List<Rectangle2D>> drainMap, ArrayList<QuadTree.Payload> payloadCache) {
        MinMax colmm = target.getColRange(showShadows);
        Rectangle2D labelBounds = this.fonts_.get((Object)TextPath.FontSizes.TINY).getStringBounds(target.getNodeName(), frc);
        double scaleHeight = labelBounds.getHeight() * 0.6666666666666666;
        double namey = (double)(target.nodeRow * 18) + scaleHeight / 2.0;
        double namex = (double)(colmm.min * 18) - labelBounds.getWidth() - 5.0 - 5.0;
        labelBounds.setRect(namex, namey - scaleHeight, labelBounds.getWidth(), scaleHeight);
        nameMap.put(target.getNodeIDWithName(), (Rectangle2D)labelBounds.clone());
        TextPath npp = new TextPath(Color.BLACK, target.getNodeName(), namex, namey, labelBounds, false, TextPath.FontSizes.TINY);
        String nkk = Integer.toString(this.nameKeyCount_++);
        QuadTree.Payload pay = new QuadTree.Payload(labelBounds, nkk);
        payloadCache.add(pay);
        this.nameKeyToPaintSecond_.put(nkk, npp);
        this.nameKeyToNodeID_.put(nkk, target.getNodeID());
        ArrayList<Rectangle2D> rectList = new ArrayList<Rectangle2D>();
        double tnamey = ((double)target.nodeRow - 0.5) * 18.0;
        List<BioFabricNetwork.DrainZone> zones = target.getDrainZones(showShadows);
        for (int i = 0; i < zones.size(); ++i) {
            DrainZoneInfo curr = new DrainZoneInfo(zones.get(i));
            if (curr.dzmm == null) continue;
            FabricDisplayOptions options = FabricDisplayOptionsManager.getMgr().getDisplayOptions();
            curr.setGreaterThanMinDZ(curr.diff + 1 >= options.getMinDrainZone());
            curr.setTextSize(target, this.fonts_, this.bigToLittle_, frc);
            float tnamex = 0.0f;
            if (curr.dumpRect != null) {
                double dumpScaleHeight = curr.dumpRect.getHeight() * 0.6666666666666666;
                if (curr.doRotateName) {
                    tnamex = (float)(((DrainZoneInfo)curr).dzmm.min * 18) + (float)(curr.diff * 18) / 2.0f + (float)(dumpScaleHeight / 2.0);
                    curr.dumpRect.setRect((double)tnamex - dumpScaleHeight, tnamey - curr.dumpRect.getWidth(), dumpScaleHeight, curr.dumpRect.getWidth());
                } else {
                    tnamex = (float)(((DrainZoneInfo)curr).dzmm.min * 18) + (float)(curr.diff * 18) / 2.0f - (float)((int)curr.dumpRect.getWidth() / 2);
                    curr.dumpRect.setRect(tnamex, tnamey - dumpScaleHeight, curr.dumpRect.getWidth(), dumpScaleHeight);
                }
                if (shadeNodes) {
                    Color col = target.nodeRow % 2 == 0 ? this.superLightBlue_ : this.superLightPink_;
                    this.buildANodeShadeRect(curr.dzmm, linkExtents, curr.dumpRect, col, payloadCache);
                }
            }
            if (curr.greaterThanMinDZ) {
                TextPath drain = new TextPath(Color.BLACK, target.getNodeName(), tnamex, tnamey, curr.dumpRect, curr.doRotateName, curr.font);
                nkk = Integer.toString(this.nameKeyCount_++);
                pay = new QuadTree.Payload(curr.dumpRect, nkk);
                payloadCache.add(pay);
                if (curr.font == TextPath.FontSizes.TINY) {
                    this.nameKeyToPaintThird_.put(nkk, drain);
                    this.nameKeyToNodeID_.put(nkk, target.getNodeID());
                } else {
                    this.nameKeyToPaintSecond_.put(nkk, drain);
                    this.nameKeyToNodeID_.put(nkk, target.getNodeID());
                }
            }
            if (curr.dumpRect == null) continue;
            rectList.add((Rectangle2D)curr.dumpRect.clone());
        }
        drainMap.put(target.getNodeIDWithName(), rectList);
    }

    private void buildANodeShadeRect(MinMax dzmm, Map<Integer, MinMax> linkExtents, Rectangle2D dumpRect, Color col, ArrayList<QuadTree.Payload> payloadCache) {
        int minRow = Integer.MAX_VALUE;
        int maxRow = Integer.MIN_VALUE;
        for (int i = dzmm.min; i <= dzmm.max; ++i) {
            MinMax range = linkExtents.get(i);
            if (range == null) continue;
            if (minRow > range.min) {
                minRow = range.min;
            }
            if (maxRow >= range.max) continue;
            maxRow = range.max;
        }
        int rectLeft = (int)Math.floor((double)(dzmm.min * 18) - 5.0 - 1.5);
        int topRow = (int)Math.floor((double)(minRow * 18) - 5.0 - 1.5);
        int rectTop = dumpRect == null ? topRow : Math.min((int)dumpRect.getMinY(), topRow);
        int rectRight = (int)Math.ceil((double)(dzmm.max * 18) + 5.0 + 1.5);
        int rectWidth = rectRight - rectLeft;
        int rectBot = (int)Math.floor((double)(maxRow * 18) + 5.0 + 1.5);
        int rectHeight = rectBot - rectTop;
        Rectangle rect = new Rectangle(rectLeft, rectTop, rectWidth, rectHeight);
        BoxPath npp = new BoxPath(col, rect);
        String nkk = Integer.toString(this.nameKeyCount_++);
        QuadTree.Payload pay = new QuadTree.Payload(rect, nkk);
        payloadCache.add(pay);
        this.nameKeyToPaintFirst_.put(nkk, npp);
    }

    public static int calcAnnotationPad(MinMax fullExtents) {
        int minExtent = fullExtents.min;
        int maxExtent = fullExtents.max;
        int diff = maxExtent - minExtent;
        int pad = (int)((double)(diff * 18) * 0.05);
        pad = UiUtil.forceToGridValueInt(Math.max(pad, 200), 18.0);
        return pad;
    }

    private void buildAnAnnotationRect(MinMax dzmm, String name, Color col, boolean isHoriz, Map<Integer, MinMax> extents, FontRenderContext frc, MinMax fullExtents, ArrayList<QuadTree.Payload> payloadCache, Integer extentCap) {
        double namex;
        double namey;
        int rectBot;
        int rectTop;
        int rectRight;
        int rectLeft;
        int minExtent = fullExtents.min;
        int maxExtent = extentCap == null ? fullExtents.max : extentCap - 1;
        int pad = PaintCacheSmall.calcAnnotationPad(fullExtents);
        if (isHoriz) {
            rectLeft = minExtent * 18 - pad;
            rectRight = maxExtent * 18 + 9;
            rectTop = dzmm.min * 18 - 9;
            rectBot = dzmm.max * 18 + 9;
        } else {
            rectLeft = dzmm.min * 18 - 9;
            rectRight = dzmm.max * 18 + 9;
            rectTop = minExtent * 18 - pad;
            rectBot = maxExtent * 18 + 9;
        }
        int rectWidth = rectRight - rectLeft;
        int rectHeight = rectBot - rectTop;
        Rectangle rect = new Rectangle(rectLeft, rectTop, rectWidth, rectHeight);
        BoxPath npp = new BoxPath(col, rect);
        String nkk = Integer.toString(this.nameKeyCount_++);
        QuadTree.Payload pay = new QuadTree.Payload(rect, nkk);
        payloadCache.add(pay);
        if (isHoriz) {
            this.nameKeyToPaintZero_.put(nkk, npp);
        } else {
            this.nameKeyToPaintOneQuarter_.put(nkk, npp);
        }
        TextPath.FontSizes useFont = null;
        RectangularShape useBounds = null;
        Rectangle2D bounds = null;
        boolean rotate = false;
        for (TextPath.FontSizes size : this.bigToLittle_) {
            bounds = this.fonts_.get((Object)size).getStringBounds(name, frc);
            double h = bounds.getHeight();
            double w = bounds.getWidth();
            if (isHoriz) {
                if (!(h < rect.getHeight()) || !(w < (double)pad)) continue;
                useFont = size;
                useBounds = bounds;
                break;
            }
            if (!(w < rect.getWidth()) || !(h < (double)pad)) continue;
            useFont = size;
            useBounds = bounds;
            break;
        }
        if (useBounds == null) {
            useFont = TextPath.FontSizes.TINY;
            useBounds = bounds;
            rotate = true;
        }
        double scaleHeight = useBounds.getHeight();
        double scaleWidth = useBounds.getWidth();
        LineMetrics metrics = this.fonts_.get((Object)useFont).getLineMetrics(name, frc);
        if (isHoriz) {
            namey = rect.getCenterY() - 0.5 * scaleHeight + (double)metrics.getAscent();
            namex = rect.getX();
        } else if (rotate) {
            namey = rect.getY() + 0.5 * (double)pad + 0.5 * scaleWidth;
            namex = rect.getCenterX() - 0.5 * scaleHeight + (double)metrics.getAscent();
            double hold = scaleHeight;
            scaleHeight = scaleWidth;
            scaleWidth = hold;
        } else {
            namey = rect.getY() + 0.5 * (double)pad - 0.5 * scaleHeight + (double)metrics.getAscent();
            namex = rect.getCenterX() - 0.5 * scaleWidth;
        }
        ((Rectangle2D)useBounds).setRect(namex, namey, scaleWidth, scaleHeight);
        TextPath tpp = new TextPath(Color.BLACK, name, namex, namey, (Rectangle2D)useBounds, rotate, useFont);
        String tkk = Integer.toString(this.nameKeyCount_++);
        QuadTree.Payload textPay = new QuadTree.Payload((Rectangle2D)useBounds, tkk);
        payloadCache.add(textPay);
        this.nameKeyToPaintOneHalf_.put(nkk, tpp);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Reduction {
        Set<Integer> paintRows;
        Set<Integer> paintCols;
        Set<NID> paintNames;

        public Reduction(Set<Integer> rows, Set<Integer> cols, Set<NID> names) {
            this.paintRows = rows;
            this.paintCols = cols;
            this.paintNames = names;
        }

        public boolean somethingToPaint() {
            return !this.paintRows.isEmpty() || !this.paintCols.isEmpty() || !this.paintNames.isEmpty();
        }
    }

    public static class FloaterSet {
        public Rectangle floater;
        public Rectangle tourRect;
        public Rectangle currSelRect;

        public FloaterSet(Rectangle floater, Rectangle tourRect, Rectangle currSelRect) {
            this.floater = floater;
            this.tourRect = tourRect;
            this.currSelRect = currSelRect;
        }

        public void clear() {
            this.floater = null;
            this.tourRect = null;
            this.currSelRect = null;
        }

        public boolean isEmpty() {
            return this.floater == null && this.tourRect == null && this.currSelRect == null;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class DrainZoneInfo {
        private int diff;
        private TextPath.FontSizes font;
        private boolean doRotateName;
        private Rectangle2D dumpRect;
        private MinMax dzmm;
        private boolean greaterThanMinDZ;

        DrainZoneInfo(BioFabricNetwork.DrainZone dz) {
            this.dzmm = dz.getMinMax().clone();
            this.diff = this.dzmm.max - this.dzmm.min;
        }

        private void setGreaterThanMinDZ(boolean greaterThanMinDZ) {
            this.greaterThanMinDZ = greaterThanMinDZ;
        }

        private void setTextSize(BioFabricNetwork.NodeInfo target, Map<TextPath.FontSizes, Font> fonts, List<TextPath.FontSizes> bigToSmall, FontRenderContext frc) {
            this.doRotateName = false;
            this.diff = this.dzmm.max - this.dzmm.min;
            Rectangle2D bounds = null;
            for (TextPath.FontSizes size : bigToSmall) {
                bounds = fonts.get((Object)size).getStringBounds(target.getNodeName(), frc);
                if (!(bounds.getWidth() <= (double)(18 * this.diff))) continue;
                this.font = size;
                this.dumpRect = bounds;
                bounds = null;
                break;
            }
            if (bounds != null) {
                this.font = TextPath.FontSizes.TINY;
                this.dumpRect = bounds;
                this.doRotateName = true;
            }
        }
    }
}

