/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.render;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Line2D;
import org.systemsbiology.biofabric.api.util.MinMax;

public class LinePath {
    private Color col;
    private Line2D path;
    private int px;
    private int py;
    private MinMax range;
    private boolean reusing;

    LinePath() {
        this.reusing = true;
    }

    LinePath(Color col, Line2D path, int x, int y, MinMax range) {
        this.reset(col, path, x, y, range);
        this.reusing = false;
    }

    public LinePath reset(Color col, Line2D path, int x, int y, MinMax range) {
        this.col = col;
        this.path = path;
        this.px = x;
        this.py = y;
        this.range = range;
        return this;
    }

    int paint(Graphics2D g2, Rectangle bounds) {
        int didPaint = 0;
        if (this.px == Integer.MIN_VALUE) {
            didPaint = this.paintAsNode(g2, bounds);
        } else if (this.py == Integer.MIN_VALUE) {
            didPaint = this.paintAsLink(g2, bounds);
        }
        return didPaint;
    }

    private int paintAsNode(Graphics2D g2, Rectangle bounds) {
        int didPaint = 0;
        g2.setPaint(this.col);
        if ((bounds == null || this.py >= bounds.y && this.py <= bounds.y + bounds.height) && (bounds == null || this.range.max >= bounds.x && this.range.min <= bounds.x + bounds.width)) {
            double x1 = this.path.getX1();
            double x2 = this.path.getX2();
            double y1 = this.path.getY1();
            double y2 = this.path.getY2();
            boolean replace = false;
            if (x2 < x1) {
                throw new IllegalStateException();
            }
            double useLowBound = x1;
            double useHiBound = x2;
            if (x2 - x1 > 100000.0) {
                if (x1 < bounds.getMinX()) {
                    useLowBound = bounds.getX() - 1000.0;
                    replace = true;
                }
                if (x2 > bounds.getMaxX()) {
                    useHiBound = bounds.getMaxX() + 1000.0;
                    replace = true;
                }
                this.path.setLine(useLowBound, y1, useHiBound, y2);
            }
            g2.draw(this.path);
            if (replace) {
                this.path.setLine(x1, y1, x2, y2);
            }
            ++didPaint;
        }
        return didPaint;
    }

    private int paintAsLink(Graphics2D g2, Rectangle bounds) {
        int didPaint = 0;
        g2.setPaint(this.col);
        if (this.py == Integer.MIN_VALUE && (bounds == null || this.px >= bounds.x && this.px <= bounds.x + bounds.width) && (bounds == null || this.range.max >= bounds.y && this.range.min <= bounds.y + bounds.height)) {
            double x1 = this.path.getX1();
            double x2 = this.path.getX2();
            double y1 = this.path.getY1();
            double y2 = this.path.getY2();
            boolean replace = false;
            if (y2 < y1) {
                throw new IllegalStateException();
            }
            double useLowBound = y1;
            double useHiBound = y2;
            if (y2 - y1 > 100000.0) {
                if (y1 < bounds.getMinY()) {
                    useLowBound = bounds.getY() - 1000.0;
                    replace = this.reusing;
                }
                if (y2 > bounds.getMaxY()) {
                    useHiBound = bounds.getMaxY() + 1000.0;
                    replace = this.reusing;
                }
                this.path.setLine(x1, useLowBound, x2, useHiBound);
            }
            g2.draw(this.path);
            if (replace) {
                this.path.setLine(x1, y1, x2, y2);
            }
            ++didPaint;
        }
        return didPaint;
    }
}

