/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.render;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;

public class ImgAndBufPool {
    private HashMap<StackKey, List<BufferedImage>> biStack_ = new HashMap();
    private HashMap<Integer, List<int[]>> bufStack_ = new HashMap();
    private HashMap<Integer, List<byte[]>> byteStack_ = new HashMap();
    private int binSize_;

    public ImgAndBufPool(int binSize) {
        this.binSize_ = binSize;
    }

    public synchronized BufferedImage fetchImage(int imgWidth, int imgHeight, int type) {
        BufferedImage bi;
        List<Object> stack = null;
        for (StackKey sk : this.biStack_.keySet()) {
            if (!sk.matches(imgWidth, imgHeight, type)) continue;
            stack = this.biStack_.get(sk);
            break;
        }
        if (stack == null) {
            stack = new ArrayList();
            this.biStack_.put(new StackKey(imgWidth, imgHeight, type), stack);
        }
        if (stack.isEmpty()) {
            bi = new BufferedImage(imgWidth, imgHeight, type);
        } else {
            bi = (BufferedImage)stack.remove(stack.size() - 1);
            Graphics2D graphics = bi.createGraphics();
            graphics.setPaint(new Color(255, 255, 255));
            graphics.fillRect(0, 0, bi.getWidth(), bi.getHeight());
        }
        return bi;
    }

    public synchronized int[] fetchBuf(int size) {
        int[] retval;
        List<int[]> stack = this.bufStack_.get(size);
        if (stack == null) {
            stack = new ArrayList<int[]>();
            this.bufStack_.put(size, stack);
        }
        if (stack.isEmpty()) {
            retval = new int[size];
        } else {
            retval = stack.remove(stack.size() - 1);
            Arrays.fill(retval, 0);
        }
        return retval;
    }

    public synchronized byte[] fetchByteBuf(int size) {
        byte[] retval;
        Integer key;
        List<byte[]> stack;
        int useSize = size;
        int rem = size % this.binSize_;
        if (rem != 0) {
            int quo = size / this.binSize_;
            useSize = (quo + 1) * this.binSize_;
        }
        if ((stack = this.byteStack_.get(key = Integer.valueOf(useSize))) == null) {
            stack = new ArrayList<byte[]>();
            this.byteStack_.put(key, stack);
        }
        if (stack.isEmpty()) {
            retval = new byte[useSize];
        } else {
            retval = stack.remove(stack.size() - 1);
            Arrays.fill(retval, (byte)0);
        }
        return retval;
    }

    public synchronized void returnImage(BufferedImage bi) {
        if (bi == null) {
            System.err.println("Returning null BufferedImage");
            return;
        }
        int imgWidth = bi.getWidth();
        int imgHeight = bi.getHeight();
        int type = bi.getType();
        List<BufferedImage> stack = null;
        for (StackKey sk : this.biStack_.keySet()) {
            if (!sk.matches(imgWidth, imgHeight, type)) continue;
            stack = this.biStack_.get(sk);
            break;
        }
        if (stack == null) {
            stack = new ArrayList<BufferedImage>();
            this.biStack_.put(new StackKey(imgWidth, imgHeight, type), stack);
        }
        for (BufferedImage sk : stack) {
            if (sk.hashCode() != bi.hashCode()) continue;
            throw new IllegalStateException();
        }
        stack.add(bi);
    }

    public synchronized void returnBuf(int[] buf) {
        if (buf == null) {
            System.err.println("Returning null buf");
            return;
        }
        List<int[]> stack = this.bufStack_.get(buf.length);
        if (stack == null) {
            stack = new ArrayList<int[]>();
            this.bufStack_.put(buf.length, stack);
        } else if (stack.contains(buf)) {
            throw new IllegalStateException();
        }
        stack.add(buf);
    }

    public synchronized void returnByteBuf(byte[] buf) {
        if (buf == null) {
            System.err.println("Returning null buf");
            return;
        }
        List<byte[]> stack = this.byteStack_.get(buf.length);
        if (stack == null) {
            stack = new ArrayList<byte[]>();
            this.byteStack_.put(buf.length, stack);
        } else if (stack.contains(buf)) {
            throw new IllegalStateException();
        }
        stack.add(buf);
    }

    private static class StackKey {
        int width;
        int height;
        int type;

        StackKey(int width, int height, int type) {
            this.width = width;
            this.height = height;
            this.type = type;
        }

        boolean matches(int width, int height, int type) {
            return this.width == width && this.height == height && this.type == type;
        }

        public int hashCode() {
            return this.width + this.height + this.type;
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof StackKey)) {
                return false;
            }
            StackKey otherMM = (StackKey)other;
            return this.width == otherMM.width && this.height == otherMM.height && this.type == otherMM.type;
        }
    }
}

