/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.render;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;

public class GlyphPath {
    private Color col_;
    private Path2D gp_;
    private Rectangle2D rect_;
    private Rectangle2D rect2_;
    private Rectangle2D gpBounds_;
    private boolean isDirected_;

    GlyphPath() {
        this.col_ = null;
        this.rect_ = new Rectangle2D.Double();
        this.rect2_ = new Rectangle2D.Double();
        this.gp_ = new Path2D.Double();
        this.gpBounds_ = new Rectangle2D.Double();
        this.isDirected_ = false;
    }

    GlyphPath(Color col, int x, int yStrt, int yEnd, double halfWidth, boolean isDirected) {
        this.col_ = col;
        this.isDirected_ = isDirected;
        if (isDirected) {
            this.buildDirected(x, yStrt, yEnd, halfWidth);
        } else {
            this.buildUndirected(x, yStrt, yEnd, halfWidth);
        }
    }

    private void buildUndirected(int x, int yStrt, int yEnd, double halfWidth) {
        this.rect_ = new Rectangle2D.Double();
        this.rect2_ = new Rectangle2D.Double();
        this.initUndir(x, yStrt, yEnd, halfWidth);
    }

    private void buildDirected(int x, int yStrt, int yEnd, double halfWidth) {
        this.rect_ = new Rectangle2D.Double();
        this.gp_ = new Path2D.Double();
        this.gpBounds_ = new Rectangle2D.Double();
        this.initDir(x, yStrt, yEnd, halfWidth);
    }

    GlyphPath reuse(Color col, int x, int yStrt, int yEnd, double halfWidth, boolean isDirected) {
        this.col_ = col;
        this.isDirected_ = isDirected;
        if (isDirected) {
            this.initDir(x, yStrt, yEnd, halfWidth);
        } else {
            this.initUndir(x, yStrt, yEnd, halfWidth);
        }
        return this;
    }

    void initUndir(int x, int yStrt, int yEnd, double halfWidth) {
        this.rect_.setRect((double)x - halfWidth, (double)yStrt - halfWidth, 2.0 * halfWidth, 2.0 * halfWidth);
        this.rect2_.setRect((double)x - halfWidth, (double)yEnd - halfWidth, 2.0 * halfWidth, 2.0 * halfWidth);
    }

    void initDir(int x, int yStrt, int yEnd, double halfWidth) {
        double yMax;
        double yMin;
        double yoff;
        this.rect_.setRect((double)x - halfWidth, (double)yStrt - halfWidth, 2.0 * halfWidth, 2.0 * halfWidth);
        if (yStrt < yEnd) {
            yoff = -halfWidth;
            yMin = (double)yEnd - 2.0 * halfWidth;
            yMax = (double)yEnd + halfWidth;
        } else {
            yoff = halfWidth;
            yMin = (double)yEnd - halfWidth;
            yMax = (double)yEnd + 2.0 * halfWidth;
        }
        this.gp_.reset();
        this.gp_.moveTo((double)x - halfWidth, (double)yEnd + 2.0 * yoff);
        this.gp_.lineTo(x, (double)yEnd + yoff);
        this.gp_.lineTo((double)x - halfWidth, (double)yEnd + yoff);
        this.gp_.lineTo((double)x - halfWidth, (double)yEnd - yoff);
        this.gp_.lineTo((double)x + halfWidth, (double)yEnd - yoff);
        this.gp_.lineTo((double)x + halfWidth, (double)yEnd + yoff);
        this.gp_.lineTo(x, (double)yEnd + yoff);
        this.gp_.lineTo((double)x + halfWidth, (double)yEnd + 2.0 * yoff);
        this.gp_.closePath();
        this.gpBounds_.setRect((double)x - halfWidth, yMin, 2.0 * halfWidth, yMax - yMin);
    }

    int paint(Graphics2D g2, Rectangle bounds) {
        int didPaint = 0;
        g2.setPaint(this.col_);
        if (this.rect_ != null) {
            if (bounds == null || this.rect_.getMaxX() > bounds.getMinX() && this.rect_.getMinX() < bounds.getMaxX() && this.rect_.getMaxY() > bounds.getMinY() && this.rect_.getMinY() < bounds.getMaxY()) {
                g2.fill(this.rect_);
                g2.setPaint(Color.BLACK);
                g2.draw(this.rect_);
                ++didPaint;
            }
            if (!this.isDirected_) {
                if (bounds == null || this.rect2_.getMaxX() > bounds.getMinX() && this.rect2_.getMinX() < bounds.getMaxX() && this.rect2_.getMaxY() > bounds.getMinY() && this.rect2_.getMinY() < bounds.getMaxY()) {
                    g2.setPaint(this.col_);
                    g2.fill(this.rect2_);
                    g2.setPaint(Color.BLACK);
                    g2.draw(this.rect2_);
                    ++didPaint;
                }
            } else if (bounds == null || this.gpBounds_.getMaxX() > bounds.getMinX() && this.gpBounds_.getMinX() < bounds.getMaxX() && this.gpBounds_.getMaxY() > bounds.getMinY() && this.gpBounds_.getMinY() < bounds.getMaxY()) {
                g2.setPaint(this.col_);
                g2.fill(this.gp_);
                g2.setPaint(Color.BLACK);
                g2.draw(this.gp_);
                ++didPaint;
            }
        }
        return didPaint;
    }
}

