/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.render;

import java.awt.Dimension;
import java.awt.Rectangle;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.image.DataBufferInt;
import java.awt.image.DirectColorModel;
import java.awt.image.WritableRaster;
import java.io.IOException;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import javax.swing.SwingUtilities;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.ui.render.BufBuildDrawer;
import org.systemsbiology.biofabric.ui.render.ImgAndBufPool;
import org.systemsbiology.biofabric.ui.render.RasterCache;
import org.systemsbiology.biofabric.util.QuadTree;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BufferBuilder {
    private static final int SLICE_HEIGHT_HACK_ = 1;
    private static final double TRANSITION_LPP_ = 20.0;
    private RasterCache cache_;
    private HashMap<Rectangle2D, WorldPieceOffering> allWorldsToImageName_;
    private QuadTree findWorldsQT_;
    private BufBuildDrawer drawRender_;
    private BufBuildDrawer binRender_;
    private int[] bbZooms_;
    private Dimension screenDim_;
    private Rectangle2D worldRect_;
    private BufferBuilderClient bbc_;
    private boolean timeToExit_;
    private BuildImageWorker biw_;
    private ImgAndBufPool bis_;

    public BufferBuilder(String cachePref, int maxMeg, BufBuildDrawer drawRender, BufBuildDrawer binRender, ImgAndBufPool bis) {
        BufferedImage forModel = new BufferedImage(1, 1, 1);
        DirectColorModel dcm = (DirectColorModel)forModel.getColorModel();
        this.cache_ = new RasterCache(cachePref, maxMeg, dcm);
        this.allWorldsToImageName_ = new HashMap();
        this.findWorldsQT_ = null;
        this.drawRender_ = drawRender;
        this.binRender_ = binRender;
        this.bbc_ = null;
        this.timeToExit_ = false;
        this.bis_ = bis;
    }

    public BufferBuilder(BufBuildDrawer drawRender, BufBuildDrawer binRender, ImgAndBufPool bis) {
        this.drawRender_ = drawRender;
        this.binRender_ = binRender;
        this.allWorldsToImageName_ = new HashMap();
        this.findWorldsQT_ = null;
        this.bbc_ = null;
        this.timeToExit_ = false;
        this.bis_ = bis;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        BufferBuilder bufferBuilder = this;
        synchronized (bufferBuilder) {
            this.timeToExit_ = true;
            this.bbc_ = null;
            this.notify();
        }
        if (this.findWorldsQT_ != null) {
            this.findWorldsQT_.clear();
        }
        this.cache_.releaseResources();
    }

    public BufferedImage buildOneBuf() {
        this.screenDim_ = new Dimension();
        this.worldRect_ = new Rectangle2D.Double();
        this.binRender_.dimsForBuf(this.screenDim_, this.worldRect_);
        Rectangle worldPiece = UiUtil.rectFromRect2D(this.worldRect_);
        BufferedImage bi = this.bis_.fetchImage(this.screenDim_.width, this.screenDim_.height, 1);
        double lpp = this.linksPerPix(this.screenDim_, worldPiece);
        BufBuildDrawer useDrawer = lpp < 20.0 ? this.drawRender_ : this.binRender_;
        useDrawer.drawForBuffer(bi, worldPiece, this.screenDim_, worldPiece, 0, lpp);
        return bi;
    }

    public void getSlicesToCover(int depth, Rectangle2D viewInWorld, List<Rectangle2D> slicesToCover) {
        ArrayList<QuadTree.QuadTreeNode> qtnList = new ArrayList<QuadTree.QuadTreeNode>();
        this.findWorldsQT_.getNodes(viewInWorld, depth, qtnList);
        int lsiz = qtnList.size();
        for (int i = 0; i < lsiz; ++i) {
            QuadTree.QuadTreeNode qtn = qtnList.get(i);
            slicesToCover.add(qtn.getWorldExtent());
        }
    }

    public BufferedImage buildBufs(int[] zooms, BufferBuilderClient bbc, int maxSize, BTProgressMonitor monitor) throws IOException, AsynchExitRequestException {
        this.timeToExit_ = false;
        this.bbZooms_ = new int[zooms.length];
        System.arraycopy(zooms, 0, this.bbZooms_, 0, zooms.length);
        this.screenDim_ = new Dimension();
        this.worldRect_ = new Rectangle2D.Double();
        this.drawRender_.dimsForBuf(this.screenDim_, this.worldRect_);
        Rectangle worldPiece = UiUtil.rectFromRect2D(this.worldRect_);
        this.findWorldsQT_ = new QuadTree(worldPiece, zooms.length);
        List<QueueRequest> requestQueuePre = this.buildQueue(0, 1, 10);
        LoopReporter lr = new LoopReporter(requestQueuePre.size(), 20, monitor, 0.0, 1.0, "progress.stockingImageBufferTop");
        while (!requestQueuePre.isEmpty()) {
            QueueRequest qr = requestQueuePre.remove(0);
            lr.report();
            this.buildBuffer(new Dimension(qr.imageDim.width, qr.imageDim.height), qr);
        }
        int useMax = 1;
        ArrayList<QueueRequest> requestQueue = zooms.length > 2 ? this.buildQueue(2, zooms.length - 1, useMax) : new ArrayList<QueueRequest>();
        this.bbc_ = bbc;
        if (!requestQueue.isEmpty()) {
            this.biw_ = new BuildImageWorker(this.screenDim_, requestQueue);
            Thread runThread = new Thread(this.biw_);
            runThread.setPriority(runThread.getPriority() - 2);
            runThread.start();
        }
        return this.getTopImage();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getTopImage() throws IOException {
        ArrayList<QuadTree.QuadTreeNode> nodes = new ArrayList<QuadTree.QuadTreeNode>();
        boolean found = this.findWorldsQT_.getAllNodesToDepth(0, 0, nodes);
        if (!found || nodes.size() != 1) {
            throw new IOException();
        }
        WorldPieceOffering wpo = this.allWorldsToImageName_.get(nodes.get(0).getWorldExtent());
        if (wpo == null) {
            return null;
        }
        BufferedImage retval = null;
        BufferBuilder bufferBuilder = this;
        synchronized (bufferBuilder) {
            retval = this.cache_.getAnImage(wpo.cacheHandle, this.bis_);
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BufferedImage getImageForPiece(int depth, Rectangle2D worldRect) throws IOException {
        WorldPieceOffering wpo = this.allWorldsToImageName_.get(worldRect);
        if (wpo == null) {
            wpo = new WorldPieceOffering(null, this.screenDim_, worldRect, false);
            this.allWorldsToImageName_.put(worldRect, wpo);
        }
        boolean needLoRes = false;
        BufferBuilder bufferBuilder = this;
        synchronized (bufferBuilder) {
            needLoRes = wpo.cacheHandle == null;
        }
        if (needLoRes) {
            UiUtil.fixMePrintout("RACE CONDITION! Make sure low-res does not replace a high-res if it gets done second");
            this.buildLoResSlice(worldRect, wpo);
            if (this.biw_ != null) {
                this.biw_.bumpRequest(new QueueRequest(depth, this.screenDim_, worldRect));
            }
        }
        BufferedImage retval = null;
        BufferBuilder bufferBuilder2 = this;
        synchronized (bufferBuilder2) {
            if (wpo.cacheHandle != null && !wpo.cacheHandle.equals("")) {
                retval = this.cache_.getAnImage(wpo.cacheHandle, this.bis_);
            }
        }
        return retval;
    }

    private List<QueueRequest> buildQueue(int startIndex, int endIndex, int maxCount) {
        ArrayList<QueueRequest> retval = new ArrayList<QueueRequest>();
        ArrayList<QuadTree.QuadTreeNode> nodes = new ArrayList<QuadTree.QuadTreeNode>();
        this.findWorldsQT_.getAllNodesToDepth(startIndex, endIndex, nodes);
        Rectangle2D.Double emptyExtent = new Rectangle2D.Double(0.0, 0.0, 0.0, 0.0);
        int numWorlds = nodes.size();
        for (int i = 0; i < numWorlds; ++i) {
            QuadTree.QuadTreeNode node = nodes.get(i);
            Rectangle2D worldExtent = node.getWorldExtent();
            if (worldExtent.equals(emptyExtent)) continue;
            WorldPieceOffering wpo = this.allWorldsToImageName_.get(worldExtent);
            if (wpo != null) {
                UiUtil.fixMePrintout("Cancel of relayout puts us here");
                System.err.println("Dup " + worldExtent);
                throw new IllegalStateException();
            }
            wpo = new WorldPieceOffering(null, this.screenDim_, worldExtent, false);
            this.allWorldsToImageName_.put(worldExtent, wpo);
            retval.add(new QueueRequest(node.getDepth(), this.screenDim_, wpo.worldRect));
            if (retval.size() < maxCount) continue;
            return retval;
        }
        return retval;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean buildBuffer(Dimension imageDim, QueueRequest qr) throws IOException {
        BufferBuilder bufferBuilder = this;
        synchronized (bufferBuilder) {
            if (this.timeToExit_) {
                return false;
            }
        }
        this.buildHiResSlice(imageDim, qr.depth, qr.worldPiece);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String buildLoResSlice(Rectangle2D worldRect, WorldPieceOffering wpo) throws IOException {
        int i;
        ArrayList<QuadTree.QuadTreeNode> path = new ArrayList<QuadTree.QuadTreeNode>();
        BufferedImage bi1 = null;
        if (!this.findWorldsQT_.getPath(worldRect, path)) {
            throw new IllegalStateException();
        }
        WorldPieceOffering wpou = null;
        int pathLen = path.size();
        for (int i2 = pathLen - 1; i2 >= 0; --i2) {
            QuadTree.QuadTreeNode node = path.get(i2);
            BufferBuilder bufferBuilder = this;
            synchronized (bufferBuilder) {
                wpou = this.allWorldsToImageName_.get(node.getWorldExtent());
                if (wpou != null && wpou.cacheHandle != null && !wpou.cacheHandle.equals("")) {
                    bi1 = this.cache_.getAnImage(wpou.cacheHandle, this.bis_);
                    break;
                }
                continue;
            }
        }
        if (bi1 == null) {
            return null;
        }
        double subxFrac = (worldRect.getX() - wpou.worldRect.getX()) / wpou.worldRect.getWidth();
        int subxLoc = (int)Math.round(subxFrac * this.screenDim_.getWidth());
        double subyFrac = (worldRect.getY() - wpou.worldRect.getY()) / wpou.worldRect.getHeight();
        int subyLoc = (int)Math.round(subyFrac * this.screenDim_.getHeight());
        int subW = (int)Math.round(worldRect.getWidth() / wpou.worldRect.getWidth() * (double)bi1.getWidth());
        int subH = (int)Math.round(worldRect.getHeight() / wpou.worldRect.getHeight() * (double)bi1.getHeight());
        WritableRaster wr = bi1.getRaster();
        int pixNum = subW * subH;
        RasterCache.ShiftData sd = new RasterCache.ShiftData((DirectColorModel)bi1.getColorModel());
        UiUtil.fixMePrintout("OK, should do scaling with original int array, but stick with old code for the moment");
        int[] bbcI = this.bis_.fetchBuf(pixNum);
        wr.getDataElements(subxLoc, subyLoc, subW, subH, bbcI);
        int smallLen = pixNum * 3;
        byte[] bbc = this.bis_.fetchByteBuf(smallLen);
        RasterCache.oneIntToThreeBytes(bbcI, bbc, sd);
        this.bis_.returnBuf(bbcI);
        BufferedImage scaled = this.bis_.fetchImage(this.screenDim_.width, this.screenDim_.height + 1, 1);
        int scaledIntBufSize = scaled.getRaster().getDataBuffer().getSize();
        byte[] bbs = this.bis_.fetchByteBuf(scaledIntBufSize * 3);
        for (int i3 = 0; i3 < bbs.length; ++i3) {
            bbs[i3] = -1;
        }
        int factor = (int)Math.floor(this.screenDim_.width / subW);
        int facSq = factor * factor;
        for (i = 0; i < subH; ++i) {
            for (int j = 0; j < subW; ++j) {
                int currOffSmall = i * (subW * 3) + j * 3;
                int currOffLargeBase = i * (subW * 3 * facSq) + j * 3 * factor;
                int dupOffset = 0;
                for (int k = 0; k < factor; ++k) {
                    int currOffLargeDup = currOffLargeBase + dupOffset;
                    dupOffset += 3;
                    for (int m = 0; m < 3; ++m) {
                        byte b;
                        bbs[currOffLargeDup + m] = b = bbc[currOffSmall + m];
                    }
                }
            }
        }
        block14: for (i = 0; i < this.screenDim_.height; i += factor) {
            int currOffBase = i * this.screenDim_.width * 3;
            for (int k = 1; k < factor; ++k) {
                int currOffDest = (i + k) * this.screenDim_.width * 3;
                try {
                    System.arraycopy(bbs, currOffBase, bbs, currOffDest, this.screenDim_.width * 3);
                    continue;
                }
                catch (ArrayIndexOutOfBoundsException aex) {
                    UiUtil.fixMePrintout("Have seen array out of bounds here (collatz.sif->Hierarchical)!");
                    System.err.println("factor " + factor + " " + this.screenDim_.width + " " + subW);
                    System.err.println("ik " + i + " " + k);
                    System.err.println("bbs " + bbs.length);
                    System.err.println("col " + currOffBase);
                    System.err.println("cold " + currOffDest);
                    i = 10000000;
                    continue block14;
                }
            }
        }
        WritableRaster bisRast = scaled.getRaster();
        int[] bbsI = this.bis_.fetchBuf(scaledIntBufSize);
        RasterCache.threeBytesToOneInt(bbs, bbsI, sd);
        bisRast.setDataElements(0, 0, this.screenDim_.width, this.screenDim_.height + 1, bbsI);
        String handle = null;
        BufferBuilder bufferBuilder = this;
        synchronized (bufferBuilder) {
            if (!wpo.isDrawn) {
                if (!this.isBlankImage(scaled)) {
                    wpo.cacheHandle = this.cache_.cacheAnImage(scaled, this.bis_);
                } else {
                    wpo.cacheHandle = "";
                    this.bis_.returnImage(scaled);
                }
            }
        }
        this.bis_.returnImage(bi1);
        this.bis_.returnByteBuf(bbc);
        this.bis_.returnByteBuf(bbs);
        this.bis_.returnBuf(bbsI);
        return handle;
    }

    private void worksForDoubling(int subW, int subH, byte[] bbc, byte[] bbs) {
        for (int i = 0; i < subH; ++i) {
            block3: for (int j = 0; j < subW; ++j) {
                int currOffSmall = i * (subW * 3) + j * 3;
                int currOffLarge = i * (subW * 3 * 4) + j * 3 * 2;
                int currOffLargeDup = currOffLarge + 3;
                int currOffLargeNextRow = i * (subW * 3 * 4) + subW * 3 * 2 + j * 3 * 2;
                int currOffLargeNextRowDup = currOffLargeNextRow + 3;
                for (int k = 0; k < 3; ++k) {
                    try {
                        byte b;
                        bbs[currOffLarge + k] = b = bbc[currOffSmall + k];
                        bbs[currOffLargeDup + k] = b;
                        bbs[currOffLargeNextRow + k] = b;
                        bbs[currOffLargeNextRowDup + k] = b;
                        continue;
                    }
                    catch (ArrayIndexOutOfBoundsException aex) {
                        System.err.println("ijk " + i + " " + j + " " + k);
                        System.err.println("cos " + currOffSmall);
                        System.err.println("col " + currOffLarge);
                        System.err.println("cold " + currOffLargeDup);
                        System.err.println("coln " + currOffLargeNextRow);
                        System.err.println("colnd " + currOffLargeNextRowDup);
                        i = 100000;
                        j = 100000;
                        continue block3;
                    }
                }
            }
        }
    }

    private double linksPerPix(Dimension imageDim, Rectangle2D worldPiece) {
        double zoom = Math.max(imageDim.getWidth() / worldPiece.getWidth(), imageDim.getHeight() / worldPiece.getHeight());
        double linksPerPix = 1.0 / (18.0 * zoom);
        return linksPerPix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void buildHiResSlice(Dimension imageDim, int depth, Rectangle2D worldPiece) throws IOException {
        BufferedImage bi = this.bis_.fetchImage(imageDim.width, imageDim.height + 1, 1);
        double lpp = this.linksPerPix(imageDim, worldPiece);
        BufBuildDrawer useDrawer = lpp < 20.0 ? this.drawRender_ : this.binRender_;
        boolean didDraw = useDrawer.drawForBuffer(bi, worldPiece, imageDim, worldPiece, 1, lpp);
        BufferBuilderClient tellHim = null;
        BufferBuilder bufferBuilder = this;
        synchronized (bufferBuilder) {
            WorldPieceOffering wpo = this.allWorldsToImageName_.get(worldPiece);
            if (didDraw) {
                UiUtil.fixMePrintout("saw an NPE here. wpo must have been null!");
                if (wpo.cacheHandle == null || wpo.cacheHandle.equals("")) {
                    wpo.cacheHandle = this.cache_.cacheAnImage(bi, this.bis_);
                } else {
                    this.cache_.replaceAnImage(wpo.cacheHandle, bi, this.bis_);
                }
                wpo.isDrawn = true;
            } else if (wpo.cacheHandle == null) {
                wpo.cacheHandle = "";
            } else if (!wpo.cacheHandle.equals("")) {
                this.cache_.dropAnImage(wpo.cacheHandle, this.bis_);
            }
            if (this.bbc_ != null) {
                tellHim = this.bbc_;
            }
        }
        if (tellHim != null) {
            final int noteKey = depth;
            final BufferBuilderClient fth = tellHim;
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    fth.yourOrderIsReady(noteKey);
                }
            });
        }
    }

    private boolean isBlankImage(BufferedImage bi) {
        int width = bi.getWidth();
        int height = bi.getHeight();
        int len = width * height;
        int[] bbs = ((DataBufferInt)bi.getRaster().getDataBuffer()).getData();
        DirectColorModel dcm = (DirectColorModel)bi.getColorModel();
        for (int i = 0; i < len; ++i) {
            if (dcm.getRed(bbs[i]) == 255 && dcm.getGreen(bbs[i]) == 255 && dcm.getBlue(bbs[i]) == 255) continue;
            return false;
        }
        return true;
    }

    public static interface BufferBuilderClient {
        public void yourOrderIsReady(int var1);
    }

    private static class QueueRequest {
        int depth;
        Dimension imageDim;
        Rectangle2D worldPiece;

        QueueRequest(int depth, Dimension imageDim, Rectangle2D worldPiece) {
            this.depth = depth;
            this.worldPiece = worldPiece;
            this.imageDim = imageDim;
        }

        public int hashCode() {
            return this.depth + this.worldPiece.hashCode() + this.imageDim.hashCode();
        }

        public boolean equals(Object other) {
            if (other == null) {
                return false;
            }
            if (other == this) {
                return true;
            }
            if (!(other instanceof QueueRequest)) {
                return false;
            }
            QueueRequest otherReq = (QueueRequest)other;
            if (this.depth != otherReq.depth) {
                return false;
            }
            if (!this.imageDim.equals(otherReq.imageDim)) {
                return false;
            }
            return this.worldPiece.equals(otherReq.worldPiece);
        }
    }

    private static class WorldPieceOffering
    implements Cloneable {
        String cacheHandle;
        boolean isDrawn;
        Dimension imageDim;
        Rectangle2D worldRect;

        WorldPieceOffering(String cacheHandle, Dimension imageDim, Rectangle2D worldRect, boolean isDrawn) {
            this.cacheHandle = cacheHandle;
            this.imageDim = imageDim;
            this.worldRect = worldRect;
            this.isDrawn = isDrawn;
        }

        public WorldPieceOffering clone() {
            try {
                return (WorldPieceOffering)super.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public class BuildImageWorker
    implements Runnable {
        private Dimension screenDim_;
        private String errString_;
        private ArrayList<QueueRequest> requests_;

        public BuildImageWorker(Dimension screenDim, List<QueueRequest> requests) {
            this.screenDim_ = (Dimension)screenDim.clone();
            this.requests_ = new ArrayList<QueueRequest>(requests);
        }

        @Override
        public void run() {
            try {
                QueueRequest qr;
                while ((qr = this.getNextRequest()) != null) {
                    if (BufferBuilder.this.buildBuffer(new Dimension(qr.imageDim.width, qr.imageDim.height), qr)) continue;
                    return;
                }
            }
            catch (IOException ex) {
                ex.printStackTrace();
                this.errString_ = "IOException";
            }
            catch (Throwable oom) {
                String format = "Other error : {1}";
                oom.printStackTrace();
                this.errString_ = MessageFormat.format(format, oom.getMessage());
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private QueueRequest getNextRequest() {
            BufferBuilder bufferBuilder = BufferBuilder.this;
            synchronized (bufferBuilder) {
                while (this.requests_.isEmpty()) {
                    try {
                        BufferBuilder.this.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    if (!BufferBuilder.this.timeToExit_) continue;
                    return null;
                }
                return this.requests_.remove(0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        void bumpRequest(QueueRequest qr) {
            BufferBuilder bufferBuilder = BufferBuilder.this;
            synchronized (bufferBuilder) {
                this.requests_.remove(qr);
                this.requests_.add(0, qr);
                BufferBuilder.this.notify();
            }
        }
    }
}

