/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.render;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.ArrayList;
import java.util.List;
import org.systemsbiology.biofabric.api.layout.AnnotColorSource;
import org.systemsbiology.biofabric.api.model.Annot;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.util.MinMax;
import org.systemsbiology.biofabric.model.AnnotationSetImpl;
import org.systemsbiology.biofabric.model.BioFabricNetwork;
import org.systemsbiology.biofabric.ui.BasicZoomTargetSupport;
import org.systemsbiology.biofabric.ui.FabricColorGenerator;
import org.systemsbiology.biofabric.ui.render.BufBuildDrawer;
import org.systemsbiology.biofabric.ui.render.ImgAndBufPool;
import org.systemsbiology.biofabric.ui.render.PaintCacheSmall;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BucketRenderer
implements BufBuildDrawer {
    private List<BioFabricNetwork.NodeInfo> targetList_ = new ArrayList<BioFabricNetwork.NodeInfo>();
    private List<BioFabricNetwork.LinkInfo> linkList_ = new ArrayList<BioFabricNetwork.LinkInfo>();
    private BioFabricNetwork.Extents ext_ = new BioFabricNetwork.Extents();
    private AnnotationSet nodeAnnot_;
    private AnnotationSet linkAnnot_;
    private Dimension screenDim_;
    private boolean showShadows_;
    private Rectangle2D worldRect_ = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
    private ImgAndBufPool bis_ = null;
    private AnnotColorSource.AnnotColor[] annotColors_;
    private Color[] linkAnnotGrays_;
    private final Color[] nodeCycle_;
    private final Color[] linkCycle_;
    private static final int LINK_MAX_ALPHA_ = 180;
    private static final int NODE_MAX_ALPHA_ = 180;

    public BucketRenderer(FabricColorGenerator colGen) {
        this.nodeAnnot_ = new AnnotationSetImpl();
        this.linkAnnot_ = new AnnotationSetImpl();
        this.nodeCycle_ = new Color[]{new Color(145, 141, 126), new Color(194, 201, 213), new Color(160, 141, 129), new Color(177, 191, 189), new Color(162, 129, 134), new Color(189, 166, 148), new Color(163, 162, 157), new Color(148, 163, 165), new Color(182, 164, 165), new Color(144, 155, 140), new Color(202, 160, 178), new Color(133, 144, 129), new Color(208, 183, 185), new Color(153, 142, 127), new Color(215, 193, 204), new Color(145, 141, 125), new Color(194, 201, 213), new Color(160, 141, 129), new Color(186, 168, 166), new Color(164, 147, 137), new Color(166, 150, 153), new Color(175, 168, 152), new Color(161, 170, 148), new Color(184, 166, 159), new Color(144, 156, 141), new Color(202, 160, 178), new Color(133, 144, 129), new Color(209, 190, 194), new Color(165, 125, 143), new Color(219, 200, 203)};
        this.linkCycle_ = new Color[]{new Color(123, 104, 111), new Color(92, 92, 90), new Color(129, 124, 117), new Color(99, 95, 93), new Color(137, 122, 128), new Color(109, 106, 84), new Color(133, 119, 125), new Color(103, 95, 101), new Color(130, 106, 109), new Color(106, 100, 96), new Color(113, 95, 100), new Color(109, 108, 102), new Color(114, 110, 101), new Color(115, 103, 108), new Color(99, 90, 102), new Color(124, 114, 116), new Color(96, 83, 103), new Color(130, 126, 123), new Color(111, 85, 105), new Color(139, 125, 129), new Color(109, 106, 84), new Color(117, 114, 121), new Color(106, 90, 95), new Color(126, 104, 98), new Color(105, 107, 104), new Color(102, 105, 112), new Color(111, 105, 107), new Color(102, 98, 112), new Color(119, 106, 109), new Color(99, 90, 102)};
        this.annotColors_ = AnnotColorSource.getColorCycle();
        this.linkAnnotGrays_ = AnnotColorSource.getGrayCycle();
    }

    @Override
    public void dimsForBuf(Dimension screenDim, Rectangle2D worldRect) {
        UiUtil.fixMePrintout("Seeing NPE here during recolor");
        screenDim.setSize(this.screenDim_);
        worldRect.setRect(this.worldRect_);
    }

    public void buildBucketCache(List<BioFabricNetwork.NodeInfo> targets, List<BioFabricNetwork.LinkInfo> links, AnnotationSet nodeAnnot, AnnotationSet linkAnnot, BioFabricNetwork.Extents ext, boolean showShadows) {
        this.targetList_ = targets;
        this.linkList_ = links;
        this.ext_ = ext;
        this.nodeAnnot_ = nodeAnnot;
        this.linkAnnot_ = linkAnnot;
        this.showShadows_ = showShadows;
    }

    public void setModelDims(Dimension screenDim, Rectangle2D worldRect, ImgAndBufPool bis) {
        this.screenDim_ = screenDim;
        this.worldRect_.setRect(worldRect);
        this.bis_ = bis;
    }

    @Override
    public boolean drawForBuffer(BufferedImage bi, Rectangle2D clip, Dimension screenDim, Rectangle2D worldRec, int heightPad, double linksPerPixel) {
        int imgHeight = bi.getHeight();
        int imgWidth = bi.getWidth();
        Graphics2D g2 = bi.createGraphics();
        g2.setPaint(Color.WHITE);
        g2.fillRect(0, 0, imgWidth, imgHeight);
        if (this.nodeAnnot_ != null && this.nodeAnnot_.size() > 0) {
            BufferedImage bina = this.bis_.fetchImage(imgWidth, imgHeight, 2);
            this.drawNodeAnnotsForBuffer(bina, clip, screenDim, worldRec, heightPad, linksPerPixel);
            g2.drawImage((Image)bina, 0, 0, null);
            this.bis_.returnImage(bina);
        }
        if (this.linkAnnot_ != null && this.linkAnnot_.size() > 0) {
            BufferedImage binal = this.bis_.fetchImage(imgWidth, imgHeight, 2);
            this.drawLinkAnnotsForBuffer(binal, clip, screenDim, worldRec, heightPad, linksPerPixel);
            g2.drawImage((Image)binal, 0, 0, null);
            this.bis_.returnImage(binal);
        }
        BufferedImage bin = this.bis_.fetchImage(imgWidth, imgHeight, 2);
        this.drawNodesForBuffer(bin, clip, screenDim, worldRec, heightPad, linksPerPixel);
        g2.drawImage((Image)bin, 0, 0, null);
        BufferedImage bil = this.bis_.fetchImage(imgWidth, imgHeight, 2);
        this.drawLinksForBuffer(bil, clip, screenDim, worldRec, heightPad, linksPerPixel);
        g2.drawImage((Image)bil, 0, 0, null);
        g2.dispose();
        this.bis_.returnImage(bin);
        this.bis_.returnImage(bil);
        return true;
    }

    private boolean drawLinksForBuffer(BufferedImage bi, Rectangle2D clip, Dimension screenDim, Rectangle2D worldRec, int heightPad, double lpp) {
        BufAndMeta bam = new BufAndMeta(bi, clip, screenDim, worldRec, heightPad, lpp, this.bis_);
        int bufOffset = bam.ulInV.x * bam.scrnHeight + bam.ulInV.y;
        for (BioFabricNetwork.LinkInfo lif : this.linkList_) {
            bam.yStrt = lif.topRow() * 18;
            bam.yEnd = lif.bottomRow() * 18;
            bam.x = lif.getUseColumn(this.showShadows_) * 18;
            if (!bam.clipForLinks(clip)) continue;
            int bufStart = bam.startPtInV.x * bam.scrnHeight + bam.startPtInV.y - bufOffset;
            int bufEnd = bam.endPtInV.x * bam.scrnHeight + bam.endPtInV.y - bufOffset;
            bam.transToBuf(bufStart, bufEnd);
        }
        for (int i = 0; i < bam.bufLen; ++i) {
            int yval;
            int pix = bam.mybuf[i];
            int red = 0;
            int green = 0;
            int blue = 0;
            int alpha = 0;
            int xval = i / bam.scrnHeight;
            if (pix != 0) {
                double val = (double)pix / lpp;
                int index = xval % this.linkCycle_.length;
                red = this.linkCycle_[index].getRed();
                green = this.linkCycle_[index].getGreen();
                blue = this.linkCycle_[index].getBlue();
                alpha = Math.min(180, (int)Math.round(val * 180.0));
            }
            int rgb = alpha << 24 | red << 16 | green << 8 | blue;
            if (xval >= bam.imgWidth || (yval = i % bam.scrnHeight) >= bam.imgHeight) continue;
            bi.setRGB(xval, yval, rgb);
        }
        this.bis_.returnBuf(bam.mybuf);
        return true;
    }

    private boolean drawNodesForBuffer(BufferedImage bi, Rectangle2D clip, Dimension screenDim, Rectangle2D worldRec, int heightPad, double lpp) {
        BufAndMeta bam = new BufAndMeta(bi, clip, screenDim, worldRec, heightPad, lpp, this.bis_);
        int bufOffset = bam.ulInV.y * bam.scrnWidth + bam.ulInV.x;
        for (BioFabricNetwork.NodeInfo nif : this.targetList_) {
            MinMax colRange = nif.getColRange(this.showShadows_);
            bam.xStrt = colRange.min * 18;
            bam.xEnd = colRange.max * 18;
            bam.y = nif.nodeRow * 18;
            if (!bam.clipForNodes(clip)) continue;
            int bufStart = bam.startPtInV.y * bam.scrnWidth + bam.startPtInV.x - bufOffset;
            int bufEnd = bam.endPtInV.y * bam.scrnWidth + bam.endPtInV.x - bufOffset;
            bam.transToBuf(bufStart, bufEnd);
        }
        for (int i = 0; i < bam.bufLen; ++i) {
            int xval;
            int pix = bam.mybuf[i];
            int red = 0;
            int green = 0;
            int blue = 0;
            int alpha = 0;
            int yval = i / bam.scrnWidth;
            if (pix != 0) {
                double val = (double)pix / lpp;
                int index = yval % this.nodeCycle_.length;
                red = this.nodeCycle_[index].getRed();
                green = this.nodeCycle_[index].getGreen();
                blue = this.nodeCycle_[index].getBlue();
                alpha = Math.min(180, (int)Math.round(val * 180.0));
            }
            int rgb = alpha << 24 | red << 16 | green << 8 | blue;
            if (yval >= bam.imgHeight || (xval = i % bam.scrnWidth) >= bam.imgWidth) continue;
            bi.setRGB(xval, yval, rgb);
        }
        this.bis_.returnBuf(bam.mybuf);
        return true;
    }

    private boolean drawNodeAnnotsForBuffer(BufferedImage bi, Rectangle2D clip, Dimension screenDim, Rectangle2D worldRec, int heightPad, double lpp) {
        BufAndMeta bam = new BufAndMeta(bi, clip, screenDim, worldRec, heightPad, lpp, this.bis_);
        int bufOffset = bam.ulInV.y * bam.scrnWidth + bam.ulInV.x;
        MinMax linkCols = this.ext_.allLinkFullRange.get(this.showShadows_);
        int pad = PaintCacheSmall.calcAnnotationPad(linkCols);
        int colNum = 0;
        for (Annot annot : this.nodeAnnot_) {
            MinMax rowRange = annot.getRange();
            for (int i = rowRange.min; i <= rowRange.max; ++i) {
                bam.xStrt = linkCols.min * 18;
                bam.xEnd = linkCols.max * 18;
                bam.y = i * 18;
                if (!bam.clipForNodes(clip)) continue;
                int bufStart = bam.startPtInV.y * bam.scrnWidth + bam.startPtInV.x - bufOffset;
                int bufEnd = bam.endPtInV.y * bam.scrnWidth + bam.endPtInV.x - bufOffset;
                AnnotColorSource.AnnotColor acol = annot.getColor();
                int useColorNum = acol == null ? colNum : acol.getCycle();
                bam.transColorToBuf(bufStart, bufEnd, useColorNum);
            }
            colNum = (colNum + 1) % this.annotColors_.length;
        }
        for (int i = 0; i < bam.bufLen; ++i) {
            int xval;
            int val = bam.mybuf[i];
            if (val == -1 || val == 0) continue;
            Color col = this.annotColors_[val - 1].getColor();
            int red = col.getRed();
            int green = col.getGreen();
            int blue = col.getBlue();
            int rgb = 0xFF000000 | red << 16 | green << 8 | blue;
            int yval = i / bam.scrnWidth;
            if (yval >= bam.imgHeight || (xval = i % bam.scrnWidth) >= bam.imgWidth) continue;
            bi.setRGB(xval, yval, rgb);
        }
        this.bis_.returnBuf(bam.mybuf);
        return true;
    }

    private boolean drawLinkAnnotsForBuffer(BufferedImage bi, Rectangle2D clip, Dimension screenDim, Rectangle2D worldRec, int heightPad, double lpp) {
        Color[] useColors;
        BufAndMeta bam = new BufAndMeta(bi, clip, screenDim, worldRec, heightPad, lpp, this.bis_);
        int bufOffset = bam.ulInV.y * bam.scrnWidth + bam.ulInV.x;
        MinMax nodeRows = this.ext_.allNodeFullRange.get(this.showShadows_);
        int pad = PaintCacheSmall.calcAnnotationPad(nodeRows);
        if (this.nodeAnnot_ != null && this.nodeAnnot_.size() > 0) {
            useColors = this.linkAnnotGrays_;
        } else {
            useColors = new Color[this.annotColors_.length];
            for (int i = 0; i < this.annotColors_.length; ++i) {
                useColors[i] = this.annotColors_[i].getColor();
            }
        }
        int colNum = 0;
        for (Annot annot : this.linkAnnot_) {
            MinMax colRange = annot.getRange();
            for (int i = nodeRows.min; i <= nodeRows.max; ++i) {
                bam.xStrt = colRange.min * 18;
                bam.xEnd = colRange.max * 18;
                bam.y = i * 18;
                if (!bam.clipForNodes(clip)) continue;
                int bufStart = bam.startPtInV.y * bam.scrnWidth + bam.startPtInV.x - bufOffset;
                int bufEnd = bam.endPtInV.y * bam.scrnWidth + bam.endPtInV.x - bufOffset;
                AnnotColorSource.AnnotColor acol = annot.getColor();
                int useColorNum = acol == null ? colNum : acol.getCycle();
                bam.transColorToBuf(bufStart, bufEnd, useColorNum);
            }
            colNum = (colNum + 1) % useColors.length;
        }
        for (int i = 0; i < bam.bufLen; ++i) {
            int xval;
            int val = bam.mybuf[i];
            if (val == -1 || val == 0) continue;
            int red = useColors[val - 1].getRed();
            int green = useColors[val - 1].getGreen();
            int blue = useColors[val - 1].getBlue();
            int alpha = useColors[val - 1].getAlpha();
            int rgb = alpha << 24 | red << 16 | green << 8 | blue;
            int yval = i / bam.scrnWidth;
            if (yval >= bam.imgHeight || (xval = i % bam.scrnWidth) >= bam.imgWidth) continue;
            bi.setRGB(xval, yval, rgb);
        }
        this.bis_.returnBuf(bam.mybuf);
        return true;
    }

    private static class BufAndMeta {
        int imgHeight;
        int imgWidth;
        double zoomH;
        double zoomV;
        double zoom;
        AffineTransform transform;
        int scrnHeight;
        int scrnWidth;
        int bufLen;
        Point2D newPoint;
        int[] mybuf;
        Point pts;
        Point pte;
        Point startPoint;
        Point endPoint;
        Point ulInV;
        Point startPtInV;
        Point endPtInV;
        double yStrt;
        double yEnd;
        double x;
        double xStrt;
        double xEnd;
        double y;

        BufAndMeta(BufferedImage bi, Rectangle2D clip, Dimension screenDim, Rectangle2D worldRec, int heightPad, double lpp, ImgAndBufPool bis) {
            this.imgHeight = bi.getHeight();
            this.imgWidth = bi.getWidth();
            this.zoomH = screenDim.getWidth() / worldRec.getWidth();
            this.zoomV = screenDim.getHeight() / worldRec.getHeight();
            this.zoom = Math.max(this.zoomH, this.zoomV);
            Point2D.Double centerW = new Point2D.Double(worldRec.getX() + worldRec.getWidth() / 2.0, worldRec.getY() + worldRec.getHeight() / 2.0);
            this.transform = new AffineTransform();
            this.transform.translate(screenDim.getWidth() / 2.0, screenDim.getHeight() / 2.0);
            this.transform.scale(this.zoom, this.zoom);
            this.transform.translate(-((Point2D)centerW).getX(), -((Point2D)centerW).getY());
            this.scrnHeight = screenDim.height;
            this.scrnWidth = screenDim.width;
            this.bufLen = this.scrnHeight * this.scrnWidth;
            this.newPoint = new Point2D.Double();
            this.mybuf = bis.fetchBuf(this.bufLen);
            this.pts = new Point();
            this.pte = new Point();
            this.startPoint = new Point();
            this.endPoint = new Point();
            this.startPoint.setLocation(worldRec.getX(), worldRec.getY());
            this.ulInV = BasicZoomTargetSupport.pointToViewport(this.startPoint, this.transform, this.newPoint, this.pts);
        }

        boolean clipForLinks(Rectangle2D clip) {
            if (this.x < clip.getX() || this.x > clip.getX() + clip.getWidth()) {
                return false;
            }
            if (this.yStrt < clip.getY()) {
                this.yStrt = clip.getY();
            }
            if (this.yStrt > clip.getY() + clip.getHeight()) {
                this.yStrt = clip.getY() + clip.getHeight();
            }
            if (this.yEnd < clip.getY()) {
                this.yEnd = clip.getY();
            }
            if (this.yEnd > clip.getY() + clip.getHeight()) {
                this.yEnd = clip.getY() + clip.getHeight();
            }
            this.startPoint.setLocation(this.x, this.yStrt);
            this.endPoint.setLocation(this.x, this.yEnd);
            this.startPtInV = BasicZoomTargetSupport.pointToViewport(this.startPoint, this.transform, this.newPoint, this.pts);
            this.endPtInV = BasicZoomTargetSupport.pointToViewport(this.endPoint, this.transform, this.newPoint, this.pte);
            return true;
        }

        boolean clipForNodes(Rectangle2D clip) {
            if (this.y < clip.getY() || this.y > clip.getY() + clip.getHeight()) {
                return false;
            }
            if (this.xStrt < clip.getX()) {
                this.xStrt = clip.getX();
            }
            if (this.xStrt > clip.getX() + clip.getWidth()) {
                this.xStrt = clip.getX() + clip.getWidth();
            }
            if (this.xEnd < clip.getX()) {
                this.xEnd = clip.getX();
            }
            if (this.xEnd > clip.getX() + clip.getWidth()) {
                this.xEnd = clip.getX() + clip.getWidth();
            }
            this.startPoint.setLocation(this.xStrt, this.y);
            this.endPoint.setLocation(this.xEnd, this.y);
            this.startPtInV = BasicZoomTargetSupport.pointToViewport(this.startPoint, this.transform, this.newPoint, this.pts);
            this.endPtInV = BasicZoomTargetSupport.pointToViewport(this.endPoint, this.transform, this.newPoint, this.pte);
            return true;
        }

        void transToBuf(int bufStart, int bufEnd) {
            for (int i = bufStart; i < bufEnd; ++i) {
                int off = i;
                if (off < 0 || off >= this.mybuf.length) continue;
                int n = off;
                this.mybuf[n] = this.mybuf[n] + 1;
            }
        }

        void transColorToBuf(int bufStart, int bufEnd, int color) {
            for (int i = bufStart; i < bufEnd; ++i) {
                int off = i;
                if (off < 0 || off >= this.mybuf.length) continue;
                int currCol = this.mybuf[off];
                int slotCol = color + 1;
                this.mybuf[off] = currCol == 0 || currCol == slotCol ? slotCol : -1;
            }
        }
    }
}

