/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.render;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Rectangle;

public class BoxPath {
    private Color col;
    private Rectangle nodeShadeRect;
    private Rectangle scratchRect;

    public BoxPath(Color col, Rectangle rect) {
        this.col = col;
        this.nodeShadeRect = rect;
        this.scratchRect = new Rectangle();
    }

    public int paint(Graphics2D g2, Rectangle bounds) {
        g2.setPaint(this.col);
        if (bounds == null || bounds.contains(this.nodeShadeRect)) {
            this.scratchRect.setRect(this.nodeShadeRect);
        } else {
            if (!bounds.intersects(this.nodeShadeRect)) {
                return 0;
            }
            double xMinN = this.nodeShadeRect.getMinX();
            double xMaxN = this.nodeShadeRect.getMaxX();
            double yMinN = this.nodeShadeRect.getMinY();
            double yMaxN = this.nodeShadeRect.getMaxY();
            double xMinB = bounds.getMinX();
            double xMaxB = bounds.getMaxX();
            double yMinB = bounds.getMinY();
            double yMaxB = bounds.getMaxY();
            double xMinUse = xMinN < xMinB ? xMinB - 1000.0 : xMinN;
            double xMaxUse = xMaxN > xMaxB ? xMaxB + 1000.0 : xMaxN;
            double yMinUse = yMinN < yMinB ? yMinB - 1000.0 : yMinN;
            double yMaxUse = yMaxN > yMaxB ? yMaxB + 1000.0 : yMaxN;
            this.scratchRect.setRect(xMinUse, yMinUse, xMaxUse - xMinUse, yMaxUse - yMinUse);
        }
        g2.fill(this.scratchRect);
        return 1;
    }
}

