/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.display;

import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import javax.imageio.ImageIO;
import javax.imageio.ImageReader;
import javax.imageio.stream.ImageInputStream;
import javax.swing.JPanel;

public class MouseOverViewPanel
extends JPanel {
    private Dimension currSize_;
    private HashMap<String, BufferedImage> imgs_;
    private BufferedImage img_;
    private BufferedImage scaledImg_;
    private Point scaledImgOrigin_;
    private CardLayout myCard_;
    private ImagePanel pPan_;
    private String path_;
    private String filePrefix_;
    private String fileSuffix_;
    private static final long serialVersionUID = 1L;

    public MouseOverViewPanel() {
        this.setBackground(Color.white);
        this.imgs_ = new HashMap();
        this.scaledImg_ = null;
        this.scaledImgOrigin_ = new Point(0, 0);
        this.img_ = null;
        this.myCard_ = new CardLayout();
        this.setLayout(this.myCard_);
        this.pPan_ = new ImagePanel();
        this.add((Component)this.pPan_, "theView");
        JPanel blankPanel = new JPanel();
        blankPanel.setBackground(Color.white);
        this.add((Component)blankPanel, "Hiding");
    }

    public Dimension getPreferredSize() {
        return new Dimension(800, 100);
    }

    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    public Dimension getMaximumSize() {
        return new Dimension(4000, 340);
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.currSize_ = new Dimension(width, height);
        this.resizeImage();
        this.repaint();
    }

    public void setFileLocations(String path, String filePrefix, String fileSuffix) {
        this.path_ = path;
        this.filePrefix_ = filePrefix;
        this.fileSuffix_ = fileSuffix;
    }

    public void showView(boolean enabled) {
        this.myCard_.show(this, enabled ? "theView" : "Hiding");
    }

    public void showForNode(String nodeName) {
        if (nodeName == null) {
            this.installImage(null);
            return;
        }
        BufferedImage bi = this.imgs_.get(nodeName);
        if (bi != null) {
            this.installImage(bi);
        } else {
            try {
                this.loadAFile(nodeName);
            }
            catch (IOException ioex) {
                System.err.println("Handle file load failures: " + ioex.getLocalizedMessage());
            }
        }
    }

    private void loadAFile(String nodeName) throws IOException {
        File forFoo = new File(this.path_ + this.filePrefix_ + nodeName + this.fileSuffix_);
        BufferedImage mvi = this.readImageFromFile(forFoo);
        this.imgs_.put(nodeName, mvi);
        this.installImage(mvi);
    }

    private void installImage(BufferedImage img) {
        this.img_ = img;
        this.scaledImg_ = null;
        this.resizeImage();
        this.repaint();
    }

    private void resizeImage() {
        int startY;
        int startX;
        int imgHeight;
        int imgWidth;
        if (this.img_ == null) {
            return;
        }
        if (this.currSize_ == null) {
            this.currSize_ = this.getSize();
        }
        if (this.currSize_.width <= 0 || this.currSize_.height <= 0) {
            return;
        }
        double imgAR = (double)this.img_.getWidth() / (double)this.img_.getHeight();
        double panelAR = this.currSize_.getWidth() / this.currSize_.getHeight();
        if (panelAR < imgAR) {
            imgWidth = this.currSize_.width;
            imgHeight = (int)((double)imgWidth / imgAR);
            if (imgHeight == 0) {
                imgHeight = 1;
            }
            startX = 0;
            startY = (this.currSize_.height - imgHeight) / 2;
        } else {
            imgHeight = this.currSize_.height;
            imgWidth = (int)((double)imgHeight * imgAR);
            if (imgWidth == 0) {
                imgWidth = 1;
            }
            startX = (this.currSize_.width - imgWidth) / 2;
            startY = 0;
        }
        this.scaledImgOrigin_.setLocation(startX, startY);
        this.scaledImg_ = new BufferedImage(imgWidth, imgHeight, 1);
        Graphics2D g2 = this.scaledImg_.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.drawImage(this.img_, 0, 0, imgWidth, imgHeight, null);
        g2.dispose();
    }

    public BufferedImage readImageFromFile(File readFile) throws IOException {
        FileInputStream fis = new FileInputStream(readFile);
        ImageInputStream iis = ImageIO.createImageInputStream(fis);
        Iterator<ImageReader> readers = ImageIO.getImageReaders(iis);
        if (!readers.hasNext()) {
            throw new IOException();
        }
        ImageReader reader = readers.next();
        BufferedImage retval = ImageIO.read(iis);
        return retval;
    }

    private class ImagePanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public ImagePanel() {
            this.setBackground(Color.white);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            if (MouseOverViewPanel.this.img_ == null) {
                return;
            }
            if (MouseOverViewPanel.this.scaledImg_ == null) {
                MouseOverViewPanel.this.resizeImage();
            }
            g2.drawImage((Image)MouseOverViewPanel.this.scaledImg_, ((MouseOverViewPanel)MouseOverViewPanel.this).scaledImgOrigin_.x, ((MouseOverViewPanel)MouseOverViewPanel.this).scaledImgOrigin_.y, null);
        }
    }
}

