/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.display;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import javax.swing.JPanel;

public class InfoPanel
extends JPanel {
    private static final long serialVersionUID = 1L;
    private Font myFont_;
    private boolean twoLines_;
    private String text1_;
    private String text2_;
    private int minHeight_;
    private int minWidth_;
    private boolean centered_;
    private boolean pad_;

    public InfoPanel(boolean twoLines, int minHeight, int minWidth, boolean centered, boolean pad) {
        this.setBackground(new Color(255, 255, 255));
        this.myFont_ = new Font("SansSerif", 1, 12);
        this.twoLines_ = twoLines;
        this.text1_ = "";
        if (this.twoLines_) {
            this.text2_ = "";
        }
        this.minHeight_ = minHeight;
        this.minWidth_ = minWidth;
        this.centered_ = centered;
        this.pad_ = pad;
    }

    public void clear() {
        this.text1_ = "";
        if (this.twoLines_) {
            this.text2_ = "";
        }
    }

    public void installName(String text1) {
        if (this.twoLines_) {
            throw new IllegalStateException();
        }
        this.text1_ = text1;
    }

    public void installNames(String text1, String text2) {
        if (!this.twoLines_) {
            throw new IllegalStateException();
        }
        this.text1_ = text1;
        this.text2_ = text2;
    }

    public Dimension getPreferredSize() {
        return new Dimension(200, this.minHeight_);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.minWidth_, this.minHeight_);
    }

    public Dimension getMaximumSize() {
        return new Dimension(4000, 200);
    }

    public void paintComponent(Graphics g) {
        float textY1;
        float textX1;
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        AffineTransform saveTrans = g2.getTransform();
        g2.setFont(this.myFont_);
        g2.setPaint(Color.BLACK);
        FontRenderContext frc = g2.getFontRenderContext();
        double maxFactor = 0.0;
        Rectangle2D boundsL = null;
        Rectangle2D boundsN = this.myFont_.getStringBounds(this.text1_, frc);
        if (this.pad_) {
            boundsN.setRect(boundsN.getX(), boundsN.getY(), boundsN.getWidth() + 16.0, boundsN.getHeight());
        }
        double reduceN = boundsN.getWidth() / (double)this.getWidth();
        if (this.twoLines_) {
            boundsL = this.myFont_.getStringBounds(this.text2_, frc);
            if (this.pad_) {
                boundsL.setRect(boundsL.getX(), boundsL.getY(), boundsL.getWidth() + 16.0, boundsL.getHeight());
            }
            double reduceL = boundsL.getWidth() / (double)this.getWidth();
            maxFactor = Math.max(reduceN, reduceL);
        } else {
            maxFactor = reduceN;
        }
        float useFactor = 1.0f;
        if (maxFactor > 1.0) {
            double rmf = 1.0 / maxFactor;
            useFactor = (float)maxFactor;
            g2.translate((double)this.getWidth() / 2.0, (double)this.getHeight() / 2.0);
            g2.scale(rmf, rmf);
            g2.translate((double)(-this.getWidth()) / 2.0, (double)(-this.getHeight()) / 2.0);
        }
        float textX2 = 0.0f;
        float textY2 = 0.0f;
        if (this.centered_) {
            textX1 = (float)this.getWidth() / 2.0f - (float)boundsN.getWidth() / 2.0f;
            float f = textY1 = this.twoLines_ ? (float)this.getHeight() / 2.0f - useFactor * (float)this.getHeight() / 6.0f + (float)boundsN.getHeight() / 3.0f : (float)this.getHeight() - useFactor * (float)this.getHeight() / 6.0f + (float)boundsN.getHeight() / 3.0f;
            if (this.twoLines_) {
                textX2 = (float)this.getWidth() / 2.0f - (float)boundsL.getWidth() / 2.0f;
                textY2 = (float)this.getHeight() / 2.0f + useFactor * (float)this.getHeight() / 6.0f + (float)boundsL.getHeight() / 3.0f;
            }
        } else {
            textX1 = (float)this.getWidth() / 2.0f - useFactor * (float)this.getWidth() / 2.0f;
            float f = textY1 = this.twoLines_ ? (float)this.getHeight() / 2.0f - useFactor * (float)this.getHeight() / 6.0f + (float)boundsN.getHeight() / 3.0f : (float)this.getHeight() / 2.0f + (float)boundsN.getHeight() / 5.0f;
            if (this.twoLines_) {
                textX2 = (float)this.getWidth() / 2.0f - useFactor * (float)this.getWidth() / 2.0f;
                textY2 = (float)this.getHeight() / 2.0f + useFactor * (float)this.getHeight() / 6.0f + (float)boundsL.getHeight() / 3.0f;
            }
        }
        g2.drawString(this.text1_, textX1, textY1);
        if (this.twoLines_) {
            g2.drawString(this.text2_, textX2, textY2);
        }
        g2.setTransform(saveTrans);
    }
}

