/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.display;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.MessageFormat;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.ui.display.BioFabricPanel;
import org.systemsbiology.biofabric.ui.display.InfoPanel;
import org.systemsbiology.biofabric.util.ResourceManager;

public class FabricNavTool
extends JPanel {
    private static final int BIG_ = 0;
    private static final int SMALL_ = 1;
    private static final int NUM_PAN_ = 2;
    private BioFabricPanel bfp_;
    private FixedJButton[] startAtCurrent_;
    private FixedJButton[] chooseAStart_;
    private InfoPanel[] infoPanel_;
    private FixedJButton[] buttonUp_;
    private FixedJButton[] buttonRight_;
    private FixedJButton[] buttonFarRight_;
    private FixedJButton[] buttonLeft_;
    private FixedJButton[] buttonFarLeft_;
    private FixedJButton[] buttonDown_;
    private FixedJButton[] buttonZoom_;
    private FixedJButton[] buttonLinkZone_;
    private FixedJButton[] buttonClear_;
    private JCheckBox[] selectedOnly_;
    private BioFabricPanel.TourStatus currTstat_;
    private boolean haveSelection_;
    private boolean haveAModel_;
    private boolean controlsEnabled_;
    private JFrame topWindow_;
    private boolean doSOReset_;
    private int currPan_;
    private CardLayout clay_;
    private JPanel bigPan_;
    private JPanel smallPan_;
    private boolean neverSet_;
    private static final long serialVersionUID = 1L;

    public FabricNavTool(JFrame topWindow) {
        this.setBackground(Color.WHITE);
        this.buildButtons();
        this.controlsEnabled_ = true;
        this.topWindow_ = topWindow;
        this.doSOReset_ = false;
        this.neverSet_ = true;
        this.clay_ = new CardLayout();
        this.setLayout(this.clay_);
        this.currPan_ = 0;
        this.haveAModel_ = false;
        this.haveSelection_ = false;
        this.smallPan_ = this.fillPanel(1);
        this.add((Component)this.smallPan_, "small");
        this.bigPan_ = this.fillPanel(0);
        this.add((Component)this.bigPan_, "big");
        this.clay_.show(this, "big");
        this.clearTour();
    }

    public Dimension getPreferredSize() {
        return this.bigPan_.getPreferredSize();
    }

    public Dimension getMinimumSize() {
        if (this.neverSet_) {
            return this.bigPan_.getMinimumSize();
        }
        return this.smallPan_.getMinimumSize();
    }

    public Dimension getMaximumSize() {
        return this.bigPan_.getMaximumSize();
    }

    public void setBounds(int x, int y, int width, int height) {
        this.neverSet_ = false;
        Dimension minBig = this.bigPan_.getMinimumSize();
        if (this.currPan_ == 0 && (minBig.height > height || minBig.width > width)) {
            this.currPan_ = 1;
            this.clay_.show(this, "small");
        } else if (this.currPan_ == 1 && minBig.height < height && minBig.width < width) {
            this.currPan_ = 0;
            this.clay_.show(this, "big");
        }
        super.setBounds(x, y, width, height);
        this.repaint();
    }

    public void resetSkipSelections() {
        for (int i = 0; i < 2; ++i) {
            this.selectedOnly_[i].setSelected(false);
        }
    }

    public void enableControls(boolean enabled) {
        this.controlsEnabled_ = enabled;
        if (!enabled) {
            this.disableControls();
        } else {
            this.syncToState();
        }
    }

    public void haveAModel(boolean haveIt) {
        this.haveAModel_ = haveIt;
        for (int i = 0; i < 2; ++i) {
            this.chooseAStart_[i].setEnabled(this.controlsEnabled_ && this.haveAModel_);
            this.infoPanel_[i].clear();
        }
        if (!this.haveAModel_) {
            this.currTstat_ = null;
            this.disableControls();
        }
        this.repaint();
    }

    public void haveASelection(boolean haveIt) {
        for (int i = 0; i < 2; ++i) {
            this.startAtCurrent_[i].setEnabled(haveIt);
            this.selectedOnly_[i].setEnabled(haveIt);
        }
        if (this.currTstat_ != null) {
            this.currTstat_.currStopUnselected = this.bfp_.tourStopNowUnselected();
        }
        this.haveSelection_ = haveIt;
        this.repaint();
    }

    private void clearTour() {
        for (int i = 0; i < 2; ++i) {
            this.infoPanel_[i].clear();
        }
        this.revalidate();
        this.disableControls();
    }

    private boolean calcSelectedOnly() {
        return this.selectedOnly_[this.currPan_].isEnabled() && this.selectedOnly_[this.currPan_].isSelected();
    }

    public void setFabricPanel(BioFabricPanel bfp) {
        this.bfp_ = bfp;
    }

    public void installNames(BioFabricPanel.TourStatus tstat) {
        if (tstat == null) {
            return;
        }
        this.currTstat_ = tstat.clone();
        this.syncToState();
    }

    private void disableControls() {
        for (int i = 0; i < 2; ++i) {
            this.buttonUp_[i].setEnabled(false);
            this.buttonRight_[i].setEnabled(false);
            this.buttonFarRight_[i].setEnabled(false);
            this.buttonLeft_[i].setEnabled(false);
            this.buttonFarLeft_[i].setEnabled(false);
            this.buttonDown_[i].setEnabled(false);
            this.buttonClear_[i].setEnabled(false);
            this.buttonZoom_[i].setEnabled(false);
            this.buttonLinkZone_[i].setEnabled(false);
            this.infoPanel_[i].setEnabled(false);
            this.selectedOnly_[i].setEnabled(false);
        }
        this.repaint();
    }

    private void syncToState() {
        for (int i = 0; i < 2; ++i) {
            this.chooseAStart_[i].setEnabled(this.haveAModel_);
        }
        if (this.currTstat_ == null) {
            this.disableControls();
            return;
        }
        ResourceManager rMan = ResourceManager.getManager();
        for (int i = 0; i < 2; ++i) {
            this.buttonZoom_[i].setEnabled(true);
            this.buttonLinkZone_[i].setEnabled(true);
            this.buttonClear_[i].setEnabled(true);
            this.infoPanel_[i].setEnabled(true);
            String nodeName = MessageFormat.format(rMan.getString("navTool.currNode"), this.currTstat_.nodeName);
            String linkName = MessageFormat.format(rMan.getString("navTool.currLink"), this.currTstat_.linkName);
            this.infoPanel_[i].installNames(nodeName, linkName);
            this.buttonUp_[i].setEnabled(this.currTstat_.upEnabled);
            this.buttonRight_[i].setEnabled(this.currTstat_.rightEnabled);
            this.buttonFarRight_[i].setEnabled(this.currTstat_.farRightEnabled);
            this.buttonLeft_[i].setEnabled(this.currTstat_.leftEnabled);
            this.buttonFarLeft_[i].setEnabled(this.currTstat_.farLeftEnabled);
            this.buttonDown_[i].setEnabled(this.currTstat_.downEnabled);
            this.selectedOnly_[i].setEnabled(this.haveSelection_);
            this.startAtCurrent_[i].setEnabled(this.haveSelection_);
        }
        this.revalidate();
        this.repaint();
    }

    private void buildButtons() {
        this.infoPanel_ = new InfoPanel[2];
        this.startAtCurrent_ = new FixedJButton[2];
        this.chooseAStart_ = new FixedJButton[2];
        this.buttonUp_ = new FixedJButton[2];
        this.buttonRight_ = new FixedJButton[2];
        this.buttonFarRight_ = new FixedJButton[2];
        this.buttonLeft_ = new FixedJButton[2];
        this.buttonFarLeft_ = new FixedJButton[2];
        this.buttonDown_ = new FixedJButton[2];
        this.buttonZoom_ = new FixedJButton[2];
        this.buttonLinkZone_ = new FixedJButton[2];
        this.buttonClear_ = new FixedJButton[2];
        this.selectedOnly_ = new JCheckBox[2];
    }

    private FixedJButton buildZeButton(int i, String label) {
        if (i == 1) {
            return FixedJButton.miniFactory(label, 12);
        }
        return new FixedJButton(label);
    }

    private JPanel fillPanel(int i) {
        JPanel retval = new JPanel();
        retval.setBackground(Color.WHITE);
        ResourceManager rMan = ResourceManager.getManager();
        retval.setLayout(new GridLayout(1, 1));
        String zeLabel = rMan.getString("navTool.startAtCurrent");
        this.startAtCurrent_[i] = this.buildZeButton(i, zeLabel);
        this.startAtCurrent_[i].setToolTipText(zeLabel);
        this.startAtCurrent_[i].addActionListener(new StartFromSel());
        this.startAtCurrent_[i].setEnabled(false);
        zeLabel = rMan.getString("navTool.chooseAStart");
        this.chooseAStart_[i] = this.buildZeButton(i, zeLabel);
        this.chooseAStart_[i].setToolTipText(zeLabel);
        this.chooseAStart_[i].addActionListener(new ChooseAStart());
        this.chooseAStart_[i].setEnabled(false);
        zeLabel = rMan.getString("navTool.up");
        this.buttonUp_[i] = this.buildZeButton(i, zeLabel);
        this.buttonUp_[i].setToolTipText(zeLabel);
        this.buttonUp_[i].addActionListener(new GoUp());
        zeLabel = rMan.getString("navTool.right");
        this.buttonRight_[i] = this.buildZeButton(i, zeLabel);
        this.buttonRight_[i].setToolTipText(zeLabel);
        this.buttonRight_[i].addActionListener(new GoRight());
        zeLabel = ">>";
        this.buttonFarRight_[i] = this.buildZeButton(i, ">>");
        this.buttonFarRight_[i].setToolTipText(zeLabel);
        this.buttonFarRight_[i].addActionListener(new GoFarRight());
        zeLabel = rMan.getString("navTool.left");
        this.buttonLeft_[i] = this.buildZeButton(i, zeLabel);
        this.buttonLeft_[i].setToolTipText(zeLabel);
        this.buttonLeft_[i].addActionListener(new GoLeft());
        zeLabel = "<<";
        this.buttonFarLeft_[i] = this.buildZeButton(i, "<<");
        this.buttonFarLeft_[i].setToolTipText(zeLabel);
        this.buttonFarLeft_[i].addActionListener(new GoFarLeft());
        zeLabel = rMan.getString("navTool.down");
        this.buttonDown_[i] = this.buildZeButton(i, zeLabel);
        this.buttonDown_[i].setToolTipText(zeLabel);
        this.buttonDown_[i].addActionListener(new GoDown());
        zeLabel = rMan.getString("navTool.clear");
        this.buttonClear_[i] = this.buildZeButton(i, zeLabel);
        this.buttonClear_[i].setToolTipText(zeLabel);
        this.buttonClear_[i].addActionListener(new ClearTour());
        zeLabel = rMan.getString("navTool.zoom");
        this.buttonZoom_[i] = this.buildZeButton(i, zeLabel);
        this.buttonZoom_[i].setToolTipText(zeLabel);
        this.buttonZoom_[i].addActionListener(new Zoom());
        zeLabel = rMan.getString("navTool.dropZone");
        this.buttonLinkZone_[i] = this.buildZeButton(i, zeLabel);
        this.buttonLinkZone_[i].setToolTipText(zeLabel);
        this.buttonLinkZone_[i].addActionListener(new ToDrain());
        this.selectedOnly_[i] = new JCheckBox(rMan.getString("navTool.skip"));
        this.selectedOnly_[i].setOpaque(true);
        this.selectedOnly_[i].setBackground(Color.white);
        this.selectedOnly_[i].addActionListener(new SelOnly());
        this.selectedOnly_[i].setEnabled(false);
        Box cbuttonPanel = Box.createHorizontalBox();
        cbuttonPanel.add(Box.createHorizontalGlue());
        cbuttonPanel.add(this.startAtCurrent_[i]);
        cbuttonPanel.add(Box.createHorizontalStrut(5));
        cbuttonPanel.add(this.chooseAStart_[i]);
        cbuttonPanel.add(Box.createHorizontalGlue());
        Box infoPanel = Box.createHorizontalBox();
        infoPanel.add(Box.createHorizontalStrut(5));
        this.infoPanel_[i] = new InfoPanel(true, 50, 100, true, false);
        infoPanel.add(this.infoPanel_[i]);
        infoPanel.add(Box.createHorizontalStrut(5));
        Box dbuttonPanel = Box.createHorizontalBox();
        dbuttonPanel.add(Box.createHorizontalGlue());
        dbuttonPanel.add(this.buttonUp_[i]);
        dbuttonPanel.add(Box.createHorizontalGlue());
        Box ebuttonPanel = Box.createHorizontalBox();
        ebuttonPanel.add(Box.createHorizontalGlue());
        ebuttonPanel.add(this.buttonFarLeft_[i]);
        ebuttonPanel.add(Box.createHorizontalStrut(5));
        ebuttonPanel.add(this.buttonLeft_[i]);
        ebuttonPanel.add(Box.createHorizontalStrut(5));
        ebuttonPanel.add(this.buttonRight_[i]);
        ebuttonPanel.add(Box.createHorizontalStrut(5));
        ebuttonPanel.add(this.buttonFarRight_[i]);
        ebuttonPanel.add(Box.createHorizontalGlue());
        Box fbuttonPanel = Box.createHorizontalBox();
        fbuttonPanel.add(Box.createHorizontalGlue());
        fbuttonPanel.add(this.buttonDown_[i]);
        fbuttonPanel.add(Box.createHorizontalGlue());
        Box hbuttonPanel = Box.createHorizontalBox();
        hbuttonPanel.add(Box.createHorizontalGlue());
        hbuttonPanel.add(this.buttonClear_[i]);
        hbuttonPanel.add(Box.createHorizontalStrut(5));
        hbuttonPanel.add(this.buttonZoom_[i]);
        hbuttonPanel.add(Box.createHorizontalStrut(5));
        hbuttonPanel.add(this.buttonLinkZone_[i]);
        hbuttonPanel.add(Box.createHorizontalGlue());
        Box ibuttonPanel = Box.createHorizontalBox();
        ibuttonPanel.add(Box.createHorizontalGlue());
        ibuttonPanel.add(this.selectedOnly_[i]);
        ibuttonPanel.add(Box.createHorizontalGlue());
        Box gbuttonPanel = Box.createVerticalBox();
        gbuttonPanel.add(Box.createVerticalGlue());
        gbuttonPanel.add(cbuttonPanel);
        gbuttonPanel.add(Box.createVerticalGlue());
        gbuttonPanel.add(infoPanel);
        gbuttonPanel.add(Box.createVerticalGlue());
        gbuttonPanel.add(dbuttonPanel);
        gbuttonPanel.add(Box.createVerticalGlue());
        gbuttonPanel.add(dbuttonPanel);
        gbuttonPanel.add(Box.createVerticalGlue());
        gbuttonPanel.add(ebuttonPanel);
        gbuttonPanel.add(Box.createVerticalGlue());
        gbuttonPanel.add(fbuttonPanel);
        gbuttonPanel.add(Box.createVerticalGlue());
        gbuttonPanel.add(hbuttonPanel);
        gbuttonPanel.add(Box.createVerticalGlue());
        gbuttonPanel.add(ibuttonPanel);
        gbuttonPanel.add(Box.createVerticalGlue());
        retval.add(gbuttonPanel);
        return retval;
    }

    public static class LabeledFabricNavTool
    extends JPanel {
        private FabricNavTool fnt_;
        private JPanel livePan_;
        private CardLayout clay_;
        private boolean collapsed_;
        private static final long serialVersionUID = 1L;

        public LabeledFabricNavTool(JFrame topWindow, Font labelFont) {
            this.fnt_ = new FabricNavTool(topWindow);
            this.livePan_ = new JPanel();
            this.livePan_.setLayout(new BorderLayout());
            this.livePan_.setBorder(new LineBorder(Color.black, 2));
            JLabel navLab = new JLabel(ResourceManager.getManager().getString("biofabric.tour"));
            navLab.setBorder(new EmptyBorder(0, 5, 0, 0));
            navLab.setOpaque(true);
            navLab.setBackground(Color.white);
            navLab.setFont(labelFont);
            this.livePan_.add((Component)navLab, "North");
            this.livePan_.add((Component)this.fnt_, "Center");
            this.clay_ = new CardLayout();
            this.setLayout(this.clay_);
            this.add((Component)this.livePan_, "live");
            this.add((Component)new JPanel(), "blank");
            this.clay_.show(this, "live");
            this.collapsed_ = false;
        }

        public FabricNavTool getFabricNavTool() {
            return this.fnt_;
        }

        public void setToBlank(boolean val) {
            this.clay_.show(this, val ? "blank" : "live");
            this.collapsed_ = val;
        }

        public Dimension getPreferredSize() {
            if (this.collapsed_) {
                return new Dimension(0, 0);
            }
            return this.livePan_.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            if (this.collapsed_) {
                return new Dimension(0, 0);
            }
            return this.livePan_.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            if (this.collapsed_) {
                return new Dimension(0, 0);
            }
            return this.livePan_.getMaximumSize();
        }
    }

    public class SelOnly
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            try {
                if (FabricNavTool.this.doSOReset_) {
                    return;
                }
                if (FabricNavTool.this.currTstat_ != null && ((FabricNavTool)FabricNavTool.this).currTstat_.currStopUnselected && FabricNavTool.this.selectedOnly_[FabricNavTool.this.currPan_].isSelected()) {
                    ResourceManager rMan = ResourceManager.getManager();
                    JOptionPane.showMessageDialog(FabricNavTool.this.topWindow_, rMan.getString("navTool.currLocUnselected"), rMan.getString("navTool.currLocUnselectedTitle"), 0);
                    FabricNavTool.this.doSOReset_ = true;
                    FabricNavTool.this.selectedOnly_[FabricNavTool.this.currPan_].setSelected(false);
                    FabricNavTool.this.doSOReset_ = false;
                    return;
                }
                boolean newVal = FabricNavTool.this.selectedOnly_[FabricNavTool.this.currPan_].isSelected();
                BioFabricPanel.TourStatus tstat = FabricNavTool.this.bfp_.getTourDirections(newVal);
                FabricNavTool.this.doSOReset_ = true;
                for (int i = 0; i < 2; ++i) {
                    if (i == FabricNavTool.this.currPan_) continue;
                    FabricNavTool.this.selectedOnly_[i].setSelected(newVal);
                }
                FabricNavTool.this.doSOReset_ = false;
                FabricNavTool.this.installNames(tstat);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class ToDrain
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            try {
                BioFabricPanel.TourStatus tstat = FabricNavTool.this.bfp_.tourToDrainZone(FabricNavTool.this.calcSelectedOnly());
                FabricNavTool.this.installNames(tstat);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class Zoom
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            try {
                FabricNavTool.this.bfp_.zoomToTourStop();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class ClearTour
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            try {
                FabricNavTool.this.bfp_.clearTour();
                FabricNavTool.this.clearTour();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class GoDown
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            try {
                BioFabricPanel.TourStatus tstat = FabricNavTool.this.bfp_.goDown(FabricNavTool.this.calcSelectedOnly());
                FabricNavTool.this.installNames(tstat);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class GoFarLeft
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            try {
                BioFabricPanel.TourStatus tstat = FabricNavTool.this.bfp_.goFarLeft(FabricNavTool.this.calcSelectedOnly());
                FabricNavTool.this.installNames(tstat);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class GoLeft
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            try {
                BioFabricPanel.TourStatus tstat = FabricNavTool.this.bfp_.goLeft(FabricNavTool.this.calcSelectedOnly());
                FabricNavTool.this.installNames(tstat);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class GoFarRight
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            try {
                BioFabricPanel.TourStatus tstat = FabricNavTool.this.bfp_.goFarRight(FabricNavTool.this.calcSelectedOnly());
                FabricNavTool.this.installNames(tstat);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class GoRight
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            try {
                BioFabricPanel.TourStatus tstat = FabricNavTool.this.bfp_.goRight(FabricNavTool.this.calcSelectedOnly());
                FabricNavTool.this.installNames(tstat);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class GoUp
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            try {
                BioFabricPanel.TourStatus tstat = FabricNavTool.this.bfp_.goUp(FabricNavTool.this.calcSelectedOnly());
                FabricNavTool.this.installNames(tstat);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class ChooseAStart
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            try {
                FabricNavTool.this.bfp_.setToCollectTourStart(FabricNavTool.this.calcSelectedOnly());
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class StartFromSel
    implements ActionListener {
        public void actionPerformed(ActionEvent ev) {
            try {
                BioFabricPanel.TourStatus tstat = FabricNavTool.this.bfp_.startTourFromSelection(FabricNavTool.this.calcSelectedOnly());
                FabricNavTool.this.installNames(tstat);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }
}

