/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.display;

import java.awt.BasicStroke;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.font.FontRenderContext;
import java.awt.geom.AffineTransform;
import java.awt.geom.Line2D;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.ArrayList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.InputMap;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.KeyStroke;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.MinMax;
import org.systemsbiology.biofabric.model.BioFabricNetwork;
import org.systemsbiology.biofabric.ui.FabricColorGenerator;
import org.systemsbiology.biofabric.ui.FabricDisplayOptionsManager;
import org.systemsbiology.biofabric.ui.display.BioFabricOverview;
import org.systemsbiology.biofabric.ui.display.FabricMagnifier;
import org.systemsbiology.biofabric.ui.render.PaintCacheSmall;
import org.systemsbiology.biofabric.util.ColorListRenderer;
import org.systemsbiology.biofabric.util.UiUtil;

public class FabricMagnifyingTool
extends JPanel {
    private static final float TOP_LINK_SPACING_ = 12.0f;
    private boolean ignore_;
    private FabricMagnifier myMag_;
    private JPanel lockPanel_;
    private JLabel lockStatus_;
    private JLabel toLock_;
    private NodeLabels nodeLabels_;
    private LinkLabels topLinkLabels_;
    private LinkDisplay linkDisplay_;
    private BioFabricNetwork model_;
    private Font tiny_;
    private FabricColorGenerator colGen_;
    private boolean mouseIn_;
    private boolean byTour_;
    private boolean accept_;
    private Point2D mouseCenter_ = null;
    private int currSize_;
    private boolean neverSet_;
    private CardLayout myCard_;
    private static final long serialVersionUID = 1L;

    public FabricMagnifyingTool(FabricColorGenerator colGen) {
        this.colGen_ = colGen;
        this.ignore_ = false;
        this.accept_ = true;
        this.neverSet_ = true;
        this.lockPanel_ = new JPanel();
        Font micro = new Font("SansSerif", 0, 10);
        this.lockStatus_ = new JLabel("Tracking", 0);
        this.lockStatus_.setFont(micro);
        this.lockStatus_.setOpaque(true);
        this.lockStatus_.setBackground(Color.green);
        this.toLock_ = new JLabel("Lock: Ctrl-Space", 0);
        this.toLock_.setFont(micro);
        JLabel toZoom = new JLabel("Zoom: Z,C,+,-", 0);
        toZoom.setFont(micro);
        JLabel toPan = new JLabel("Pan: A,W,X,D", 0);
        toPan.setFont(micro);
        JLabel toPan2 = new JLabel("Pan: \u2190,\u2191,\u2193,\u2192", 0);
        toPan2.setFont(micro);
        this.lockPanel_.setLayout(new GridLayout(0, 1));
        this.lockPanel_.add(this.lockStatus_);
        this.lockPanel_.add(this.toLock_);
        this.lockPanel_.add(toZoom);
        this.lockPanel_.add(toPan);
        this.lockPanel_.add(toPan2);
        this.myMag_ = new FabricMagnifier(colGen);
        this.myMag_.addMouseListener(new MouseHandler());
        this.nodeLabels_ = new NodeLabels();
        this.topLinkLabels_ = new LinkLabels();
        this.linkDisplay_ = new LinkDisplay();
        this.myMag_.setFocusable(true);
        this.mouseIn_ = false;
        this.byTour_ = false;
        this.currSize_ = 10;
        JPanel realGuts = this.sizeGuts(this.currSize_);
        this.myCard_ = new CardLayout();
        this.setLayout(this.myCard_);
        this.add((Component)realGuts, "SUPanel");
        JPanel blankPanel = new JPanel();
        blankPanel.setBackground(Color.white);
        this.add((Component)blankPanel, "Hiding");
        this.tiny_ = new Font("SansSerif", 1, 10);
    }

    public void setSelections(PaintCacheSmall.Reduction selections) {
        this.myMag_.setSelections(selections);
    }

    public boolean isIgnoring() {
        return this.ignore_;
    }

    public void enableControls(boolean enabled) {
        this.accept_ = enabled;
        this.myCard_.show(this, enabled ? "SUPanel" : "Hiding");
    }

    public void setCurrentFloater(PaintCacheSmall.FloaterSet floaters) {
        this.myMag_.setCurrentFloater(floaters);
    }

    public void keyInstall(JPanel cpane) {
        InputMap iMapf = this.myMag_.getInputMap(0);
        InputMap iMapw = this.myMag_.getInputMap(2);
        ActionMap aMap = this.myMag_.getActionMap();
        iMapw.put(KeyStroke.getKeyStroke(32, 128), "MagnifyFreeze");
        aMap.put("MagnifyFreeze", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                try {
                    if (!FabricMagnifyingTool.this.accept_) {
                        return;
                    }
                    FabricMagnifyingTool.this.myMag_.requestFocusInWindow();
                    FabricMagnifyingTool.this.myMag_.toggleFreeze();
                    FabricMagnifyingTool.this.ignore_ = !FabricMagnifyingTool.this.ignore_;
                    FabricMagnifyingTool.this.lockStatus_.setText(FabricMagnifyingTool.this.ignore_ ? "Locked" : "Tracking");
                    FabricMagnifyingTool.this.lockStatus_.setBackground(FabricMagnifyingTool.this.ignore_ ? Color.red : Color.green);
                    FabricMagnifyingTool.this.lockStatus_.invalidate();
                    FabricMagnifyingTool.this.toLock_.setText(FabricMagnifyingTool.this.ignore_ ? "Unlock: Ctrl-Space" : "Lock: Ctrl-Space");
                    FabricMagnifyingTool.this.toLock_.invalidate();
                    FabricMagnifyingTool.this.lockPanel_.validate();
                    FabricMagnifyingTool.this.repaint();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        iMapw.put(KeyStroke.getKeyStroke(67, 0), "MagnifyMore");
        iMapw.put(KeyStroke.getKeyStroke(61, 0), "MagnifyMore");
        aMap.put("MagnifyMore", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                try {
                    if (!FabricMagnifyingTool.this.accept_) {
                        return;
                    }
                    FabricMagnifyingTool.this.myMag_.bumpGridSize(false);
                    FabricMagnifyingTool.this.linkSync();
                    FabricMagnifyingTool.this.myMag_.requestFocusInWindow();
                    FabricMagnifyingTool.this.repaint();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        iMapw.put(KeyStroke.getKeyStroke(90, 0), "MagnifyLess");
        iMapw.put(KeyStroke.getKeyStroke(45, 0), "MagnifyLess");
        aMap.put("MagnifyLess", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                try {
                    if (!FabricMagnifyingTool.this.accept_) {
                        return;
                    }
                    FabricMagnifyingTool.this.myMag_.bumpGridSize(true);
                    FabricMagnifyingTool.this.linkSync();
                    FabricMagnifyingTool.this.myMag_.requestFocusInWindow();
                    FabricMagnifyingTool.this.repaint();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        iMapf.put(KeyStroke.getKeyStroke(224, 0), "MagnifyUp");
        iMapf.put(KeyStroke.getKeyStroke(38, 0), "MagnifyUp");
        iMapw.put(KeyStroke.getKeyStroke(87, 0), "MagnifyUp");
        aMap.put("MagnifyUp", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                try {
                    if (!FabricMagnifyingTool.this.accept_) {
                        return;
                    }
                    FabricMagnifyingTool.this.myMag_.up();
                    FabricMagnifyingTool.this.linkSync();
                    FabricMagnifyingTool.this.myMag_.requestFocusInWindow();
                    FabricMagnifyingTool.this.repaint();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        iMapf.put(KeyStroke.getKeyStroke(225, 0), "MagnifyDown");
        iMapf.put(KeyStroke.getKeyStroke(40, 0), "MagnifyDown");
        iMapw.put(KeyStroke.getKeyStroke(88, 0), "MagnifyDown");
        aMap.put("MagnifyDown", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                try {
                    if (!FabricMagnifyingTool.this.accept_) {
                        return;
                    }
                    FabricMagnifyingTool.this.myMag_.down();
                    FabricMagnifyingTool.this.linkSync();
                    FabricMagnifyingTool.this.myMag_.requestFocusInWindow();
                    FabricMagnifyingTool.this.repaint();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        iMapf.put(KeyStroke.getKeyStroke(226, 0), "MagnifyLeft");
        iMapf.put(KeyStroke.getKeyStroke(37, 0), "MagnifyLeft");
        iMapw.put(KeyStroke.getKeyStroke(65, 0), "MagnifyLeft");
        aMap.put("MagnifyLeft", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                try {
                    if (!FabricMagnifyingTool.this.accept_) {
                        return;
                    }
                    FabricMagnifyingTool.this.myMag_.left();
                    FabricMagnifyingTool.this.linkSync();
                    FabricMagnifyingTool.this.myMag_.requestFocusInWindow();
                    FabricMagnifyingTool.this.repaint();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        iMapf.put(KeyStroke.getKeyStroke(227, 0), "MagnifyRight");
        iMapf.put(KeyStroke.getKeyStroke(39, 0), "MagnifyRight");
        iMapw.put(KeyStroke.getKeyStroke(68, 0), "MagnifyRight");
        aMap.put("MagnifyRight", new AbstractAction(){
            private static final long serialVersionUID = 1L;

            public void actionPerformed(ActionEvent e) {
                try {
                    if (!FabricMagnifyingTool.this.accept_) {
                        return;
                    }
                    FabricMagnifyingTool.this.myMag_.right();
                    FabricMagnifyingTool.this.linkSync();
                    FabricMagnifyingTool.this.myMag_.requestFocusInWindow();
                    FabricMagnifyingTool.this.repaint();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public Dimension getMinimumSize() {
        if (this.neverSet_) {
            return new Dimension(550, 400);
        }
        return new Dimension(550, 80);
    }

    public Dimension getMaximumSize() {
        return new Dimension(4000, 440);
    }

    public void setFabricOverview(BioFabricOverview bfo) {
        this.myMag_.setFabricOverview(bfo);
    }

    public void setModel(BioFabricNetwork model) {
        this.model_ = model;
    }

    public void setBounds(int x, int y, int width, int height) {
        this.neverSet_ = false;
        this.currSize_ = (int)Math.floor((float)height / 32.0f);
        this.myMag_.setCurrSize(this.currSize_);
        super.setBounds(x, y, width, height);
        this.linkSync();
        this.repaint();
    }

    public void setCenter(Point2D center, Point cprc, boolean byTour) {
        if (!byTour) {
            this.mouseCenter_ = center;
        }
        this.myMag_.setCenter(center, cprc, byTour);
        this.byTour_ = byTour;
        if (this.ignore_) {
            return;
        }
        this.linkSync();
        this.repaint();
    }

    public void setMouseIn(boolean isIn) {
        this.myMag_.setMouseIn(isIn);
        this.mouseIn_ = isIn;
        if (this.ignore_) {
            return;
        }
        this.linkSync();
        this.repaint();
    }

    public void linkSync() {
        List<LinkListElementDisplay> links = this.model_ != null ? this.linkDisplay_.calcLinks() : new ArrayList<LinkListElementDisplay>();
        this.linkDisplay_.setLinks(links);
    }

    public void setPainters(PaintCacheSmall painter, PaintCacheSmall selectionPainter) {
        this.myMag_.setPainters(painter, selectionPainter);
    }

    public Rectangle getClipRect() {
        return this.myMag_.getClipRect();
    }

    public Point2D getMouseLoc() {
        return this.mouseCenter_;
    }

    private JPanel sizeGuts(int magSize) {
        JPanel realGuts = new JPanel();
        realGuts.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        int col = 0;
        int row = 0;
        int wth = 10;
        int ht = (int)Math.ceil((float)(magSize + 1) * 12.0f / 10.0f + 4.0f);
        UiUtil.gbcSet(gbc, col, row, wth, ht, 1, 0, 0, 0, 0, 0, 0, 11, 0.25, 0.0);
        realGuts.add((Component)this.lockPanel_, gbc);
        col = wth;
        row = 0;
        wth = 45;
        ht = (int)Math.ceil((float)(magSize + 1) * 12.0f / 10.0f + 4.0f);
        UiUtil.gbcSet(gbc, col, row, wth, ht, 1, 0, 0, 0, 0, 0, 0, 16, 0.75, 0.0);
        realGuts.add((Component)this.topLinkLabels_, gbc);
        col = 0;
        row = ht;
        wth = 10;
        ht = magSize * 20 / 10;
        UiUtil.gbcSet(gbc, col, row, wth, ht, 1, 0, 0, 0, 0, 0, 0, 10, 0.25, 0.0);
        realGuts.add((Component)this.nodeLabels_, gbc);
        col = wth;
        wth = magSize * 20 / 10;
        ht = magSize * 20 / 10;
        UiUtil.gbcSet(gbc, col, row, wth, ht, 0, 0, 0, 0, 0, 0, 0, 10, 0.0, 0.0);
        realGuts.add((Component)this.myMag_, gbc);
        col += wth;
        wth = 45 - wth;
        ht = magSize * 20 / 10;
        UiUtil.gbcSet(gbc, col, row, wth, ht, 1, 0, 0, 0, 0, 0, 0, 10, 0.75, 0.0);
        realGuts.add((Component)this.linkDisplay_, gbc);
        return realGuts;
    }

    public class MouseHandler
    extends MouseAdapter {
        private Point lastPress_;
        private static final int CLICK_SLOP_ = 2;

        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                // empty if block
            }
        }

        private void handleClick(int lastX, int lastY) {
            Point2D.Double clickPoint = new Point2D.Double(lastX, lastY);
            Point2D.Double worldPoint = new Point2D.Double(0.0, 0.0);
            AffineTransform ac = FabricMagnifyingTool.this.myMag_.getTransform();
            try {
                ac.inverseTransform(clickPoint, worldPoint);
            }
            catch (NoninvertibleTransformException nite) {
                return;
            }
        }

        public void mousePressed(MouseEvent me) {
            try {
                if (me.isPopupTrigger()) {
                    return;
                }
                this.lastPress_ = new Point(me.getX(), me.getY());
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void mouseReleased(MouseEvent me) {
            try {
                if (me.isPopupTrigger()) {
                    return;
                }
                int currX = me.getX();
                int currY = me.getY();
                if (this.lastPress_ == null) {
                    return;
                }
                int lastX = this.lastPress_.x;
                int lastY = this.lastPress_.y;
                int diffX = Math.abs(currX - lastX);
                int diffY = Math.abs(currY - lastY);
                if (diffX <= 2 && diffY <= 2) {
                    this.handleClick(lastX, lastY);
                }
                this.lastPress_ = null;
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    private class LinkListElementDisplay
    implements ColorListRenderer.ColorSource {
        private Color color_;
        private String desc_;

        LinkListElementDisplay(Color color, String desc) {
            this.color_ = color;
            this.desc_ = desc;
        }

        public Color getColor() {
            return this.color_;
        }

        public String getDescription() {
            return this.desc_;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class LinkDisplay
    extends JPanel {
        private JList linkList_;
        private ColorListRenderer renderer_;
        private static final long serialVersionUID = 1L;

        LinkDisplay() {
            ArrayList myList = new ArrayList();
            this.linkList_ = new JList<Object>(myList.toArray());
            this.linkList_.setSelectionMode(0);
            this.renderer_ = new ColorListRenderer(myList);
            this.linkList_.setCellRenderer(this.renderer_);
            JScrollPane jsp = new JScrollPane(this.linkList_);
            jsp.setHorizontalScrollBarPolicy(30);
            jsp.setVerticalScrollBarPolicy(20);
            this.setLayout(new GridLayout(1, 1));
            this.add(jsp);
        }

        @Override
        public Dimension getPreferredSize() {
            return new Dimension(250, FabricMagnifyingTool.this.currSize_ * 20);
        }

        @Override
        public Dimension getMinimumSize() {
            return new Dimension(200, FabricMagnifyingTool.this.currSize_ * 20);
        }

        @Override
        public Dimension getMaximumSize() {
            return new Dimension(4000, FabricMagnifyingTool.this.currSize_ * 20);
        }

        public void setLinks(List<LinkListElementDisplay> links) {
            this.linkList_.clearSelection();
            this.linkList_.setListData(links.toArray());
            this.renderer_.setValues(links);
        }

        public List<LinkListElementDisplay> calcLinks() {
            ArrayList<LinkListElementDisplay> list = new ArrayList<LinkListElementDisplay>();
            if (!(FabricMagnifyingTool.this.mouseIn_ || FabricMagnifyingTool.this.byTour_ || FabricMagnifyingTool.this.ignore_)) {
                return list;
            }
            Point myCen = FabricMagnifyingTool.this.myMag_.getCenterRC();
            int zoom = FabricMagnifyingTool.this.myMag_.getZoom();
            int halfZoom = zoom / 2;
            int startCen = myCen.x - halfZoom;
            int endCen = myCen.x + halfZoom;
            boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
            for (int i = startCen; i <= endCen; ++i) {
                BioFabricNetwork.LinkInfo li;
                Integer colObj = i;
                NetNode src = FabricMagnifyingTool.this.model_.getSourceIDForColumn(colObj, showShadows);
                if (src == null || (li = FabricMagnifyingTool.this.model_.getLinkDefinition(colObj, showShadows)) == null) continue;
                int minRow = li.topRow();
                int maxRow = li.bottomRow();
                if ((minRow < myCen.y - halfZoom || minRow > myCen.y + halfZoom) && (maxRow < myCen.y - halfZoom || maxRow > myCen.y + halfZoom)) continue;
                Color paintCol = FabricMagnifyingTool.this.colGen_.getModifiedColor(li.getColorKey(), 2);
                list.add(new LinkListElementDisplay(paintCol, li.getLink().toDisplayString()));
            }
            return list;
        }
    }

    private class LinkLabels
    extends JPanel {
        private static final long serialVersionUID = 1L;

        LinkLabels() {
            this.setBackground(new Color(245, 245, 245));
        }

        public Dimension getPreferredSize() {
            return new Dimension(450, (int)((float)(FabricMagnifyingTool.this.currSize_ + 1) * 12.0f));
        }

        public Dimension getMinimumSize() {
            return new Dimension(450, (int)((float)(FabricMagnifyingTool.this.currSize_ + 1) * 12.0f));
        }

        public Dimension getMaximumSize() {
            return new Dimension(4000, (int)((float)(FabricMagnifyingTool.this.currSize_ + 1) * 12.0f));
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (FabricMagnifyingTool.this.model_ == null) {
                return;
            }
            if (!(FabricMagnifyingTool.this.mouseIn_ || FabricMagnifyingTool.this.byTour_ || FabricMagnifyingTool.this.ignore_)) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            Point myCen = FabricMagnifyingTool.this.myMag_.getCenterRC();
            int myZoom = FabricMagnifyingTool.this.myMag_.getZoom();
            if (myZoom != FabricMagnifyingTool.this.currSize_) {
                return;
            }
            boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
            Point2D.Double atPoint = new Point2D.Double(0.0, 0.0);
            Point2D.Double drawPoint = new Point2D.Double(0.0, 0.0);
            AffineTransform ac = FabricMagnifyingTool.this.myMag_.getTransform();
            g2.setFont(FabricMagnifyingTool.this.tiny_);
            BasicStroke selectedStroke = new BasicStroke(1.0f, 2, 0);
            g2.setStroke(selectedStroke);
            FontRenderContext frc = g2.getFontRenderContext();
            int numCol = FabricMagnifyingTool.this.model_.getColumnCount(showShadows);
            int startCen = myCen.x - FabricMagnifyingTool.this.currSize_ / 2;
            if (startCen < 0) {
                startCen = 0;
            }
            if (startCen >= numCol) {
                return;
            }
            int endCen = myCen.x + FabricMagnifyingTool.this.currSize_ / 2;
            if (endCen > numCol) {
                endCen = numCol;
            }
            int count = -1;
            float deltaY = 12.0f;
            float startY = 12.0f;
            for (int i = startCen; i <= endCen; ++i) {
                BioFabricNetwork.LinkInfo li;
                ++count;
                Integer colObj = i;
                NetNode src = FabricMagnifyingTool.this.model_.getSourceIDForColumn(colObj, showShadows);
                NetNode trg = FabricMagnifyingTool.this.model_.getTargetIDForColumn(colObj, showShadows);
                if (src == null || trg == null || (li = FabricMagnifyingTool.this.model_.getLinkDefinition(colObj, showShadows)) == null) continue;
                int minRow = li.topRow();
                int maxRow = li.bottomRow();
                if (minRow > myCen.y + FabricMagnifyingTool.this.currSize_ / 2 || maxRow < myCen.y - FabricMagnifyingTool.this.currSize_ / 2) continue;
                String linkDisp = li.getLink().toDisplayString();
                Rectangle2D bounds = FabricMagnifyingTool.this.tiny_.getStringBounds(linkDisp, frc);
                ((Point2D)atPoint).setLocation(i * 18, 0.0);
                ac.transform(atPoint, drawPoint);
                float baseptX = (float)((Point2D)drawPoint).getX();
                if (baseptX < 0.0f || baseptX > (float)(FabricMagnifyingTool.this.currSize_ * 20)) continue;
                float baseptY = startY + (float)count * deltaY;
                g2.setPaint(Color.BLACK);
                g2.drawString(linkDisp, baseptX + 5.0f, baseptY);
                Color paintCol = FabricMagnifyingTool.this.colGen_.getModifiedColor(li.getColorKey(), 2);
                float boxBaseY = baseptY - (float)bounds.getHeight() / 3.0f;
                Line2D.Float line = new Line2D.Float(baseptX, boxBaseY, baseptX, 400.0f);
                g2.setColor(paintCol);
                g2.draw(line);
                Rectangle2D.Float rect = new Rectangle2D.Float(baseptX - 2.0f, boxBaseY - 2.0f, 5.0f, 5.0f);
                g2.fill(rect);
            }
        }
    }

    private class NodeLabels
    extends JPanel {
        private static final long serialVersionUID = 1L;

        NodeLabels() {
            this.setBackground(new Color(245, 245, 245));
        }

        public Dimension getPreferredSize() {
            return new Dimension(100, FabricMagnifyingTool.this.currSize_ * 20);
        }

        public Dimension getMinimumSize() {
            return new Dimension(100, 10);
        }

        public Dimension getMaximumSize() {
            return new Dimension(4000, FabricMagnifyingTool.this.currSize_ * 20);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            if (FabricMagnifyingTool.this.model_ == null) {
                return;
            }
            if (!(FabricMagnifyingTool.this.mouseIn_ || FabricMagnifyingTool.this.byTour_ || FabricMagnifyingTool.this.ignore_)) {
                return;
            }
            Graphics2D g2 = (Graphics2D)g;
            Point myCen = FabricMagnifyingTool.this.myMag_.getCenterRC();
            int myZoom = FabricMagnifyingTool.this.myMag_.getZoom();
            if (myZoom != FabricMagnifyingTool.this.currSize_) {
                return;
            }
            Point2D.Double atPoint = new Point2D.Double(0.0, 0.0);
            Point2D.Double drawPoint = new Point2D.Double(0.0, 0.0);
            boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
            AffineTransform ac = FabricMagnifyingTool.this.myMag_.getTransform();
            g2.setFont(FabricMagnifyingTool.this.tiny_);
            g2.setPaint(Color.BLACK);
            FontRenderContext frc = g2.getFontRenderContext();
            int startCen = myCen.y - FabricMagnifyingTool.this.currSize_ / 2 - 1;
            int endCen = myCen.y + FabricMagnifyingTool.this.currSize_ / 2 + 1;
            for (int i = startCen; i <= endCen; ++i) {
                NetNode node = FabricMagnifyingTool.this.model_.getNodeIDForRow(i);
                if (node == null) continue;
                BioFabricNetwork.NodeInfo ni = FabricMagnifyingTool.this.model_.getNodeDefinition(node);
                MinMax nimm = ni.getColRange(showShadows);
                if (nimm.min > myCen.x + FabricMagnifyingTool.this.currSize_ / 2 || nimm.max < myCen.x - FabricMagnifyingTool.this.currSize_ / 2) continue;
                Rectangle2D bounds = FabricMagnifyingTool.this.tiny_.getStringBounds(node.getName(), frc);
                ((Point2D)atPoint).setLocation(0.0, i * 18);
                ac.transform(atPoint, drawPoint);
                g2.drawString(node.getName(), (float)this.getWidth() - (float)bounds.getWidth() - 5.0f, (float)((Point2D)drawPoint).getY() + (float)bounds.getHeight() / 3.0f);
            }
        }
    }
}

