/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.display;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;
import org.systemsbiology.biofabric.ui.FabricColorGenerator;
import org.systemsbiology.biofabric.ui.FabricDisplayOptions;
import org.systemsbiology.biofabric.ui.FabricDisplayOptionsManager;
import org.systemsbiology.biofabric.ui.display.BioFabricOverview;
import org.systemsbiology.biofabric.ui.render.PaintCacheSmall;

public class FabricMagnifier
extends JPanel {
    public static final int PREF_SIZE = 10;
    public static final int MIN_SIZE = 2;
    public static final int MAX_SIZE = 10;
    public static final int MAG_GRID = 20;
    private int miniSize_ = 10;
    private boolean needInit_ = true;
    private PaintCacheSmall painter_;
    private PaintCacheSmall selectionPainter_;
    private PaintCacheSmall.Reduction selections_;
    private AffineTransform miniTrans_;
    private Rectangle worldRec_;
    private Rectangle clipRec_;
    private Point2D center_ = new Point2D.Double(0.0, 0.0);
    private Point centerRC_ = new Point(0, 0);
    private boolean ignore_ = false;
    private boolean mouseIn_ = false;
    private boolean byTour_ = false;
    private BioFabricOverview bfo_;
    private BufferedImage bim_;
    private PaintCacheSmall.FloaterSet floaters_;
    private int currSize_ = 10;
    private static final long serialVersionUID = 1L;

    public FabricMagnifier(FabricColorGenerator colGen) {
        this.miniTrans_ = new AffineTransform();
        this.setBackground(Color.white);
        this.painter_ = new PaintCacheSmall(colGen);
        this.selectionPainter_ = new PaintCacheSmall(colGen);
        this.floaters_ = null;
        this.worldRec_ = new Rectangle();
        this.clipRec_ = new Rectangle();
    }

    public void setSelections(PaintCacheSmall.Reduction selections) {
        this.selections_ = selections;
    }

    public void setCurrentFloater(PaintCacheSmall.FloaterSet floaters) {
        this.floaters_ = floaters;
    }

    public void setFabricOverview(BioFabricOverview bfo) {
        this.bfo_ = bfo;
    }

    public void setCurrSize(int size) {
        if (size == this.miniSize_ && !this.needInit_) {
            return;
        }
        this.needInit_ = false;
        int oldSize = this.miniSize_;
        this.miniSize_ = size < 2 ? 2 : size;
        int newCurr = this.currSize_ / oldSize * this.miniSize_;
        this.setZoom(newCurr);
    }

    public Dimension getPreferredSize() {
        return new Dimension(this.miniSize_ * 20, this.miniSize_ * 20);
    }

    public Dimension getMinimumSize() {
        return new Dimension(this.miniSize_ * 20, this.miniSize_ * 20);
    }

    public Dimension getMaximumSize() {
        return this.getPreferredSize();
    }

    public void setBounds(int x, int y, int width, int height) {
        super.setBounds(x, y, width, height);
        this.setMiniZoom();
        this.repaint();
    }

    public void paintComponent(Graphics g) {
        super.paintComponent(g);
        Graphics2D g2 = (Graphics2D)g;
        this.drawingGuts(g2);
    }

    public void bumpGridSize(boolean up) {
        int newSize;
        int n = newSize = up ? this.currSize_ * 2 : this.currSize_ / 2;
        if (newSize < this.miniSize_) {
            newSize = this.miniSize_;
        }
        this.setZoom(newSize);
    }

    public void toggleFreeze() {
        this.ignore_ = !this.ignore_;
    }

    public void up() {
        int inc = this.getZoom() / this.currSize_;
        this.centerRC_.y -= inc;
        this.center_.setLocation(this.center_.getX(), this.center_.getY() - (double)(18 * inc));
        this.setMiniZoom();
        this.repaint();
    }

    public void down() {
        int inc = this.getZoom() / this.currSize_;
        this.centerRC_.y += inc;
        this.center_.setLocation(this.center_.getX(), this.center_.getY() + (double)(18 * inc));
        this.setMiniZoom();
        this.repaint();
    }

    public void left() {
        int inc = this.getZoom() / this.currSize_;
        this.centerRC_.x -= inc;
        this.center_.setLocation(this.center_.getX() - (double)(18 * inc), this.center_.getY());
        this.setMiniZoom();
        this.repaint();
    }

    public void right() {
        int inc = this.getZoom() / this.currSize_;
        this.centerRC_.x += inc;
        this.center_.setLocation(this.center_.getX() + (double)(18 * inc), this.center_.getY());
        this.setMiniZoom();
        this.repaint();
    }

    public void setZoom(int gridsize) {
        this.currSize_ = gridsize;
        this.setMiniZoom();
        this.repaint();
    }

    public int getZoom() {
        return this.currSize_;
    }

    public AffineTransform getTransform() {
        return this.miniTrans_;
    }

    public Point getCenterRC() {
        return this.centerRC_;
    }

    public Rectangle getClipRect() {
        return this.clipRec_;
    }

    public void setCenter(Point2D center, Point centerRC, boolean byTour) {
        if (this.ignore_) {
            return;
        }
        this.byTour_ = byTour;
        this.centerRC_.setLocation(centerRC);
        this.center_.setLocation(center);
        this.setMiniZoom();
        this.repaint();
    }

    public void setMouseIn(boolean isIn) {
        if (this.ignore_) {
            return;
        }
        this.mouseIn_ = isIn;
        this.repaint();
    }

    public void setMiniZoom() {
        Dimension screenDim = this.getSize();
        int worldWidth = this.currSize_ * 18;
        int worldHeight = this.currSize_ * 18;
        this.worldRec_.setBounds((int)this.center_.getX() - worldWidth / 2, (int)this.center_.getY() - worldHeight / 2, worldWidth, worldHeight);
        this.clipRec_.setBounds((int)(this.worldRec_.getX() - 18.0), (int)(this.worldRec_.getY() - 18.0), (int)(this.worldRec_.getWidth() + 36.0), (int)(this.worldRec_.getHeight() + 36.0));
        double zoomH = screenDim.getWidth() / this.worldRec_.getWidth();
        double zoomV = screenDim.getHeight() / this.worldRec_.getHeight();
        double zoom = Math.min(zoomH, zoomV);
        this.miniTrans_.setToIdentity();
        this.miniTrans_.translate(screenDim.getWidth() / 2.0, screenDim.getHeight() / 2.0);
        this.miniTrans_.scale(zoom, zoom);
        this.miniTrans_.translate(-this.center_.getX(), -this.center_.getY());
        this.bfo_.setMagnifyView(this.worldRec_);
    }

    public void setPainters(PaintCacheSmall painter, PaintCacheSmall selectionPainter) {
        this.painter_ = painter;
        this.selectionPainter_ = selectionPainter;
        this.repaint();
    }

    private void drawingGuts(Graphics g) {
        if (this.painter_ == null) {
            return;
        }
        if (!(this.mouseIn_ || this.byTour_ || this.ignore_)) {
            return;
        }
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        AffineTransform saveTrans = g2.getTransform();
        g2.transform(this.miniTrans_);
        BasicStroke selectedStroke = new BasicStroke(3.0f, 2, 0);
        g2.setStroke(selectedStroke);
        this.painter_.paintIt(g2, this.clipRec_, null);
        g2.setTransform(saveTrans);
        if (this.selections_ != null && this.selections_.somethingToPaint()) {
            this.drawSelections(g2, this.clipRec_);
        }
        if (this.floaters_ != null) {
            g2.transform(this.miniTrans_);
            this.painter_.drawFloater(g2, this.floaters_);
        }
    }

    public void drawSelections(Graphics2D g2, Rectangle clip) {
        FabricDisplayOptions fdo = FabricDisplayOptionsManager.getMgr().getDisplayOptions();
        Dimension viewDim = this.getSize();
        if (this.bim_ == null || this.bim_.getHeight() != viewDim.height || this.bim_.getWidth() != viewDim.width) {
            this.bim_ = new BufferedImage(viewDim.width, viewDim.height, 2);
        }
        Graphics2D ig2 = this.bim_.createGraphics();
        ig2.setTransform(new AffineTransform());
        Color drawCol = new Color(1.0f, 1.0f, 1.0f, (float)fdo.getSelectionOpaqueLevel());
        ig2.setBackground(drawCol);
        ig2.clearRect(0, 0, viewDim.width, viewDim.height);
        ig2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ig2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        BasicStroke selectedStroke = new BasicStroke(3.0f, 2, 0);
        ig2.setStroke(selectedStroke);
        ig2.setTransform(this.miniTrans_);
        ig2.setComposite(AlphaComposite.Src);
        this.selectionPainter_.paintIt(ig2, clip, this.selections_);
        g2.drawImage(this.bim_, 0, 0, viewDim.width, viewDim.height, null);
    }
}

