/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.display;

import java.awt.Color;
import java.awt.GridLayout;
import java.util.Iterator;
import java.util.List;
import javax.swing.JPanel;
import org.systemsbiology.biofabric.ui.display.BioFabricPanel;
import org.systemsbiology.biofabric.ui.display.InfoPanel;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FabricLocation
extends JPanel {
    private static final long serialVersionUID = 1L;
    private InfoPanel nodePanel_;
    private InfoPanel linkPanel_;
    private InfoPanel linkZonePanel_;
    private InfoPanel nodeAnnotPanel_;
    private InfoPanel linkAnnotPanel_;
    private StringBuffer scratch_;

    public FabricLocation() {
        this.setBackground(Color.WHITE);
        this.setLayout(new GridLayout(2, 1));
        JPanel topPanel = new JPanel();
        JPanel botPanel = new JPanel();
        topPanel.setLayout(new GridLayout(1, 2));
        topPanel.setBackground(Color.WHITE);
        botPanel.setLayout(new GridLayout(1, 3));
        botPanel.setBackground(Color.WHITE);
        this.add(topPanel);
        this.add(botPanel);
        this.nodePanel_ = new InfoPanel(false, 15, 150, false, true);
        this.linkPanel_ = new InfoPanel(false, 15, 150, false, true);
        this.linkZonePanel_ = new InfoPanel(false, 15, 150, false, true);
        this.nodeAnnotPanel_ = new InfoPanel(false, 15, 300, false, true);
        this.linkAnnotPanel_ = new InfoPanel(false, 15, 300, false, true);
        this.nodePanel_.installName("Mouse Over Node Row: <none>");
        this.linkPanel_.installName("Mouse Over Link: <none>");
        this.linkZonePanel_.installName("Mouse Over Node Link Zone: <none>");
        this.nodeAnnotPanel_.installName("Mouse Over Node Annotations: <none>");
        this.linkAnnotPanel_.installName("Mouse Over Link Annotations: <none>");
        topPanel.add(this.nodeAnnotPanel_);
        topPanel.add(this.linkAnnotPanel_);
        botPanel.add(this.nodePanel_);
        botPanel.add(this.linkPanel_);
        botPanel.add(this.linkZonePanel_);
        this.scratch_ = new StringBuffer();
    }

    public void setNodeAndLink(BioFabricPanel.MouseLocInfo mlo) {
        this.nodePanel_.installName("Mouse Over Node Row: " + mlo.nodeDesc);
        this.linkPanel_.installName("Mouse Over Link: " + mlo.linkDesc);
        this.linkZonePanel_.installName("Mouse Over Node Link Zone: " + mlo.zoneDesc);
        this.nodeAnnotPanel_.installName("Mouse Over Node Annotations: " + this.displayString(this.scratch_, mlo.nodeAnnotations));
        this.linkAnnotPanel_.installName("Mouse Over Link Annotations: " + this.displayString(this.scratch_, mlo.linkAnnotations));
        this.repaint();
    }

    private String displayString(StringBuffer buf, List<String> vals) {
        buf.setLength(0);
        Iterator<String> fli = vals.iterator();
        while (fli.hasNext()) {
            buf.append(fli.next());
            if (!fli.hasNext()) continue;
            buf.append(", ");
        }
        return buf.toString();
    }
}

