/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.display;

import java.awt.AlphaComposite;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.awt.print.PageFormat;
import java.awt.print.Printable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JPanel;
import javax.swing.JScrollBar;
import javax.swing.JScrollPane;
import javax.swing.JViewport;
import org.systemsbiology.biofabric.api.model.AnnotationSet;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.MinMax;
import org.systemsbiology.biofabric.api.util.NID;
import org.systemsbiology.biofabric.api.worker.AsynchExitRequestException;
import org.systemsbiology.biofabric.api.worker.BTProgressMonitor;
import org.systemsbiology.biofabric.api.worker.LoopReporter;
import org.systemsbiology.biofabric.app.BioFabricApplication;
import org.systemsbiology.biofabric.app.BioFabricWindow;
import org.systemsbiology.biofabric.cmd.CommandSet;
import org.systemsbiology.biofabric.cmd.ZoomCommandSupport;
import org.systemsbiology.biofabric.cmd.ZoomTarget;
import org.systemsbiology.biofabric.event.EventManager;
import org.systemsbiology.biofabric.event.SelectionChangeEvent;
import org.systemsbiology.biofabric.io.BuildDataImpl;
import org.systemsbiology.biofabric.model.AnnotationSetImpl;
import org.systemsbiology.biofabric.model.BioFabricNetwork;
import org.systemsbiology.biofabric.model.FabricLink;
import org.systemsbiology.biofabric.ui.BasicZoomTargetSupport;
import org.systemsbiology.biofabric.ui.CursorManager;
import org.systemsbiology.biofabric.ui.FabricColorGenerator;
import org.systemsbiology.biofabric.ui.FabricDisplayOptions;
import org.systemsbiology.biofabric.ui.FabricDisplayOptionsManager;
import org.systemsbiology.biofabric.ui.ImageExporter;
import org.systemsbiology.biofabric.ui.PopupMenuControl;
import org.systemsbiology.biofabric.ui.ZoomPresentation;
import org.systemsbiology.biofabric.ui.display.BioFabricOverview;
import org.systemsbiology.biofabric.ui.display.FabricLocation;
import org.systemsbiology.biofabric.ui.display.FabricMagnifyingTool;
import org.systemsbiology.biofabric.ui.display.FabricNavTool;
import org.systemsbiology.biofabric.ui.display.MouseOverView;
import org.systemsbiology.biofabric.ui.render.BucketRenderer;
import org.systemsbiology.biofabric.ui.render.BufBuildDrawer;
import org.systemsbiology.biofabric.ui.render.BufferBuilder;
import org.systemsbiology.biofabric.ui.render.ImgAndBufPool;
import org.systemsbiology.biofabric.ui.render.PaintCacheSmall;
import org.systemsbiology.biofabric.util.QuadTree;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BioFabricPanel
implements ZoomTarget,
ZoomPresentation,
Printable,
BufBuildDrawer,
BufferBuilder.BufferBuilderClient {
    private static final double PAD_MULT_ = 0.2;
    public static final int GRID_SIZE = 18;
    public static final int GRID_SIZE_SQ = 324;
    private MyPaintPanel myPanel_;
    private JScrollPane jsp_;
    private BasicZoomTargetSupport zoomer_;
    private ZoomCommandSupport zcs_;
    private TreeMap<Double, Integer> zoomMap_;
    private Point lastPress_;
    private Point lastView_;
    private Point lastAbs_;
    private boolean collectingZoomMode_;
    private boolean collectingTourStart_;
    private boolean tourStartSelectionOnly_;
    private Point firstZoomPoint_;
    private boolean isAMac_;
    private boolean lastShifted_;
    private boolean lastCtrl_;
    private BioFabricPanel myMini_;
    private HashSet<FabricLink> currLinkSelections_;
    private HashSet<NetNode> currNodeSelections_;
    private HashSet<Integer> currColSelections_;
    private ArrayList<BioFabricNetwork.NodeInfo> targetList_;
    private ArrayList<BioFabricNetwork.LinkInfo> linkList_;
    private ArrayList<Rectangle> rects_;
    private int currSel_;
    private PaintCacheSmall.Reduction selections_;
    private BufferBuilder bufferBuilder_;
    private FabricLocation myLocation_;
    private MouseOverView mov_;
    private Rectangle2D worldRectNetAR_;
    private Rectangle2D worldRectScreenAR_;
    private Dimension screenDim_;
    private PaintCacheSmall.FloaterSet floaterSet_;
    private Point selFocus_;
    private Point tourFocus_;
    private BioFabricNetwork bfn_;
    private PaintCacheSmall painter_;
    private BioFabricApplication bfa_;
    private FabricMagnifyingTool fmt_;
    private FabricNavTool fnt_;
    private BioFabricOverview bfo_;
    private BufferedImage bim_;
    private boolean doBuildSelect_;
    private CursorManager cursorMgr_;
    private BioFabricWindow bfw_;
    private Map<NetNode, Rectangle2D> nodeNameLocations_;
    private Map<NetNode, List<Rectangle2D>> drainNameLocations_;
    private QuadTree forSelections_;
    private PopupMenuControl popCtrl_;
    private BucketRenderer bucketRend_;
    private Rectangle clipRect_;
    private Rectangle clipRect2_;
    private ImgAndBufPool bis_;
    private List<BufferedImage> staleImages_;
    private Point fullModelPos_;
    private Dimension fullModelExtent_;

    public BioFabricPanel(FabricColorGenerator colGen, BioFabricApplication bfa, FabricMagnifyingTool fmt, BioFabricOverview bfo, FabricNavTool fnt, boolean isForMain, BioFabricWindow bfw, BucketRenderer bRend, boolean headless) {
        this.bfa_ = bfa;
        this.fmt_ = fmt;
        this.fnt_ = fnt;
        this.bfo_ = bfo;
        this.bfw_ = bfw;
        this.myPanel_ = headless ? null : new MyPaintPanel();
        this.zoomer_ = new BasicZoomTargetSupport(this, this.myPanel_);
        CommandSet fc = CommandSet.getCmds(isForMain ? "mainWindow" : "selectionWindow");
        this.zcs_ = new ZoomCommandSupport(fc);
        this.isAMac_ = fc.isAMac();
        this.painter_ = new PaintCacheSmall(colGen);
        if (this.fmt_ != null) {
            this.fmt_.setPainters(this.painter_, this.painter_);
        }
        this.zoomMap_ = new TreeMap();
        if (this.myPanel_ != null) {
            this.myPanel_.addMouseListener(new MouseHandler());
            this.myPanel_.addMouseMotionListener(new MouseMotionHandler());
        }
        this.currLinkSelections_ = new HashSet();
        this.currNodeSelections_ = new HashSet();
        this.currColSelections_ = new HashSet();
        this.targetList_ = new ArrayList();
        this.linkList_ = new ArrayList();
        this.collectingZoomMode_ = false;
        this.collectingTourStart_ = false;
        this.tourStartSelectionOnly_ = false;
        this.firstZoomPoint_ = null;
        this.lastShifted_ = false;
        this.lastCtrl_ = false;
        this.clipRect_ = new Rectangle();
        this.clipRect2_ = new Rectangle();
        this.worldRectNetAR_ = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
        this.zoomer_.setWorldRect(UiUtil.rectFromRect2D(this.worldRectNetAR_));
        this.bfn_ = null;
        this.floaterSet_ = new PaintCacheSmall.FloaterSet(null, null, null);
        if (this.fmt_ != null) {
            this.fmt_.setCurrentFloater(this.floaterSet_);
        }
        this.rects_ = new ArrayList();
        this.currSel_ = -1;
        this.selFocus_ = null;
        this.tourFocus_ = null;
        this.doBuildSelect_ = true;
        this.cursorMgr_ = headless ? null : new CursorManager(this.myPanel_, false);
        this.popCtrl_ = headless ? null : new PopupMenuControl(this.myPanel_);
        this.bucketRend_ = bRend;
        this.staleImages_ = new ArrayList<BufferedImage>();
    }

    public JPanel getPanel() {
        return this.myPanel_;
    }

    public BucketRenderer getBucketRend() {
        return this.bucketRend_;
    }

    public ImgAndBufPool getBufImgStack() {
        return this.bis_;
    }

    public FabricMagnifyingTool getMagnifier() {
        return this.fmt_;
    }

    @Override
    public void setCurrClipRect(Rectangle2D clipRect) {
        this.zoomer_.setCurrClipRect(clipRect);
    }

    public void toggleBuildSelect() {
        this.doBuildSelect_ = !this.doBuildSelect_;
    }

    public boolean amBuildingSelections() {
        return this.doBuildSelect_;
    }

    public boolean hasAModel() {
        return this.bfn_ != null && this.bfn_.getRowCount() > 0;
    }

    public BioFabricNetwork getNetwork() {
        return this.bfn_;
    }

    public void setSelectionPanel(BioFabricPanel mini) {
        this.myMini_ = mini;
    }

    public void reset() {
        if (this.bufferBuilder_ != null) {
            this.bufferBuilder_.release();
        }
        this.painter_.clear();
        this.bfn_ = null;
        if (this.fmt_ != null) {
            this.fmt_.setModel(null);
        }
        this.zoomMap_.clear();
        this.worldRectNetAR_ = new Rectangle2D.Double(0.0, 0.0, 100.0, 100.0);
        this.zoomer_.setWorldRect(UiUtil.rectFromRect2D(this.worldRectNetAR_));
        this.clearSelections();
        if (this.fnt_ != null) {
            this.fnt_.haveAModel(false);
        }
        this.floaterSet_.clear();
        this.nodeNameLocations_ = null;
        this.drainNameLocations_ = null;
    }

    public void shutdown() {
        if (this.bufferBuilder_ != null) {
            this.bufferBuilder_.release();
        }
    }

    @Override
    public void yourOrderIsReady(int size) {
        if (this.bfn_ == null) {
            return;
        }
        Double zoomVal = new Double(this.zoomer_.getZoomFactor());
        Integer numObj = this.zoomMap_.get(zoomVal);
        if (numObj != null && size == numObj) {
            this.repaint();
        }
    }

    public void setBufBuilder(BufferBuilder bb) {
        this.bufferBuilder_ = bb;
    }

    public BufferBuilder getBufBuilder() {
        return this.bufferBuilder_;
    }

    public int[] calcZoomSettings(Dimension screenSize) {
        int count;
        double zoom;
        double worldHeightScreenAR;
        double worldWidthScreenAR;
        double screenAR = screenSize.getWidth() / screenSize.getHeight();
        double worldAR = this.worldRectNetAR_.getWidth() / this.worldRectNetAR_.getHeight();
        if (worldAR > screenAR) {
            worldWidthScreenAR = this.worldRectNetAR_.getWidth();
            worldHeightScreenAR = worldWidthScreenAR / screenAR;
            zoom = screenSize.getWidth() / this.worldRectNetAR_.getWidth();
        } else {
            worldHeightScreenAR = this.worldRectNetAR_.getHeight();
            worldWidthScreenAR = worldHeightScreenAR * screenAR;
            zoom = screenSize.getHeight() / this.worldRectNetAR_.getHeight();
        }
        this.screenDim_ = new Dimension(screenSize);
        this.bis_ = new ImgAndBufPool(50000);
        double worldCenterX = this.worldRectNetAR_.getCenterX();
        double worldCenterY = this.worldRectNetAR_.getCenterY();
        double worldULX = worldCenterX - worldWidthScreenAR / 2.0;
        double worldULY = worldCenterY - worldHeightScreenAR / 2.0;
        this.worldRectScreenAR_ = new Rectangle2D.Double(worldULX, worldULY, worldWidthScreenAR, worldHeightScreenAR);
        double maxZoom = screenSize.getHeight() / 72.0;
        double transitionZoom = screenSize.getWidth() / 180000.0;
        double lastZoom = zoom;
        ArrayList<Double> zoomList = new ArrayList<Double>();
        ArrayList<Integer> forRet = new ArrayList<Integer>();
        for (count = 0; lastZoom < maxZoom || count < 1; ++count, lastZoom *= 2.0) {
            Double zObj = lastZoom;
            zoomList.add(zObj);
            if (!(lastZoom < transitionZoom) && count >= 2) continue;
            Integer index = count;
            this.zoomMap_.put(zObj, index);
            forRet.add(index);
        }
        this.bucketRend_.setModelDims(this.screenDim_, this.worldRectScreenAR_, this.bis_);
        int[] zooms = new int[forRet.size()];
        double[] zoomVals = new double[zoomList.size()];
        count = 0;
        for (Integer n : forRet) {
            zooms[count++] = n;
        }
        count = 0;
        for (Double d : zoomList) {
            zoomVals[count++] = d;
        }
        this.zcs_.setZoomPoints(zoomVals);
        this.zcs_.setZoomLevels(zooms);
        return zooms;
    }

    @Override
    public void dimsForBuf(Dimension screenDim, Rectangle2D worldRect) {
        screenDim.setSize(this.screenDim_);
        worldRect.setRect(this.worldRectScreenAR_);
    }

    public void clearSelections() {
        this.currLinkSelections_.clear();
        this.currNodeSelections_.clear();
        this.currColSelections_.clear();
        this.fmt_.setSelections(null);
        this.targetList_.clear();
        this.linkList_.clear();
        this.floaterSet_.currSelRect = null;
        this.rects_.clear();
        this.currSel_ = -1;
        this.selections_ = null;
        if (this.fnt_ != null) {
            this.fnt_.haveASelection(false);
        }
        this.handleFloaterChange();
        EventManager mgr = EventManager.getManager();
        SelectionChangeEvent ev = new SelectionChangeEvent(null, null, 3);
        mgr.sendSelectionChangeEvent(ev);
    }

    public void setFabricLocation(FabricLocation loc, MouseOverView mov) {
        this.myLocation_ = loc;
        this.mov_ = mov;
    }

    public Rectangle buildFocusBox(Point rcPoint) {
        Point ulp = (Point)rcPoint.clone();
        ulp.setLocation(ulp.x - 2, ulp.y - 2);
        Point2D wulp = this.rowColToWorld(ulp);
        return new Rectangle((int)wulp.getX(), (int)wulp.getY(), 72, 72);
    }

    public boolean haveASelection() {
        return !this.currLinkSelections_.isEmpty() || !this.currNodeSelections_.isEmpty() || !this.currColSelections_.isEmpty();
    }

    public Set<NetNode> getNodeSelections() {
        return this.currNodeSelections_;
    }

    public void installSearchResult(Set<NetNode> results, boolean doDiscard) {
        if (doDiscard) {
            this.currLinkSelections_.clear();
            this.currNodeSelections_.clear();
            this.currColSelections_.clear();
            this.fmt_.setSelections(null);
            this.currSel_ = -1;
            this.floaterSet_.currSelRect = null;
        }
        if (results.isEmpty()) {
            this.buildSelectionGeometry(null, null);
            return;
        }
        this.currNodeSelections_.addAll(results);
        this.buildSelectionGeometry(results.iterator().next(), null);
        this.zoomToSelected();
    }

    public void addFirstNeighbors() {
        boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
        this.bfn_.addFirstNeighbors(this.currNodeSelections_, this.currColSelections_, this.currLinkSelections_, showShadows);
        this.buildSelectionGeometry(null, null);
    }

    private void transmitSelections(List<BioFabricNetwork.NodeInfo> targetList, List<BioFabricNetwork.LinkInfo> linkList) {
        if (this.myMini_ == null) {
            this.bfa_.launchSelection();
            if (this.myMini_ == null) {
                throw new IllegalStateException();
            }
        } else {
            this.bfa_.raiseSelection();
        }
        CommandSet fc = CommandSet.getCmds("selectionWindow");
        try {
            BuildDataImpl bfnsbd = new BuildDataImpl(this.bfn_, targetList, linkList);
            fc.getFileLoader().newModelOperations(bfnsbd, false);
        }
        catch (IOException ioex) {
            throw new IllegalStateException();
        }
    }

    public void handleFloaterChange() {
        this.repaint();
        if (this.fmt_ != null) {
            this.fmt_.repaint();
        }
    }

    @Override
    public void repaint() {
        if (this.myPanel_ != null) {
            this.myPanel_.repaint();
        }
        if (this.fmt_ != null) {
            this.fmt_.repaint();
        }
    }

    public TourStatus goRight(boolean selectedOnly) {
        return this.goLeftRight(1, selectedOnly);
    }

    public TourStatus goFarRight(boolean selectedOnly) {
        return this.goFarLeftRight(true, selectedOnly);
    }

    public TourStatus goLeft(boolean selectedOnly) {
        return this.goLeftRight(-1, selectedOnly);
    }

    public TourStatus goFarLeft(boolean selectedOnly) {
        return this.goFarLeftRight(false, selectedOnly);
    }

    public TourStatus goUp(boolean selectedOnly) {
        return this.goUpDown(true, selectedOnly);
    }

    public TourStatus goDown(boolean selectedOnly) {
        return this.goUpDown(false, selectedOnly);
    }

    public void zoomToTourStop() {
        this.zoomToRectangle(this.floaterSet_.tourRect);
    }

    public TourStatus tourToDrainZone(boolean selectedOnly) {
        return this.goToDrainZone(selectedOnly);
    }

    public void clearTour() {
        this.floaterSet_.tourRect = null;
        this.handleFloaterChange();
    }

    public TourStatus getTourDirections(boolean selectedOnly) {
        if (this.tourFocus_ == null) {
            return null;
        }
        return this.handleTourStop(this.tourFocus_.x, this.tourFocus_.y, this.tourFocus_.x, selectedOnly ? this.bfn_.getNodeIDForRow(this.tourFocus_.y) : null);
    }

    private TourStatus goToDrainZone(boolean selectedOnly) {
        int colMax;
        int colMin;
        UiUtil.fixMePrintout("Handle cycling through multiple drain zones");
        NetNode nodeName = this.bfn_.getNodeIDForRow(this.tourFocus_.y);
        if (nodeName == null) {
            return null;
        }
        BioFabricNetwork.NodeInfo node = this.bfn_.getNodeDefinition(nodeName);
        boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
        List<BioFabricNetwork.DrainZone> dropZone = node.getDrainZones(showShadows);
        MinMax nmm = null;
        if (dropZone == null) {
            nmm = node.getColRange(showShadows);
            colMin = nmm.max;
            colMax = nmm.max;
        } else {
            UiUtil.fixMePrintout("Crash here on go to drain zone in tour: array size 0");
            colMin = dropZone.get((int)0).getMinMax().min;
            colMax = dropZone.get((int)0).getMinMax().max;
        }
        int start = colMin;
        int end = colMax;
        for (int i = start; i <= end; ++i) {
            Integer testCol = i;
            if (selectedOnly && !this.currColSelections_.contains(testCol)) continue;
            NetNode target = this.bfn_.getTargetIDForColumn(testCol, showShadows);
            NetNode source = this.bfn_.getSourceIDForColumn(testCol, showShadows);
            if (target == null || source == null || !target.equals(nodeName) && !source.equals(nodeName)) continue;
            return this.handleTourStop(i, this.tourFocus_.y, testCol, selectedOnly ? nodeName : null);
        }
        return null;
    }

    private TourStatus goLeftRight(int inc, boolean selectedOnly) {
        boolean nodeAlive;
        NetNode nodeName = this.bfn_.getNodeIDForRow(this.tourFocus_.y);
        if (nodeName == null) {
            return null;
        }
        BioFabricNetwork.NodeInfo node = this.bfn_.getNodeDefinition(nodeName);
        boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
        MinMax nmm = node.getColRange(showShadows);
        int colMin = nmm.min;
        int colMax = nmm.max;
        int currCol = this.tourFocus_.x;
        if (currCol < colMin) {
            currCol = colMin - 1;
        }
        if (currCol > colMax) {
            currCol = colMax;
        }
        int start = currCol + inc;
        int end = inc == 1 ? colMax : colMin;
        int i = start;
        while (inc == 1 ? i <= end : i >= end) {
            Integer testCol = i;
            if (!selectedOnly || this.currColSelections_.contains(testCol)) {
                NetNode target = this.bfn_.getTargetIDForColumn(testCol, showShadows);
                NetNode source = this.bfn_.getSourceIDForColumn(testCol, showShadows);
                if (target != null && source != null && (target.equals(nodeName) || source.equals(nodeName))) {
                    return this.handleTourStop(i, this.tourFocus_.y, testCol, selectedOnly ? nodeName : null);
                }
            }
            i += inc;
        }
        boolean bl = nodeAlive = !selectedOnly ? true : this.currNodeSelections_.contains(nodeName);
        if (inc == -1 && nodeAlive) {
            Rectangle2D targName = this.nodeNameLocations_.get(nodeName);
            Point targNameRC = this.worldToRowCol(new Point2D.Double(targName.getCenterX(), targName.getCenterY()));
            int useCol = targNameRC.x;
            return this.handleTourStop(useCol, this.tourFocus_.y, useCol, nodeName);
        }
        return null;
    }

    private TourStatus goFarLeftRight(boolean goRight, boolean selectedOnly) {
        boolean nodeAlive;
        NetNode nodeName = this.bfn_.getNodeIDForRow(this.tourFocus_.y);
        if (nodeName == null) {
            return null;
        }
        boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
        BioFabricNetwork.NodeInfo node = this.bfn_.getNodeDefinition(nodeName);
        MinMax range = node.getColRange(showShadows);
        int useCol = goRight ? range.max : range.min;
        boolean bl = nodeAlive = !selectedOnly ? true : this.currNodeSelections_.contains(nodeName);
        if (!goRight && nodeAlive) {
            Rectangle2D targName = this.nodeNameLocations_.get(nodeName);
            Point targNameRC = this.worldToRowCol(new Point2D.Double(targName.getCenterX(), targName.getCenterY()));
            useCol = targNameRC.x;
            return this.handleTourStop(useCol, this.tourFocus_.y, useCol, nodeName);
        }
        if (selectedOnly) {
            int end = this.tourFocus_.y;
            int inc = goRight ? -1 : 1;
            int i = useCol;
            while (inc == 1 ? i <= end : i >= end) {
                Integer testCol = i;
                if (this.currColSelections_.contains(testCol)) {
                    NetNode target = this.bfn_.getTargetIDForColumn(testCol, showShadows);
                    NetNode source = this.bfn_.getSourceIDForColumn(testCol, showShadows);
                    if (target != null && source != null && (target.equals(node.getNodeIDWithName()) || source.equals(node.getNodeIDWithName()))) {
                        return this.handleTourStop(useCol, this.tourFocus_.y, testCol, nodeName);
                    }
                }
                i += inc;
            }
        } else {
            Integer testCol = useCol;
            NetNode target = this.bfn_.getTargetIDForColumn(testCol, showShadows);
            NetNode source = this.bfn_.getSourceIDForColumn(testCol, showShadows);
            if (target != null && source != null) {
                return this.handleTourStop(useCol, this.tourFocus_.y, testCol, null);
            }
        }
        return null;
    }

    private SortedSet<Integer> findSelectedLinkStops(NetNode nodeName) {
        TreeSet<Integer> retval = new TreeSet<Integer>();
        boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
        BioFabricNetwork.NodeInfo node = this.bfn_.getNodeDefinition(nodeName);
        MinMax range = node.getColRange(showShadows);
        int start = range.min;
        int end = range.max;
        for (int i = start; i <= end; ++i) {
            Integer testCol = i;
            if (!this.currColSelections_.contains(testCol)) continue;
            NetNode target = this.bfn_.getTargetIDForColumn(testCol, showShadows);
            NetNode source = this.bfn_.getSourceIDForColumn(testCol, showShadows);
            if (target == null || source == null || !target.equals(node.getNodeIDWithName()) && !source.equals(node.getNodeIDWithName())) continue;
            retval.add(testCol);
        }
        return retval;
    }

    public boolean tourStopNowUnselected() {
        if (this.tourFocus_ == null) {
            return false;
        }
        return this.tourStopIsUnselected(this.tourFocus_);
    }

    private boolean tourStopIsUnselected(Point focusPoint) {
        if (focusPoint == null) {
            return false;
        }
        if (this.currColSelections_.isEmpty() && this.currNodeSelections_.isEmpty()) {
            return false;
        }
        Integer rowObj = focusPoint.y;
        Integer colObj = focusPoint.x;
        NetNode nodeName = this.bfn_.getNodeIDForRow(rowObj);
        if (nodeName == null) {
            return false;
        }
        Rectangle2D targName = this.nodeNameLocations_.get(nodeName);
        Point targNameRC = this.worldToRowCol(new Point2D.Double(targName.getCenterX(), targName.getCenterY()));
        boolean onTargName = focusPoint.equals(targNameRC);
        if (onTargName) {
            return !this.currNodeSelections_.contains(nodeName);
        }
        boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
        if (this.bfn_.getLinkDefinition(colObj, showShadows) == null) {
            return false;
        }
        SortedSet<Integer> okStops = this.findSelectedLinkStops(nodeName);
        return !okStops.contains(colObj);
    }

    private TourStatus handleTourStop(int x, int y, Integer col, NetNode selectedOnlyNodeName) {
        this.tourFocus_.setLocation(x, y);
        this.floaterSet_.tourRect = this.buildFocusBox(this.tourFocus_);
        this.handleFloaterChange();
        this.centerOnRectangle(this.floaterSet_.tourRect);
        this.fmt_.setCenter(this.rowColToWorld(this.tourFocus_), this.tourFocus_, true);
        MouseLocInfo vals = this.buildMouseLocation(this.tourFocus_);
        SortedSet<Integer> okStops = selectedOnlyNodeName == null ? null : this.findSelectedLinkStops(selectedOnlyNodeName);
        boolean nodeAlive = selectedOnlyNodeName == null ? true : this.currNodeSelections_.contains(selectedOnlyNodeName);
        boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
        BioFabricNetwork.LinkInfo ld = this.bfn_.getLinkDefinition(col, showShadows);
        if (ld != null && !ld.inLinkRowRange(this.tourFocus_.y)) {
            ld = null;
        }
        return new TourStatus(vals, this.bfn_, ld, this.tourFocus_, okStops, nodeAlive, this.tourStopIsUnselected(this.tourFocus_));
    }

    private TourStatus goUpDown(boolean up, boolean selectedOnly) {
        if (this.tourFocus_.y < 0 || this.tourFocus_.y >= this.bfn_.getRowCount()) {
            return null;
        }
        boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
        Integer useCol = this.tourFocus_.x;
        BioFabricNetwork.LinkInfo link = this.bfn_.getLinkDefinition(useCol, showShadows);
        if (link == null) {
            return null;
        }
        int useX = this.tourFocus_.x;
        int useY = up ? (this.tourFocus_.y > link.getEndRow() ? link.getEndRow() : (this.tourFocus_.y > link.getStartRow() ? link.getStartRow() : link.getEndRow())) : (this.tourFocus_.y < link.getStartRow() ? link.getStartRow() : (this.tourFocus_.y < link.getEndRow() ? link.getEndRow() : link.getStartRow()));
        return this.handleTourStop(useX, useY, useCol, selectedOnly ? this.bfn_.getNodeIDForRow(useY) : null);
    }

    public void setToCollectZoomRect() {
        this.bfw_.disableControls(2, false);
        this.collectingZoomMode_ = true;
        this.firstZoomPoint_ = null;
        this.cursorMgr_.showModeCursor();
    }

    public void setToCollectTourStart(boolean selectionOnly) {
        this.bfw_.disableControls(2, false);
        this.collectingTourStart_ = true;
        this.tourStartSelectionOnly_ = selectionOnly;
        this.cursorMgr_.showModeCursor();
    }

    public void cancelModals() {
        this.collectingZoomMode_ = false;
        this.collectingTourStart_ = false;
        this.tourStartSelectionOnly_ = false;
        this.firstZoomPoint_ = null;
        this.floaterSet_.floater = null;
        this.handleFloaterChange();
        this.cursorMgr_.showDefaultCursor();
        this.bfw_.reenableControls();
    }

    @Override
    public void incrementToNextSelection() {
        this.bumpNextSelection();
    }

    @Override
    public void decrementToPreviousSelection() {
        this.bumpPreviousSelection();
    }

    public void setScroll(JScrollPane jsp) {
        this.jsp_ = jsp;
        this.jsp_.setWheelScrollingEnabled(false);
        this.jsp_.addMouseWheelListener(new MouseWheelListener(){

            public void mouseWheelMoved(MouseWheelEvent e) {
                BioFabricPanel.this.getZoomController().bumpZoomWrapper(e.getWheelRotation() > 0 ? (char)'-' : '+');
            }
        });
    }

    public void changePaint(BTProgressMonitor monitor) throws AsynchExitRequestException {
        if (this.bufferBuilder_ != null) {
            this.bufferBuilder_.release();
        }
        if (this.bfn_ == null) {
            return;
        }
        FabricDisplayOptions fdo = FabricDisplayOptionsManager.getMgr().getDisplayOptions();
        boolean shadeNodes = fdo.getShadeNodes();
        boolean showShadows = fdo.getDisplayShadows();
        BioFabricNetwork.Extents ext = new BioFabricNetwork.Extents(this.bfn_, monitor);
        this.painter_.buildObjCache(this.bfn_.getNodeDefList(), this.bfn_.getLinkDefList(showShadows), shadeNodes, showShadows, ext, new HashMap<NetNode, Rectangle2D>(), new HashMap<NetNode, List<Rectangle2D>>(), this.worldRectNetAR_, this.bfn_.getNodeAnnotations(), this.bfn_.getLinkAnnotations(showShadows), monitor);
        this.handleFloaterChange();
    }

    public void installModel(BioFabricNetwork bfn, BTProgressMonitor monitor) throws AsynchExitRequestException {
        this.bfn_ = bfn;
        FabricDisplayOptions fdo = FabricDisplayOptionsManager.getMgr().getDisplayOptions();
        boolean shadeNodes = fdo.getShadeNodes();
        boolean showShadows = fdo.getDisplayShadows();
        int cols = this.bfn_.getColumnCount(showShadows);
        int rows = this.bfn_.getRowCount();
        double netWidth = cols * 18;
        double netHeight = rows * 18;
        Rectangle2D.Double linksAndNodes = new Rectangle2D.Double(0.0, 0.0, netWidth, netHeight);
        this.nodeNameLocations_ = new HashMap<NetNode, Rectangle2D>();
        this.drainNameLocations_ = new HashMap<NetNode, List<Rectangle2D>>();
        BioFabricNetwork.Extents ext = new BioFabricNetwork.Extents(this.bfn_, monitor);
        Rectangle2D fullNetRect = this.painter_.buildObjCache(this.bfn_.getNodeDefList(), this.bfn_.getLinkDefList(showShadows), shadeNodes, showShadows, ext, this.nodeNameLocations_, this.drainNameLocations_, linksAndNodes, this.bfn_.getNodeAnnotations(), this.bfn_.getLinkAnnotations(showShadows), monitor);
        double ulPtx = 0.2 * fullNetRect.getWidth();
        double ulPty = 0.2 * fullNetRect.getHeight();
        this.worldRectNetAR_ = new Rectangle2D.Double(fullNetRect.getX() - ulPtx, fullNetRect.getY() - ulPty, fullNetRect.getWidth() + 2.0 * ulPtx, fullNetRect.getHeight() + 2.0 * ulPty);
        UiUtil.force2DToGrid(this.worldRectNetAR_, 18.0);
        this.zoomer_.setWorldRect(UiUtil.rectFromRect2D(this.worldRectNetAR_));
        this.bucketRend_.buildBucketCache(this.bfn_.getNodeDefList(), this.bfn_.getLinkDefList(showShadows), this.bfn_.getNodeAnnotations(), this.bfn_.getLinkAnnotations(showShadows), ext, showShadows);
        LoopReporter lr = new LoopReporter(this.drainNameLocations_.size(), 20, monitor, 0.0, 1.0, "progress.drainsToQuad");
        this.forSelections_ = new QuadTree(fullNetRect, 5);
        Iterator<NetNode> kit = this.drainNameLocations_.keySet().iterator();
        int count = 0;
        while (kit.hasNext()) {
            NetNode nid = kit.next();
            lr.report();
            List<Rectangle2D> rects = this.drainNameLocations_.get(nid);
            int numR = rects.size();
            for (int i = 0; i < numR; ++i) {
                String key = Integer.toString(count++);
                QuadTree.Payload pay = new QuadTree.Payload(rects.get(i), key);
                this.forSelections_.insertPayload(pay);
            }
        }
        lr.finish();
        if (this.fnt_ != null) {
            this.fnt_.haveAModel(true);
        }
    }

    public void installModelPost() {
        this.fmt_.setModel(this.bfn_);
        if (this.myPanel_ != null) {
            this.myPanel_.requestFocus();
        }
    }

    public void initZoom() {
        this.getZoomController().zoomToModel(true);
    }

    public Rectangle2D getViewInWorld(JViewport view) {
        Point viewPos = view.getViewPosition();
        Dimension viewDim = view.getExtentSize();
        Point2D vrul = this.viewToWorld(viewPos);
        Point2D vrlr = this.viewToWorld(new Point(viewPos.x + viewDim.width, viewPos.y + viewDim.height));
        Rectangle2D.Double viewInWorld = new Rectangle2D.Double(vrul.getX(), vrul.getY(), vrlr.getX() - vrul.getX(), vrlr.getY() - vrul.getY());
        return viewInWorld;
    }

    public Rectangle2D getViewInWorld() {
        JViewport view = this.jsp_.getViewport();
        return this.getViewInWorld(view);
    }

    public void selectionsToSubmodel() {
        this.transmitSelections(this.targetList_, this.linkList_);
    }

    public void setFullModelViewPos(Point vp) {
        this.fullModelPos_ = vp;
    }

    public void setFullModelExtent(Dimension dim) {
        this.fullModelExtent_ = dim;
    }

    private void drawingGuts(Graphics g, Rectangle2D viewRect) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        AffineTransform saveTrans = g2.getTransform();
        this.clipRect2_.setBounds((int)viewRect.getX(), (int)viewRect.getY(), (int)viewRect.getWidth(), (int)viewRect.getHeight());
        g2.transform(this.zoomer_.getTransform());
        BasicStroke selectedStroke = new BasicStroke(3.0f, 2, 0);
        g2.setStroke(selectedStroke);
        g2.setPaint(Color.WHITE);
        g2.drawRect(this.clipRect2_.x, this.clipRect2_.y, this.clipRect2_.width, this.clipRect2_.height);
        this.painter_.paintIt(g2, this.clipRect2_, null);
        if (!this.targetList_.isEmpty() || !this.linkList_.isEmpty()) {
            g2.setTransform(saveTrans);
            this.drawSelections(g2, this.clipRect2_);
            g2.setTransform(saveTrans);
            g2.transform(this.zoomer_.getTransform());
        }
        this.drawFloater(g2, false);
    }

    private void drawFloater(Graphics2D g2, boolean needInit) {
        if (this.floaterSet_.isEmpty()) {
            return;
        }
        AffineTransform saveTrans = null;
        if (needInit) {
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            saveTrans = g2.getTransform();
            g2.transform(this.zoomer_.getTransform());
        }
        this.painter_.drawFloater(g2, this.floaterSet_);
        if (needInit) {
            g2.setTransform(saveTrans);
        }
    }

    @Override
    public int print(Graphics g, PageFormat pf, int pageIndex) {
        if (pageIndex != 0) {
            return 1;
        }
        double px = pf.getImageableX();
        double py = pf.getImageableY();
        double pw = pf.getImageableWidth();
        double ph = pf.getImageableHeight();
        Rectangle worldPiece = UiUtil.rectFromRect2D(this.worldRectNetAR_);
        double hFrac = (double)worldPiece.height / ph;
        double wFrac = (double)worldPiece.width / pw;
        double frac = 1.0 / (hFrac > wFrac ? hFrac : wFrac);
        AffineTransform trans = new AffineTransform();
        trans.translate(px + pw / 2.0, py + ph / 2.0);
        trans.scale(frac, frac);
        trans.translate(-worldPiece.getCenterX(), -worldPiece.getCenterY());
        Graphics2D g2 = (Graphics2D)g;
        g2.setColor(Color.white);
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        BasicStroke selectedStroke = new BasicStroke(3.0f, 2, 0);
        g2.setStroke(selectedStroke);
        g2.transform(trans);
        g2.fillRect(worldPiece.x, worldPiece.y, worldPiece.width, worldPiece.height);
        this.painter_.paintIt(g2, worldPiece, null);
        return 0;
    }

    @Override
    public boolean drawForBuffer(BufferedImage bi, Rectangle2D clip, Dimension screenDim, Rectangle2D worldRec, int heightPad, double linksPerPixel) {
        Graphics2D g2 = bi.createGraphics();
        g2.setColor(Color.WHITE);
        g2.fillRect(0, 0, screenDim.width, screenDim.height + heightPad);
        double zoomH = screenDim.getWidth() / worldRec.getWidth();
        double zoomV = screenDim.getHeight() / worldRec.getHeight();
        double zoom = Math.max(zoomH, zoomV);
        Point2D.Double centerW = new Point2D.Double(worldRec.getX() + worldRec.getWidth() / 2.0, worldRec.getY() + worldRec.getHeight() / 2.0);
        AffineTransform transform = new AffineTransform();
        transform.translate(screenDim.getWidth() / 2.0, screenDim.getHeight() / 2.0);
        transform.scale(zoom, zoom);
        transform.translate(-((Point2D)centerW).getX(), -((Point2D)centerW).getY());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        BasicStroke selectedStroke = new BasicStroke(3.0f, 2, 0);
        g2.setStroke(selectedStroke);
        g2.setTransform(transform);
        boolean retval = this.painter_.paintIt(g2, UiUtil.rectFromRect2D(clip), null);
        g2.dispose();
        return retval;
    }

    public boolean drawForPrint(Graphics g, Rectangle clip, Dimension screenDim, Rectangle worldRec) {
        Graphics2D g2 = (Graphics2D)g;
        double zoomH = screenDim.getWidth() / worldRec.getWidth();
        double zoomV = screenDim.getHeight() / worldRec.getHeight();
        double zoom = Math.max(zoomH, zoomV);
        Point2D.Double centerW = new Point2D.Double(worldRec.getX() + worldRec.getWidth() / 2.0, worldRec.getY() + worldRec.getHeight() / 2.0);
        AffineTransform transform = new AffineTransform();
        transform.translate(screenDim.getWidth() / 2.0, screenDim.getHeight() / 2.0);
        transform.scale(zoom, zoom);
        transform.translate(-((Point2D)centerW).getX(), -((Point2D)centerW).getY());
        g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        BasicStroke selectedStroke = new BasicStroke(3.0f, 2, 0);
        g2.setStroke(selectedStroke);
        g2.setTransform(transform);
        boolean retval = this.painter_.paintIt(g2, clip, null);
        return retval;
    }

    public void drawSelections(Graphics2D g2, Rectangle clip) {
        FabricDisplayOptions fdo = FabricDisplayOptionsManager.getMgr().getDisplayOptions();
        Rectangle viewRect = this.jsp_.getViewport().getViewRect();
        if (this.bim_ == null || this.bim_.getHeight() != viewRect.height || this.bim_.getWidth() != viewRect.width) {
            this.bim_ = new BufferedImage(viewRect.width, viewRect.height, 6);
        }
        Graphics2D ig2 = this.bim_.createGraphics();
        ig2.setTransform(new AffineTransform());
        Color drawCol = new Color(1.0f, 1.0f, 1.0f, (float)fdo.getSelectionOpaqueLevel());
        ig2.setBackground(drawCol);
        ig2.clearRect(0, 0, viewRect.width, viewRect.height);
        ig2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        ig2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
        BasicStroke selectedStroke = new BasicStroke(3.0f, 2, 0);
        ig2.setStroke(selectedStroke);
        AffineTransform otp = new AffineTransform();
        AffineTransform overTrans = new AffineTransform(this.zoomer_.getTransform());
        otp.translate(-viewRect.getX(), -viewRect.getY());
        overTrans.preConcatenate(otp);
        ig2.setTransform(overTrans);
        ig2.setComposite(AlphaComposite.Src);
        this.painter_.paintIt(ig2, clip, this.selections_);
        g2.drawImage(this.bim_, viewRect.x, viewRect.y, viewRect.width, viewRect.height, null);
    }

    public void zoomToSelected() {
        this.zcs_.zoomToSelected();
    }

    public void zoomToRectangle(Rectangle rect) {
        this.zcs_.zoomToRect(rect);
    }

    public void centerOnSelected() {
        this.zcs_.centerOnSelected();
    }

    public void centerOnRectangle(Rectangle rect) {
        this.zcs_.centerOnRectangle(rect);
    }

    public ZoomCommandSupport getZoomController() {
        return this.zcs_;
    }

    @Override
    public Rectangle getRequiredSize() {
        return UiUtil.rectFromRect2D(this.worldRectNetAR_);
    }

    public Rectangle getWorldScreen() {
        return UiUtil.rectFromRect2D(this.worldRectScreenAR_);
    }

    @Override
    public Rectangle getSelectionSize() {
        int numRect = this.rects_.size();
        if (numRect == 0) {
            return null;
        }
        Rectangle retval = (Rectangle)this.rects_.get(0).clone();
        for (int i = 1; i < numRect; ++i) {
            Rectangle.union(retval, this.rects_.get(i), retval);
        }
        return retval;
    }

    @Override
    public Rectangle getCurrentSelectionSize() {
        if (this.currSel_ == -1) {
            return null;
        }
        return this.rects_.get(this.currSel_);
    }

    @Override
    public boolean haveCurrentSelection() {
        return this.currSel_ != -1;
    }

    @Override
    public boolean haveMultipleSelections() {
        return this.rects_.size() > 1;
    }

    @Override
    public void bumpPreviousSelection() {
        --this.currSel_;
        if (this.currSel_ < 0) {
            this.currSel_ = this.rects_.size() - 1;
        }
        this.bumpGuts();
    }

    @Override
    public void bumpNextSelection() {
        this.currSel_ = (this.currSel_ + 1) % this.rects_.size();
        this.bumpGuts();
    }

    private void bumpGuts() {
        if (this.rects_.isEmpty()) {
            this.fnt_.haveASelection(false);
        } else if (this.currSel_ <= this.rects_.size() - 1) {
            Rectangle rect = this.rects_.get(this.currSel_);
            this.floaterSet_.currSelRect = (Rectangle)rect.clone();
            this.selFocus_ = this.worldToRowCol(new Point2D.Double(this.floaterSet_.currSelRect.getCenterX(), this.floaterSet_.currSelRect.getCenterY()));
            this.fmt_.setCenter(this.rowColToWorld(this.selFocus_), this.selFocus_, true);
            this.fnt_.haveASelection(true);
        }
        this.handleFloaterChange();
    }

    @Override
    public void setPresentationZoomFactor(double zoom) {
    }

    @Override
    public Point pointToViewport(Point world) {
        return this.zoomer_.pointToViewport(world);
    }

    @Override
    public Point2D getRawCenterPoint() {
        return this.zoomer_.getRawCenterPoint();
    }

    @Override
    public Rectangle getSelectedBounds() {
        return this.zoomer_.getSelectedBounds();
    }

    @Override
    public Rectangle getCurrentSelectedBounds() {
        return this.zoomer_.getCurrentSelectedBounds();
    }

    @Override
    public Rectangle getWorldRect() {
        return this.zoomer_.getWorldRect();
    }

    @Override
    public Dimension getPreferredSize() {
        return this.myPanel_.getPreferredSize();
    }

    @Override
    public Dimension getBasicSize() {
        return this.zoomer_.getBasicSize();
    }

    @Override
    public Point2D viewToWorld(Point vPt) {
        return this.zoomer_.viewToWorld(vPt);
    }

    @Override
    public void setZoomFactor(double newZoomVal, Dimension vDim) {
        this.zoomer_.setZoomFactor(newZoomVal, vDim);
    }

    @Override
    public Rectangle getCurrentBasicBounds() {
        return this.zoomer_.getCurrentBasicBounds();
    }

    @Override
    public void adjustWideZoomForSize(Dimension dims) {
        this.zoomer_.adjustWideZoomForSize(dims);
        this.repaint();
    }

    @Override
    public Point getCenterPoint() {
        return this.zoomer_.getCenterPoint();
    }

    @Override
    public double getZoomFactor() {
        return this.zoomer_.getZoomFactor();
    }

    public Point transToRowCol(Point loc) {
        Point2D vrul = this.viewToWorld(loc);
        return this.worldToRowCol(vrul);
    }

    public Point worldToRowCol(Point2D wloc) {
        Point2D retval = (Point2D)wloc.clone();
        UiUtil.forceToGrid(wloc.getX(), wloc.getY(), retval, 18.0);
        return new Point((int)retval.getX() / 18, (int)retval.getY() / 18);
    }

    public Point2D rowColToWorld(Point loc) {
        int col = loc.x * 18;
        int row = loc.y * 18;
        return new Point2D.Double(col, row);
    }

    public Rectangle valsToRect(int sx, int sy, int ex, int ey, boolean convert) {
        int endy;
        int endx;
        int height;
        int width;
        int y;
        int x;
        if (convert) {
            Point locs = new Point(sx, sy);
            Point spt = this.transToRowCol(locs);
            Point loce = new Point(ex, ey);
            Point ept = this.transToRowCol(loce);
            Point2D.Double start = new Point2D.Double(spt.x, spt.y);
            Point2D.Double end = new Point2D.Double(ept.x, ept.y);
            x = (int)((Point2D)start).getX();
            y = (int)((Point2D)start).getY();
            width = (int)((Point2D)end).getX() - x;
            height = (int)((Point2D)end).getY() - y;
            endx = (int)((Point2D)end).getX();
            endy = (int)((Point2D)end).getY();
        } else {
            x = sx;
            y = sy;
            width = ex - sx;
            height = ey - sy;
            endx = ex;
            endy = ey;
        }
        if (width != 0 && height != 0) {
            int rh;
            int ry;
            int rw;
            int rx;
            if (width < 0) {
                rx = endx;
                rw = -width;
            } else {
                rx = x;
                rw = width;
            }
            if (height < 0) {
                ry = endy;
                rh = -height;
            } else {
                ry = y;
                rh = height;
            }
            return new Rectangle(rx, ry, rw, rh);
        }
        return null;
    }

    MouseLocInfo buildMouseLocation(Point cprc) {
        BioFabricNetwork.LinkInfo li;
        MouseLocInfo retval = new MouseLocInfo();
        Integer colObj = cprc.x;
        Integer rowObj = cprc.y;
        NetNode target = this.bfn_.getNodeIDForRow(rowObj);
        boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
        NetNode src = this.bfn_.getSourceIDForColumn(colObj, showShadows);
        NetNode trg = this.bfn_.getTargetIDForColumn(colObj, showShadows);
        NetNode drain = this.bfn_.getDrainForColumn(colObj, showShadows);
        retval.nodeAnnotations.clear();
        AnnotationSet ansn = this.bfn_.getNodeAnnotations();
        if (ansn != null) {
            AnnotationSetImpl.AnnotsForPosImpl a4pn = new AnnotationSetImpl.AnnotsForPosImpl();
            ansn.fillAnnots(a4pn, rowObj);
            a4pn.displayStrings(retval.nodeAnnotations);
        }
        retval.linkAnnotations.clear();
        AnnotationSet ansl = this.bfn_.getLinkAnnotations(showShadows);
        if (ansl != null) {
            AnnotationSetImpl.AnnotsForPosImpl a4pl = new AnnotationSetImpl.AnnotsForPosImpl();
            ansl.fillAnnots(a4pl, colObj);
            a4pl.displayStrings(retval.linkAnnotations);
        }
        int numRows = this.bfn_.getRowCount();
        if (target != null) {
            BioFabricNetwork.NodeInfo ni = this.bfn_.getNodeDefinition(target);
            MinMax nimm = ni.getColRange(showShadows);
            if (nimm.min <= cprc.x && nimm.max >= cprc.x) {
                retval.nodeDesc = target.getName();
            } else {
                Rectangle2D nnl = this.nodeNameLocations_.get(target);
                Point2D inWorld = this.rowColToWorld(cprc);
                UiUtil.fixMePrintout("zigg.sif plus zigg.noa see null ptr here *on mouse move during node-attribute relayout??*");
                if (nnl == null || inWorld == null) {
                    System.err.println("nnl " + nnl + " iw " + inWorld);
                    Thread.dumpStack();
                } else if (nnl.contains(inWorld)) {
                    retval.nodeDesc = target.getName();
                }
            }
        }
        if (src != null && trg != null && (li = this.bfn_.getLinkDefinition(colObj, showShadows)) != null) {
            int minRow = li.topRow();
            int maxRow = li.bottomRow();
            if (minRow <= cprc.y && maxRow >= cprc.y) {
                FabricLink flink = li.getLink();
                retval.linkDesc = flink.toDisplayString();
                retval.linkSrcDesc = flink.getSrcNode().getName();
                retval.linkTrgDesc = flink.getTrgNode().getName();
            }
        }
        if (drain != null && 0 <= cprc.x && numRows >= cprc.y) {
            retval.zoneDesc = drain.getName();
        }
        return retval;
    }

    public void selectionLogicPoint(Point rcbp, Point sloc, boolean showShadows, Set<NetNode> nodes, Set<FabricLink> links, Set<Integer> cols, boolean shiftPressed) {
        BioFabricNetwork.LinkInfo linf;
        if (this.nodeNameLocations_ == null || this.drainNameLocations_ == null) {
            return;
        }
        MinMax colRange = null;
        MinMax nodeRange = null;
        if (shiftPressed) {
            colRange = new MinMax();
            colRange.init();
            nodeRange = new MinMax();
            nodeRange.init();
            for (Integer col : cols) {
                colRange.update(col);
            }
            for (NetNode node : nodes) {
                int row = this.bfn_.getNodeDefinition((NetNode)node).nodeRow;
                nodeRange.update(row);
            }
        }
        int row = rcbp.y;
        int col = rcbp.x;
        boolean nodeAdd = false;
        boolean linkAdd = false;
        NetNode gotDrain = null;
        Point2D worldPt = this.viewToWorld(sloc);
        block2: for (NetNode target : this.drainNameLocations_.keySet()) {
            List<Rectangle2D> nameLocs = this.drainNameLocations_.get(target);
            for (Rectangle2D zone : nameLocs) {
                if (!zone.contains(worldPt)) continue;
                gotDrain = target;
                continue block2;
            }
        }
        HashSet<String> foundKeys = new HashSet<String>();
        this.forSelections_.getPayloadKeys(worldPt, foundKeys);
        UiUtil.fixMePrintout("READ ME FOR NEW POLICY");
        boolean gotLink = false;
        Integer rowObj = row;
        NetNode target = this.bfn_.getNodeIDForRow(rowObj);
        Integer colObj = col;
        if (target != null && gotDrain == null) {
            BioFabricNetwork.NodeInfo tni = this.bfn_.getNodeDefinition(target);
            MinMax range = tni.getColRange(showShadows);
            if (col >= range.min && col <= range.max) {
                if (nodes.contains(target)) {
                    nodes.remove(target);
                } else {
                    if (nodeRange != null) {
                        nodeRange.update(row);
                    }
                    nodes.add(target);
                    nodeAdd = true;
                }
            } else {
                Point2D worldPt2 = this.rowColToWorld(new Point(col, row));
                Rectangle2D nameLoc = this.nodeNameLocations_.get(target);
                if (nameLoc.contains(worldPt2)) {
                    if (nodes.contains(target)) {
                        nodes.remove(target);
                    } else {
                        if (nodeRange != null) {
                            nodeRange.update(row);
                        }
                        nodes.add(target);
                        nodeAdd = true;
                    }
                }
            }
        }
        if ((linf = this.bfn_.getLinkDefinition(colObj, showShadows)) != null && (rowObj.intValue() == linf.getStartRow() || rowObj.intValue() == linf.getEndRow())) {
            boolean removeIt = false;
            if (cols.contains(colObj)) {
                cols.remove(colObj);
                removeIt = true;
            } else {
                if (colRange != null) {
                    colRange.update(col);
                }
                cols.add(colObj);
            }
            NetNode src = this.bfn_.getSourceIDForColumn(colObj, showShadows);
            NetNode trg = this.bfn_.getTargetIDForColumn(colObj, showShadows);
            if (removeIt) {
                links.remove(linf.getLink());
            } else {
                links.add(linf.getLink().clone());
                nodes.add(src);
                nodes.add(trg);
            }
            gotLink = true;
        }
        if (!gotLink && gotDrain != null) {
            if (nodes.contains(gotDrain)) {
                nodes.remove(gotDrain);
            } else {
                if (nodeRange != null) {
                    int row2 = this.bfn_.getNodeDefinition((NetNode)gotDrain).nodeRow;
                    nodeRange.update(row2);
                }
                nodes.add(gotDrain);
                nodeAdd = true;
            }
        }
        if (shiftPressed) {
            if (linkAdd && colRange.min != Integer.MAX_VALUE) {
                for (int i = colRange.min; i < colRange.max; ++i) {
                    Integer colObj2 = i;
                    cols.add(colObj2);
                    NetNode src = this.bfn_.getSourceIDForColumn(colObj2, showShadows);
                    NetNode trg = this.bfn_.getTargetIDForColumn(colObj2, showShadows);
                    BioFabricNetwork.LinkInfo linf2 = this.bfn_.getLinkDefinition(colObj2, showShadows);
                    links.add(linf2.getLink().clone());
                    nodes.add(src);
                    nodes.add(trg);
                }
            }
            if (nodeAdd && nodeRange.min != Integer.MAX_VALUE) {
                for (int i = nodeRange.min; i < nodeRange.max; ++i) {
                    Integer rowObj2 = i;
                    NetNode target2 = this.bfn_.getNodeIDForRow(rowObj2);
                    nodes.add(target2);
                }
            }
        }
    }

    public void selectionLogicRect(Rectangle rect, boolean showShadows, Set<NetNode> nodes, Set<FabricLink> links, Set<Integer> cols) {
        if (this.nodeNameLocations_ == null || this.drainNameLocations_ == null) {
            return;
        }
        int startRow = rect.y;
        int endRow = rect.y + rect.height;
        int startCol = rect.x;
        int endCol = rect.x + rect.width;
        UiUtil.fixMePrintout("READ ME FOR NEW POLICY");
        for (int col = startCol; col <= endCol; ++col) {
            boolean endOK;
            Integer colObj = col;
            BioFabricNetwork.LinkInfo linf = this.bfn_.getLinkDefinition(colObj, showShadows);
            if (linf == null) continue;
            int lstart = linf.getStartRow();
            int lend = linf.getEndRow();
            boolean startOK = lstart >= startRow && lstart <= endRow;
            boolean bl = endOK = lend >= startRow && lend <= endRow;
            if (!startOK && !endOK) continue;
            cols.add(colObj);
            NetNode src = this.bfn_.getSourceIDForColumn(colObj, showShadows);
            NetNode trg = this.bfn_.getTargetIDForColumn(colObj, showShadows);
            links.add(linf.getLink().clone());
            nodes.add(src);
            nodes.add(trg);
        }
    }

    public void buildSelectionGeometry(NetNode newStartName, Rectangle newStartRect) {
        Point focus = new Point();
        boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
        this.targetList_.clear();
        TreeMap<Integer, Rectangle> sortTargs = new TreeMap<Integer, Rectangle>();
        for (NetNode target : this.currNodeSelections_) {
            BioFabricNetwork.NodeInfo targetInf = this.bfn_.getNodeDefinition(target);
            this.targetList_.add(targetInf);
            Rectangle2D targName = this.nodeNameLocations_.get(target);
            Point targNameRC = this.worldToRowCol(new Point2D.Double(targName.getCenterX(), targName.getCenterY()));
            focus.setLocation(targNameRC.x, targetInf.nodeRow);
            sortTargs.put(targetInf.nodeRow, this.buildFocusBox(focus));
        }
        HashMap linksByRow = new HashMap();
        this.linkList_.clear();
        for (Integer colObj : this.currColSelections_) {
            BioFabricNetwork.LinkInfo linf = this.bfn_.getLinkDefinition(colObj, showShadows);
            this.linkList_.add(linf);
            Integer strtObj = linf.getStartRow();
            SortedMap<Integer, Rectangle> lbr = (TreeMap<Integer, Rectangle>)linksByRow.get(strtObj);
            if (lbr == null) {
                lbr = new TreeMap<Integer, Rectangle>();
                linksByRow.put(strtObj, lbr);
            }
            focus.setLocation(linf.getUseColumn(showShadows), linf.getStartRow());
            lbr.put(colObj, this.buildFocusBox(focus));
            Integer endObj = linf.getEndRow();
            lbr = (SortedMap)linksByRow.get(endObj);
            if (lbr == null) {
                lbr = new TreeMap();
                linksByRow.put(endObj, lbr);
            }
            focus.setLocation(linf.getUseColumn(showShadows), linf.getEndRow());
            lbr.put(colObj, this.buildFocusBox(focus));
        }
        Rectangle currRect = this.currSel_ == -1 || this.currSel_ >= this.rects_.size() ? null : this.rects_.get(this.currSel_);
        this.rects_.clear();
        for (Integer row : sortTargs.keySet()) {
            Rectangle trgRect = (Rectangle)sortTargs.get(row);
            if (trgRect.equals(currRect)) {
                this.currSel_ = this.rects_.size();
            } else if (newStartName != null && newStartName.equals(this.bfn_.getNodeIDForRow(row))) {
                this.currSel_ = this.rects_.size();
            }
            this.rects_.add(trgRect);
            SortedMap ufr = (SortedMap)linksByRow.get(row);
            if (ufr == null) continue;
            this.rects_.addAll(ufr.values());
        }
        if (newStartName == null) {
            if (newStartRect != null) {
                this.resetCurrentSelection(newStartRect);
            } else if (currRect != null) {
                this.resetCurrentSelection(currRect);
            }
        }
        if (this.rects_.size() > 0 && this.currSel_ == -1) {
            this.currSel_ = 0;
        }
        this.bumpGuts();
        this.handleFloaterChange();
        UiUtil.fixMePrintout("This has gotta change");
        HashSet<Integer> targRows = new HashSet<Integer>();
        HashSet<Integer> targCols = new HashSet<Integer>(this.currColSelections_);
        HashSet<NID> targIDs = new HashSet<NID>();
        int numTarg = this.targetList_.size();
        for (int i = 0; i < numTarg; ++i) {
            BioFabricNetwork.NodeInfo targetInf = this.targetList_.get(i);
            targRows.add(targetInf.nodeRow);
            targIDs.add(targetInf.getNodeID());
        }
        this.selections_ = new PaintCacheSmall.Reduction(targRows, targCols, targIDs);
        this.fmt_.setSelections(this.selections_);
        EventManager mgr = EventManager.getManager();
        SelectionChangeEvent ev = new SelectionChangeEvent(null, null, 3);
        mgr.sendSelectionChangeEvent(ev);
    }

    private void resetCurrentSelection(Rectangle newStart) {
        int numRect = this.rects_.size();
        for (int i = 0; i < numRect; ++i) {
            Rectangle trgRect = this.rects_.get(i);
            if (!trgRect.equals(newStart)) continue;
            this.currSel_ = i;
        }
    }

    public void exportToFile(File saveFile, String format, ImageExporter.ResolutionSettings res, double zoom, Dimension size) throws IOException {
        this.exportGuts(saveFile, format, res, zoom, size);
    }

    public void exportToStream(OutputStream stream, String format, ImageExporter.ResolutionSettings res, double zoom, Dimension size) throws IOException {
        this.exportGuts(stream, format, res, zoom, size);
    }

    private void exportGuts(Object outObj, String format, ImageExporter.ResolutionSettings res, double zoom, Dimension size) throws IOException {
        Rectangle worldPiece = UiUtil.rectFromRect2D(this.worldRectNetAR_);
        Dimension useSize = size == null ? new Dimension((int)((double)worldPiece.width * zoom), (int)((double)worldPiece.height * zoom)) : size;
        BufferedImage bi = new BufferedImage(useSize.width, useSize.height, 1);
        this.drawForBuffer(bi, worldPiece, useSize, worldPiece, 0, 0.0);
        ImageExporter iex = new ImageExporter();
        iex.export(outObj, bi, format, res);
    }

    public TourStatus startTourFromSelection(boolean selectionOnly) {
        if (this.currSel_ == -1 || this.floaterSet_.currSelRect == null) {
            throw new IllegalStateException();
        }
        this.floaterSet_.tourRect = (Rectangle)this.floaterSet_.currSelRect.clone();
        this.tourFocus_ = this.worldToRowCol(new Point2D.Double(this.floaterSet_.tourRect.getCenterX(), this.floaterSet_.tourRect.getCenterY()));
        this.centerOnRectangle(this.floaterSet_.tourRect);
        this.fmt_.setCenter(this.rowColToWorld(this.tourFocus_), this.tourFocus_, true);
        MouseLocInfo vals = this.buildMouseLocation(this.tourFocus_);
        this.handleFloaterChange();
        boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
        Integer tfx = this.tourFocus_.x;
        BioFabricNetwork.LinkInfo ld = this.bfn_.getLinkDefinition(tfx, showShadows);
        if (ld != null && !ld.inLinkRowRange(this.tourFocus_.y)) {
            ld = null;
        }
        NetNode nodeForRow = this.bfn_.getNodeIDForRow(this.tourFocus_.y);
        SortedSet<Integer> okStops = selectionOnly ? null : this.findSelectedLinkStops(nodeForRow);
        boolean nodeAlive = !selectionOnly ? true : this.currNodeSelections_.contains(nodeForRow);
        return new TourStatus(vals, this.bfn_, ld, this.tourFocus_, okStops, nodeAlive, false);
    }

    private Point findClosestTourStart(Point prtc, int limit) {
        int start = prtc.x - limit;
        int end = prtc.x + limit;
        int minY = prtc.y - limit;
        int maxY = prtc.y + limit;
        boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
        Point2D.Double forVec = new Point2D.Double(prtc.x, prtc.y);
        double minDist = Double.POSITIVE_INFINITY;
        Point closestRC = new Point();
        for (int i = start; i <= end; ++i) {
            Point2D.Double testPt;
            double dSq;
            Integer testCol = i;
            BioFabricNetwork.LinkInfo linf = this.bfn_.getLinkDefinition(testCol, showShadows);
            if (linf == null) continue;
            if (linf.getStartRow() >= minY && linf.getStartRow() <= maxY && (dSq = forVec.distanceSq(testPt = new Point2D.Double(i, linf.getStartRow()))) < minDist) {
                minDist = dSq;
                closestRC.setLocation(i, linf.getStartRow());
            }
            if (linf.getEndRow() < minY || linf.getEndRow() > maxY || !((dSq = forVec.distanceSq(testPt = new Point2D.Double(i, linf.getEndRow()))) < minDist)) continue;
            minDist = dSq;
            closestRC.setLocation(i, linf.getEndRow());
        }
        Point2D inWorldL = this.rowColToWorld(new Point(prtc.x - limit, prtc.y));
        Point2D inWorldR = this.rowColToWorld(new Point(prtc.x + limit, prtc.y));
        for (int i = minY; i <= maxY; ++i) {
            Rectangle2D nnl;
            Point2D.Double nameCenter;
            Integer testRow = i;
            NetNode nodeName = this.bfn_.getNodeIDForRow(testRow);
            if (nodeName == null || !(((Point2D)(nameCenter = new Point2D.Double((nnl = this.nodeNameLocations_.get(nodeName)).getCenterX(), nnl.getCenterY()))).getX() >= inWorldL.getX()) || !(((Point2D)nameCenter).getX() <= inWorldR.getX())) continue;
            Point ncRC = this.worldToRowCol(nameCenter);
            double dSq = forVec.distanceSq(new Point2D.Double(((Point2D)forVec).getX(), ((Point2D)ncRC).getY()));
            if (!(dSq < minDist)) continue;
            minDist = dSq;
            closestRC.setLocation((int)((Point2D)ncRC).getX(), i);
        }
        return minDist < Double.POSITIVE_INFINITY ? closestRC : null;
    }

    public class MyPaintPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public Dimension getPreferredSize() {
            return BioFabricPanel.this.zoomer_.getPreferredSize();
        }

        public void print(Graphics g) {
            if (BioFabricPanel.this.bfn_ == null) {
                return;
            }
            Rectangle2D viewInWorld = BioFabricPanel.this.getViewInWorld();
            Graphics2D g2 = (Graphics2D)g;
            BioFabricPanel.this.drawingGuts(g2, viewInWorld);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            for (BufferedImage bi : BioFabricPanel.this.staleImages_) {
                BioFabricPanel.this.bis_.returnImage(bi);
            }
            BioFabricPanel.this.staleImages_.clear();
            if (BioFabricPanel.this.bfn_ == null) {
                return;
            }
            Double zoomVal = BioFabricPanel.this.zoomer_.getZoomFactor();
            Rectangle2D viewInWorld = BioFabricPanel.this.getViewInWorld();
            Integer numObj = (Integer)BioFabricPanel.this.zoomMap_.get(zoomVal);
            boolean wideCase = false;
            if (zoomVal < (Double)BioFabricPanel.this.zoomMap_.firstKey() && BioFabricPanel.this.bufferBuilder_ != null) {
                numObj = 0;
                wideCase = true;
            } else if (numObj == null || BioFabricPanel.this.bufferBuilder_ == null) {
                Graphics2D g2 = (Graphics2D)g;
                BioFabricPanel.this.drawingGuts(g2, viewInWorld);
                return;
            }
            ArrayList<ImageToUse> imagesToUse = new ArrayList<ImageToUse>();
            UiUtil.fixMePrintout("implement the above??");
            ArrayList<Rectangle2D> slicesToCover = new ArrayList<Rectangle2D>();
            BioFabricPanel.this.bufferBuilder_.getSlicesToCover(numObj, viewInWorld, slicesToCover);
            int numSlice = slicesToCover.size();
            AffineTransform wideTrans = null;
            for (int i = 0; i < numSlice; ++i) {
                Rectangle2D worldRect = slicesToCover.get(i);
                BufferedImage img = null;
                try {
                    img = BioFabricPanel.this.bufferBuilder_.getImageForPiece(numObj, worldRect);
                }
                catch (IOException ioex) {
                    System.err.println("Bad load");
                }
                if (img == null) continue;
                Point wtv = BioFabricPanel.this.pointToViewport(new Point((int)Math.round(worldRect.getX()), (int)Math.round(worldRect.getY())));
                int stX = wtv.x;
                int stY = wtv.y;
                if (wideCase) {
                    wideTrans = new AffineTransform();
                    double fkz = (Double)BioFabricPanel.this.zoomMap_.firstKey();
                    double zf = BioFabricPanel.this.zoomer_.getZoomFactor();
                    double izoom = zf / fkz;
                    JViewport view = BioFabricPanel.this.jsp_.getViewport();
                    Dimension viewDim = view.getViewSize();
                    wideTrans.translate(viewDim.getWidth() / 2.0, viewDim.getHeight() / 2.0);
                    wideTrans.scale(izoom, izoom);
                    UiUtil.fixMePrintout("Scaling image " + izoom);
                    wideTrans.translate((double)(-img.getWidth()) / 2.0, (double)(-img.getHeight()) / 2.0);
                    stX = 0;
                    stY = 0;
                }
                ImageToUse itu = new ImageToUse(img, stX, stY);
                imagesToUse.add(itu);
            }
            if (imagesToUse.isEmpty()) {
                return;
            }
            Graphics2D g2p = (Graphics2D)g;
            for (ImageToUse it : imagesToUse) {
                if (it.image == null) continue;
                int useX = it.stX;
                int useY = it.stY;
                AffineTransform stash = null;
                if (wideTrans != null) {
                    stash = g2p.getTransform();
                    g2p.transform(wideTrans);
                }
                g2p.drawImage((Image)it.image, useX, useY, null);
                if (stash == null) continue;
                g2p.setTransform(stash);
                BioFabricPanel.this.staleImages_.add(it.image);
            }
            BioFabricPanel.this.clipRect_.setBounds((int)viewInWorld.getX(), (int)viewInWorld.getY(), (int)viewInWorld.getWidth(), (int)viewInWorld.getHeight());
            if (!BioFabricPanel.this.targetList_.isEmpty() || !BioFabricPanel.this.linkList_.isEmpty()) {
                BioFabricPanel.this.drawSelections(g2p, BioFabricPanel.this.clipRect_);
            }
            BioFabricPanel.this.drawFloater(g2p, true);
            g.dispose();
        }
    }

    public class MouseMotionHandler
    extends MouseMotionAdapter {
        public void mouseDragged(MouseEvent me) {
            try {
                if (BioFabricPanel.this.lastPress_ == null) {
                    return;
                }
                Point currPt = me.getPoint();
                if (me.isControlDown() || BioFabricPanel.this.isAMac_ && me.isMetaDown()) {
                    Point2D lpw = BioFabricPanel.this.viewToWorld(BioFabricPanel.this.lastPress_);
                    Point2D cupw = BioFabricPanel.this.viewToWorld(currPt);
                    ((BioFabricPanel)BioFabricPanel.this).floaterSet_.floater = BioFabricPanel.this.valsToRect((int)lpw.getX(), (int)lpw.getY(), (int)cupw.getX(), (int)cupw.getY(), false);
                    BioFabricPanel.this.handleFloaterChange();
                } else if (BioFabricPanel.this.collectingZoomMode_) {
                    ((BioFabricPanel)BioFabricPanel.this).floaterSet_.floater = null;
                    BioFabricPanel.this.handleFloaterChange();
                } else {
                    Point compLoc = me.getComponent().getLocationOnScreen();
                    Point currAbs = new Point(compLoc.x + currPt.x, compLoc.y + currPt.y);
                    JScrollBar hsb = BioFabricPanel.this.jsp_.getHorizontalScrollBar();
                    int hMax = hsb.getMaximum() - hsb.getVisibleAmount();
                    int hMin = hsb.getMinimum();
                    int newX = ((BioFabricPanel)BioFabricPanel.this).lastView_.x - (currAbs.x - ((BioFabricPanel)BioFabricPanel.this).lastAbs_.x);
                    if (newX > hMax) {
                        newX = hMax;
                    }
                    if (newX < hMin) {
                        newX = hMin;
                    }
                    JScrollBar vsb = BioFabricPanel.this.jsp_.getVerticalScrollBar();
                    int vMax = vsb.getMaximum() - vsb.getVisibleAmount();
                    int vMin = vsb.getMinimum();
                    int newY = ((BioFabricPanel)BioFabricPanel.this).lastView_.y - (currAbs.y - ((BioFabricPanel)BioFabricPanel.this).lastAbs_.y);
                    if (newY > vMax) {
                        newY = vMax;
                    }
                    if (newY < vMin) {
                        newY = vMin;
                    }
                    BioFabricPanel.this.jsp_.getViewport().setViewPosition(new Point(newX, newY));
                    BioFabricPanel.this.jsp_.getViewport().invalidate();
                    BioFabricPanel.this.jsp_.revalidate();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void mouseMoved(MouseEvent me) {
            try {
                Point currPt = me.getPoint();
                Point2D cpw = BioFabricPanel.this.viewToWorld(currPt);
                Point cprc = BioFabricPanel.this.worldToRowCol(cpw);
                BioFabricPanel.this.fmt_.setCenter(cpw, cprc, false);
                BioFabricPanel.this.bfo_.setMouse(cpw, cprc);
                if (BioFabricPanel.this.bfn_ == null) {
                    return;
                }
                MouseLocInfo vals = BioFabricPanel.this.buildMouseLocation(cprc);
                BioFabricPanel.this.myLocation_.setNodeAndLink(vals);
                BioFabricPanel.this.mov_.showForNode(vals);
                if (BioFabricPanel.this.collectingZoomMode_ && BioFabricPanel.this.firstZoomPoint_ != null) {
                    Point2D lpw = BioFabricPanel.this.viewToWorld(BioFabricPanel.this.firstZoomPoint_);
                    Point2D cupw = BioFabricPanel.this.viewToWorld(currPt);
                    ((BioFabricPanel)BioFabricPanel.this).floaterSet_.floater = BioFabricPanel.this.valsToRect((int)lpw.getX(), (int)lpw.getY(), (int)cupw.getX(), (int)cupw.getY(), false);
                    BioFabricPanel.this.handleFloaterChange();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public class MouseHandler
    extends MouseAdapter {
        private static final int CLICK_SLOP_ = 2;

        public void mouseClicked(MouseEvent me) {
            if (me.isPopupTrigger()) {
                Point pscreenLoc = me.getComponent().getLocationOnScreen();
                Point abs = new Point(me.getX() + pscreenLoc.x, me.getY() + pscreenLoc.y);
                this.triggerPopup(me.getX(), me.getY(), abs);
            }
        }

        private void handleClick(int lastX, int lastY, boolean shiftPressed) {
            Point loc = new Point(lastX, lastY);
            Point rcp = BioFabricPanel.this.transToRowCol(loc);
            this.handleSelection(rcp, null, loc, true, shiftPressed);
        }

        private void handleSelection(Point rcbp, Rectangle rect, Point sloc, boolean onePt, boolean shiftPressed) {
            Rectangle newStart;
            if (BioFabricPanel.this.bfn_ == null) {
                return;
            }
            boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
            if (BioFabricPanel.this.collectingTourStart_) {
                boolean tstatUS = false;
                boolean forSelOnly = BioFabricPanel.this.tourStartSelectionOnly_;
                if (rcbp != null) {
                    Point newFocus = BioFabricPanel.this.findClosestTourStart(rcbp, 3);
                    if (newFocus == null) {
                        BioFabricPanel.this.cursorMgr_.signalError();
                        return;
                    }
                    if (BioFabricPanel.this.tourStopIsUnselected(newFocus)) {
                        tstatUS = true;
                        forSelOnly = false;
                        BioFabricPanel.this.fnt_.resetSkipSelections();
                    }
                    BioFabricPanel.this.tourFocus_ = newFocus;
                    ((BioFabricPanel)BioFabricPanel.this).floaterSet_.tourRect = BioFabricPanel.this.buildFocusBox(BioFabricPanel.this.tourFocus_);
                    MouseLocInfo loc = BioFabricPanel.this.buildMouseLocation(BioFabricPanel.this.tourFocus_);
                    BioFabricNetwork.LinkInfo linf = BioFabricPanel.this.bfn_.getLinkDefinition(((BioFabricPanel)BioFabricPanel.this).tourFocus_.x, showShadows);
                    if (linf != null && !linf.inLinkRowRange(((BioFabricPanel)BioFabricPanel.this).tourFocus_.y)) {
                        linf = null;
                    }
                    NetNode nodeForRow = BioFabricPanel.this.bfn_.getNodeIDForRow(((BioFabricPanel)BioFabricPanel.this).tourFocus_.y);
                    SortedSet okStops = forSelOnly ? BioFabricPanel.this.findSelectedLinkStops(nodeForRow) : null;
                    boolean nodeAlive = !forSelOnly ? true : BioFabricPanel.this.currNodeSelections_.contains(nodeForRow);
                    BioFabricPanel.this.fnt_.installNames(new TourStatus(loc, BioFabricPanel.this.bfn_, linf, BioFabricPanel.this.tourFocus_, okStops, nodeAlive, tstatUS));
                }
                BioFabricPanel.this.collectingTourStart_ = false;
                BioFabricPanel.this.tourStartSelectionOnly_ = false;
                BioFabricPanel.this.cursorMgr_.showDefaultCursor();
                BioFabricPanel.this.bfw_.reenableControls();
                return;
            }
            if (BioFabricPanel.this.collectingZoomMode_) {
                if (BioFabricPanel.this.firstZoomPoint_ == null) {
                    BioFabricPanel.this.firstZoomPoint_ = (Point)sloc.clone();
                    return;
                }
                Rectangle rcRect = BioFabricPanel.this.valsToRect(((BioFabricPanel)BioFabricPanel.this).firstZoomPoint_.x, ((BioFabricPanel)BioFabricPanel.this).firstZoomPoint_.y, sloc.x, sloc.y, false);
                if (rcRect == null) {
                    return;
                }
                Point2D lpu = BioFabricPanel.this.viewToWorld(new Point(rcRect.x, rcRect.y));
                Point2D rpl = BioFabricPanel.this.viewToWorld(new Point((int)rcRect.getMaxX(), (int)rcRect.getMaxY()));
                Rectangle zoomTo = new Rectangle((int)lpu.getX(), (int)lpu.getY(), (int)(rpl.getX() - lpu.getX()), (int)(rpl.getY() - lpu.getY()));
                if (zoomTo.width > 0 && zoomTo.height > 0) {
                    BioFabricPanel.this.zoomToRectangle(zoomTo);
                }
                BioFabricPanel.this.collectingZoomMode_ = false;
                BioFabricPanel.this.firstZoomPoint_ = null;
                BioFabricPanel.this.cursorMgr_.showDefaultCursor();
                BioFabricPanel.this.bfw_.reenableControls();
                return;
            }
            if (!BioFabricPanel.this.doBuildSelect_) {
                BioFabricPanel.this.currLinkSelections_.clear();
                BioFabricPanel.this.currNodeSelections_.clear();
                BioFabricPanel.this.currColSelections_.clear();
                BioFabricPanel.this.fmt_.setSelections(null);
                BioFabricPanel.this.currSel_ = -1;
                ((BioFabricPanel)BioFabricPanel.this).floaterSet_.currSelRect = null;
            }
            if (onePt) {
                newStart = BioFabricPanel.this.buildFocusBox(rcbp);
                BioFabricPanel.this.selectionLogicPoint(rcbp, sloc, showShadows, BioFabricPanel.this.currNodeSelections_, BioFabricPanel.this.currLinkSelections_, BioFabricPanel.this.currColSelections_, shiftPressed);
            } else {
                newStart = null;
                BioFabricPanel.this.selectionLogicRect(rect, showShadows, BioFabricPanel.this.currNodeSelections_, BioFabricPanel.this.currLinkSelections_, BioFabricPanel.this.currColSelections_);
            }
            BioFabricPanel.this.buildSelectionGeometry(null, newStart);
        }

        private void dragResult(int sx, int sy, int ex, int ey, boolean isCtrl) {
            if (!isCtrl) {
                return;
            }
            if (BioFabricPanel.this.collectingZoomMode_) {
                BioFabricPanel.this.collectingZoomMode_ = false;
                BioFabricPanel.this.cursorMgr_.showDefaultCursor();
                BioFabricPanel.this.bfw_.reenableControls();
                return;
            }
            if (BioFabricPanel.this.collectingTourStart_) {
                BioFabricPanel.this.collectingTourStart_ = false;
                BioFabricPanel.this.tourStartSelectionOnly_ = false;
                BioFabricPanel.this.cursorMgr_.showDefaultCursor();
                BioFabricPanel.this.bfw_.reenableControls();
                return;
            }
            Rectangle rcRect = BioFabricPanel.this.valsToRect(sx, sy, ex, ey, true);
            if (rcRect != null) {
                this.handleSelection(null, rcRect, null, false, false);
            }
        }

        public void mousePressed(MouseEvent me) {
            try {
                if (me.isPopupTrigger()) {
                    Point pscreenLoc = me.getComponent().getLocationOnScreen();
                    Point abs = new Point(me.getX() + pscreenLoc.x, me.getY() + pscreenLoc.y);
                    this.triggerPopup(me.getX(), me.getY(), abs);
                } else {
                    BioFabricPanel.this.lastPress_ = new Point(me.getX(), me.getY());
                    BioFabricPanel.this.lastView_ = BioFabricPanel.this.jsp_.getViewport().getViewPosition();
                    Point screenLoc = me.getComponent().getLocationOnScreen();
                    BioFabricPanel.this.lastAbs_ = new Point(me.getX() + screenLoc.x, me.getY() + screenLoc.y);
                    BioFabricPanel.this.lastShifted_ = me.isShiftDown();
                    BioFabricPanel.this.lastCtrl_ = me.isControlDown() || BioFabricPanel.this.isAMac_ && me.isMetaDown();
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void mouseEntered(MouseEvent me) {
            try {
                BioFabricPanel.this.bfo_.setMouseIn(true, BioFabricPanel.this.fmt_.isIgnoring());
                BioFabricPanel.this.fmt_.setMouseIn(true);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void mouseExited(MouseEvent me) {
            try {
                BioFabricPanel.this.bfo_.setMouseIn(false, BioFabricPanel.this.fmt_.isIgnoring());
                BioFabricPanel.this.fmt_.setMouseIn(false);
                BioFabricPanel.this.myLocation_.setNodeAndLink(new MouseLocInfo());
                BioFabricPanel.this.mov_.showForNode(new MouseLocInfo());
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void mouseReleased(MouseEvent me) {
            try {
                Point screenLoc = me.getComponent().getLocationOnScreen();
                Point newAbs = new Point(me.getX() + screenLoc.x, me.getY() + screenLoc.y);
                boolean absChange = BioFabricPanel.this.lastAbs_ != null && !newAbs.equals(BioFabricPanel.this.lastAbs_);
                BioFabricPanel.this.lastView_ = null;
                BioFabricPanel.this.lastAbs_ = null;
                if (me.isPopupTrigger()) {
                    Point pscreenLoc = me.getComponent().getLocationOnScreen();
                    Point abs = new Point(me.getX() + pscreenLoc.x, me.getY() + pscreenLoc.y);
                    this.triggerPopup(me.getX(), me.getY(), abs);
                    return;
                }
                boolean shiftPressed = me.isShiftDown();
                int currX = me.getX();
                int currY = me.getY();
                if (BioFabricPanel.this.lastPress_ == null) {
                    return;
                }
                int lastX = ((BioFabricPanel)BioFabricPanel.this).lastPress_.x;
                int lastY = ((BioFabricPanel)BioFabricPanel.this).lastPress_.y;
                int diffX = Math.abs(currX - lastX);
                int diffY = Math.abs(currY - lastY);
                if (!absChange && diffX <= 2 && diffY <= 2) {
                    this.handleClick(lastX, lastY, shiftPressed);
                } else if (BioFabricPanel.this.lastCtrl_ && (diffX >= 2 || diffY >= 2)) {
                    this.dragResult(lastX, lastY, currX, currY, BioFabricPanel.this.lastCtrl_);
                }
                ((BioFabricPanel)BioFabricPanel.this).floaterSet_.floater = null;
                BioFabricPanel.this.lastPress_ = null;
                BioFabricPanel.this.handleFloaterChange();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        private void triggerPopup(int x, int y, Point screenAbs) {
            try {
                Point loc = new Point(x, y);
                Point rcp = BioFabricPanel.this.transToRowCol(loc);
                HashSet<NetNode> nodes = new HashSet<NetNode>();
                HashSet<FabricLink> links = new HashSet<FabricLink>();
                HashSet<Integer> cols = new HashSet<Integer>();
                boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
                BioFabricPanel.this.selectionLogicPoint(rcp, loc, showShadows, nodes, links, cols, false);
                if (!links.isEmpty()) {
                    FabricLink fabLink = links.iterator().next();
                    BioFabricPanel.this.popCtrl_.showLinkPopup(fabLink, loc);
                } else if (!nodes.isEmpty()) {
                    NetNode nodeName = nodes.iterator().next();
                    BioFabricPanel.this.popCtrl_.showNodePopup(nodeName, loc);
                }
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TourStatus
    implements Cloneable {
        public String nodeName;
        public String linkName;
        boolean upEnabled;
        boolean downEnabled;
        boolean leftEnabled;
        boolean rightEnabled;
        boolean farLeftEnabled;
        boolean farRightEnabled;
        boolean currStopUnselected;

        TourStatus(MouseLocInfo vals, BioFabricNetwork bfn, BioFabricNetwork.LinkInfo link, Point navFocus, SortedSet<Integer> selectedOnly, boolean nodeAlive, boolean stopUnselected) {
            this.nodeName = vals.nodeDesc;
            this.linkName = vals.linkDesc;
            boolean showShadows = FabricDisplayOptionsManager.getMgr().getDisplayOptions().getDisplayShadows();
            this.currStopUnselected = stopUnselected;
            if (link == null) {
                this.upEnabled = false;
                this.downEnabled = false;
                this.leftEnabled = false;
                this.farLeftEnabled = false;
                this.rightEnabled = true;
                this.farRightEnabled = true;
            } else {
                BioFabricNetwork.NodeInfo useNode;
                BioFabricNetwork.NodeInfo src = bfn.getNodeDefinition(link.getSource());
                BioFabricNetwork.NodeInfo trg = bfn.getNodeDefinition(link.getTarget());
                BioFabricNetwork.NodeInfo nodeInfo = useNode = navFocus.y == src.nodeRow ? src : trg;
                if (selectedOnly != null && selectedOnly.isEmpty()) {
                    this.leftEnabled = false;
                    this.farLeftEnabled = nodeAlive;
                    this.rightEnabled = false;
                    this.farRightEnabled = false;
                } else {
                    MinMax range = useNode.getColRange(showShadows);
                    int maxCol = selectedOnly == null ? range.max : selectedOnly.last();
                    this.upEnabled = navFocus.y != link.topRow();
                    this.downEnabled = navFocus.y != link.bottomRow();
                    this.leftEnabled = navFocus.x >= range.min && nodeAlive;
                    this.farLeftEnabled = navFocus.x >= range.min && nodeAlive;
                    this.rightEnabled = maxCol != navFocus.x;
                    this.farRightEnabled = maxCol != navFocus.x;
                }
            }
        }

        public TourStatus clone() {
            try {
                return (TourStatus)super.clone();
            }
            catch (CloneNotSupportedException cnse) {
                throw new IllegalStateException();
            }
        }
    }

    private static class ImageToUse {
        BufferedImage image;
        int stX;
        int stY;

        ImageToUse(BufferedImage image, int stX, int stY) {
            this.image = image;
            this.stX = stX;
            this.stY = stY;
        }
    }

    public static class MouseLocInfo {
        public String nodeDesc;
        public String linkDesc;
        public String zoneDesc;
        public String linkSrcDesc;
        public String linkTrgDesc;
        public ArrayList<String> nodeAnnotations;
        public ArrayList<String> linkAnnotations;

        public MouseLocInfo(String nodeDesc, String linkDesc, String zoneDesc, String linkSrcDesc, String linkTrgDesc, String nodeAnnotation, String linkAnnotation) {
            this.nodeDesc = nodeDesc;
            this.linkDesc = linkDesc;
            this.zoneDesc = zoneDesc;
            this.linkSrcDesc = linkSrcDesc;
            this.linkTrgDesc = linkTrgDesc;
            this.nodeAnnotations = new ArrayList();
            this.nodeAnnotations.add(nodeAnnotation);
            this.linkAnnotations = new ArrayList();
            this.linkAnnotations.add(linkAnnotation);
        }

        public MouseLocInfo() {
            this.nodeDesc = "<none>";
            this.linkDesc = "<none>";
            this.zoneDesc = "<none>";
            this.linkSrcDesc = "<none>";
            this.linkTrgDesc = "<none>";
            this.nodeAnnotations = new ArrayList();
            this.nodeAnnotations.add("<none>");
            this.linkAnnotations = new ArrayList();
            this.linkAnnotations.add("<none>");
        }
    }
}

