/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.display;

import java.awt.BasicStroke;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JPanel;

public class BioFabricOverview {
    private static final float MOUSE_RADIUS_ = 10.0f;
    private static final float MOUSE_XHAIR_ = 15.0f;
    private static final float BOX_XHAIR_ = 15.0f;
    private JPanel myPanel_;
    private Dimension currSize_;
    private BufferedImage img_;
    private BufferedImage scaledImg_;
    private Point navFocus_;
    private Point scaledImgOrigin_;
    private Rectangle worldRect_;
    private AffineTransform transform_;
    private Point2D mousePoint_;
    private double zoom_;
    private boolean mouseIn_;
    private Rectangle2D viewInWorld_;
    private Rectangle magInWorld_;
    private boolean hideMag_;
    private CardLayout myCard_;
    private PaintPanel pPan_;

    public BioFabricOverview(boolean isHeadless) {
        if (isHeadless) {
            return;
        }
        this.myPanel_ = new MyOverPanel();
        this.myPanel_.setBackground(Color.white);
        this.scaledImg_ = null;
        this.img_ = null;
        this.navFocus_ = new Point(0, 0);
        this.scaledImgOrigin_ = new Point(0, 0);
        this.mouseIn_ = false;
        this.hideMag_ = true;
        this.worldRect_ = new Rectangle();
        this.mousePoint_ = new Point2D.Double();
        this.viewInWorld_ = new Rectangle2D.Double();
        this.magInWorld_ = new Rectangle();
        this.myCard_ = new CardLayout();
        this.myPanel_.setLayout(this.myCard_);
        this.pPan_ = new PaintPanel();
        this.myPanel_.add((Component)this.pPan_, "theView");
        JPanel blankPanel = new JPanel();
        blankPanel.setBackground(Color.white);
        this.myPanel_.add((Component)blankPanel, "Hiding");
    }

    public JPanel getPanel() {
        return this.myPanel_;
    }

    public void showView(boolean enabled) {
        this.myCard_.show(this.myPanel_, enabled ? "theView" : "Hiding");
    }

    public void setMouse(Point2D center, Point cprc) {
        this.navFocus_ = cprc;
        this.mousePoint_.setLocation(center);
        this.mouseIn_ = true;
        this.myPanel_.repaint();
    }

    public void setViewInWorld(Rectangle2D viewInWorld) {
        this.viewInWorld_.setFrame(viewInWorld);
        this.myPanel_.repaint();
    }

    public void setMagnifyView(Rectangle magInWorld) {
        this.magInWorld_.setBounds(magInWorld);
        this.myPanel_.repaint();
    }

    public void setMouseIn(boolean isIn, boolean magIgnoring) {
        this.mouseIn_ = isIn;
        this.hideMag_ = !isIn && !magIgnoring;
        this.myPanel_.repaint();
    }

    public void installImage(BufferedImage img, Rectangle worldRect) {
        this.img_ = img;
        this.scaledImg_ = null;
        this.worldRect_.setBounds(worldRect);
        this.resizeImage();
        this.myPanel_.repaint();
    }

    private void resizeImage() {
        int startY;
        int startX;
        int imgHeight;
        int imgWidth;
        if (this.img_ == null) {
            return;
        }
        if (this.currSize_ == null) {
            this.currSize_ = this.myPanel_.getSize();
        }
        if (this.currSize_.width <= 0 || this.currSize_.height <= 0) {
            return;
        }
        double imgAR = (double)this.img_.getWidth() / (double)this.img_.getHeight();
        double panelAR = this.currSize_.getWidth() / this.currSize_.getHeight();
        if (panelAR < imgAR) {
            imgWidth = this.currSize_.width;
            imgHeight = (int)((double)imgWidth / imgAR);
            if (imgHeight == 0) {
                imgHeight = 1;
            }
            startX = 0;
            startY = (this.currSize_.height - imgHeight) / 2;
        } else {
            imgHeight = this.currSize_.height;
            imgWidth = (int)((double)imgHeight * imgAR);
            if (imgWidth == 0) {
                imgWidth = 1;
            }
            startX = (this.currSize_.width - imgWidth) / 2;
            startY = 0;
        }
        this.scaledImgOrigin_.setLocation(startX, startY);
        this.scaledImg_ = new BufferedImage(imgWidth, imgHeight, 1);
        Graphics2D g2 = this.scaledImg_.createGraphics();
        g2.setRenderingHint(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC);
        g2.drawImage(this.img_, 0, 0, imgWidth, imgHeight, null);
        g2.dispose();
        double zoomHW = (double)imgWidth / this.worldRect_.getWidth();
        double zoomVW = (double)imgHeight / this.worldRect_.getHeight();
        this.zoom_ = zoomHW < zoomVW ? zoomHW : zoomVW;
        this.transform_ = new AffineTransform();
        this.transform_.translate(this.worldRect_.getWidth() / 2.0 * this.zoom_, this.worldRect_.getHeight() / 2.0 * this.zoom_);
        this.transform_.scale(this.zoom_, this.zoom_);
        this.transform_.translate(-this.worldRect_.getCenterX(), -this.worldRect_.getCenterY());
    }

    public class MyOverPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public Dimension getPreferredSize() {
            return new Dimension(800, 100);
        }

        public Dimension getMinimumSize() {
            return new Dimension(10, 10);
        }

        public Dimension getMaximumSize() {
            return new Dimension(4000, 340);
        }

        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            BioFabricOverview.this.currSize_ = new Dimension(width, height);
            BioFabricOverview.this.resizeImage();
            this.repaint();
        }
    }

    private class PaintPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public PaintPanel() {
            this.setBackground(Color.white);
        }

        public void paintComponent(Graphics g) {
            super.paintComponent(g);
            Graphics2D g2 = (Graphics2D)g;
            if (BioFabricOverview.this.img_ == null) {
                return;
            }
            if (BioFabricOverview.this.scaledImg_ == null) {
                BioFabricOverview.this.resizeImage();
            }
            g2.drawImage((Image)BioFabricOverview.this.scaledImg_, ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x, ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y, null);
            this.drawFloater(g);
        }

        private Point pointToViewport(Point2D worldPoint) {
            Point2D.Double newPoint = new Point2D.Double(worldPoint.getX(), worldPoint.getY());
            BioFabricOverview.this.transform_.transform(newPoint, newPoint);
            int x = (int)Math.round(((Point2D)newPoint).getX());
            int y = (int)Math.round(((Point2D)newPoint).getY());
            Point pt = new Point(x, y);
            return pt;
        }

        private void drawFloater(Graphics g) {
            int vcy;
            int vcx;
            int vh;
            int vw;
            Point viewLR;
            Point2D.Double viwLR;
            Point viewUL;
            Point2D.Double viwUL;
            Graphics2D g2 = (Graphics2D)g;
            g2.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
            g2.setRenderingHint(RenderingHints.KEY_FRACTIONALMETRICS, RenderingHints.VALUE_FRACTIONALMETRICS_ON);
            BasicStroke selectedStroke = new BasicStroke(1.0f, 2, 0);
            g2.setStroke(selectedStroke);
            g2.setPaint(Color.GREEN);
            if (BioFabricOverview.this.mousePoint_ != null && BioFabricOverview.this.mouseIn_) {
                Point viewP = this.pointToViewport(BioFabricOverview.this.mousePoint_);
                Ellipse2D.Double circ = new Ellipse2D.Double((float)(viewP.x + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x) - 10.0f, (float)(viewP.y + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y) - 10.0f, 20.0, 20.0);
                g2.draw(circ);
                g2.drawLine((int)((float)(viewP.x + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x) - 15.0f), viewP.y + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y, (int)((float)(viewP.x + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x) + 15.0f), viewP.y + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y);
                g2.drawLine(viewP.x + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x, (int)((float)(viewP.y + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y) - 15.0f), viewP.x + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x, (int)((float)(viewP.y + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y) + 15.0f));
            }
            if (BioFabricOverview.this.viewInWorld_ != null) {
                viwUL = new Point2D.Double(BioFabricOverview.this.viewInWorld_.getMinX(), BioFabricOverview.this.viewInWorld_.getMinY());
                viewUL = this.pointToViewport(viwUL);
                viwLR = new Point2D.Double(BioFabricOverview.this.viewInWorld_.getMaxX(), BioFabricOverview.this.viewInWorld_.getMaxY());
                viewLR = this.pointToViewport(viwLR);
                vw = viewLR.x - viewUL.x;
                vh = viewLR.y - viewUL.y;
                vcx = (viewUL.x + viewLR.x) / 2;
                vcy = (viewUL.y + viewLR.y) / 2;
                g2.drawRect(viewUL.x + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x, viewUL.y + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y, vw, vh);
                g2.drawLine((int)((float)(vcx + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x) - 15.0f), vcy + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y, (int)((float)(vcx + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x) + 15.0f), vcy + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y);
                g2.drawLine(vcx + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x, (int)((float)(vcy + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y) - 15.0f), vcx + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x, (int)((float)(vcy + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y) + 15.0f));
            }
            if (BioFabricOverview.this.magInWorld_ != null && !BioFabricOverview.this.hideMag_) {
                g2.setPaint(Color.RED);
                viwUL = new Point2D.Double(BioFabricOverview.this.magInWorld_.getMinX(), BioFabricOverview.this.magInWorld_.getMinY());
                viewUL = this.pointToViewport(viwUL);
                viwLR = new Point2D.Double(BioFabricOverview.this.magInWorld_.getMaxX(), BioFabricOverview.this.magInWorld_.getMaxY());
                viewLR = this.pointToViewport(viwLR);
                vw = viewLR.x - viewUL.x;
                vh = viewLR.y - viewUL.y;
                vcx = (viewUL.x + viewLR.x) / 2;
                vcy = (viewUL.y + viewLR.y) / 2;
                g2.drawRect(viewUL.x + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x, viewUL.y + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y, vw, vh);
                g2.drawLine((int)((float)(vcx + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x) - 15.0f), vcy + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y, (int)((float)(vcx + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x) + 15.0f), vcy + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y);
                g2.drawLine(vcx + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x, (int)((float)(vcy + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y) - 15.0f), vcx + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.x, (int)((float)(vcy + ((BioFabricOverview)BioFabricOverview.this).scaledImgOrigin_.y) + 15.0f));
            }
        }
    }
}

