/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.display;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import org.systemsbiology.biofabric.cmd.CommandSet;
import org.systemsbiology.biofabric.ui.display.BioFabricOverview;
import org.systemsbiology.biofabric.ui.display.BioFabricPanel;
import org.systemsbiology.biofabric.ui.display.FabricLocation;
import org.systemsbiology.biofabric.ui.display.FabricMagnifyingTool;
import org.systemsbiology.biofabric.ui.display.FabricNavTool;
import org.systemsbiology.biofabric.ui.display.MouseOverView;
import org.systemsbiology.biofabric.util.ResourceManager;

public class BioFabricNavAndControl {
    private MyNavPanel myPanel_;
    private FabricMagnifyingTool fmt_;
    private BioFabricOverview bfo_;
    private MouseOverView mvo_;
    private FabricNavTool fnt_;
    private FabricNavTool.LabeledFabricNavTool lfnt_;
    private FabricLocation floc_;
    private CardLayout clay_;
    private boolean collapsed_;
    private JPanel withControls_;
    private JSplitPane spot_;
    private double savedSplitFrac_;

    public BioFabricNavAndControl(boolean isMain, JFrame topWindow, boolean isHeadless) {
        if (isHeadless) {
            return;
        }
        this.myPanel_ = new MyNavPanel();
        this.floc_ = new FabricLocation();
        CommandSet fc = CommandSet.getCmds(isMain ? "mainWindow" : "selectionWindow");
        this.fmt_ = new FabricMagnifyingTool(fc.getColorGenerator());
        this.fmt_.keyInstall((JPanel)topWindow.getContentPane());
        JPanel fmpan = new JPanel();
        fmpan.setLayout(new BorderLayout());
        fmpan.setBorder(new LineBorder(Color.black, 2));
        Font labelFont = new Font("SansSerif", 1, 20);
        JLabel magLab = new JLabel(ResourceManager.getManager().getString("biofabric.magnifier"));
        magLab.setBorder(new EmptyBorder(0, 5, 0, 0));
        magLab.setOpaque(true);
        magLab.setBackground(Color.white);
        magLab.setFont(labelFont);
        fmpan.add((Component)magLab, "North");
        fmpan.add((Component)this.fmt_, "Center");
        this.bfo_ = new BioFabricOverview(isHeadless);
        this.fmt_.setFabricOverview(this.bfo_);
        this.mvo_ = new MouseOverView();
        this.mvo_.setIsAlive(false);
        this.mvo_.setFileLocations("path", "filePrefix", "fileSuffix");
        JPanel fopan = new JPanel();
        fopan.setLayout(new BorderLayout());
        fopan.setBorder(new LineBorder(Color.black, 2));
        JLabel overLab = new JLabel(ResourceManager.getManager().getString("biofabric.overview"));
        overLab.setBorder(new EmptyBorder(0, 5, 0, 0));
        overLab.setOpaque(true);
        overLab.setBackground(Color.white);
        overLab.setFont(labelFont);
        fopan.add((Component)overLab, "North");
        fopan.add((Component)this.bfo_.getPanel(), "Center");
        this.lfnt_ = new FabricNavTool.LabeledFabricNavTool(topWindow, labelFont);
        this.fnt_ = this.lfnt_.getFabricNavTool();
        this.spot_ = new JSplitPane(1, fopan, this.lfnt_);
        this.spot_.setBorder(new EmptyBorder(0, 0, 0, 0));
        this.spot_.setResizeWeight(1.0);
        JSplitPane sp = new JSplitPane(1, fmpan, this.spot_);
        this.withControls_ = new JPanel();
        this.withControls_.setLayout(new BorderLayout());
        this.withControls_.add((Component)this.floc_, "North");
        this.withControls_.add((Component)sp, "Center");
        this.clay_ = new CardLayout();
        this.myPanel_.setLayout(this.clay_);
        this.myPanel_.add((Component)this.withControls_, "cntrl");
        this.myPanel_.add((Component)new JPanel(), "blank");
        this.clay_.show(this.myPanel_, "cntrl");
        this.collapsed_ = false;
    }

    public MyNavPanel getPanel() {
        return this.myPanel_;
    }

    public boolean showTour(boolean show) {
        if (show) {
            this.spot_.setEnabled(true);
            this.lfnt_.setToBlank(!show);
            double need = (double)(this.spot_.getWidth() - this.lfnt_.getMinimumSize().width) / (double)this.spot_.getWidth();
            this.spot_.setDividerLocation(Math.min(this.savedSplitFrac_, need));
            if (this.lfnt_.getMinimumSize().height > this.myPanel_.getHeight()) {
                return true;
            }
        } else {
            this.lfnt_.setToBlank(!show);
            int lastLoc = this.spot_.getDividerLocation();
            this.savedSplitFrac_ = (double)lastLoc / (double)this.spot_.getWidth();
            this.spot_.setDividerLocation(1.0);
            this.spot_.setEnabled(false);
        }
        return false;
    }

    public FabricNavTool getNavTool() {
        return this.fnt_;
    }

    public void setToBlank(boolean val) {
        this.clay_.show(this.myPanel_, val ? "blank" : "cntrl");
        this.collapsed_ = val;
    }

    public FabricLocation getFabricLocation() {
        return this.floc_;
    }

    public MouseOverView getMouseOverView() {
        return this.mvo_;
    }

    public FabricMagnifyingTool getFMT() {
        return this.fmt_;
    }

    public BioFabricOverview getOverview() {
        return this.bfo_;
    }

    public void setFabricPanel(BioFabricPanel cp) {
        if (this.fnt_ != null) {
            this.fnt_.setFabricPanel(cp);
        }
    }

    public class MyNavPanel
    extends JPanel {
        private static final long serialVersionUID = 1L;

        public Dimension getPreferredSize() {
            if (BioFabricNavAndControl.this.collapsed_) {
                return new Dimension(0, 0);
            }
            return BioFabricNavAndControl.this.withControls_.getPreferredSize();
        }

        public Dimension getMinimumSize() {
            if (BioFabricNavAndControl.this.collapsed_) {
                return new Dimension(0, 0);
            }
            return BioFabricNavAndControl.this.withControls_.getMinimumSize();
        }

        public Dimension getMaximumSize() {
            if (BioFabricNavAndControl.this.collapsed_) {
                return new Dimension(0, 0);
            }
            return BioFabricNavAndControl.this.withControls_.getMaximumSize();
        }

        public void setBounds(int x, int y, int width, int height) {
            super.setBounds(x, y, width, height);
            this.repaint();
        }
    }
}

