/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs.utils;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JViewport;
import javax.swing.ListSelectionModel;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.util.ComboBoxEditorTracker;
import org.systemsbiology.biofabric.util.ComboFinishedTracker;
import org.systemsbiology.biofabric.util.DoubleEditor;
import org.systemsbiology.biofabric.util.EditableComboBoxEditorTracker;
import org.systemsbiology.biofabric.util.EnumCell;
import org.systemsbiology.biofabric.util.IntegerEditor;
import org.systemsbiology.biofabric.util.NumberEditorTracker;
import org.systemsbiology.biofabric.util.ProtoDouble;
import org.systemsbiology.biofabric.util.ProtoInteger;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.TextEditor;
import org.systemsbiology.biofabric.util.TextEditorTracker;
import org.systemsbiology.biofabric.util.TextFinishedTracker;
import org.systemsbiology.biofabric.util.TrackingUnit;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EditableTable<T extends ATableRow> {
    public static final int NO_BUTTONS = 0;
    public static final int ADD_BUTTON = 1;
    public static final int EDIT_BUTTON = 2;
    public static final int DELETE_BUTTON = 4;
    public static final int RAISE_BUTTON = 8;
    public static final int LOWER_BUTTON = 16;
    public static final int RAISE_AND_LOWER_BUTTONS = 24;
    public static final int ALL_BUT_EDIT_BUTTONS = 29;
    public static final int ALL_BUTTONS = 31;
    private TableModel<T> estm_;
    private int[] selectedRows_;
    private boolean trueButtonDEnable_;
    private boolean trueButtonAEnable_;
    private boolean trueButtonREnable_;
    private boolean trueButtonLEnable_;
    private boolean trueButtonEEnable_;
    private JButton tableButtonD_;
    private JButton tableButtonR_;
    private JButton tableButtonL_;
    private JButton tableButtonA_;
    private JButton tableButtonE_;
    private TrackingJTable qt_;
    private SelectionTracker tracker_;
    private boolean addAlwaysAtEnd_;
    private TextEditor textEdit_;
    private Set<Class<?>> usedClasses_;
    private HashMap<Integer, TableCellEditor> editors_;
    private HashMap<Integer, TableCellRenderer> renderers_;
    private HashSet<Integer> editableEnums_;
    private JFrame parent_;
    private boolean cancelEditOnDisable_;
    private EditButtonHandler ebh_;

    public EditableTable(TableModel<T> atm, JFrame parent) {
        this.estm_ = atm;
        this.parent_ = parent;
    }

    public JTable getTable() {
        return this.qt_;
    }

    public TableModel<T> getModel() {
        return this.estm_;
    }

    public int[] getSelectedRows() {
        return this.selectedRows_;
    }

    public void setEditButtonHandler(EditButtonHandler ebh) {
        this.ebh_ = ebh;
    }

    public void setEnabled(boolean enable) {
        this.qt_.setEnabled(enable);
        if (!enable) {
            this.stopTheEditing(this.cancelEditOnDisable_);
        }
        ((DefaultTableCellRenderer)this.qt_.getTableHeader().getDefaultRenderer()).setEnabled(enable);
        this.enableDefaultEditorsAndRenderers(enable);
        this.enableColumnEditorsAndRenderers(enable);
        this.qt_.getSelectionModel().clearSelection();
        if (!enable) {
            if (this.tableButtonA_ != null) {
                this.tableButtonA_.setEnabled(false);
            }
            if (this.tableButtonD_ != null) {
                this.tableButtonD_.setEnabled(false);
            }
            if (this.tableButtonR_ != null) {
                this.tableButtonR_.setEnabled(false);
            }
            if (this.tableButtonL_ != null) {
                this.tableButtonL_.setEnabled(false);
            }
            if (this.tableButtonE_ != null) {
                this.tableButtonE_.setEnabled(false);
            }
        } else {
            this.syncButtons();
        }
        this.qt_.getTableHeader().repaint();
        this.qt_.repaint();
    }

    private void syncButtons() {
        if (this.tableButtonA_ != null) {
            this.tableButtonA_.setEnabled(this.trueButtonAEnable_);
            this.tableButtonA_.revalidate();
        }
        if (this.tableButtonD_ != null) {
            this.tableButtonD_.setEnabled(this.trueButtonDEnable_);
            this.tableButtonD_.revalidate();
        }
        if (this.tableButtonR_ != null) {
            this.tableButtonR_.setEnabled(this.trueButtonREnable_);
            this.tableButtonR_.revalidate();
        }
        if (this.tableButtonL_ != null) {
            this.tableButtonL_.setEnabled(this.trueButtonLEnable_);
            this.tableButtonL_.revalidate();
        }
        if (this.tableButtonE_ != null) {
            this.tableButtonE_.setEnabled(this.trueButtonEEnable_);
            this.tableButtonE_.revalidate();
        }
    }

    public void updateTable(boolean fireChange, List<T> elements) {
        this.estm_.extractValues(elements);
        if (fireChange) {
            this.estm_.fireTableDataChanged();
        }
        if (this.estm_.getRowCount() > 0) {
            this.qt_.getSelectionModel().setSelectionInterval(0, 0);
        } else {
            this.selectedRows_ = new int[0];
            this.trueButtonAEnable_ = this.estm_.canAddRow();
            this.trueButtonDEnable_ = false;
            this.trueButtonREnable_ = false;
            this.trueButtonLEnable_ = false;
            this.trueButtonEEnable_ = false;
            this.syncButtons();
        }
    }

    public List<T> getValuesFromTable() {
        return this.estm_.getValuesFromTable();
    }

    public void clearSelections() {
        this.tracker_.setIgnore(true);
        this.qt_.getSelectionModel().clearSelection();
        this.selectedRows_ = null;
        this.tracker_.setIgnore(false);
    }

    public void makeCurrentSelectionVisible() {
        this.makeSelectionVisible(this.qt_.getSelectionModel().getMinSelectionIndex());
    }

    public void makeSelectionVisible(int selRow) {
        JViewport viewport = (JViewport)this.qt_.getParent();
        Rectangle rect = this.qt_.getCellRect(selRow, 0, true);
        Point pt = viewport.getViewPosition();
        rect.setLocation(rect.x - pt.x, rect.y - pt.y);
        viewport.scrollRectToVisible(rect);
        viewport.validate();
    }

    public JPanel buildEditableTable(TableParams etp) {
        this.usedClasses_ = this.estm_.usedClasses();
        this.selectedRows_ = new int[0];
        this.addAlwaysAtEnd_ = etp.addAlwaysAtEnd;
        this.cancelEditOnDisable_ = etp.cancelEditOnDisable;
        this.qt_ = new TrackingJTable(this.estm_);
        this.estm_.setJTable(this.qt_);
        JTableHeader th = this.qt_.getTableHeader();
        th.setReorderingAllowed(false);
        this.tracker_ = new SelectionTracker();
        ListSelectionModel lsm = this.qt_.getSelectionModel();
        if (etp.singleSelectOnly) {
            lsm.setSelectionMode(0);
        }
        lsm.addListSelectionListener(this.tracker_);
        if (etp.tableIsUnselectable) {
            this.qt_.setRowSelectionAllowed(false);
        }
        if (etp.colWidths != null) {
            int numC = etp.colWidths.size();
            TableColumnModel tcm = this.qt_.getColumnModel();
            for (int i = 0; i < numC; ++i) {
                ColumnWidths cw = etp.colWidths.get(i);
                int viewColumn = this.qt_.convertColumnIndexToView(cw.colNum);
                TableColumn tfCol = tcm.getColumn(viewColumn);
                tfCol.setMinWidth(cw.min);
                tfCol.setPreferredWidth(cw.pref);
                tfCol.setMaxWidth(cw.max);
            }
        }
        UiUtil.installDefaultCellRendererForPlatform(this.qt_, String.class, true);
        UiUtil.installDefaultCellRendererForPlatform(this.qt_, ProtoInteger.class, true);
        UiUtil.installDefaultCellRendererForPlatform(this.qt_, Integer.class, true);
        this.editors_ = new HashMap();
        this.renderers_ = new HashMap();
        this.editableEnums_ = new HashSet();
        this.setDefaultEditors();
        if (etp.perColumnEnums != null) {
            this.setColumnEditorsAndRenderers(etp.perColumnEnums, this.renderers_, this.editors_, this.editableEnums_);
            this.estm_.setEnums(this.renderers_, this.editors_, this.editableEnums_);
        }
        UiUtil.platformTableRowHeight(this.qt_, true);
        return etp.buttonsOnSide ? this.addButtonsOnSide(etp) : this.addButtonsOnBottom(etp);
    }

    public void refreshEditorsAndRenderers(Map<Integer, EnumCellInfo> perColumnEnums) {
        this.editors_.clear();
        this.renderers_.clear();
        this.editableEnums_.clear();
        this.setDefaultEditors();
        if (perColumnEnums != null) {
            this.setColumnEditorsAndRenderers(perColumnEnums, this.renderers_, this.editors_, this.editableEnums_);
            this.estm_.setEnums(this.renderers_, this.editors_, this.editableEnums_);
        }
        ((TableModel)this.estm_).refreshColumnEditorsAndRenderers();
    }

    private void createButtons(TableParams etp) {
        ResourceManager rMan = ResourceManager.getManager();
        if (etp.buttons != 0) {
            if ((etp.buttons & 1) != 0) {
                String aTag = rMan.getString("dialogs.addEntry");
                this.tableButtonA_ = etp.buttonsOnSide ? new JButton(aTag) : new FixedJButton(aTag);
                this.tableButtonA_.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        try {
                            int[] addAt;
                            EditableTable.this.stopTheEditing(false);
                            int[] nArray = addAt = EditableTable.this.addAlwaysAtEnd_ ? new int[]{} : EditableTable.this.selectedRows_;
                            if (EditableTable.this.estm_.addRow(addAt)) {
                                EditableTable.this.qt_.revalidate();
                            }
                        }
                        catch (Exception ex) {
                            ExceptionHandler.getHandler().displayException(ex);
                        }
                    }
                });
                this.trueButtonAEnable_ = true;
                this.tableButtonA_.setEnabled(true);
            }
            if ((etp.buttons & 0x10) != 0) {
                String lTag = rMan.getString("dialogs.lowerEntry");
                this.tableButtonL_ = etp.buttonsOnSide ? new JButton(lTag) : new FixedJButton(lTag);
                this.tableButtonL_.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        try {
                            EditableTable.this.stopTheEditing(false);
                            EditableTable.this.estm_.bumpRowDown(EditableTable.this.selectedRows_);
                            int[] nArray = EditableTable.this.selectedRows_;
                            nArray[0] = nArray[0] + 1;
                            EditableTable.this.qt_.getSelectionModel().setSelectionInterval(EditableTable.this.selectedRows_[0], EditableTable.this.selectedRows_[0]);
                            EditableTable.this.qt_.revalidate();
                        }
                        catch (Exception ex) {
                            ExceptionHandler.getHandler().displayException(ex);
                        }
                    }
                });
                this.tableButtonL_.setEnabled(false);
                this.trueButtonLEnable_ = false;
            }
            if ((etp.buttons & 8) != 0) {
                String rTag = rMan.getString("dialogs.raiseEntry");
                this.tableButtonR_ = etp.buttonsOnSide ? new JButton(rTag) : new FixedJButton(rTag);
                this.tableButtonR_.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        try {
                            EditableTable.this.stopTheEditing(false);
                            EditableTable.this.estm_.bumpRowUp(EditableTable.this.selectedRows_);
                            int[] nArray = EditableTable.this.selectedRows_;
                            nArray[0] = nArray[0] - 1;
                            EditableTable.this.qt_.getSelectionModel().setSelectionInterval(EditableTable.this.selectedRows_[0], EditableTable.this.selectedRows_[0]);
                            EditableTable.this.qt_.revalidate();
                        }
                        catch (Exception ex) {
                            ExceptionHandler.getHandler().displayException(ex);
                        }
                    }
                });
                this.tableButtonR_.setEnabled(false);
                this.trueButtonREnable_ = false;
            }
            if ((etp.buttons & 4) != 0) {
                String dTag = rMan.getString("dialogs.deleteEntry");
                this.tableButtonD_ = etp.buttonsOnSide ? new JButton(dTag) : new FixedJButton(dTag);
                this.tableButtonD_.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        try {
                            EditableTable.this.stopTheEditing(true);
                            EditableTable.this.estm_.deleteRows(EditableTable.this.selectedRows_);
                            EditableTable.this.qt_.getSelectionModel().clearSelection();
                            EditableTable.this.qt_.revalidate();
                        }
                        catch (Exception ex) {
                            ExceptionHandler.getHandler().displayException(ex);
                        }
                    }
                });
                this.tableButtonD_.setEnabled(false);
                this.trueButtonDEnable_ = false;
            }
            if ((etp.buttons & 2) != 0) {
                String eTag = rMan.getString("dialogs.editEntry");
                this.tableButtonE_ = etp.buttonsOnSide ? new JButton(eTag) : new FixedJButton(eTag);
                this.tableButtonE_.addActionListener(new ActionListener(){

                    public void actionPerformed(ActionEvent ev) {
                        try {
                            EditableTable.this.stopTheEditing(false);
                            EditableTable.this.ebh_.pressed();
                            EditableTable.this.qt_.revalidate();
                        }
                        catch (Exception ex) {
                            ExceptionHandler.getHandler().displayException(ex);
                        }
                    }
                });
                this.tableButtonE_.setEnabled(false);
                this.trueButtonEEnable_ = false;
            }
        }
    }

    private JPanel startPanel(TableParams etp) {
        if (etp.buttons != 0 && etp.noScroll) {
            throw new IllegalStateException();
        }
        JPanel retval = new JPanel();
        retval.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        if (etp.noScroll) {
            JTableHeader jth = this.qt_.getTableHeader();
            retval.setBorder(BorderFactory.createEtchedBorder());
            retval.setLayout(new BorderLayout());
            retval.add((Component)jth, "North");
            retval.add((Component)this.qt_, "Center");
        } else {
            JScrollPane jsp = new JScrollPane(this.qt_);
            UiUtil.gbcSet(gbc, 0, 0, 1, 10, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
            retval.add((Component)jsp, gbc);
        }
        return retval;
    }

    private JPanel addButtonsOnBottom(TableParams etp) {
        JPanel retval = this.startPanel(etp);
        if (etp.buttons != 0) {
            GridBagConstraints gbc = new GridBagConstraints();
            this.createButtons(etp);
            int buttonCount = 0;
            Box tableButtonPanel = Box.createHorizontalBox();
            tableButtonPanel.add(Box.createHorizontalGlue());
            if ((etp.buttons & 1) != 0) {
                tableButtonPanel.add(this.tableButtonA_);
                ++buttonCount;
            }
            if ((etp.buttons & 0x10) != 0) {
                if (buttonCount != 0) {
                    tableButtonPanel.add(Box.createHorizontalStrut(10));
                }
                tableButtonPanel.add(this.tableButtonL_);
                ++buttonCount;
            }
            if ((etp.buttons & 8) != 0) {
                if (buttonCount != 0) {
                    tableButtonPanel.add(Box.createHorizontalStrut(10));
                }
                tableButtonPanel.add(this.tableButtonR_);
                ++buttonCount;
            }
            if ((etp.buttons & 4) != 0) {
                if (buttonCount != 0) {
                    tableButtonPanel.add(Box.createHorizontalStrut(10));
                }
                tableButtonPanel.add(this.tableButtonD_);
                ++buttonCount;
            }
            if ((etp.buttons & 2) != 0) {
                if (buttonCount != 0) {
                    tableButtonPanel.add(Box.createHorizontalStrut(10));
                }
                tableButtonPanel.add(this.tableButtonE_);
                ++buttonCount;
            }
            tableButtonPanel.add(Box.createHorizontalGlue());
            UiUtil.gbcSet(gbc, 0, 10, 1, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
            retval.add((Component)tableButtonPanel, gbc);
        }
        return retval;
    }

    private JPanel addButtonsOnSide(TableParams etp) {
        JPanel retval = this.startPanel(etp);
        if (etp.buttons != 0) {
            GridBagConstraints gbc = new GridBagConstraints();
            this.createButtons(etp);
            int buttonCount = 0;
            JPanel tableButtonPanel = new JPanel();
            tableButtonPanel.setLayout(new GridBagLayout());
            if ((etp.buttons & 1) != 0) {
                UiUtil.gbcSet(gbc, 0, buttonCount++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
                tableButtonPanel.add((Component)this.tableButtonA_, gbc);
            }
            if ((etp.buttons & 0x10) != 0) {
                UiUtil.gbcSet(gbc, 0, buttonCount++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
                tableButtonPanel.add((Component)this.tableButtonL_, gbc);
            }
            if ((etp.buttons & 8) != 0) {
                UiUtil.gbcSet(gbc, 0, buttonCount++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
                tableButtonPanel.add((Component)this.tableButtonR_, gbc);
            }
            if ((etp.buttons & 4) != 0) {
                UiUtil.gbcSet(gbc, 0, buttonCount++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
                tableButtonPanel.add((Component)this.tableButtonD_, gbc);
            }
            if ((etp.buttons & 2) != 0) {
                UiUtil.gbcSet(gbc, 0, buttonCount++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 11, 0.0, 0.0);
                tableButtonPanel.add((Component)this.tableButtonE_, gbc);
            }
            UiUtil.gbcSet(gbc, 2, 0, 1, 1, 3, 0, 0, 5, 5, 5, 5, 10, 0.0, 1.0);
            retval.add((Component)tableButtonPanel, gbc);
        }
        return retval;
    }

    private void setDefaultEditors() {
        for (Class<?> used : this.usedClasses_) {
            if (used.equals(ProtoDouble.class)) {
                DoubleEditor dEdit = new DoubleEditor(this.parent_);
                new NumberEditorTracker(dEdit, this.estm_);
                this.qt_.setDefaultEditor(ProtoDouble.class, dEdit);
                continue;
            }
            if (used.equals(String.class)) {
                this.textEdit_ = new TextEditor();
                new TextEditorTracker(this.textEdit_, this.estm_, this.estm_);
                this.qt_.setDefaultEditor(String.class, this.textEdit_);
                continue;
            }
            if (used.equals(ProtoInteger.class)) {
                IntegerEditor intEdit = new IntegerEditor(this.parent_);
                new NumberEditorTracker(intEdit, this.estm_);
                this.qt_.setDefaultEditor(ProtoInteger.class, intEdit);
                continue;
            }
            if (used.equals(Boolean.class) || used.equals(Integer.class) || used.equals(EnumCell.class)) continue;
            throw new IllegalStateException();
        }
    }

    private void enableDefaultEditorsAndRenderers(boolean enable) {
        for (Class<?> used : this.usedClasses_) {
            JComponent dtcr;
            if (used.equals(ProtoDouble.class)) {
                DoubleEditor dt = (DoubleEditor)this.qt_.getDefaultEditor(ProtoDouble.class);
                dt.setEnabled(enable);
                dt.setEditable(enable);
                dtcr = (JComponent)((Object)this.qt_.getDefaultRenderer(ProtoDouble.class));
                dtcr.setEnabled(enable);
                continue;
            }
            if (used.equals(String.class)) {
                TextEditor te = (TextEditor)this.qt_.getDefaultEditor(String.class);
                te.setEnabled(enable);
                te.setEditable(enable);
                dtcr = (DefaultTableCellRenderer)this.qt_.getDefaultRenderer(String.class);
                dtcr.setEnabled(enable);
                continue;
            }
            if (used.equals(ProtoInteger.class)) {
                IntegerEditor ie = (IntegerEditor)this.qt_.getDefaultEditor(ProtoInteger.class);
                ie.setEnabled(enable);
                ie.setEditable(enable);
                dtcr = (DefaultTableCellRenderer)this.qt_.getDefaultRenderer(ProtoInteger.class);
                dtcr.setEnabled(enable);
                continue;
            }
            if (used.equals(Boolean.class) || used.equals(Integer.class) || used.equals(EnumCell.class)) continue;
            throw new IllegalStateException();
        }
    }

    private void enableColumnEditorsAndRenderers(boolean enable) {
        for (Integer key : this.renderers_.keySet()) {
            if (this.editableEnums_.contains(key)) {
                EnumCell.EditableComboBoxRenderer ecbr = (EnumCell.EditableComboBoxRenderer)this.renderers_.get(key);
                ecbr.setEnabled(enable);
                continue;
            }
            EnumCell.ReadOnlyComboBoxRenderer rocbr = (EnumCell.ReadOnlyComboBoxRenderer)this.renderers_.get(key);
            rocbr.setEnabled(enable);
        }
        for (Integer key : this.editors_.keySet()) {
            if (this.editableEnums_.contains(key)) {
                EnumCell.EditableEnumCellEditor eece = (EnumCell.EditableEnumCellEditor)this.editors_.get(key);
                eece.setEnabled(enable);
                eece.setEditable(enable);
                continue;
            }
            EnumCell.ReadOnlyEnumCellEditor roene = (EnumCell.ReadOnlyEnumCellEditor)this.editors_.get(key);
            roene.setEnabled(enable);
        }
    }

    private void setColumnEditorsAndRenderers(Map<Integer, EnumCellInfo> contents, Map<Integer, TableCellRenderer> renderers, Map<Integer, TableCellEditor> editors, Set<Integer> editableEnums) {
        for (Integer intObj : contents.keySet()) {
            EnumCellInfo eci = contents.get(intObj);
            TableColumn tc = this.qt_.getColumnModel().getColumn(intObj);
            if (eci.editable) {
                EnumCell.EditableComboBoxRenderer ecbr = new EnumCell.EditableComboBoxRenderer(eci.values);
                tc.setCellRenderer(ecbr);
                renderers.put(intObj, ecbr);
                EnumCell.EditableEnumCellEditor re = new EnumCell.EditableEnumCellEditor(eci.values);
                new EditableComboBoxEditorTracker(re, this.estm_);
                tc.setCellEditor(re);
                editors.put(intObj, re);
                editableEnums.add(intObj);
                continue;
            }
            EnumCell.ReadOnlyComboBoxRenderer rocbr = eci.trackingUnits == null ? new EnumCell.ReadOnlyComboBoxRenderer(eci.values) : new EnumCell.TrackingReadOnlyComboBoxRenderer(eci.values, eci.trackingUnits);
            tc.setCellRenderer(rocbr);
            renderers.put(intObj, rocbr);
            EnumCell.ReadOnlyEnumCellEditor me = new EnumCell.ReadOnlyEnumCellEditor(eci.values);
            new ComboBoxEditorTracker(me, this.estm_, this.estm_);
            tc.setCellEditor(me);
            editors.put(intObj, me);
        }
    }

    public void stopTheEditing(boolean doCancel) {
        for (Class<?> used : this.usedClasses_) {
            if (used.equals(EnumCell.class) || used.equals(Integer.class) || used.equals(Boolean.class)) continue;
            TableCellEditor tce = this.qt_.getDefaultEditor(used);
            if (doCancel) {
                tce.cancelCellEditing();
                continue;
            }
            tce.stopCellEditing();
        }
        for (Integer key : this.editors_.keySet()) {
            TableCellEditor tce = this.editors_.get(key);
            if (doCancel) {
                tce.cancelCellEditing();
                continue;
            }
            tce.stopCellEditing();
        }
    }

    static /* synthetic */ int[] access$202(EditableTable x0, int[] x1) {
        x0.selectedRows_ = x1;
        return x1;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OneEnumTableModel
    extends TableModel<TableRow> {
        public static final int ENUM_COL_ = 0;
        private static final int NUM_COL_ = 1;
        private static final int ORIG_ORDER_ = 0;
        private static final int NUM_HIDDEN_ = 1;
        private ArrayList<EnumCell> currEnums_;
        private static final long serialVersionUID = 1L;

        public OneEnumTableModel(String title, List<EnumCell> currEnums) {
            super(1);
            this.colNames_ = new String[]{title};
            this.colClasses_ = new Class[]{EnumCell.class};
            this.canEdit_ = new boolean[]{true};
            this.addHiddenColumns(1);
            this.currEnums_ = new ArrayList<EnumCell>(currEnums);
        }

        @Override
        protected TableRow constructARow(int i) {
            return new TableRow(i);
        }

        @Override
        public TableRow constructARow() {
            return new TableRow();
        }

        @Override
        void setEnums(Map<Integer, TableCellRenderer> renderers, Map<Integer, TableCellEditor> editors, Set<Integer> editableEnums) {
            if (!editableEnums.isEmpty()) {
                throw new IllegalArgumentException();
            }
            super.setEnums(renderers, editors, editableEnums);
        }

        public void setCurrentEnums(List<EnumCell> prsList) {
            this.currEnums_.clear();
            this.currEnums_.addAll(prsList);
        }

        @Override
        public boolean canAddRow() {
            return !this.currEnums_.isEmpty();
        }

        @Override
        public boolean addRow(int[] rows) {
            int addIndex;
            super.addRow(rows);
            int lastIndex = this.rowCount_ - 1;
            int n = addIndex = rows.length == 0 ? lastIndex : rows[0] + 1;
            if (this.currEnums_.isEmpty()) {
                throw new IllegalStateException();
            }
            EnumCell fillIn = new EnumCell(this.currEnums_.get(0));
            ((List)this.columns_.get(0)).set(addIndex, fillIn);
            ((List)this.hiddenColumns_.get(0)).set(addIndex, new Integer(lastIndex));
            return true;
        }

        public class TableRow
        implements ATableRow {
            public Integer origOrder;
            public EnumCell enumChoice;

            public TableRow() {
            }

            TableRow(int i) {
                this.enumChoice = (EnumCell)((List)OneEnumTableModel.this.columns_.get(0)).get(i);
                this.origOrder = (Integer)((List)OneEnumTableModel.this.hiddenColumns_.get(0)).get(i);
            }

            public void toCols() {
                ((List)OneEnumTableModel.this.columns_.get(0)).add(this.enumChoice);
                ((List)OneEnumTableModel.this.hiddenColumns_.get(0)).add(this.origOrder);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class TaggedValueModel
    extends TableModel<TableRow> {
        private static final int VALUE = 0;
        private static final int NUM_COL_ = 1;
        private static final int HIDDEN_ = 0;
        private static final int NUM_HIDDEN_ = 1;
        private static final long serialVersionUID = 1L;

        public TaggedValueModel(String title, boolean editable) {
            super(1);
            this.colNames_ = new String[]{title};
            this.colClasses_ = new Class[]{String.class};
            this.canEdit_ = new boolean[]{editable};
            this.addHiddenColumns(1);
        }

        @Override
        protected TableRow constructARow(int i) {
            return new TableRow(i);
        }

        @Override
        public TableRow constructARow() {
            return new TableRow();
        }

        public class TableRow
        implements ATableRow {
            public String hidden;
            public String value;

            public TableRow() {
            }

            TableRow(int i) {
                this.hidden = (String)((List)TaggedValueModel.this.hiddenColumns_.get(0)).get(i);
                this.value = (String)((List)TaggedValueModel.this.columns_.get(0)).get(i);
            }

            public void toCols() {
                ((List)TaggedValueModel.this.columns_.get(0)).add(this.value);
                ((List)TaggedValueModel.this.hiddenColumns_.get(0)).add(this.hidden);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class OneValueModel
    extends TableModel<TableRow> {
        private static final int VALUE = 0;
        private static final int NUM_COL_ = 1;
        private static final long serialVersionUID = 1L;

        public OneValueModel(String title, boolean edit) {
            super(1);
            this.colNames_ = new String[]{title};
            this.colClasses_ = new Class[]{String.class};
            this.canEdit_ = new boolean[]{edit};
        }

        @Override
        protected TableRow constructARow(int i) {
            return new TableRow(i);
        }

        @Override
        public TableRow constructARow() {
            return new TableRow();
        }

        public class TableRow
        implements ATableRow {
            public String value;

            public TableRow() {
            }

            TableRow(int i) {
                this.value = (String)((List)OneValueModel.this.columns_.get(0)).get(i);
            }

            public void toCols() {
                ((List)OneValueModel.this.columns_.get(0)).add(this.value);
            }
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class TrackingJTable
    extends JTable {
        private static final long serialVersionUID = 1L;
        private int lastCol_;
        private Object lastOrig_;

        TrackingJTable(TableModel<T> estm) {
            super(estm);
            this.lastCol_ = -1;
        }

        Object getLastOrig() {
            return this.lastOrig_;
        }

        void clearLastOrig() {
            this.lastOrig_ = null;
        }

        int getLastColumn() {
            return this.lastCol_;
        }

        @Override
        public TableCellEditor getCellEditor(int row, int column) {
            this.lastOrig_ = null;
            if (this.lastCol_ == column && EditableTable.this.editableEnums_.contains(new Integer(column))) {
                EnumCell.EditableEnumCellEditor fixit = (EnumCell.EditableEnumCellEditor)EditableTable.this.editors_.get(new Integer(column));
                if (((EnumCell)((EditableTable)EditableTable.this).estm_.getValueAt((int)row, (int)column)).display.equals(((EnumCell)fixit.getOriginalValue()).display)) {
                    this.lastOrig_ = EditableTable.this.estm_.getValueAt(row, column);
                }
            }
            this.lastCol_ = column;
            return super.getCellEditor(row, column);
        }
    }

    class SelectionTracker
    implements ListSelectionListener {
        private boolean ignore_ = false;

        SelectionTracker() {
        }

        public void valueChanged(ListSelectionEvent lse) {
            try {
                if (this.ignore_) {
                    return;
                }
                if (lse.getValueIsAdjusting()) {
                    return;
                }
                EditableTable.access$202(EditableTable.this, EditableTable.this.qt_.getSelectedRows());
                Object lastOrig = EditableTable.this.qt_.getLastOrig();
                int col = EditableTable.this.qt_.getLastColumn();
                if (lastOrig != null) {
                    EnumCell.EditableEnumCellEditor fixit = (EnumCell.EditableEnumCellEditor)EditableTable.this.editors_.get(new Integer(col));
                    fixit.getTableCellEditorComponent(EditableTable.this.qt_, lastOrig, true, EditableTable.this.selectedRows_[0], EditableTable.this.qt_.getLastColumn());
                    EditableTable.this.qt_.clearLastOrig();
                }
                boolean haveARow = EditableTable.this.selectedRows_.length > 0;
                EditableTable.this.trueButtonDEnable_ = haveARow;
                EditableTable.this.trueButtonEEnable_ = haveARow;
                boolean haveZeroOrOne = EditableTable.this.selectedRows_.length <= 1;
                EditableTable.this.trueButtonAEnable_ = (EditableTable.this.addAlwaysAtEnd_ || haveZeroOrOne) && EditableTable.this.estm_.canAddRow();
                boolean canLower = EditableTable.this.selectedRows_.length == 1 && EditableTable.this.selectedRows_[0] < EditableTable.this.estm_.getRowCount() - 1;
                EditableTable.this.trueButtonLEnable_ = canLower;
                boolean canRaise = EditableTable.this.selectedRows_.length == 1 && EditableTable.this.selectedRows_[0] != 0;
                EditableTable.this.trueButtonREnable_ = canRaise;
                EditableTable.this.syncButtons();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void setIgnore(boolean ignore) {
            this.ignore_ = ignore;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static abstract class TableModel<T extends ATableRow>
    extends AbstractTableModel
    implements ComboFinishedTracker,
    TextFinishedTracker {
        protected JTable tmqt_;
        protected ArrayList<List<Object>> columns_ = new ArrayList();
        protected ArrayList<Integer> origIndex_;
        protected ArrayList<List<Object>> hiddenColumns_;
        protected int rowCount_;
        protected String[] colNames_;
        protected Class<?>[] colClasses_;
        protected boolean[] canEdit_;
        protected boolean[] colUseDirect_;
        protected Set<Integer> myEditableEnums_;
        protected HashMap<Integer, TableCellRenderer> myRenderers_;
        protected HashMap<Integer, TableCellEditor> myEditors_;
        protected int collapseCount_;
        protected boolean isCollapsed_;
        private static final long serialVersionUID = 1L;

        protected TableModel(int colNum) {
            for (int i = 0; i < colNum; ++i) {
                this.columns_.add(new ArrayList());
            }
            this.origIndex_ = new ArrayList();
            this.hiddenColumns_ = new ArrayList();
            this.canEdit_ = null;
            this.colUseDirect_ = null;
            this.collapseCount_ = -1;
            this.isCollapsed_ = false;
            this.myRenderers_ = new HashMap();
            this.myEditors_ = new HashMap();
        }

        protected void resetColumnCount(int colNum) {
            this.columns_ = new ArrayList();
            for (int i = 0; i < colNum; ++i) {
                this.columns_.add(new ArrayList());
            }
        }

        protected void addHiddenColumns(int colNum) {
            this.hiddenColumns_ = new ArrayList();
            for (int i = 0; i < colNum; ++i) {
                this.hiddenColumns_.add(new ArrayList());
            }
        }

        Set<Class<?>> usedClasses() {
            HashSet retval = new HashSet();
            for (int i = 0; i < this.colClasses_.length; ++i) {
                retval.add(this.colClasses_[i]);
            }
            return retval;
        }

        void setJTable(JTable tab) {
            this.tmqt_ = tab;
        }

        void setEnums(Map<Integer, TableCellRenderer> renderers, Map<Integer, TableCellEditor> editors, Set<Integer> editableEnums) {
            this.myRenderers_.clear();
            this.myEditors_.clear();
            this.myRenderers_.putAll(renderers);
            this.myEditors_.putAll(editors);
            this.myEditableEnums_ = editableEnums;
        }

        public void deleteRows(int[] rows) {
            for (int i = 0; i < rows.length; ++i) {
                int j;
                int clen = this.columns_.size();
                for (int j2 = 0; j2 < clen; ++j2) {
                    this.columns_.get(j2).remove(rows[i]);
                }
                int hlen = this.hiddenColumns_.size();
                for (j = 0; j < hlen; ++j) {
                    this.hiddenColumns_.get(j).remove(rows[i]);
                }
                this.origIndex_.remove(rows[i]);
                for (j = i + 1; j < rows.length; ++j) {
                    if (rows[j] <= rows[i]) continue;
                    int n = j;
                    rows[n] = rows[n] - 1;
                }
                --this.rowCount_;
            }
        }

        public void bumpRowUp(int[] rows) {
            if (rows.length != 1 || rows[0] == 0) {
                throw new IllegalStateException();
            }
            int clen = this.columns_.size();
            for (int j = 0; j < clen; ++j) {
                Object remObj = this.columns_.get(j).remove(rows[0] - 1);
                this.columns_.get(j).add(rows[0], remObj);
            }
            int hlen = this.hiddenColumns_.size();
            for (int j = 0; j < hlen; ++j) {
                Object remObj = this.hiddenColumns_.get(j).remove(rows[0] - 1);
                this.hiddenColumns_.get(j).add(rows[0], remObj);
            }
            Integer remObj = this.origIndex_.remove(rows[0] - 1);
            this.origIndex_.add(rows[0], remObj);
        }

        public void bumpRowDown(int[] rows) {
            if (rows.length != 1 || rows[0] == this.origIndex_.size() - 1) {
                throw new IllegalStateException();
            }
            int clen = this.columns_.size();
            for (int j = 0; j < clen; ++j) {
                Object remObj = this.columns_.get(j).remove(rows[0]);
                this.columns_.get(j).add(rows[0] + 1, remObj);
            }
            int hlen = this.hiddenColumns_.size();
            for (int j = 0; j < hlen; ++j) {
                Object remObj = this.hiddenColumns_.get(j).remove(rows[0]);
                this.hiddenColumns_.get(j).add(rows[0] + 1, remObj);
            }
            Integer remObj = this.origIndex_.remove(rows[0]);
            this.origIndex_.add(rows[0] + 1, remObj);
        }

        public boolean addRow(int[] rows) {
            if (rows.length == 0) {
                this.origIndex_.add(null);
            } else if (rows.length == 1) {
                this.origIndex_.add(rows[0] + 1, null);
            } else {
                throw new IllegalStateException();
            }
            int clen = this.columns_.size();
            for (int j = 0; j < clen; ++j) {
                if (rows.length == 0) {
                    this.columns_.get(j).add(null);
                    continue;
                }
                this.columns_.get(j).add(rows[0] + 1, null);
            }
            int hlen = this.hiddenColumns_.size();
            for (int j = 0; j < hlen; ++j) {
                if (rows.length == 0) {
                    this.hiddenColumns_.get(j).add(null);
                    continue;
                }
                this.hiddenColumns_.get(j).add(rows[0] + 1, null);
            }
            ++this.rowCount_;
            return true;
        }

        @Override
        public int getRowCount() {
            return this.rowCount_;
        }

        @Override
        public int getColumnCount() {
            if (this.collapseCount_ == -1) {
                return this.columns_.size();
            }
            return this.isCollapsed_ ? this.collapseCount_ : this.columns_.size();
        }

        protected List<Object> getListAt(int c) {
            try {
                if (c >= this.columns_.size()) {
                    throw new IllegalArgumentException();
                }
                return this.columns_.get(c);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }

        protected int mapSelectionIndex(int r) {
            return r;
        }

        @Override
        public String getColumnName(int c) {
            try {
                if (c >= this.colNames_.length) {
                    throw new IllegalArgumentException();
                }
                if (this.colUseDirect_ == null || !this.colUseDirect_[c]) {
                    ResourceManager rMan = ResourceManager.getManager();
                    return rMan.getString(this.colNames_[c]);
                }
                return this.colNames_[c];
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }

        @Override
        public Class<?> getColumnClass(int c) {
            try {
                if (c >= this.colClasses_.length) {
                    throw new IllegalArgumentException();
                }
                return this.colClasses_[c];
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }

        @Override
        public Object getValueAt(int r, int c) {
            try {
                List<Object> list = this.getListAt(c);
                if (list.isEmpty()) {
                    return null;
                }
                return list.get(this.mapSelectionIndex(r));
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return null;
            }
        }

        @Override
        public void setValueAt(Object value, int r, int c) {
            try {
                List<Object> list = this.getListAt(c);
                if (list.isEmpty()) {
                    return;
                }
                Object currVal = list.get(r);
                Class<?> colClass = this.getColumnClass(c);
                if (colClass.equals(ProtoInteger.class)) {
                    ProtoInteger currNum = (ProtoInteger)currVal;
                    if (currNum != null && currNum.textValue.equals(((ProtoInteger)value).textValue)) {
                        return;
                    }
                } else if (colClass.equals(String.class)) {
                    String currStr = (String)currVal;
                    if (currStr != null && currStr.equals(value)) {
                        return;
                    }
                } else if (colClass.equals(ProtoDouble.class)) {
                    ProtoDouble currNum = (ProtoDouble)currVal;
                    if (currNum != null && currNum.textValue.equals(((ProtoDouble)value).textValue)) {
                        return;
                    }
                } else if (colClass.equals(Boolean.class)) {
                    Boolean currInclude = (Boolean)currVal;
                    if (currInclude != null && currInclude.equals(value)) {
                        return;
                    }
                } else if (colClass.equals(EnumCell.class)) {
                    EnumCell currEC = (EnumCell)currVal;
                    if (this.myEditableEnums_.contains(new Integer(c)) ? currEC != null && currEC.internal != null && currEC.internal.equals(((EnumCell)value).internal) : currEC != null && currEC.value == ((EnumCell)value).value) {
                        return;
                    }
                } else {
                    throw new IllegalStateException();
                }
                list.set(r, value);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        @Override
        public boolean isCellEditable(int r, int c) {
            try {
                if (this.canEdit_ == null) {
                    return true;
                }
                return this.canEdit_[c];
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
                return false;
            }
        }

        public void extractValues(List<T> rowElements) {
            this.origIndex_.clear();
            int clen = this.columns_.size();
            for (int i = 0; i < clen; ++i) {
                this.columns_.get(i).clear();
            }
            int hlen = this.hiddenColumns_.size();
            for (int i = 0; i < hlen; ++i) {
                this.hiddenColumns_.get(i).clear();
            }
            this.rowCount_ = 0;
            Iterator<T> iit = rowElements.iterator();
            while (iit.hasNext()) {
                iit.next();
                this.origIndex_.add(new Integer(this.rowCount_++));
            }
            for (ATableRow ent : rowElements) {
                ent.toCols();
            }
        }

        public abstract T constructARow();

        protected abstract T constructARow(int var1);

        public List<T> getValuesFromTable() {
            ArrayList<T> retval = new ArrayList<T>();
            for (int i = 0; i < this.rowCount_; ++i) {
                T ent = this.constructARow(i);
                retval.add(ent);
            }
            return retval;
        }

        public void collapseView(boolean doCollapse) {
            if (this.collapseCount_ == -1) {
                throw new IllegalStateException();
            }
            this.isCollapsed_ = doCollapse;
            this.fireTableStructureChanged();
            this.refreshColumnEditorsAndRenderers();
        }

        public boolean canAddRow() {
            return true;
        }

        private void refreshColumnEditorsAndRenderers() {
            int currColumns = this.getColumnCount();
            TableColumnModel tcm = this.tmqt_.getColumnModel();
            for (Integer key : this.myRenderers_.keySet()) {
                if (key >= currColumns) continue;
                TableColumn tc = tcm.getColumn(key);
                if (this.myEditableEnums_.contains(key)) {
                    EnumCell.EditableComboBoxRenderer ecbr = (EnumCell.EditableComboBoxRenderer)this.myRenderers_.get(key);
                    tc.setCellRenderer(ecbr);
                    continue;
                }
                EnumCell.ReadOnlyComboBoxRenderer rocbr = (EnumCell.ReadOnlyComboBoxRenderer)this.myRenderers_.get(key);
                tc.setCellRenderer(rocbr);
            }
            for (Integer key : this.myEditors_.keySet()) {
                if (key >= currColumns) continue;
                TableColumn tc = tcm.getColumn(key);
                if (this.myEditableEnums_.contains(key)) {
                    EnumCell.EditableEnumCellEditor eece = (EnumCell.EditableEnumCellEditor)this.myEditors_.get(key);
                    tc.setCellEditor(eece);
                    continue;
                }
                EnumCell.ReadOnlyEnumCellEditor roene = (EnumCell.ReadOnlyEnumCellEditor)this.myEditors_.get(key);
                tc.setCellEditor(roene);
            }
        }

        @Override
        public boolean textEditingDone(int col, int row, Object val) {
            return true;
        }

        @Override
        public boolean comboEditingDone(int col, int row, Object val) {
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class EnumCellInfo {
        public boolean editable;
        public List<EnumCell> values;
        public Map<Integer, TrackingUnit> trackingUnits;

        public EnumCellInfo(boolean editable, List<EnumCell> values) {
            this(editable, values, null);
        }

        public EnumCellInfo(boolean editable, List<EnumCell> values, Map<Integer, TrackingUnit> trackingUnits) {
            this.editable = editable;
            this.values = values;
            this.trackingUnits = trackingUnits;
            if (trackingUnits != null && editable) {
                throw new IllegalArgumentException();
            }
        }
    }

    public static class ColumnWidths {
        public int colNum;
        public int min;
        public int pref;
        public int max;

        public ColumnWidths() {
        }

        public ColumnWidths(int colNum, int min, int pref, int max) {
            this.colNum = colNum;
            this.min = min;
            this.pref = pref;
            this.max = max;
        }
    }

    public static class TableParams {
        public boolean addAlwaysAtEnd;
        public boolean singleSelectOnly;
        public boolean cancelEditOnDisable;
        public boolean tableIsUnselectable;
        public int buttons;
        public Map<Integer, EnumCellInfo> perColumnEnums;
        public List<ColumnWidths> colWidths;
        public boolean buttonsOnSide;
        public boolean noScroll;
    }

    public static interface EditButtonHandler {
        public void pressed();
    }

    public static interface ATableRow {
        public void toCols();
    }
}

