/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs.utils;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import org.systemsbiology.biofabric.api.dialog.DialogObj;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DialogSupport {
    private DialogObj.DialogSupportClient dsClient_;
    private ResourceManager rMan_;
    private GridBagConstraints gbc_;
    private JDialog closeMe_;

    public DialogSupport(DialogObj.DialogSupportClient client, ResourceManager rMan, GridBagConstraints gbc) {
        this.dsClient_ = client;
        this.rMan_ = rMan;
        this.gbc_ = gbc;
    }

    public DialogSupport(ResourceManager rMan, GridBagConstraints gbc, JDialog closeMe) {
        this.closeMe_ = closeMe;
        this.rMan_ = rMan;
        this.gbc_ = gbc;
    }

    public DialogSupport(ResourceManager rMan, GridBagConstraints gbc) {
        this.rMan_ = rMan;
        this.gbc_ = gbc;
    }

    public ResourceManager getRman() {
        return this.rMan_;
    }

    public GridBagConstraints getGbc() {
        return this.gbc_;
    }

    public DialogObj.ButtonsAndBox buildButtonBox(boolean doApply, boolean showAsCancel, boolean doCentering) {
        DialogObj.Buttons myButtons = new DialogObj.Buttons();
        myButtons.applyButton = null;
        if (doApply) {
            myButtons.applyButton = new FixedJButton(this.rMan_.getString("dialogs.apply"));
            myButtons.applyButton.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        DialogSupport.this.dsClient_.applyAction();
                    }
                    catch (Exception ex) {
                        ExceptionHandler.getHandler().displayException(ex);
                    }
                    catch (OutOfMemoryError oom) {
                        ExceptionHandler.getHandler().displayOutOfMemory(oom);
                    }
                }
            });
        }
        myButtons.okButton = new FixedJButton(this.rMan_.getString("dialogs.ok"));
        myButtons.okButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    DialogSupport.this.dsClient_.okAction();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
                catch (OutOfMemoryError oom) {
                    ExceptionHandler.getHandler().displayOutOfMemory(oom);
                }
            }
        });
        myButtons.cancelButton = new FixedJButton(this.rMan_.getString(showAsCancel ? "dialogs.cancel" : "dialogs.close"));
        myButtons.cancelButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    DialogSupport.this.dsClient_.closeAction();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
                catch (OutOfMemoryError oom) {
                    ExceptionHandler.getHandler().displayOutOfMemory(oom);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        if (doApply) {
            buttonPanel.add(myButtons.applyButton);
            buttonPanel.add(Box.createHorizontalStrut(10));
        }
        buttonPanel.add(myButtons.okButton);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(myButtons.cancelButton);
        if (doCentering) {
            buttonPanel.add(Box.createHorizontalGlue());
        }
        DialogObj.ButtonsAndBox retval = new DialogObj.ButtonsAndBox();
        retval.buttonBox = buttonPanel;
        retval.buttons = myButtons;
        return retval;
    }

    public DialogObj.Buttons buildAndInstallButtonBox(JPanel cp, int rowNum, int colWidth, boolean doApply, boolean showAsCancel, Border border) {
        DialogObj.ButtonsAndBox bAndBox = this.buildButtonBox(doApply, showAsCancel, false);
        if (border != null) {
            bAndBox.buttonBox.setBorder(border);
        }
        UiUtil.gbcSet(this.gbc_, 0, rowNum, colWidth, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)bAndBox.buttonBox, this.gbc_);
        return bAndBox.buttons;
    }

    public DialogObj.Buttons buildAndInstallCenteredButtonBox(JPanel cp, int rowNum, int colWidth, boolean doApply, boolean showAsCancel) {
        DialogObj.ButtonsAndBox bAndBox = this.buildButtonBox(doApply, showAsCancel, true);
        UiUtil.gbcSet(this.gbc_, 0, rowNum, colWidth, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)bAndBox.buttonBox, this.gbc_);
        return bAndBox.buttons;
    }

    public DialogObj.Buttons buildAndInstallButtonBox(JPanel cp, int rowNum, int colWidth, boolean doApply, boolean showAsCancel) {
        DialogObj.Buttons retval = this.buildAndInstallButtonBox(cp, rowNum, colWidth, doApply, showAsCancel, null);
        return retval;
    }

    public Box buildButtonBoxWithExtra(boolean doApply, JButton xtraButton, boolean showAsCancel) {
        ArrayList<JButton> xtraButtonList = new ArrayList<JButton>();
        xtraButtonList.add(xtraButton);
        return this.buildButtonBoxWithMultiExtra(doApply, xtraButtonList, showAsCancel);
    }

    public Box buildButtonBoxWithMultiExtra(boolean doApply, List<JButton> xtraButtonList, boolean showAsCancel) {
        FixedJButton buttonA = null;
        if (doApply) {
            buttonA = new FixedJButton(this.rMan_.getString("dialogs.apply"));
            buttonA.addActionListener(new ActionListener(){

                public void actionPerformed(ActionEvent ev) {
                    try {
                        DialogSupport.this.dsClient_.applyAction();
                    }
                    catch (Exception ex) {
                        ExceptionHandler.getHandler().displayException(ex);
                    }
                    catch (OutOfMemoryError oom) {
                        ExceptionHandler.getHandler().displayOutOfMemory(oom);
                    }
                }
            });
        }
        FixedJButton buttonO = new FixedJButton(this.rMan_.getString("dialogs.ok"));
        buttonO.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    DialogSupport.this.dsClient_.okAction();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
                catch (OutOfMemoryError oom) {
                    ExceptionHandler.getHandler().displayOutOfMemory(oom);
                }
            }
        });
        FixedJButton buttonC = new FixedJButton(this.rMan_.getString(showAsCancel ? "dialogs.cancel" : "dialogs.close"));
        buttonC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    DialogSupport.this.dsClient_.closeAction();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
                catch (OutOfMemoryError oom) {
                    ExceptionHandler.getHandler().displayOutOfMemory(oom);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalStrut(10));
        int numBut = xtraButtonList.size();
        for (int i = 0; i < numBut; ++i) {
            buttonPanel.add(xtraButtonList.get(i));
            if (i == numBut - 1) continue;
            buttonPanel.add(Box.createHorizontalStrut(10));
        }
        buttonPanel.add(Box.createHorizontalGlue());
        if (doApply) {
            buttonPanel.add(buttonA);
            buttonPanel.add(Box.createHorizontalStrut(10));
        }
        buttonPanel.add(buttonO);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(buttonC);
        return buttonPanel;
    }

    public void buildAndInstallButtonBoxWithExtra(JPanel cp, int rowNum, int colWidth, boolean doApply, JButton xtraButton, boolean showAsCancel) {
        Box bBox = this.buildButtonBoxWithExtra(doApply, xtraButton, showAsCancel);
        UiUtil.gbcSet(this.gbc_, 0, rowNum, colWidth, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)bBox, this.gbc_);
    }

    public void buildAndInstallButtonBoxWithMultiExtra(JPanel cp, int rowNum, int colWidth, boolean doApply, List<JButton> xtraButtonList, boolean showAsCancel) {
        Box bBox = this.buildButtonBoxWithMultiExtra(doApply, xtraButtonList, showAsCancel);
        UiUtil.gbcSet(this.gbc_, 0, rowNum, colWidth, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)bBox, this.gbc_);
    }

    public Box buildCloseButtonBox() {
        FixedJButton buttonC = new FixedJButton(this.rMan_.getString("dialogs.close"));
        buttonC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    DialogSupport.this.closeMe_.setVisible(false);
                    DialogSupport.this.closeMe_.dispose();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
                catch (OutOfMemoryError oom) {
                    ExceptionHandler.getHandler().displayOutOfMemory(oom);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(buttonC);
        buttonPanel.add(Box.createHorizontalStrut(10));
        return buttonPanel;
    }

    public void buildAndInstallCloseButtonBox(JPanel cp, int rowNum, int colWidth, Border border) {
        Box bBox = this.buildCloseButtonBox();
        if (border != null) {
            bBox.setBorder(border);
        }
        UiUtil.gbcSet(this.gbc_, 0, rowNum, colWidth, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)bBox, this.gbc_);
    }

    public int installLabeledJComp(JComponent tf, JPanel cp, String labelRS, int rowNum, int colWidth) {
        JLabel typeLab = new JLabel(this.rMan_.getString(labelRS));
        UiUtil.gbcSet(this.gbc_, 0, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
        cp.add((Component)typeLab, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, rowNum++, colWidth - 1, 1, 2, 0, 0, 5, 5, 5, 5, 17, 1.0, 0.0);
        cp.add((Component)tf, this.gbc_);
        return rowNum;
    }

    public int installPreLabeledJComp(JComponent tf, JPanel cp, JLabel typeLab, int rowNum, int colWidth) {
        UiUtil.gbcSet(this.gbc_, 0, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
        cp.add((Component)typeLab, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, rowNum++, colWidth - 1, 1, 2, 0, 0, 5, 5, 5, 5, 17, 1.0, 0.0);
        cp.add((Component)tf, this.gbc_);
        return rowNum;
    }

    public int installLabelJCompPair(JPanel cp, String labelRS1, JComponent tf1, String labelRS2, JComponent tf2, int rowNum, int colWidth, boolean gottaGrow) {
        int halfCol = colWidth / 2;
        double vert = gottaGrow ? 1.0 : 0.0;
        JLabel typeLab = new JLabel(this.rMan_.getString(labelRS1));
        UiUtil.gbcSet(this.gbc_, 0, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, vert);
        cp.add((Component)typeLab, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, rowNum, halfCol - 1, 1, 2, 0, 0, 5, 5, 5, 5, 17, 0.5, vert);
        cp.add((Component)tf1, this.gbc_);
        JLabel lab2 = new JLabel(this.rMan_.getString(labelRS2));
        UiUtil.gbcSet(this.gbc_, halfCol, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, vert);
        cp.add((Component)lab2, this.gbc_);
        UiUtil.gbcSet(this.gbc_, halfCol + 1, rowNum++, halfCol - 1, 1, 2, 0, 0, 5, 5, 5, 5, 17, 0.5, vert);
        cp.add((Component)tf2, this.gbc_);
        return rowNum;
    }

    public int installLabelJCompTriple(JPanel cp, Object labelRS1, JComponent tf1, Object labelRS2, JComponent tf2, Object labelRS3, JComponent tf3, int rowNum, int colWidth) {
        int width;
        int thirdCol = colWidth / 3;
        int twoThirdCol = thirdCol * 2;
        if (labelRS1 != null) {
            JLabel typeLab = labelRS1 instanceof String ? new JLabel(this.rMan_.getString((String)labelRS1)) : (JLabel)labelRS1;
            UiUtil.gbcSet(this.gbc_, 0, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
            cp.add((Component)typeLab, this.gbc_);
            width = 1;
        } else {
            width = 0;
        }
        UiUtil.gbcSet(this.gbc_, width, rowNum, thirdCol - width, 1, 2, 0, 0, 5, 5, 5, 5, 17, 0.33, 0.0);
        cp.add((Component)tf1, this.gbc_);
        if (labelRS2 != null) {
            JLabel lab2 = labelRS2 instanceof String ? new JLabel(this.rMan_.getString((String)labelRS2)) : (JLabel)labelRS2;
            UiUtil.gbcSet(this.gbc_, thirdCol, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
            cp.add((Component)lab2, this.gbc_);
            width = 1;
        } else {
            width = 0;
        }
        UiUtil.gbcSet(this.gbc_, thirdCol + width, rowNum, thirdCol - width, 1, 2, 0, 0, 5, 5, 5, 5, 17, 0.33, 0.0);
        cp.add((Component)tf2, this.gbc_);
        if (labelRS2 != null) {
            JLabel lab3 = labelRS3 instanceof String ? new JLabel(this.rMan_.getString((String)labelRS3)) : (JLabel)labelRS3;
            UiUtil.gbcSet(this.gbc_, twoThirdCol, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 0.0);
            cp.add((Component)lab3, this.gbc_);
            width = 1;
        } else {
            width = 0;
        }
        UiUtil.gbcSet(this.gbc_, twoThirdCol + width, rowNum++, thirdCol - width, 1, 2, 0, 0, 5, 5, 5, 5, 17, 0.34, 0.0);
        cp.add((Component)tf3, this.gbc_);
        return rowNum;
    }

    public int addWidgetFullRow(JPanel cp, JComponent comp, boolean fixHeight, int rowNum, int columns) {
        return this.addWidgetFullRow(cp, comp, fixHeight, false, rowNum, columns);
    }

    public int addWidgetFullRow(JPanel cp, JComponent comp, boolean fixHeight, boolean flushLeft, int rowNum, int columns) {
        int worc = flushLeft ? 17 : 10;
        double vFac = fixHeight ? 0.0 : 1.0;
        UiUtil.gbcSet(this.gbc_, 0, rowNum++, columns, 1, 2, 0, 0, 5, 5, 5, 5, worc, 1.0, vFac);
        cp.add((Component)comp, this.gbc_);
        return rowNum;
    }

    public int addTallWidgetFullRow(JPanel cp, JComponent comp, boolean fixHeight, boolean flushLeft, int height, int rowNum, int columns) {
        int worc = flushLeft ? 17 : 10;
        double vFac = fixHeight ? 0.0 : 1.0;
        UiUtil.gbcSet(this.gbc_, 0, rowNum, columns, height, 2, 0, 0, 5, 5, 5, 5, worc, 1.0, vFac);
        cp.add((Component)comp, this.gbc_);
        return rowNum += height;
    }

    public int addWidgetFullRowWithInsets(JPanel cp, JComponent comp, boolean fixHeight, int inst, int insl, int insb, int insr, int rowNum, int columns) {
        double vFac = fixHeight ? 0.0 : 1.0;
        UiUtil.gbcSet(this.gbc_, 0, rowNum++, columns, 1, 2, 0, 0, inst, insl, insb, insr, 10, 1.0, vFac);
        cp.add((Component)comp, this.gbc_);
        return rowNum;
    }

    public int addLabeledWidget(JPanel cp, JLabel label, JComponent comp, boolean fixHeight, boolean flushLeft, int rowNum, int columns) {
        double vFac = fixHeight ? 0.0 : 1.0;
        int eorw = flushLeft ? 17 : 13;
        UiUtil.gbcSet(this.gbc_, 0, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, eorw, 0.0, vFac);
        cp.add((Component)label, this.gbc_);
        UiUtil.gbcSet(this.gbc_, 1, rowNum++, columns - 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, vFac);
        cp.add((Component)comp, this.gbc_);
        return rowNum;
    }

    public int addTable(JPanel cp, JComponent tablePan, int rowHeight, int rowNum, int columns) {
        UiUtil.gbcSet(this.gbc_, 0, rowNum, columns, rowHeight, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)tablePan, this.gbc_);
        return rowNum += rowHeight;
    }

    public int addTableNoInset(JPanel cp, JComponent tablePan, int rowHeight, int rowNum, int columns) {
        UiUtil.gbcSet(this.gbc_, 0, rowNum, columns, rowHeight, 1, 0, 0, 0, 0, 0, 0, 10, 1.0, 1.0);
        cp.add((Component)tablePan, this.gbc_);
        return rowNum += rowHeight;
    }
}

