/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JCheckBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.systemsbiology.biofabric.api.dialog.BTStashResultsDialog;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.layouts.NodeSimilarityLayout;
import org.systemsbiology.biofabric.util.ResourceManager;

public class ReorderLayoutParamsDialog
extends BTStashResultsDialog {
    private JTextField numPassesField_;
    private JCheckBox termAtIncreaseBox_;
    private NodeSimilarityLayout.ResortParams results_;

    public ReorderLayoutParamsDialog(JFrame parent, NodeSimilarityLayout.ResortParams params) {
        super(parent, ResourceManager.getManager().getString("clusteredLayout.reorderTitle"), new Dimension(600, 300), 2);
        ResourceManager rMan = ResourceManager.getManager();
        this.parent_ = parent;
        this.results_ = null;
        this.numPassesField_ = new JTextField(Integer.toString(params.passCount));
        JLabel label = new JLabel(rMan.getString("clusteredLayout.passCount"));
        this.addLabeledWidget(label, this.numPassesField_, false, false);
        this.termAtIncreaseBox_ = new JCheckBox(rMan.getString("clusteredLayout.termAtIncrease"));
        this.termAtIncreaseBox_.setSelected(params.terminateAtIncrease);
        this.addWidgetFullRow(this.termAtIncreaseBox_, false);
        FixedJButton buttonR = new FixedJButton(rMan.getString("dialogs.resetDefaults"));
        buttonR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    ReorderLayoutParamsDialog.this.resetDefaults();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.finishConstructionWithExtraLeftButton(buttonR);
    }

    public NodeSimilarityLayout.ResortParams getParams() {
        return this.results_;
    }

    protected boolean stashForOK() {
        this.results_ = new NodeSimilarityLayout.ResortParams();
        String passStr = this.numPassesField_.getText();
        Integer passes = this.parseInteger(passStr, "clusteredLayout.badPass");
        if (passes == null) {
            return false;
        }
        this.results_.passCount = passes;
        this.results_.terminateAtIncrease = this.termAtIncreaseBox_.isSelected();
        return true;
    }

    private Integer parseInteger(String intVal, String badMsg) {
        boolean badVal = false;
        int retVal = 1;
        if (intVal == null || intVal.trim().equals("")) {
            badVal = true;
        } else {
            try {
                retVal = Integer.parseInt(intVal);
                if (retVal < 1) {
                    badVal = true;
                }
            }
            catch (NumberFormatException ex) {
                badVal = true;
            }
        }
        if (badVal) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.parent_, rMan.getString(badMsg), rMan.getString("clusteredLayout.badValueTitle"), 0);
            return null;
        }
        return new Integer(retVal);
    }

    private void resetDefaults() {
        NodeSimilarityLayout.ResortParams defaults = new NodeSimilarityLayout.ResortParams();
        this.numPassesField_.setText(Integer.toString(defaults.passCount));
        this.termAtIncreaseBox_.setSelected(defaults.terminateAtIncrease);
    }
}

