/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import org.systemsbiology.biofabric.api.dialog.BTStashResultsDialog;
import org.systemsbiology.biofabric.api.model.AugRelation;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.ui.dialogs.utils.EditableTable;
import org.systemsbiology.biofabric.util.ResourceManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelationDirectionDialog
extends BTStashResultsDialog {
    private EditableTable<RelationDirTableModel.TableRow> est_;
    private SortedMap<AugRelation, Boolean> returnMap_ = null;
    private boolean getFromFile_ = false;
    private HashSet<AugRelation> returnKeys_;
    private SortedMap<AugRelation, Boolean> reducedMap_;
    private static final long serialVersionUID = 1L;

    public RelationDirectionDialog(JFrame parent, SortedMap<AugRelation, Boolean> relationMap) {
        super(parent, ResourceManager.getManager().getString("relDir.title"), new Dimension(800, 400), 1);
        this.returnKeys_ = new HashSet<AugRelation>(relationMap.keySet());
        this.reducedMap_ = new TreeMap<AugRelation, Boolean>();
        HashSet<String> seenRels = new HashSet<String>();
        for (AugRelation aug : relationMap.keySet()) {
            if (seenRels.contains(aug.relation)) continue;
            seenRels.add(aug.relation);
            Boolean isDir = (Boolean)relationMap.get(aug);
            this.reducedMap_.put(new AugRelation(aug.relation, false), isDir);
        }
        this.est_ = new EditableTable<RelationDirTableModel.TableRow>(new RelationDirTableModel(), this.parent_);
        EditableTable.TableParams etp = new EditableTable.TableParams();
        etp.addAlwaysAtEnd = true;
        etp.singleSelectOnly = true;
        etp.cancelEditOnDisable = true;
        etp.tableIsUnselectable = true;
        etp.perColumnEnums = null;
        etp.colWidths = new ArrayList<EditableTable.ColumnWidths>();
        etp.colWidths.add(new EditableTable.ColumnWidths(0, 50, 300, 5000));
        etp.colWidths.add(new EditableTable.ColumnWidths(1, 50, 100, 200));
        JPanel tablePan = this.est_.buildEditableTable(etp);
        this.addTable(tablePan, 8);
        this.returnKeys_ = new HashSet<AugRelation>(relationMap.keySet());
        ArrayList<JButton> xtraButtonList = new ArrayList<JButton>();
        FixedJButton buttonSA = new FixedJButton(this.rMan_.getString("dialogs.selectAll"));
        buttonSA.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    RelationDirectionDialog.this.doMassUpdate(true);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        xtraButtonList.add(buttonSA);
        FixedJButton buttonSN = new FixedJButton(this.rMan_.getString("dialogs.selectNone"));
        buttonSN.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    RelationDirectionDialog.this.doMassUpdate(false);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        xtraButtonList.add(buttonSN);
        FixedJButton buttonFile = new FixedJButton(this.rMan_.getString("relDir.useFile"));
        buttonFile.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    RelationDirectionDialog.this.getFromFile_ = true;
                    RelationDirectionDialog.this.okAction();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        xtraButtonList.add(buttonFile);
        this.finishConstructionWithMultiExtraLeftButtons(xtraButtonList);
        this.displayProperties();
    }

    void doMassUpdate(boolean select) {
        Boolean isDir = new Boolean(select);
        EditableTable.TableModel<RelationDirTableModel.TableRow> ecdtm = this.est_.getModel();
        List<RelationDirTableModel.TableRow> vals = ecdtm.getValuesFromTable();
        int numVals = vals.size();
        ArrayList<RelationDirTableModel.TableRow> upVals = new ArrayList<RelationDirTableModel.TableRow>();
        for (int i = 0; i < numVals; ++i) {
            RelationDirTableModel.TableRow tr = vals.get(i);
            RelationDirTableModel.TableRow trc = ecdtm.constructARow();
            trc.relation = tr.relation;
            trc.isDir = isDir;
            upVals.add(trc);
        }
        this.est_.updateTable(true, upVals);
    }

    public boolean getFromFile() {
        return this.getFromFile_;
    }

    public SortedMap<AugRelation, Boolean> getRelationMap() {
        if (this.getFromFile_) {
            return null;
        }
        this.returnMap_ = new TreeMap<AugRelation, Boolean>();
        for (AugRelation aug : this.returnKeys_) {
            Boolean isDir = (Boolean)this.reducedMap_.get(new AugRelation(aug.relation, false));
            this.returnMap_.put(aug, isDir);
        }
        return this.returnMap_;
    }

    public static SortedMap<AugRelation, Boolean> forceAllUndirected(SortedMap<AugRelation, Boolean> relationMap) {
        TreeMap<AugRelation, Boolean> returnMap = new TreeMap<AugRelation, Boolean>();
        for (AugRelation aug : relationMap.keySet()) {
            returnMap.put(aug, Boolean.FALSE);
        }
        return returnMap;
    }

    private void displayProperties() {
        List<RelationDirTableModel.TableRow> tableRows = this.initTableRows();
        this.est_.getModel().extractValues(tableRows);
    }

    private List<RelationDirTableModel.TableRow> initTableRows() {
        ArrayList<RelationDirTableModel.TableRow> retval = new ArrayList<RelationDirTableModel.TableRow>();
        EditableTable.TableModel<RelationDirTableModel.TableRow> ecdtm = this.est_.getModel();
        for (AugRelation aug : this.reducedMap_.keySet()) {
            RelationDirTableModel.TableRow tr = ecdtm.constructARow();
            tr.relation = aug.relation;
            tr.isDir = (Boolean)this.reducedMap_.get(aug);
            retval.add(tr);
        }
        return retval;
    }

    @Override
    protected boolean stashForOK() {
        if (this.getFromFile_) {
            this.reducedMap_.clear();
            return true;
        }
        EditableTable.TableModel<RelationDirTableModel.TableRow> ecdtm = this.est_.getModel();
        List<RelationDirTableModel.TableRow> vals = ecdtm.getValuesFromTable();
        int numVals = vals.size();
        for (int i = 0; i < numVals; ++i) {
            RelationDirTableModel.TableRow tr = vals.get(i);
            this.reducedMap_.put(new AugRelation(tr.relation, false), tr.isDir);
        }
        return true;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class RelationDirTableModel
    extends EditableTable.TableModel<TableRow> {
        private static final long serialVersionUID = 1L;
        static final int RELATION = 0;
        static final int DIRECTION = 1;
        private static final int NUM_COL_ = 2;

        RelationDirTableModel() {
            super(2);
            this.colNames_ = new String[]{"relDir.relation", "relDir.direction"};
            this.colClasses_ = new Class[]{String.class, Boolean.class};
            this.canEdit_ = new boolean[]{false, true};
        }

        @Override
        protected TableRow constructARow(int i) {
            return new TableRow(i);
        }

        @Override
        public TableRow constructARow() {
            return new TableRow();
        }

        class TableRow
        implements EditableTable.ATableRow {
            String relation;
            Boolean isDir;

            TableRow() {
            }

            TableRow(int i) {
                this.relation = (String)((List)RelationDirTableModel.this.columns_.get(0)).get(i);
                this.isDir = (Boolean)((List)RelationDirTableModel.this.columns_.get(1)).get(i);
            }

            public void toCols() {
                ((List)RelationDirTableModel.this.columns_.get(0)).add(this.relation);
                ((List)RelationDirTableModel.this.columns_.get(1)).add(this.isDir);
            }

            void replaceCols(int row) {
                ((List)RelationDirTableModel.this.columns_.get(0)).set(row, this.relation);
                ((List)RelationDirTableModel.this.columns_.get(1)).set(row, this.isDir);
            }
        }
    }
}

