/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.systemsbiology.biofabric.api.dialog.BTStashResultsDialog;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.layouts.NodeSimilarityLayout;
import org.systemsbiology.biofabric.util.ChoiceContent;
import org.systemsbiology.biofabric.util.ResourceManager;

public class NodeSimilarityLayoutSetupDialog
extends BTStashResultsDialog {
    private static final long serialVersionUID = 1L;
    private JTextField chainSizeField_;
    private JTextField jumpToleranceField_;
    private JComboBox distanceTypeCombo_ = new JComboBox<ChoiceContent>(NodeSimilarityLayout.ClusterParams.getDistanceChoices());
    private NodeSimilarityLayout.ClusterParams results_ = null;

    public NodeSimilarityLayoutSetupDialog(JFrame parent, NodeSimilarityLayout.ClusterParams params) {
        super(parent, ResourceManager.getManager().getString("clusteredLayout.title"), new Dimension(600, 350), 2);
        int numSrc = this.distanceTypeCombo_.getItemCount();
        for (int i = 0; i < numSrc; ++i) {
            ChoiceContent cc = (ChoiceContent)this.distanceTypeCombo_.getItemAt(i);
            if (cc.val != params.distanceMethod) continue;
            this.distanceTypeCombo_.setSelectedIndex(i);
            break;
        }
        JLabel label = new JLabel(this.rMan_.getString("clusteredLayout.distanceType"));
        this.addLabeledWidget(label, this.distanceTypeCombo_, false, false);
        this.chainSizeField_ = new JTextField(Integer.toString(params.chainLength));
        label = new JLabel(this.rMan_.getString("clusteredLayout.chainSize"));
        this.addLabeledWidget(label, this.chainSizeField_, false, false);
        this.jumpToleranceField_ = new JTextField(Double.toString(params.tolerance));
        label = new JLabel(this.rMan_.getString("clusteredLayout.jumpTolerance"));
        this.addLabeledWidget(label, this.jumpToleranceField_, false, false);
        FixedJButton buttonR = new FixedJButton(this.rMan_.getString("dialogs.resetDefaults"));
        buttonR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    NodeSimilarityLayoutSetupDialog.this.resetDefaults();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.finishConstructionWithExtraLeftButton(buttonR);
    }

    public NodeSimilarityLayout.ClusterParams getParams() {
        return this.results_;
    }

    protected boolean stashForOK() {
        this.results_ = new NodeSimilarityLayout.ClusterParams();
        ChoiceContent cc = (ChoiceContent)this.distanceTypeCombo_.getSelectedItem();
        this.results_.distanceMethod = cc.val;
        String chainStr = this.chainSizeField_.getText();
        Integer chainLen = this.parseInteger(chainStr, "clusteredLayout.badChain");
        if (chainLen == null) {
            return false;
        }
        this.results_.chainLength = chainLen;
        String jumpStr = this.jumpToleranceField_.getText();
        Double jumpTol = this.parseDouble(jumpStr, "clusteredLayout.badTolerance");
        if (jumpTol == null) {
            return false;
        }
        this.results_.tolerance = jumpTol;
        return true;
    }

    private Double parseDouble(String doubleVal, String badMsg) {
        boolean badVal = false;
        double levelVal = 1.0;
        if (doubleVal == null || doubleVal.trim().equals("")) {
            badVal = true;
        } else {
            try {
                levelVal = Double.parseDouble(doubleVal);
                if (levelVal < 0.0) {
                    badVal = true;
                }
                if (levelVal > 1.0) {
                    badVal = true;
                }
            }
            catch (NumberFormatException ex) {
                badVal = true;
            }
        }
        if (badVal) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.parent_, rMan.getString(badMsg), rMan.getString("clusteredLayout.badValueTitle"), 0);
            return null;
        }
        return new Double(levelVal);
    }

    private Integer parseInteger(String intVal, String badMsg) {
        boolean badVal = false;
        int retVal = 1;
        if (intVal == null || intVal.trim().equals("")) {
            badVal = true;
        } else {
            try {
                retVal = Integer.parseInt(intVal);
                if (retVal < 1) {
                    badVal = true;
                }
            }
            catch (NumberFormatException ex) {
                badVal = true;
            }
        }
        if (badVal) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.parent_, rMan.getString(badMsg), rMan.getString("clusteredLayout.badValueTitle"), 0);
            return null;
        }
        return retVal;
    }

    private void resetDefaults() {
        NodeSimilarityLayout.ClusterParams defaults = new NodeSimilarityLayout.ClusterParams();
        int numSrc = this.distanceTypeCombo_.getItemCount();
        for (int i = 0; i < numSrc; ++i) {
            ChoiceContent cc = (ChoiceContent)this.distanceTypeCombo_.getItemAt(i);
            if (cc.val != defaults.distanceMethod) continue;
            this.distanceTypeCombo_.setSelectedIndex(i);
            break;
        }
        this.chainSizeField_.setText(Integer.toString(defaults.chainLength));
        this.jumpToleranceField_.setText(Double.toString(defaults.tolerance));
    }
}

