/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs;

import java.awt.Dimension;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.text.MessageFormat;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.systemsbiology.biofabric.api.dialog.BTStashResultsDialog;
import org.systemsbiology.biofabric.api.dialog.DialogObj;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.util.ResourceManager;

public class LinkRelationDialog
extends BTStashResultsDialog {
    private JFrame parent_;
    private FixedJButton buttonOK_;
    private JTextField textField_;
    private final String DEFAULT_RELATION_;
    private static final long serialVersionUID = 1L;

    public LinkRelationDialog(JFrame parent, String default_relation) {
        super(parent, ResourceManager.getManager().getString("dialog.relationTitle"), new Dimension(600, 200), 2);
        this.parent_ = parent;
        this.DEFAULT_RELATION_ = default_relation;
        final ResourceManager rMan = ResourceManager.getManager();
        String msg = MessageFormat.format(rMan.getString("dialog.relationMessage"), "GW");
        JLabel msgLabel = new JLabel(msg);
        this.addWidgetFullRow(msgLabel, false, false);
        this.textField_ = new JTextField(this.DEFAULT_RELATION_);
        this.textField_.getDocument().addDocumentListener(new DocumentListener(){

            public void insertUpdate(DocumentEvent e) {
                try {
                    LinkRelationDialog.this.manageOKButton();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }

            public void removeUpdate(DocumentEvent e) {
                try {
                    LinkRelationDialog.this.manageOKButton();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }

            public void changedUpdate(DocumentEvent e) {
                try {
                    LinkRelationDialog.this.manageOKButton();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        JLabel label = new JLabel(rMan.getString("dialog.linkRelation"));
        this.addLabeledWidget(label, this.textField_, false, false);
        DialogObj.Buttons buttons = this.finishConstruction();
        this.buttonOK_ = buttons.okButton;
        this.manageOKButton();
        FixedJButton buttonCancel = buttons.cancelButton;
        buttonCancel.setEnabled(false);
        this.addWindowListener(new WindowListener(){

            public void windowClosing(WindowEvent e) {
                String msg = MessageFormat.format(rMan.getString("dialog.relationWarning"), LinkRelationDialog.this.getRelation());
                JOptionPane.showMessageDialog(LinkRelationDialog.this.parent_, msg, rMan.getString("dialog.relationWarningTitle"), 2);
                LinkRelationDialog.this.stashResults(true);
            }

            public void windowClosed(WindowEvent e) {
            }

            public void windowOpened(WindowEvent e) {
            }

            public void windowIconified(WindowEvent e) {
            }

            public void windowDeiconified(WindowEvent e) {
            }

            public void windowActivated(WindowEvent e) {
            }

            public void windowDeactivated(WindowEvent e) {
            }
        });
        this.setLocationRelativeTo(parent);
    }

    public String getRelation() {
        String ret = this.textField_.getText().trim();
        return this.hasMinRequirements() ? ret : this.DEFAULT_RELATION_;
    }

    private void manageOKButton() {
        if (this.hasMinRequirements()) {
            this.buttonOK_.setEnabled(true);
        } else {
            this.buttonOK_.setEnabled(false);
        }
    }

    private boolean hasMinRequirements() {
        String text = this.textField_.getText().trim();
        return !text.isEmpty() && text.split(" ").length == 1;
    }

    public void okAction() {
        try {
            super.okAction();
        }
        catch (Exception ex) {
            ExceptionHandler.getHandler().displayException(ex);
        }
    }

    protected boolean stashForOK() {
        return this.hasMinRequirements();
    }
}

