/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.systemsbiology.biofabric.api.dialog.BTStashResultsDialog;
import org.systemsbiology.biofabric.api.model.AugRelation;
import org.systemsbiology.biofabric.api.model.Network;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.cmd.CommandSet;
import org.systemsbiology.biofabric.ui.dialogs.utils.EditableTable;
import org.systemsbiology.biofabric.util.DataUtil;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LinkGroupingSetupDialog
extends BTStashResultsDialog {
    private final int CHOICE_PER_NODE = 0;
    private final int CHOICE_PER_NETWORK = 1;
    private List<String> linkGroupResult_;
    private EditableTable<LinkGroupingTableModel.TableRow> est_;
    private JFrame parent_;
    private Set<AugRelation> allRelations_;
    private JComboBox comboBox;
    private JCheckBox showAnnotationsBox_;
    private boolean showAnnotations_;
    private Network.LayoutMode chosenMode;
    private static final long serialVersionUID = 1L;

    public LinkGroupingSetupDialog(JFrame parent, List<String> currentTags, boolean showGroupAnnot, Network.LayoutMode mode, Set<AugRelation> allRelations) {
        super(parent, ResourceManager.getManager().getString("linkGroupEdit.title"), new Dimension(650, 450), 2);
        this.parent_ = parent;
        this.allRelations_ = allRelations;
        this.installJComboBox(mode);
        this.showAnnotationsBox_ = new JCheckBox(this.rMan_.getString("linkGroupEdit.showLinkAnnotations"));
        this.addWidgetFullRow(this.showAnnotationsBox_, true, true);
        this.showAnnotationsBox_.setSelected(showGroupAnnot);
        FixedJButton fileButton = new FixedJButton(this.rMan_.getString("linkGroupEdit.loadFromFile"));
        fileButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    LinkGroupingSetupDialog.this.loadFromFile();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.est_ = new EditableTable<LinkGroupingTableModel.TableRow>(new LinkGroupingTableModel(), this.parent_);
        EditableTable.TableParams etp = new EditableTable.TableParams();
        etp.addAlwaysAtEnd = false;
        etp.buttons = 29;
        etp.singleSelectOnly = true;
        JPanel tablePan = this.est_.buildEditableTable(etp);
        this.addTable(tablePan, 4);
        List<LinkGroupingTableModel.TableRow> initRows = this.initTableRows(currentTags == null ? new ArrayList() : currentTags);
        this.est_.getModel().extractValues(initRows);
        this.setLocationRelativeTo(parent);
        this.finishConstructionWithExtraLeftButton(fileButton);
    }

    private void installJComboBox(Network.LayoutMode mode) {
        JLabel boxLabel = new JLabel(this.rMan_.getString("linkGroupEdit.mode"));
        String[] choices = new String[]{this.rMan_.getString("linkGroupEdit.orderPerNode"), this.rMan_.getString("linkGroupEdit.orderNetwork")};
        this.comboBox = new JComboBox<String>(choices);
        if (mode == Network.LayoutMode.UNINITIALIZED_MODE || mode == Network.LayoutMode.PER_NODE_MODE) {
            this.comboBox.setSelectedIndex(0);
        } else if (mode == Network.LayoutMode.PER_NETWORK_MODE) {
            this.comboBox.setSelectedIndex(1);
        }
        this.addLabeledWidget(boxLabel, this.comboBox, true, true);
    }

    public List<String> getGroups() {
        return this.linkGroupResult_;
    }

    public Network.LayoutMode getChosenMode() {
        return this.chosenMode;
    }

    public boolean showLinkAnnotations() {
        return this.showAnnotations_;
    }

    @Override
    protected boolean stashForOK() {
        this.linkGroupResult_ = ((LinkGroupingTableModel)this.est_.getModel()).applyValues();
        if (this.linkGroupResult_ == null) {
            return false;
        }
        int mode = this.comboBox.getSelectedIndex();
        if (mode == 0) {
            this.chosenMode = Network.LayoutMode.PER_NODE_MODE;
        } else if (mode == 1) {
            this.chosenMode = Network.LayoutMode.PER_NETWORK_MODE;
        } else {
            ExceptionHandler.getHandler().displayException(new IllegalArgumentException("Illegal Selected Index"));
        }
        this.showAnnotations_ = this.showAnnotationsBox_.isSelected();
        return true;
    }

    private void loadFromFile() {
        CommandSet cmd = CommandSet.getCmds("mainWindow");
        File fileEda = cmd.getFileLoader().getTheFile(".txt", null, "AttribDirectory", "filterName.txt", this);
        if (fileEda == null) {
            return;
        }
        List<String> groups = UiUtil.simpleFileRead(fileEda);
        if (groups == null) {
            return;
        }
        List<LinkGroupingTableModel.TableRow> initRows = this.initTableRows(groups);
        this.est_.updateTable(true, initRows);
    }

    private List<LinkGroupingTableModel.TableRow> initTableRows(List<String> inTags) {
        ArrayList<LinkGroupingTableModel.TableRow> retval = new ArrayList<LinkGroupingTableModel.TableRow>();
        EditableTable.TableModel<LinkGroupingTableModel.TableRow> ecdtm = this.est_.getModel();
        for (String tag : inTags) {
            LinkGroupingTableModel.TableRow tr = ecdtm.constructARow();
            tr.groupTag = tag;
            retval.add(tr);
        }
        return retval;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    class LinkGroupingTableModel
    extends EditableTable.TableModel<TableRow> {
        private static final int GROUP_TAG_ = 0;
        private static final int NUM_COL_ = 1;
        private static final long serialVersionUID = 1L;

        LinkGroupingTableModel() {
            super(1);
            this.colNames_ = new String[]{"linkGroupEdit.suffix"};
            this.colClasses_ = new Class[]{String.class};
        }

        @Override
        protected TableRow constructARow(int i) {
            return new TableRow(i);
        }

        @Override
        public TableRow constructARow() {
            return new TableRow();
        }

        List<String> applyValues() {
            List vals = this.getValuesFromTable();
            ResourceManager rMan = ResourceManager.getManager();
            ArrayList<String> seenTags = new ArrayList<String>();
            int size = vals.size();
            if (size == 0) {
                return seenTags;
            }
            for (int i = 0; i < size; ++i) {
                String tag = ((TableRow)vals.get((int)i)).groupTag;
                if (tag == null || tag.trim().equals("")) {
                    JOptionPane.showMessageDialog(LinkGroupingSetupDialog.this.parent_, rMan.getString("rsedit.badRegion"), rMan.getString("rsedit.badRegionTitle"), 0);
                    return null;
                }
                if (DataUtil.containsKey(seenTags, tag = tag.trim())) {
                    JOptionPane.showMessageDialog(LinkGroupingSetupDialog.this.parent_, rMan.getString("rsedit.dupRegion"), rMan.getString("rsedit.badRegionTitle"), 0);
                    return null;
                }
                seenTags.add(tag);
            }
            boolean fail = false;
            int numST = seenTags.size();
            for (AugRelation relation : LinkGroupingSetupDialog.this.allRelations_) {
                boolean gotIt = false;
                for (int i = 0; i < numST; ++i) {
                    if (relation.relation.indexOf(seenTags.get(i)) == -1) continue;
                    gotIt = true;
                    break;
                }
                if (gotIt) continue;
                fail = true;
                break;
            }
            if (fail) {
                JOptionPane.showMessageDialog(LinkGroupingSetupDialog.this.parent_, rMan.getString("rsedit.notCovering"), rMan.getString("rsedit.badCoverageTitle"), 0);
                return null;
            }
            return seenTags;
        }

        public class TableRow
        implements EditableTable.ATableRow {
            public String groupTag;

            public TableRow() {
            }

            public TableRow(String val) {
                this.groupTag = val;
            }

            TableRow(int i) {
                this.groupTag = (String)((List)LinkGroupingTableModel.this.columns_.get(0)).get(i);
            }

            public void toCols() {
                ((List)LinkGroupingTableModel.this.columns_.get(0)).add(this.groupTag);
            }
        }
    }
}

