/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Set;
import java.util.Vector;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.systemsbiology.biofabric.api.model.NetNode;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.model.BioFabricNetwork;
import org.systemsbiology.biofabric.util.ChoiceContent;
import org.systemsbiology.biofabric.util.DataUtil;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.UiUtil;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FabricSearchDialog
extends JDialog {
    private static final int FULL_MATCH_ = 0;
    private static final int PARTIAL_MATCH_ = 1;
    private static final long serialVersionUID = 1L;
    private JTextField stringField_;
    private JFrame parent_;
    private boolean itemFound_;
    private JComboBox matchTypeCombo_;
    private JCheckBox discardSelections_;
    private BioFabricNetwork bfn_;
    private Set<NetNode> result_;
    private boolean doDiscard_;

    public FabricSearchDialog(JFrame parent, BioFabricNetwork bfn, boolean haveSelection, boolean buildingSels) {
        super(parent, ResourceManager.getManager().getString("nsearch.title"), true);
        this.parent_ = parent;
        this.itemFound_ = false;
        this.bfn_ = bfn;
        this.doDiscard_ = false;
        ResourceManager rMan = ResourceManager.getManager();
        this.setSize(600, 300);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setBorder(new EmptyBorder(20, 20, 20, 20));
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JPanel search = this.buildNodeSearchTab(haveSelection, buildingSels);
        int rowNum = 0;
        UiUtil.gbcSet(gbc, 0, rowNum, 10, 8, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)search, gbc);
        rowNum += 8;
        FixedJButton buttonO = new FixedJButton(rMan.getString("nsearch.search"));
        buttonO.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (!FabricSearchDialog.this.doSearch()) {
                        return;
                    }
                    FabricSearchDialog.this.setVisible(false);
                    FabricSearchDialog.this.dispose();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        FixedJButton buttonC = new FixedJButton(rMan.getString("dialogs.cancel"));
        buttonC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    FabricSearchDialog.this.setVisible(false);
                    FabricSearchDialog.this.dispose();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(buttonO);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(buttonC);
        UiUtil.gbcSet(gbc, 0, rowNum, 4, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)buttonPanel, gbc);
        this.setLocationRelativeTo(parent);
    }

    public boolean itemWasFound() {
        return this.itemFound_;
    }

    public Set<NetNode> getMatches() {
        return this.result_;
    }

    public boolean discardSelections() {
        return this.doDiscard_;
    }

    private JPanel buildNodeSearchTab(boolean haveSelection, boolean buildingSelections) {
        ResourceManager rMan = ResourceManager.getManager();
        JPanel cp = new JPanel();
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        JLabel label = new JLabel(rMan.getString("nsearch.searchString"));
        this.stringField_ = new JTextField();
        int rowNum = 0;
        UiUtil.gbcSet(gbc, 0, rowNum, 1, 1, 0, 0, 0, 5, 5, 5, 5, 13, 0.0, 1.0);
        cp.add((Component)label, gbc);
        UiUtil.gbcSet(gbc, 1, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)this.stringField_, gbc);
        this.matchTypeCombo_ = new JComboBox<ChoiceContent>(this.getMatchChoices());
        UiUtil.gbcSet(gbc, 2, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.0, 1.0);
        cp.add((Component)this.matchTypeCombo_, gbc);
        if (haveSelection) {
            this.discardSelections_ = new JCheckBox(rMan.getString("nsearch.discardCurrentSelections"));
            this.discardSelections_.setSelected(!buildingSelections);
            UiUtil.gbcSet(gbc, 2, rowNum++, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.0, 1.0);
            cp.add((Component)this.discardSelections_, gbc);
        }
        return cp;
    }

    private Vector<ChoiceContent> getMatchChoices() {
        ResourceManager rMan = ResourceManager.getManager();
        Vector<ChoiceContent> retval = new Vector<ChoiceContent>();
        retval.add(new ChoiceContent(rMan.getString("nsearch.fullMatch"), 0));
        retval.add(new ChoiceContent(rMan.getString("nsearch.partialMatch"), 1));
        return retval;
    }

    private boolean doSearch() {
        int matchType = ((ChoiceContent)this.matchTypeCombo_.getSelectedItem()).val;
        String search = this.normalizeSearchString(this.stringField_.getText().trim());
        this.result_ = this.bfn_.nodeMatches(matchType == 0, search);
        if (this.result_.isEmpty()) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this, rMan.getString("nsearch.noMatchMessage"), rMan.getString("nsearch.noMatchTitle"), 2);
            return false;
        }
        this.doDiscard_ = this.discardSelections_ != null ? this.discardSelections_.isSelected() : false;
        this.itemFound_ = true;
        return true;
    }

    private String normalizeSearchString(String searchString) {
        return DataUtil.normKey(searchString);
    }
}

