/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs;

import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.net.MalformedURLException;
import java.net.URL;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JTextField;
import org.systemsbiology.biofabric.api.dialog.BTStashResultsDialog;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.ui.FabricDisplayOptions;
import org.systemsbiology.biofabric.ui.FabricDisplayOptionsManager;
import org.systemsbiology.biofabric.util.ResourceManager;

public class FabricDisplayOptionsDialog
extends BTStashResultsDialog {
    private static final long serialVersionUID = 1L;
    private final Integer[] minDrainZoneChoices = new Integer[]{1, 2, 3, 4, 5, 10, 20};
    private JTextField selectionOpaqueLevelField_;
    private JTextField nodeLighterLevelField_;
    private JTextField linkDarkerLevelField_;
    private JCheckBox displayShadowsBox_;
    private JCheckBox minShadSublinksBox_;
    private JCheckBox shadeNodesBox_;
    private JComboBox minDrainZoneBox_;
    private JCheckBox offerNodeBrowser_;
    private JTextField browserURLField_;
    private JCheckBox offerLinkBrowser_;
    private JTextField browserLinkURLField_;
    private FabricDisplayOptions newOpts_;
    private boolean needRebuild_;
    private boolean needRecolor_;

    public FabricDisplayOptionsDialog(JFrame parent) {
        super(parent, ResourceManager.getManager().getString("displayOptions.title"), new Dimension(1000, 600), 2);
        ResourceManager rMan = ResourceManager.getManager();
        this.parent_ = parent;
        FabricDisplayOptionsManager dopmgr = FabricDisplayOptionsManager.getMgr();
        FabricDisplayOptions options = dopmgr.getDisplayOptions();
        this.selectionOpaqueLevelField_ = new JTextField(Double.toString(options.getSelectionOpaqueLevel()));
        JLabel label = new JLabel(rMan.getString("displayOptions.selectionOpaqueLevel"));
        this.addLabeledWidget(label, this.selectionOpaqueLevelField_, false, false);
        this.nodeLighterLevelField_ = new JTextField(Double.toString(options.getNodeLighterLevel()));
        label = new JLabel(rMan.getString("displayOptions.nodeLighterLevel"));
        this.addLabeledWidget(label, this.nodeLighterLevelField_, false, false);
        this.linkDarkerLevelField_ = new JTextField(Double.toString(options.getLinkDarkerLevel()));
        label = new JLabel(rMan.getString("displayOptions.linkDarkerLevel"));
        this.addLabeledWidget(label, this.linkDarkerLevelField_, false, false);
        this.displayShadowsBox_ = new JCheckBox(rMan.getString("displayOptions.displayShadowLinks"));
        this.displayShadowsBox_.setSelected(options.getDisplayShadows());
        this.displayShadowsBox_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    FabricDisplayOptionsDialog.this.minShadSublinksBox_.setEnabled(FabricDisplayOptionsDialog.this.displayShadowsBox_.isSelected());
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.addWidgetFullRow(this.displayShadowsBox_, false);
        this.minShadSublinksBox_ = new JCheckBox(rMan.getString("displayOptions.minShadowSubLinks"));
        this.minShadSublinksBox_.setSelected(options.getMinShadowSubmodelLinks());
        this.minShadSublinksBox_.setEnabled(options.getDisplayShadows());
        this.addWidgetFullRow(this.minShadSublinksBox_, false);
        this.shadeNodesBox_ = new JCheckBox(rMan.getString("displayOptions.shadeNodes"));
        this.shadeNodesBox_.setSelected(options.getShadeNodes());
        this.addWidgetFullRow(this.shadeNodesBox_, false);
        this.minDrainZoneBox_ = new JComboBox<Integer>(this.minDrainZoneChoices);
        this.minDrainZoneBox_.setSelectedIndex(this.getMinDrainZoneIndex(options.getMinDrainZone()));
        label = new JLabel(rMan.getString("displayOptions.minDrainZone"));
        this.addLabeledWidget(label, this.minDrainZoneBox_, false, false);
        this.offerNodeBrowser_ = new JCheckBox(rMan.getString("displayOptions.offerNodeBrowser"));
        this.offerNodeBrowser_.setSelected(options.getOfferNodeBrowser());
        this.addWidgetFullRow(this.offerNodeBrowser_, false);
        this.browserURLField_ = new JTextField(options.getBrowserURL());
        label = new JLabel(rMan.getString("displayOptions.browserURL"));
        this.addLabeledWidget(label, this.browserURLField_, false, false);
        this.offerLinkBrowser_ = new JCheckBox(rMan.getString("displayOptions.offerLinkBrowser"));
        this.offerLinkBrowser_.setSelected(options.getOfferLinkBrowser());
        this.addWidgetFullRow(this.offerLinkBrowser_, false);
        this.browserLinkURLField_ = new JTextField(options.getBrowserLinkURL());
        label = new JLabel(rMan.getString("displayOptions.browserLinkURL"));
        this.addLabeledWidget(label, this.browserLinkURLField_, false, false);
        FixedJButton buttonR = new FixedJButton(rMan.getString("dialogs.resetDefaults"));
        buttonR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    FabricDisplayOptionsDialog.this.resetDefaults();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.finishConstructionWithExtraLeftButton(buttonR);
    }

    public FabricDisplayOptions getNewOpts() {
        return this.newOpts_;
    }

    public boolean needsRecolor() {
        return this.needRecolor_;
    }

    public boolean needsRebuild() {
        return this.needRebuild_;
    }

    protected boolean stashForOK() {
        FabricDisplayOptionsManager dopmgr = FabricDisplayOptionsManager.getMgr();
        FabricDisplayOptions oldOpts = dopmgr.getDisplayOptions();
        this.newOpts_ = new FabricDisplayOptions();
        this.needRecolor_ = false;
        this.needRebuild_ = false;
        String selOpqStr = this.selectionOpaqueLevelField_.getText();
        Double selOpq = this.parseDouble(selOpqStr, "displayOptions.badOpqLevel");
        if (selOpq == null) {
            return false;
        }
        if (selOpq < 0.0 || selOpq > 1.0) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.parent_, rMan.getString("displayOptions.opacityOOB"), rMan.getString("displayOptions.badLevelTitle"), 0);
            return false;
        }
        this.newOpts_.setSelectionOpaqueLevel(selOpq);
        String nodeLightStr = this.nodeLighterLevelField_.getText();
        Double nodeLight = this.parseDouble(nodeLightStr, "displayOptions.badNodeLightLevel");
        if (nodeLight == null) {
            return false;
        }
        if (nodeLight < 0.0 || nodeLight > 1.0) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.parent_, rMan.getString("displayOptions.nodeLightOOB"), rMan.getString("displayOptions.badLevelTitle"), 0);
            return false;
        }
        this.newOpts_.setNodeLighterLevel(nodeLight);
        this.needRecolor_ = this.needRecolor_ || oldOpts.getNodeLighterLevel() != this.newOpts_.getNodeLighterLevel();
        String linkDrkStr = this.linkDarkerLevelField_.getText();
        Double linkDrk = this.parseDouble(linkDrkStr, "displayOptions.badLinkDarkLevel");
        if (linkDrk == null) {
            return false;
        }
        if (linkDrk < 0.0 || linkDrk > 1.0) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.parent_, rMan.getString("displayOptions.linkDarkOOB"), rMan.getString("displayOptions.badLevelTitle"), 0);
            return false;
        }
        this.newOpts_.setLinkDarkerLevel(linkDrk);
        this.needRecolor_ = this.needRecolor_ || oldOpts.getLinkDarkerLevel() != this.newOpts_.getLinkDarkerLevel();
        boolean currDisp = this.displayShadowsBox_.isSelected();
        this.newOpts_.setDisplayShadows(currDisp);
        this.needRebuild_ = this.needRebuild_ || oldOpts.getDisplayShadows() != this.newOpts_.getDisplayShadows();
        boolean minShadSublinks = this.minShadSublinksBox_.isSelected();
        this.newOpts_.setMinShadowSubmodelLinks(currDisp && minShadSublinks);
        boolean currShade = this.shadeNodesBox_.isSelected();
        this.newOpts_.setShadeNodes(currShade);
        this.needRecolor_ = this.needRecolor_ || oldOpts.getShadeNodes() != this.newOpts_.getShadeNodes();
        int newMinDrainZone = this.minDrainZoneChoices[this.minDrainZoneBox_.getSelectedIndex()];
        this.newOpts_.setMinDrainZone(newMinDrainZone);
        this.needRecolor_ = this.needRecolor_ || oldOpts.getMinDrainZone() != this.newOpts_.getMinDrainZone();
        boolean offerNode = this.offerNodeBrowser_.isSelected();
        this.newOpts_.setOfferNodeBrowser(offerNode);
        boolean offerLink = this.offerLinkBrowser_.isSelected();
        this.newOpts_.setOfferLinkBrowser(offerLink);
        String browserURL = this.browserURLField_.getText().trim();
        if (!this.testURL(browserURL, true)) {
            return false;
        }
        this.newOpts_.setBrowserURL(browserURL);
        String browserLinkURL = this.browserLinkURLField_.getText().trim();
        if (!this.testURL(browserLinkURL, false)) {
            return false;
        }
        this.newOpts_.setBrowserLinkURL(browserLinkURL);
        return true;
    }

    private boolean testURL(String browserURL, boolean forNode) {
        if (!browserURL.equals("")) {
            boolean badURL = false;
            String testURL = null;
            if (forNode) {
                if (browserURL.indexOf("%_BIOFABRIC_NODE_NAME_%") == -1) {
                    badURL = true;
                } else {
                    testURL = browserURL.replaceFirst("%_BIOFABRIC_NODE_NAME_%", "WJRL");
                }
            } else if (browserURL.indexOf("%_BIOFABRIC_LINK_SRC_%") == -1 || browserURL.indexOf("%_BIOFABRIC_LINK_TRG_%") == -1 || browserURL.indexOf("%_BIOFABRIC_LINK_REL_%") == -1) {
                badURL = true;
            } else {
                testURL = browserURL.replaceFirst("%_BIOFABRIC_LINK_SRC_%", "WJRL");
                testURL = testURL.replaceFirst("%_BIOFABRIC_LINK_TRG_%", "WJRL");
                testURL = testURL.replaceFirst("%_BIOFABRIC_LINK_REL_%", "WJRL");
            }
            if (testURL != null) {
                try {
                    URL uRL = new URL(browserURL);
                }
                catch (MalformedURLException muex) {
                    badURL = true;
                }
            }
            if (badURL) {
                ResourceManager rMan = ResourceManager.getManager();
                JOptionPane.showMessageDialog(this.parent_, rMan.getString("displayOptions.badURL"), rMan.getString("displayOptions.badURLTitle"), 0);
                return false;
            }
        }
        return true;
    }

    private Double parseDouble(String doubleVal, String badMsg) {
        boolean badVal = false;
        double levelVal = 1.0;
        if (doubleVal == null || doubleVal.trim().equals("")) {
            badVal = true;
        } else {
            try {
                levelVal = Double.parseDouble(doubleVal);
                if (levelVal < 0.0) {
                    badVal = true;
                }
            }
            catch (NumberFormatException ex) {
                badVal = true;
            }
        }
        if (badVal) {
            ResourceManager rMan = ResourceManager.getManager();
            JOptionPane.showMessageDialog(this.parent_, rMan.getString(badMsg), rMan.getString("displayOptions.badLevelTitle"), 0);
            return null;
        }
        return new Double(levelVal);
    }

    private int getMinDrainZoneIndex(int choice) {
        for (int i = 0; i < this.minDrainZoneChoices.length; ++i) {
            if (choice != this.minDrainZoneChoices[i]) continue;
            return i;
        }
        throw new IllegalArgumentException("Wrong argument: " + choice + " for min drain zone index request");
    }

    private void resetDefaults() {
        FabricDisplayOptions defOptions = new FabricDisplayOptions();
        this.selectionOpaqueLevelField_.setText(Double.toString(defOptions.getSelectionOpaqueLevel()));
        this.nodeLighterLevelField_.setText(Double.toString(defOptions.getNodeLighterLevel()));
        this.linkDarkerLevelField_.setText(Double.toString(defOptions.getLinkDarkerLevel()));
        this.displayShadowsBox_.setSelected(defOptions.getDisplayShadows());
        this.minShadSublinksBox_.setSelected(defOptions.getMinShadowSubmodelLinks());
        this.shadeNodesBox_.setSelected(defOptions.getShadeNodes());
        this.browserURLField_.setText(defOptions.getBrowserURL());
        this.browserLinkURLField_.setText(defOptions.getBrowserLinkURL());
    }
}

