/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.ui.ImageExporter;
import org.systemsbiology.biofabric.ui.dialogs.ExportSettingsDialog;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.UiUtil;

public class ExportSettingsPublishDialog
extends JDialog {
    private static final int NONE_ = 0;
    private static final int ZOOM_ = 1;
    private static final int HEIGHT_ = 2;
    private static final int WIDTH_ = 3;
    private static final int ASPECT_ = 4;
    private static final int RES_ = 5;
    private static final double CM_PER_INCH_ = 2.54;
    private static final double MIN_SIZE_INCH_ = 0.1;
    private static final double MIN_SIZE_CM_ = 0.254;
    private static final double MAX_SIZE_INCH_ = 72.0;
    private static final double MAX_SIZE_CM_ = 182.88;
    private static final double DIM_MULT_ = 100.0;
    private static final double ZOOM_MULT_ = 100000.0;
    private JRadioButton useInches_;
    private JRadioButton useCm_;
    private JCheckBox keepAspect_;
    private JTextField pubWidth_;
    private JTextField pubHeight_;
    private JTextField pubZoom_;
    private JComboBox pubResolution_;
    private JLabel pubWidthUnits_;
    private JLabel pubHeightUnits_;
    private JLabel pubResUnits_;
    private int currentUnits_;
    private JComboBox pubCombo_;
    private boolean processing_;
    private Settings currSettings_;
    private Settings origSettings_;
    private int origUnits_;
    private String origFormat_;
    private int origResIndex_;
    private List resList_;
    private String currentFormat_;
    private ExportSettingsDialog.ExportSettings finishedSettings_;
    private Preferences prefs_;

    public ExportSettingsPublishDialog(JFrame parent, int baseWidth, int baseHeight) {
        super(parent, ResourceManager.getManager().getString("exportDialog.title"), true);
        ResourceManager rMan = ResourceManager.getManager();
        this.setSize(400, 350);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setBorder(new EmptyBorder(20, 20, 20, 20));
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.finishedSettings_ = null;
        this.currSettings_ = new Settings(baseHeight, baseWidth);
        this.prefs_ = Preferences.userNodeForPackage(this.getClass());
        this.currSettings_.zoom = this.prefs_.getDouble("ExportPublishZoom", 1.0);
        List<String> types = ImageExporter.getSupportedExports();
        String maybeFormat = this.prefs_.get("ExportPublishFormat", "TIFF");
        this.currentFormat_ = types.contains(maybeFormat) ? maybeFormat : (types.contains("PNG") ? "PNG" : types.get(0));
        this.origFormat_ = this.currentFormat_;
        this.resList_ = ImageExporter.getSupportedResolutions(true);
        JPanel pubPanel = this.buildPublishPanel(baseWidth, baseHeight, types);
        this.origSettings_ = new Settings(this.currSettings_);
        this.origUnits_ = this.currentUnits_;
        this.origResIndex_ = this.pubResolution_.getSelectedIndex();
        UiUtil.gbcSet(gbc, 0, 0, 10, 8, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)pubPanel, gbc);
        FixedJButton buttonR = new FixedJButton(rMan.getString("dialogs.reset"));
        buttonR.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    ExportSettingsPublishDialog.this.reset();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        FixedJButton buttonO = new FixedJButton(rMan.getString("exportDialog.ok"));
        buttonO.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (ExportSettingsPublishDialog.this.extractProperties()) {
                        ExportSettingsPublishDialog.this.setVisible(false);
                        ExportSettingsPublishDialog.this.dispose();
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        FixedJButton buttonC = new FixedJButton(rMan.getString("exportDialog.cancel"));
        buttonC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    ExportSettingsPublishDialog.this.setVisible(false);
                    ExportSettingsPublishDialog.this.dispose();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(buttonR);
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(buttonO);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(buttonC);
        UiUtil.gbcSet(gbc, 0, 8, 10, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)buttonPanel, gbc);
        this.setLocationRelativeTo(parent);
    }

    public ExportSettingsDialog.ExportSettings getResults() {
        return this.finishedSettings_;
    }

    private void reset() {
        if (this.processing_) {
            return;
        }
        this.processing_ = true;
        try {
            this.currentUnits_ = this.origUnits_;
            this.useInches_.setSelected(this.currentUnits_ == 0);
            this.useCm_.setSelected(this.currentUnits_ == 1);
            this.updateUnits();
            this.pubCombo_.setSelectedItem(this.origFormat_);
            this.currSettings_.merge(this.origSettings_);
            this.pubWidth_.setText(Double.toString(this.currSettings_.width));
            this.pubHeight_.setText(Double.toString(this.currSettings_.height));
            this.pubZoom_.setText(Double.toString(this.currSettings_.zoom));
            this.keepAspect_.setSelected(this.currSettings_.aspectFixed);
            this.pubResolution_.setSelectedIndex(this.origResIndex_);
        }
        finally {
            this.processing_ = false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processPublishVal(boolean force, int whichVal) {
        if (this.processing_) {
            return;
        }
        this.processing_ = true;
        try {
            double min = this.currentUnits_ == 0 ? 0.1 : 0.254;
            double max = this.currentUnits_ == 0 ? 72.0 : 182.88;
            boolean fixVal = false;
            double newZoom = this.currSettings_.zoom;
            if (whichVal == 1) {
                String zoomText = this.pubZoom_.getText().trim();
                boolean haveZoom = false;
                if (!zoomText.equals("") && !zoomText.equals(".")) {
                    try {
                        double parsedZoom = Double.parseDouble(zoomText);
                        if (parsedZoom > 0.0) {
                            newZoom = parsedZoom;
                            haveZoom = true;
                        } else if (parsedZoom == 0.0) {
                            if (force) {
                                Toolkit.getDefaultToolkit().beep();
                            }
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                        if (haveZoom && this.tooBigOrSmall(newZoom, 1)) {
                            newZoom = this.currSettings_.zoom;
                            haveZoom = false;
                            Toolkit.getDefaultToolkit().beep();
                        }
                        if (haveZoom && parsedZoom != ExportSettingsPublishDialog.rounded(parsedZoom, 100000.0)) {
                            newZoom = this.currSettings_.zoom;
                            haveZoom = false;
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                    catch (NumberFormatException nfe) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else if (force) {
                    Toolkit.getDefaultToolkit().beep();
                }
                if (force && !haveZoom) {
                    fixVal = true;
                }
            }
            double newHeight = this.currSettings_.height;
            if (whichVal == 2) {
                String heightText = this.pubHeight_.getText().trim();
                boolean haveHeight = false;
                if (!heightText.equals("") && !heightText.equals(".")) {
                    try {
                        double parsedHeight = Double.parseDouble(heightText);
                        if (parsedHeight >= min && parsedHeight <= max) {
                            newHeight = parsedHeight;
                            haveHeight = true;
                        } else if (parsedHeight == 0.0) {
                            if (force) {
                                Toolkit.getDefaultToolkit().beep();
                            }
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                        if (haveHeight && this.tooBigOrSmall(newHeight, 2)) {
                            newHeight = this.currSettings_.height;
                            haveHeight = false;
                            Toolkit.getDefaultToolkit().beep();
                        }
                        if (haveHeight && parsedHeight != ExportSettingsPublishDialog.rounded(parsedHeight, 100.0)) {
                            newHeight = this.currSettings_.height;
                            haveHeight = false;
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                    catch (NumberFormatException nfe) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else if (force) {
                    Toolkit.getDefaultToolkit().beep();
                }
                if (force && !haveHeight) {
                    fixVal = true;
                }
            }
            double newWidth = this.currSettings_.width;
            if (whichVal == 3) {
                String widthText = this.pubWidth_.getText().trim();
                boolean haveWidth = false;
                if (!widthText.equals("") && !widthText.equals(".")) {
                    try {
                        double parsedWidth = Double.parseDouble(widthText);
                        if (parsedWidth >= min && parsedWidth <= max) {
                            newWidth = parsedWidth;
                            haveWidth = true;
                        } else if (parsedWidth == 0.0) {
                            if (force) {
                                Toolkit.getDefaultToolkit().beep();
                            }
                        } else {
                            Toolkit.getDefaultToolkit().beep();
                        }
                        if (haveWidth && this.tooBigOrSmall(newWidth, 3)) {
                            newWidth = this.currSettings_.width;
                            haveWidth = false;
                            Toolkit.getDefaultToolkit().beep();
                        }
                        if (haveWidth && parsedWidth != ExportSettingsPublishDialog.rounded(parsedWidth, 100.0)) {
                            newWidth = this.currSettings_.width;
                            haveWidth = false;
                            Toolkit.getDefaultToolkit().beep();
                        }
                    }
                    catch (NumberFormatException nfe) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                } else if (force) {
                    Toolkit.getDefaultToolkit().beep();
                }
                if (force && !haveWidth) {
                    fixVal = true;
                }
            }
            boolean newAspect = this.currSettings_.aspectFixed;
            if (whichVal == 4) {
                newAspect = this.keepAspect_.isSelected();
            }
            long newRes = this.currSettings_.resolution;
            if (whichVal == 5) {
                newRes = this.resolutionForIndex(this.pubResolution_.getSelectedIndex());
            }
            this.setFields(whichVal, newZoom, newHeight, newWidth, newAspect, newRes, fixVal);
        }
        finally {
            this.processing_ = false;
        }
    }

    private void setFields(int whichVal, double newZoom, double newHeight, double newWidth, boolean newAspect, long newRes, boolean fixVal) {
        Settings settings = new Settings(this.currSettings_);
        switch (whichVal) {
            case 1: {
                settings.changeZoom(newZoom);
                if (settings.zoomChanged(this.currSettings_)) {
                    this.currSettings_.mergeZoom(settings);
                }
                if (settings.widthChanged(this.currSettings_)) {
                    this.currSettings_.mergeWidth(settings);
                    this.pubWidth_.setText(Double.toString(this.currSettings_.width));
                }
                if (settings.heightChanged(this.currSettings_)) {
                    this.currSettings_.mergeHeight(settings);
                    this.pubHeight_.setText(Double.toString(this.currSettings_.height));
                }
                if (!fixVal) break;
                this.pubZoom_.setText(Double.toString(this.currSettings_.zoom));
                break;
            }
            case 2: {
                settings.changeHeight(newHeight);
                if (settings.heightChanged(this.currSettings_)) {
                    this.currSettings_.mergeHeight(settings);
                }
                if (settings.widthChanged(this.currSettings_)) {
                    this.currSettings_.mergeWidth(settings);
                    this.pubWidth_.setText(Double.toString(this.currSettings_.width));
                }
                if (settings.zoomChanged(this.currSettings_)) {
                    this.currSettings_.mergeZoom(settings);
                    this.pubZoom_.setText(Double.toString(this.currSettings_.zoom));
                }
                if (!fixVal) break;
                this.pubHeight_.setText(Double.toString(this.currSettings_.height));
                break;
            }
            case 3: {
                settings.changeWidth(newWidth);
                if (settings.widthChanged(this.currSettings_)) {
                    this.currSettings_.mergeWidth(settings);
                }
                this.currSettings_.mergeWidth(settings);
                if (settings.heightChanged(this.currSettings_)) {
                    this.currSettings_.mergeHeight(settings);
                    this.pubHeight_.setText(Double.toString(this.currSettings_.height));
                }
                if (settings.zoomChanged(this.currSettings_)) {
                    this.currSettings_.mergeZoom(settings);
                    this.pubZoom_.setText(Double.toString(this.currSettings_.zoom));
                }
                if (!fixVal) break;
                this.pubWidth_.setText(Double.toString(this.currSettings_.width));
                break;
            }
            case 4: {
                settings.changeAspect(newAspect);
                if (settings.aspectChanged(this.currSettings_)) {
                    this.currSettings_.mergeAspect(settings);
                }
                if (settings.heightChanged(this.currSettings_)) {
                    this.currSettings_.mergeHeight(settings);
                    this.pubHeight_.setText(Double.toString(this.currSettings_.height));
                }
                if (!settings.widthChanged(this.currSettings_)) break;
                this.currSettings_.mergeWidth(settings);
                this.pubWidth_.setText(Double.toString(this.currSettings_.width));
                break;
            }
            case 5: {
                settings.changeResolution(newRes);
                if (settings.resolutionChanged(this.currSettings_)) {
                    this.currSettings_.mergeResolution(settings);
                }
                if (!settings.zoomChanged(this.currSettings_)) break;
                this.currSettings_.mergeZoom(settings);
                this.pubZoom_.setText(Double.toString(this.currSettings_.zoom));
                break;
            }
            default: {
                throw new IllegalStateException();
            }
        }
    }

    private void fixPubVals() {
        if (this.processing_) {
            return;
        }
        this.processing_ = true;
        try {
            this.currSettings_.roundVals();
            this.pubWidth_.setText(Double.toString(this.currSettings_.width));
            this.pubHeight_.setText(Double.toString(this.currSettings_.height));
            this.pubZoom_.setText(Double.toString(this.currSettings_.zoom));
        }
        finally {
            this.processing_ = false;
        }
    }

    private boolean tooBigOrSmall(double newVal, int whichVal) {
        double min = this.currentUnits_ == 0 ? 0.1 : 0.254;
        double max = this.currentUnits_ == 0 ? 72.0 : 182.88;
        Settings settings = new Settings(this.currSettings_);
        switch (whichVal) {
            case 1: {
                settings.changeZoom(newVal);
                return settings.width < min || settings.height < min || settings.width > max || settings.height > max;
            }
            case 2: {
                settings.changeHeight(newVal);
                return settings.width < min || settings.width > max || settings.zoom == 0.0;
            }
            case 3: {
                settings.changeWidth(newVal);
                return settings.height < min || settings.height > max || settings.zoom == 0.0;
            }
        }
        throw new IllegalStateException();
    }

    private JPanel buildPublishPanel(int baseWidth, int baseHeight, List types) {
        JPanel retval = new JPanel();
        retval.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        ResourceManager rMan = ResourceManager.getManager();
        this.currentUnits_ = this.prefs_.getInt("ExportPublishUnits", 0);
        this.currSettings_.aspectFixed = this.prefs_.getBoolean("ExportPublishAspect", true);
        String currUnits = rMan.getString(this.currentUnits_ == 0 ? "exportDialog.inches" : "exportDialog.cm");
        int rowNum = this.addUnitChoices(retval, gbc, rMan);
        JLabel label = new JLabel(rMan.getString("exportDialog.pubSize"));
        JLabel wLab = new JLabel(rMan.getString("exportDialog.width"));
        this.pubWidth_ = new JTextField();
        this.pubWidthUnits_ = new JLabel(rMan.getString(currUnits));
        JLabel hLab = new JLabel(rMan.getString("exportDialog.height"));
        this.pubHeight_ = new JTextField();
        this.pubHeightUnits_ = new JLabel(rMan.getString(currUnits));
        JLabel zLab = new JLabel(rMan.getString("exportDialog.zoom"));
        this.pubZoom_ = new JTextField();
        this.keepAspect_ = new JCheckBox(rMan.getString("exportDialog.keepAspect"), this.currSettings_.aspectFixed);
        JLabel reslabel = new JLabel(rMan.getString("exportDialog.resolution"));
        this.pubResolution_ = new JComboBox<String>(this.buildResolutions());
        String savedResolution = this.prefs_.get("ExportPublishRes", "0");
        if (!savedResolution.equals("0")) {
            this.pubResolution_.setSelectedItem(savedResolution);
        }
        String prStr = rMan.getString(this.currentUnits_ == 0 ? "exportDialog.dpi" : "exportDialog.dpc");
        this.pubResUnits_ = new JLabel(rMan.getString(prStr));
        this.currSettings_.resolution = this.resolutionForIndex(this.pubResolution_.getSelectedIndex());
        this.currSettings_.initDims();
        this.pubZoom_.setText(Double.toString(this.currSettings_.zoom));
        this.pubWidth_.setText(Double.toString(this.currSettings_.width));
        this.pubHeight_.setText(Double.toString(this.currSettings_.height));
        PublishListener pl = new PublishListener(1);
        this.pubZoom_.addActionListener(pl);
        this.pubZoom_.addCaretListener(pl);
        this.pubZoom_.addFocusListener(pl);
        PublishListener pl1 = new PublishListener(3);
        this.pubWidth_.addActionListener(pl1);
        this.pubWidth_.addCaretListener(pl1);
        this.pubWidth_.addFocusListener(pl1);
        PublishListener pl2 = new PublishListener(2);
        this.pubHeight_.addActionListener(pl2);
        this.pubHeight_.addCaretListener(pl2);
        this.pubHeight_.addFocusListener(pl2);
        this.keepAspect_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    ExportSettingsPublishDialog.this.processPublishVal(false, 4);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.pubResolution_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    ExportSettingsPublishDialog.this.processPublishVal(false, 5);
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        UiUtil.gbcSet(gbc, 0, rowNum, 3, 1, 1, 0, 0, 5, 5, 5, 5, 13, 1.0, 1.0);
        retval.add((Component)reslabel, gbc);
        UiUtil.gbcSet(gbc, 3, rowNum, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.0, 1.0);
        retval.add((Component)this.pubResolution_, gbc);
        UiUtil.gbcSet(gbc, 5, rowNum++, 1, 1, 1, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        retval.add((Component)this.pubResUnits_, gbc);
        UiUtil.gbcSet(gbc, 3, rowNum++, 3, 1, 1, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        retval.add((Component)this.keepAspect_, gbc);
        UiUtil.gbcSet(gbc, 0, rowNum, 3, 1, 1, 0, 0, 5, 5, 5, 5, 13, 1.0, 1.0);
        retval.add((Component)label, gbc);
        UiUtil.gbcSet(gbc, 3, rowNum, 1, 1, 1, 0, 0, 5, 5, 5, 5, 13, 0.0, 1.0);
        retval.add((Component)wLab, gbc);
        UiUtil.gbcSet(gbc, 4, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.5, 1.0);
        retval.add((Component)this.pubWidth_, gbc);
        UiUtil.gbcSet(gbc, 5, rowNum++, 1, 1, 1, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        retval.add((Component)this.pubWidthUnits_, gbc);
        UiUtil.gbcSet(gbc, 3, rowNum, 1, 1, 1, 0, 0, 5, 5, 5, 5, 13, 0.0, 1.0);
        retval.add((Component)hLab, gbc);
        UiUtil.gbcSet(gbc, 4, rowNum, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.5, 1.0);
        retval.add((Component)this.pubHeight_, gbc);
        UiUtil.gbcSet(gbc, 5, rowNum++, 1, 1, 1, 0, 0, 5, 5, 5, 5, 17, 0.0, 1.0);
        retval.add((Component)this.pubHeightUnits_, gbc);
        UiUtil.gbcSet(gbc, 3, rowNum, 1, 1, 1, 0, 0, 5, 5, 5, 5, 13, 0.0, 1.0);
        retval.add((Component)zLab, gbc);
        UiUtil.gbcSet(gbc, 4, rowNum++, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.5, 1.0);
        retval.add((Component)this.pubZoom_, gbc);
        JLabel flabel = new JLabel(rMan.getString("exportDialog.format"));
        this.pubCombo_ = new JComboBox<String>(types.toArray(new String[types.size()]));
        this.pubCombo_.setSelectedItem(this.currentFormat_);
        Object currCombo = this.pubCombo_.getSelectedItem();
        if (currCombo == null || !currCombo.equals(this.currentFormat_)) {
            throw new IllegalArgumentException();
        }
        UiUtil.gbcSet(gbc, 0, rowNum, 3, 1, 1, 0, 0, 5, 5, 5, 5, 13, 1.0, 1.0);
        retval.add((Component)flabel, gbc);
        UiUtil.gbcSet(gbc, 3, rowNum, 2, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.0, 1.0);
        retval.add((Component)this.pubCombo_, gbc);
        return retval;
    }

    private int addUnitChoices(JPanel retval, GridBagConstraints gbc, ResourceManager rMan) {
        String inches = rMan.getString("exportDialog.inches");
        this.useInches_ = new JRadioButton(inches, this.currentUnits_ == 0);
        this.useInches_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (ExportSettingsPublishDialog.this.currentUnits_ != 0) {
                        ExportSettingsPublishDialog.this.currentUnits_ = 0;
                        ExportSettingsPublishDialog.this.updateUnits();
                        ExportSettingsPublishDialog.this.validate();
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        String cm = rMan.getString("exportDialog.cm");
        this.useCm_ = new JRadioButton(cm, this.currentUnits_ == 1);
        this.useCm_.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (ExportSettingsPublishDialog.this.currentUnits_ != 1) {
                        ExportSettingsPublishDialog.this.currentUnits_ = 1;
                        ExportSettingsPublishDialog.this.updateUnits();
                        ExportSettingsPublishDialog.this.validate();
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        ButtonGroup group = new ButtonGroup();
        group.add(this.useInches_);
        group.add(this.useCm_);
        JLabel unitLabel = new JLabel(rMan.getString("exportDialog.useUnits"));
        UiUtil.gbcSet(gbc, 0, 0, 2, 1, 1, 0, 0, 5, 5, 5, 5, 13, 1.0, 1.0);
        retval.add((Component)unitLabel, gbc);
        UiUtil.gbcSet(gbc, 2, 0, 2, 1, 1, 0, 0, 5, 5, 5, 5, 10, 0.0, 0.0);
        retval.add((Component)this.useInches_, gbc);
        UiUtil.gbcSet(gbc, 4, 0, 2, 1, 1, 0, 0, 5, 5, 5, 5, 10, 0.0, 0.0);
        retval.add((Component)this.useCm_, gbc);
        return 1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateUnits() {
        ResourceManager rMan = ResourceManager.getManager();
        String currUnits = rMan.getString(this.currentUnits_ == 0 ? "exportDialog.inches" : "exportDialog.cm");
        this.pubWidthUnits_.setText(currUnits);
        this.pubHeightUnits_.setText(currUnits);
        this.pubResUnits_.setText(currUnits);
        String prStr = rMan.getString(this.currentUnits_ == 0 ? "exportDialog.dpi" : "exportDialog.dpc");
        this.pubResUnits_.setText(rMan.getString(prStr));
        this.processing_ = true;
        try {
            int currRes = this.pubResolution_.getSelectedIndex();
            this.pubResolution_.removeAllItems();
            String[] res = this.buildResolutions();
            for (int i = 0; i < res.length; ++i) {
                this.pubResolution_.addItem(res[i]);
            }
            this.pubResolution_.setSelectedIndex(currRes);
            this.currSettings_.changeUnits(this.resolutionForIndex(currRes), this.currentUnits_);
            this.pubWidth_.setText(Double.toString(this.currSettings_.width));
            this.pubHeight_.setText(Double.toString(this.currSettings_.height));
        }
        finally {
            this.processing_ = false;
        }
    }

    private String[] buildResolutions() {
        int numRes = this.resList_.size();
        String[] retval = new String[numRes];
        for (int i = 0; i < numRes; ++i) {
            Object[] resVal = (Object[])this.resList_.get(i);
            retval[i] = Double.toString(((ImageExporter.RationalNumber)resVal[this.currentUnits_]).value);
            double res = ((ImageExporter.RationalNumber)resVal[this.currentUnits_]).value;
            retval[i] = Long.toString(Math.round(res));
        }
        return retval;
    }

    private long resolutionForIndex(int i) {
        Object[] resVal = (Object[])this.resList_.get(i);
        return Math.round(((ImageExporter.RationalNumber)resVal[this.currentUnits_]).value);
    }

    private boolean extractProperties() {
        long pixWidth;
        long pixHeight = this.currSettings_.getPixHeight();
        long numPix = pixHeight * (pixWidth = this.currSettings_.getPixWidth());
        if (numPix > 12250000L) {
            ResourceManager rMan = ResourceManager.getManager();
            String desc = MessageFormat.format(rMan.getString("export.confirmBigExport"), new Long(numPix));
            int result = JOptionPane.showConfirmDialog(this, desc = UiUtil.convertMessageToHtml(desc), rMan.getString("export.confirmBigExportTitle"), 0);
            if (result != 0) {
                return false;
            }
        }
        this.finishedSettings_ = new ExportSettingsDialog.ExportSettings();
        this.finishedSettings_.formatType = (String)this.pubCombo_.getSelectedItem();
        int resIndex = this.pubResolution_.getSelectedIndex();
        Object[] resVal = (Object[])this.resList_.get(resIndex);
        ImageExporter.RationalNumber ratNum = (ImageExporter.RationalNumber)resVal[this.currentUnits_];
        this.finishedSettings_.res = new ImageExporter.ResolutionSettings();
        this.finishedSettings_.res.dotsPerUnit = ratNum;
        this.finishedSettings_.res.units = this.currentUnits_;
        this.finishedSettings_.zoomVal = this.currSettings_.zoom;
        this.finishedSettings_.size = new Dimension((int)pixWidth, (int)pixHeight);
        this.prefs_.putInt("ExportPublishUnits", this.currentUnits_);
        this.prefs_.putBoolean("ExportPublishAspect", this.currSettings_.aspectFixed);
        this.prefs_.putDouble("ExportPublishZoom", this.currSettings_.zoom);
        this.prefs_.put("ExportPublishRes", (String)this.pubResolution_.getSelectedItem());
        this.prefs_.put("ExportPublishFormat", this.finishedSettings_.formatType);
        return true;
    }

    static double rounded(double val, double mult) {
        double retval = Math.round(val * mult);
        return retval / mult;
    }

    private static class Settings {
        public long resolution;
        public double height;
        public double width;
        public boolean aspectFixed;
        public double zoom;
        private double startAspect_;
        private int startHeight_;
        private int startWidth_;

        Settings(int baseHeight, int baseWidth) {
            this.startHeight_ = baseHeight;
            this.startWidth_ = baseWidth;
            this.startAspect_ = (double)baseWidth / (double)baseHeight;
        }

        Settings(long resolution, double height, double width, boolean aspectFixed, double zoom, int baseHeight, int baseWidth, double baseAspect) {
            this.resolution = resolution;
            this.height = height;
            this.width = width;
            this.aspectFixed = aspectFixed;
            this.zoom = zoom;
            this.startHeight_ = baseHeight;
            this.startWidth_ = baseWidth;
            this.startAspect_ = baseAspect;
        }

        Settings() {
        }

        Settings(Settings other) {
            this.merge(other);
        }

        void merge(Settings other) {
            this.resolution = other.resolution;
            this.height = other.height;
            this.width = other.width;
            this.aspectFixed = other.aspectFixed;
            this.zoom = other.zoom;
            this.startHeight_ = other.startHeight_;
            this.startWidth_ = other.startWidth_;
            this.startAspect_ = other.startAspect_;
        }

        void initDims() {
            this.height = ExportSettingsPublishDialog.rounded(this.zoom * (double)this.startHeight_ / (double)this.resolution, 100.0);
            this.width = ExportSettingsPublishDialog.rounded(this.zoom * (double)this.startWidth_ / (double)this.resolution, 100.0);
        }

        void roundVals() {
            this.height = ExportSettingsPublishDialog.rounded(this.height, 100.0);
            this.width = ExportSettingsPublishDialog.rounded(this.width, 100.0);
            this.zoom = ExportSettingsPublishDialog.rounded(this.zoom, 100000.0);
        }

        void changeUnits(long res, int units) {
            this.resolution = res;
            double convert = units == 0 ? 0.39370078740157477 : 2.54;
            this.height *= convert;
            this.width *= convert;
            this.height = ExportSettingsPublishDialog.rounded(this.height, 100.0);
            this.width = ExportSettingsPublishDialog.rounded(this.width, 100.0);
        }

        long getPixHeight() {
            return Math.round(this.height * (double)this.resolution);
        }

        long getPixWidth() {
            return Math.round(this.width * (double)this.resolution);
        }

        boolean resolutionChanged(Settings old) {
            return this.resolution != old.resolution;
        }

        boolean heightChanged(Settings old) {
            return this.height != old.height;
        }

        boolean widthChanged(Settings old) {
            return this.width != old.width;
        }

        boolean aspectChanged(Settings old) {
            return this.aspectFixed != old.aspectFixed;
        }

        boolean zoomChanged(Settings old) {
            return this.zoom != old.zoom;
        }

        void mergeResolution(Settings src) {
            this.resolution = src.resolution;
        }

        void mergeHeight(Settings src) {
            this.height = src.height;
        }

        void mergeWidth(Settings src) {
            this.width = src.width;
        }

        void mergeAspect(Settings src) {
            this.aspectFixed = src.aspectFixed;
        }

        void mergeZoom(Settings src) {
            this.zoom = src.zoom;
        }

        double calcZoomFromFixedDims() {
            long pixHeight = Math.round(this.height * (double)this.resolution);
            double zoomValForH = ExportSettingsPublishDialog.rounded((double)pixHeight / (double)this.startHeight_, 100000.0);
            if (this.aspectFixed) {
                return zoomValForH;
            }
            long pixWidth = Math.round(this.width * (double)this.resolution);
            double zoomValForW = ExportSettingsPublishDialog.rounded((double)pixWidth / (double)this.startWidth_, 100000.0);
            return zoomValForH > zoomValForW ? zoomValForW : zoomValForH;
        }

        void changeZoom(double newZoom) {
            if (this.zoom != newZoom) {
                this.zoom = newZoom;
                double oldAspect = this.width / this.height;
                if (this.aspectFixed || oldAspect == this.startAspect_) {
                    this.height = ExportSettingsPublishDialog.rounded((double)this.startHeight_ * this.zoom / (double)this.resolution, 100.0);
                    this.width = ExportSettingsPublishDialog.rounded((double)this.startWidth_ * this.zoom / (double)this.resolution, 100.0);
                } else if (oldAspect > this.startAspect_) {
                    this.height = ExportSettingsPublishDialog.rounded((double)this.startHeight_ * this.zoom / (double)this.resolution, 100.0);
                    this.width = ExportSettingsPublishDialog.rounded(this.height * oldAspect, 100.0);
                } else {
                    this.width = ExportSettingsPublishDialog.rounded((double)this.startWidth_ * this.zoom / (double)this.resolution, 100.0);
                    this.height = ExportSettingsPublishDialog.rounded(this.width / oldAspect, 100.0);
                }
            }
        }

        void changeHeight(double newHeight) {
            if (this.height != newHeight) {
                double oldAspect = this.width / this.height;
                this.height = newHeight;
                if (this.aspectFixed) {
                    long pixHeight = Math.round(this.height * (double)this.resolution);
                    this.zoom = ExportSettingsPublishDialog.rounded((double)pixHeight / (double)this.startHeight_, 100000.0);
                    this.width = ExportSettingsPublishDialog.rounded((double)this.startWidth_ * this.zoom / (double)this.resolution, 100.0);
                } else {
                    this.zoom = this.calcZoomFromFixedDims();
                }
            }
        }

        void changeWidth(double newWidth) {
            if (this.width != newWidth) {
                double oldAspect = this.width / this.height;
                this.width = newWidth;
                if (this.aspectFixed) {
                    long pixWidth = Math.round(this.width * (double)this.resolution);
                    this.zoom = ExportSettingsPublishDialog.rounded((double)pixWidth / (double)this.startWidth_, 100000.0);
                    this.height = ExportSettingsPublishDialog.rounded((double)this.startHeight_ * this.zoom / (double)this.resolution, 100.0);
                } else {
                    this.zoom = this.calcZoomFromFixedDims();
                }
            }
        }

        void changeAspect(boolean newAspect) {
            if (this.aspectFixed != newAspect) {
                this.aspectFixed = newAspect;
                if (this.aspectFixed) {
                    double possibleWidth = ExportSettingsPublishDialog.rounded(this.height * this.startAspect_, 100.0);
                    if (possibleWidth > this.width) {
                        this.width = possibleWidth;
                    } else {
                        this.height = ExportSettingsPublishDialog.rounded(this.width / this.startAspect_, 100.0);
                    }
                }
            }
        }

        void changeResolution(long newRes) {
            if (this.resolution != newRes) {
                this.resolution = newRes;
                this.zoom = this.calcZoomFromFixedDims();
            }
        }
    }

    private class PublishListener
    implements ActionListener,
    CaretListener,
    FocusListener {
        private int whichVal_;

        PublishListener(int whichVal) {
            this.whichVal_ = whichVal;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                ExportSettingsPublishDialog.this.processPublishVal(true, this.whichVal_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void caretUpdate(CaretEvent evt) {
            try {
                ExportSettingsPublishDialog.this.processPublishVal(false, this.whichVal_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void focusGained(FocusEvent evt) {
        }

        public void focusLost(FocusEvent evt) {
            try {
                ExportSettingsPublishDialog.this.fixPubVals();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }
}

