/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs;

import java.awt.Component;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.text.MessageFormat;
import java.util.List;
import java.util.prefs.Preferences;
import javax.swing.Box;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.ui.ImageExporter;
import org.systemsbiology.biofabric.util.ResourceManager;
import org.systemsbiology.biofabric.util.UiUtil;

public class ExportSettingsDialog
extends JDialog {
    public static final long HUGE_PIC = 12250000L;
    private static final int NONE_ = 0;
    private static final int ZOOM_ = 1;
    private static final int HEIGHT_ = 2;
    private static final int WIDTH_ = 3;
    private JTextField zoomField_;
    private double currentZoomVal_;
    private JTextField heightField_;
    private long currentZoomHeight_;
    private JTextField widthField_;
    private long currentZoomWidth_;
    private JComboBox combo_;
    private boolean processing_;
    private String currentFormat_;
    private int baseWidth_;
    private int baseHeight_;
    private ExportSettings finishedSettings_;
    private Preferences prefs_;
    private static final long serialVersionUID = 1L;

    public ExportSettingsDialog(JFrame parent, int baseWidth, int baseHeight) {
        super(parent, ResourceManager.getManager().getString("exportDialog.title"), true);
        ResourceManager rMan = ResourceManager.getManager();
        this.setSize(400, 350);
        JPanel cp = (JPanel)this.getContentPane();
        cp.setBorder(new EmptyBorder(20, 20, 20, 20));
        cp.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        this.finishedSettings_ = null;
        this.prefs_ = Preferences.userNodeForPackage(this.getClass());
        this.currentZoomVal_ = this.prefs_.getDouble("ExportZoom", 1.0);
        List<String> types = ImageExporter.getSupportedExports();
        String maybeFormat = this.prefs_.get("ExportFormat", "PNG");
        this.currentFormat_ = types.contains(maybeFormat) ? maybeFormat : types.get(0);
        JPanel zoomPanel = this.buildZoomPanel(baseWidth, baseHeight, types);
        UiUtil.gbcSet(gbc, 0, 0, 10, 8, 1, 0, 0, 5, 5, 5, 5, 10, 1.0, 1.0);
        cp.add((Component)zoomPanel, gbc);
        FixedJButton buttonO = new FixedJButton(rMan.getString("exportDialog.ok"));
        buttonO.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    if (ExportSettingsDialog.this.extractProperties()) {
                        ExportSettingsDialog.this.setVisible(false);
                        ExportSettingsDialog.this.dispose();
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        FixedJButton buttonC = new FixedJButton(rMan.getString("exportDialog.cancel"));
        buttonC.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent ev) {
                try {
                    ExportSettingsDialog.this.setVisible(false);
                    ExportSettingsDialog.this.dispose();
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        Box buttonPanel = Box.createHorizontalBox();
        buttonPanel.add(Box.createHorizontalGlue());
        buttonPanel.add(buttonO);
        buttonPanel.add(Box.createHorizontalStrut(10));
        buttonPanel.add(buttonC);
        UiUtil.gbcSet(gbc, 0, 8, 10, 1, 2, 0, 0, 5, 5, 5, 5, 14, 1.0, 0.0);
        cp.add((Component)buttonPanel, gbc);
        this.setLocationRelativeTo(parent);
    }

    public ExportSettings getResults() {
        return this.finishedSettings_;
    }

    private void processZoomVal(boolean force, int whichVal) {
        if (this.processing_) {
            return;
        }
        this.processing_ = true;
        boolean fixVal = false;
        double newZoom = this.currentZoomVal_;
        if (whichVal == 1) {
            String zoomText = this.zoomField_.getText();
            boolean haveZoom = false;
            if (!zoomText.trim().equals("")) {
                try {
                    double parsedZoom = Double.parseDouble(zoomText);
                    if (parsedZoom > 0.0) {
                        newZoom = parsedZoom;
                        haveZoom = true;
                    } else if (parsedZoom == 0.0 && force) {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    if (haveZoom && this.tooSmall(newZoom, 0L, 1)) {
                        newZoom = this.currentZoomVal_;
                        haveZoom = false;
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                catch (NumberFormatException nfe) {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else if (force) {
                Toolkit.getDefaultToolkit().beep();
            }
            if (force && !haveZoom) {
                fixVal = true;
            }
        }
        long newHeight = this.currentZoomHeight_;
        if (whichVal == 2) {
            String heightText = this.heightField_.getText();
            boolean haveHeight = false;
            if (!heightText.trim().equals("")) {
                try {
                    long parsedHeight = Long.parseLong(heightText);
                    if (parsedHeight > 0L) {
                        newHeight = parsedHeight;
                        haveHeight = true;
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    if (haveHeight && this.tooSmall(0.0, newHeight, 2)) {
                        newHeight = this.currentZoomHeight_;
                        haveHeight = false;
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                catch (NumberFormatException nfe) {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else if (force) {
                Toolkit.getDefaultToolkit().beep();
            }
            if (force && !haveHeight) {
                fixVal = true;
            }
        }
        long newWidth = this.currentZoomWidth_;
        if (whichVal == 3) {
            String widthText = this.widthField_.getText();
            boolean haveWidth = false;
            if (!widthText.trim().equals("")) {
                try {
                    long parsedWidth = Long.parseLong(widthText);
                    if (parsedWidth > 0L) {
                        newWidth = parsedWidth;
                        haveWidth = true;
                    } else {
                        Toolkit.getDefaultToolkit().beep();
                    }
                    if (haveWidth && this.tooSmall(0.0, newWidth, 3)) {
                        newWidth = this.currentZoomWidth_;
                        haveWidth = false;
                        Toolkit.getDefaultToolkit().beep();
                    }
                }
                catch (NumberFormatException nfe) {
                    Toolkit.getDefaultToolkit().beep();
                }
            } else if (force) {
                Toolkit.getDefaultToolkit().beep();
            }
            if (force && !haveWidth) {
                fixVal = true;
            }
        }
        switch (whichVal) {
            case 0: {
                break;
            }
            case 1: {
                if (this.currentZoomVal_ != newZoom) {
                    this.currentZoomVal_ = newZoom;
                    this.currentZoomHeight_ = Math.round((double)this.baseHeight_ * this.currentZoomVal_);
                    this.currentZoomWidth_ = Math.round((double)this.baseWidth_ * this.currentZoomVal_);
                    this.widthField_.setText(Long.toString(this.currentZoomWidth_));
                    this.heightField_.setText(Long.toString(this.currentZoomHeight_));
                }
                if (!fixVal) break;
                this.zoomField_.setText(Double.toString(this.currentZoomVal_));
                break;
            }
            case 2: {
                if (this.currentZoomHeight_ != newHeight) {
                    this.currentZoomHeight_ = newHeight;
                    this.currentZoomVal_ = (double)this.currentZoomHeight_ / (double)this.baseHeight_;
                    this.currentZoomWidth_ = Math.round((double)this.baseWidth_ * this.currentZoomVal_);
                    this.zoomField_.setText(Double.toString(this.currentZoomVal_));
                    this.widthField_.setText(Long.toString(this.currentZoomWidth_));
                }
                if (!fixVal) break;
                this.heightField_.setText(Long.toString(this.currentZoomHeight_));
                break;
            }
            case 3: {
                if (this.currentZoomWidth_ != newWidth) {
                    this.currentZoomWidth_ = newWidth;
                    this.currentZoomVal_ = (double)this.currentZoomWidth_ / (double)this.baseWidth_;
                    this.currentZoomHeight_ = Math.round((double)this.baseHeight_ * this.currentZoomVal_);
                    this.zoomField_.setText(Double.toString(this.currentZoomVal_));
                    this.heightField_.setText(Long.toString(this.currentZoomHeight_));
                }
                if (!fixVal) break;
                this.widthField_.setText(Long.toString(this.currentZoomWidth_));
                break;
            }
            default: {
                this.processing_ = false;
                throw new IllegalStateException();
            }
        }
        this.processing_ = false;
    }

    private void fixZoomVals() {
        if (this.processing_) {
            return;
        }
        this.processing_ = true;
        this.widthField_.setText(Long.toString(this.currentZoomWidth_));
        this.heightField_.setText(Long.toString(this.currentZoomHeight_));
        this.zoomField_.setText(Double.toString(this.currentZoomVal_));
        this.processing_ = false;
    }

    private boolean tooSmall(double newZoom, long newDim, int whichVal) {
        switch (whichVal) {
            case 1: {
                long newZoomHeight = Math.round((double)this.baseHeight_ * newZoom);
                long newZoomWidth = Math.round((double)this.baseWidth_ * newZoom);
                if (newZoomHeight != 0L && newZoomWidth != 0L) break;
                return true;
            }
            case 2: {
                double newZoomVal = (double)newDim / (double)this.baseHeight_;
                long newZoomWidth = Math.round((double)this.baseWidth_ * newZoomVal);
                if (newZoomVal != 0.0 && newZoomWidth != 0L) break;
                return true;
            }
            case 3: {
                double newZoomVal = (double)newDim / (double)this.baseWidth_;
                long newZoomHeight = Math.round((double)this.baseHeight_ * newZoomVal);
                if (newZoomVal != 0.0 && newZoomHeight != 0L) break;
                return true;
            }
            default: {
                throw new IllegalStateException();
            }
        }
        return false;
    }

    private JPanel buildZoomPanel(int baseWidth, int baseHeight, List types) {
        JPanel retval = new JPanel();
        retval.setLayout(new GridBagLayout());
        GridBagConstraints gbc = new GridBagConstraints();
        ResourceManager rMan = ResourceManager.getManager();
        JLabel fixedLab = new JLabel(rMan.getString("exportDialog.fixedAspect"));
        UiUtil.gbcSet(gbc, 0, 0, 2, 1, 1, 0, 0, 5, 5, 5, 5, 13, 1.0, 1.0);
        retval.add((Component)fixedLab, gbc);
        JLabel label = new JLabel(rMan.getString("exportDialog.zoom"));
        this.zoomField_ = new JTextField(Double.toString(this.currentZoomVal_));
        ZoomListener zl = new ZoomListener(1);
        this.zoomField_.addActionListener(zl);
        this.zoomField_.addCaretListener(zl);
        this.zoomField_.addFocusListener(zl);
        UiUtil.gbcSet(gbc, 0, 1, 1, 1, 1, 0, 0, 5, 5, 5, 5, 13, 1.0, 1.0);
        retval.add((Component)label, gbc);
        UiUtil.gbcSet(gbc, 1, 1, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.5, 1.0);
        retval.add((Component)this.zoomField_, gbc);
        this.baseWidth_ = baseWidth;
        JLabel wlab = new JLabel(rMan.getString("exportDialog.width"));
        this.widthField_ = new JTextField();
        this.baseHeight_ = baseHeight;
        JLabel hlab = new JLabel(rMan.getString("exportDialog.height"));
        this.heightField_ = new JTextField();
        this.initZoomDims();
        ZoomListener zlw = new ZoomListener(3);
        this.widthField_.addActionListener(zlw);
        this.widthField_.addCaretListener(zlw);
        this.widthField_.addFocusListener(zlw);
        ZoomListener zlh = new ZoomListener(2);
        this.heightField_.addActionListener(zlh);
        this.heightField_.addCaretListener(zlh);
        this.heightField_.addFocusListener(zlh);
        UiUtil.gbcSet(gbc, 0, 2, 1, 1, 1, 0, 0, 5, 5, 5, 5, 13, 1.0, 1.0);
        retval.add((Component)wlab, gbc);
        UiUtil.gbcSet(gbc, 1, 2, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.5, 1.0);
        retval.add((Component)this.widthField_, gbc);
        UiUtil.gbcSet(gbc, 0, 3, 1, 1, 1, 0, 0, 5, 5, 5, 5, 13, 1.0, 1.0);
        retval.add((Component)hlab, gbc);
        UiUtil.gbcSet(gbc, 1, 3, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.5, 1.0);
        retval.add((Component)this.heightField_, gbc);
        JLabel flabel = new JLabel(rMan.getString("exportDialog.format"));
        this.combo_ = new JComboBox<String>(types.toArray(new String[types.size()]));
        this.combo_.setSelectedItem(this.currentFormat_);
        Object currCombo = this.combo_.getSelectedItem();
        if (currCombo == null || !currCombo.equals(this.currentFormat_)) {
            throw new IllegalArgumentException();
        }
        UiUtil.gbcSet(gbc, 0, 4, 1, 1, 1, 0, 0, 5, 5, 5, 5, 13, 1.0, 1.0);
        retval.add((Component)flabel, gbc);
        UiUtil.gbcSet(gbc, 1, 4, 1, 1, 2, 0, 0, 5, 5, 5, 5, 10, 0.0, 1.0);
        retval.add((Component)this.combo_, gbc);
        return retval;
    }

    private void initZoomDims() {
        this.currentZoomHeight_ = Math.round((double)this.baseHeight_ * this.currentZoomVal_);
        this.currentZoomWidth_ = Math.round((double)this.baseWidth_ * this.currentZoomVal_);
        this.widthField_.setText(Long.toString(this.currentZoomWidth_));
        this.heightField_.setText(Long.toString(this.currentZoomHeight_));
    }

    private boolean extractProperties() {
        long numPix = this.currentZoomWidth_ * this.currentZoomHeight_;
        if (numPix > 12250000L) {
            ResourceManager rMan = ResourceManager.getManager();
            String desc = MessageFormat.format(rMan.getString("export.confirmBigExport"), new Long(numPix));
            int result = JOptionPane.showConfirmDialog(this, desc = UiUtil.convertMessageToHtml(desc), rMan.getString("export.confirmBigExportTitle"), 0);
            if (result != 0) {
                return false;
            }
        }
        this.finishedSettings_ = new ExportSettings();
        this.finishedSettings_.zoomVal = this.currentZoomVal_;
        this.finishedSettings_.formatType = (String)this.combo_.getSelectedItem();
        if (ImageExporter.formatRequiresResolution(this.finishedSettings_.formatType)) {
            List resList = ImageExporter.getSupportedResolutions(false);
            if (resList.size() == 0) {
                throw new IllegalStateException();
            }
            Object[] resVal = (Object[])resList.get(0);
            ImageExporter.RationalNumber ratNum = (ImageExporter.RationalNumber)resVal[1];
            this.finishedSettings_.res = new ImageExporter.ResolutionSettings();
            this.finishedSettings_.res.dotsPerUnit = ratNum;
            this.finishedSettings_.res.units = 1;
        } else {
            this.finishedSettings_.res = null;
        }
        this.finishedSettings_.size = new Dimension((int)this.currentZoomWidth_, (int)this.currentZoomHeight_);
        this.prefs_.putDouble("ExportZoom", this.currentZoomVal_);
        this.prefs_.put("ExportFormat", this.finishedSettings_.formatType);
        return true;
    }

    private class ZoomListener
    implements ActionListener,
    CaretListener,
    FocusListener {
        private int whichVal_;

        ZoomListener(int whichVal) {
            this.whichVal_ = whichVal;
        }

        public void actionPerformed(ActionEvent evt) {
            try {
                ExportSettingsDialog.this.processZoomVal(true, this.whichVal_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void caretUpdate(CaretEvent evt) {
            try {
                ExportSettingsDialog.this.processZoomVal(false, this.whichVal_);
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }

        public void focusGained(FocusEvent evt) {
        }

        public void focusLost(FocusEvent evt) {
            try {
                ExportSettingsDialog.this.fixZoomVals();
            }
            catch (Exception ex) {
                ExceptionHandler.getHandler().displayException(ex);
            }
        }
    }

    public static class ExportSettings {
        public double zoomVal;
        public String formatType;
        public ImageExporter.ResolutionSettings res;
        public Dimension size;
    }
}

