/*
 * Decompiled with CFR 0.152.
 */
package org.systemsbiology.biofabric.ui.dialogs;

import java.awt.Dimension;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.EmptyBorder;
import org.systemsbiology.biofabric.api.dialog.BTStashResultsDialog;
import org.systemsbiology.biofabric.api.io.FileLoadFlows;
import org.systemsbiology.biofabric.api.util.ExceptionHandler;
import org.systemsbiology.biofabric.api.util.FixedJButton;
import org.systemsbiology.biofabric.util.ResourceManager;

public class DirectoryChooserDialog
extends BTStashResultsDialog {
    private JFrame parent_;
    private JTextField nameField_;
    private File directory_;
    private static final long serialVersionUID = 1L;
    private FileLoadFlows flf_;

    public DirectoryChooserDialog(JFrame parent, FileLoadFlows flf, String currChoice) {
        super(parent, ResourceManager.getManager().getString("directoryChooser.title"), new Dimension(800, 150), 3);
        ResourceManager rMan = ResourceManager.getManager();
        this.parent_ = parent;
        this.flf_ = flf;
        JPanel cp = (JPanel)this.getContentPane();
        cp.setBorder(new EmptyBorder(20, 20, 20, 20));
        cp.setLayout(new GridBagLayout());
        FixedJButton directoryBrowse = new FixedJButton(rMan.getString("directoryChooser.browse"));
        directoryBrowse.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                try {
                    File directory = DirectoryChooserDialog.this.flf_.getTheDirectory("PlugInDirectory");
                    if (directory != null) {
                        DirectoryChooserDialog.this.nameField_.setText(directory.getAbsolutePath());
                    }
                }
                catch (Exception ex) {
                    ExceptionHandler.getHandler().displayException(ex);
                }
            }
        });
        this.nameField_ = new JTextField(30);
        this.nameField_.setText(currChoice == null ? "" : currChoice);
        JLabel directoryLabel = new JLabel(rMan.getString("directoryChooser.directory"));
        this.addLabeledFileBrowse(directoryLabel, this.nameField_, directoryBrowse);
        this.finishConstruction();
        this.setLocationRelativeTo(parent);
    }

    protected boolean stashForOK() {
        this.directory_ = new File(this.nameField_.getText());
        return this.flf_.standardFileChecks(this.directory_, true, false, false, true, false, true);
    }

    public File getDirectory() {
        return this.directory_;
    }
}

